/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc;

import java.net.InetSocketAddress;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.wst.xquery.marklogic.xcc.ContentSource;
import org.eclipse.wst.xquery.marklogic.xcc.SecurityOptions;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.XccConfigException;
import org.eclipse.wst.xquery.marklogic.xcc.impl.ContentSourceImpl;
import org.eclipse.wst.xquery.marklogic.xcc.impl.SSLSocketPoolProvider;
import org.eclipse.wst.xquery.marklogic.xcc.impl.SocketPoolProvider;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ConnectionProvider;

public class ContentSourceFactory {
    private static final String[] knownSchemes = new String[]{"xcc", "xccs", "xdbc"};
    private static final String[] secureSchemes = new String[]{"xccs"};
    private static final int STANDARD_PROVIDER_CACHE_SIZE = Integer.getInteger("xcc.connectionprovider.standard.cache.size", 8);
    private static final int SECURE_PROVIDER_CACHE_SIZE = Integer.getInteger("xcc.connectionprovider.secure.cache.size", 8);
    private static final Map<Object, ConnectionProvider> standardProviders = Collections.synchronizedMap(new ConnectionProviderCache(STANDARD_PROVIDER_CACHE_SIZE));
    private static final Map<Object, ConnectionProvider> secureProviders = Collections.synchronizedMap(new ConnectionProviderCache(SECURE_PROVIDER_CACHE_SIZE));

    private ContentSourceFactory() {
    }

    public static ContentSource newContentSource(ConnectionProvider connectionProvider, String user, String password, String contentbaseName) {
        return new ContentSourceImpl(connectionProvider, user, password, contentbaseName);
    }

    public static ContentSource newContentSource(URI uri, SecurityOptions options) throws XccConfigException {
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        String userInfoStr = uri.getUserInfo();
        String[] userInfo = userInfoStr == null ? new String[]{} : userInfoStr.split(":");
        String contentBase = uri.getPath();
        if (!ContentSourceFactory.validScheme(scheme)) {
            throw new XccConfigException("Unrecognized connection scheme: " + scheme);
        }
        if (!ContentSourceFactory.secureScheme(scheme) && options != null) {
            throw new XccConfigException("Non-Secure connection requested but SecurityOptions is non-null");
        }
        if (contentBase != null) {
            if (contentBase.startsWith("/")) {
                contentBase = contentBase.substring(1);
            }
            if (contentBase.length() == 0) {
                contentBase = null;
            }
        }
        if (userInfo.length != 2 || userInfo[0].length() == 0 || userInfo[1].length() == 0) {
            return ContentSourceFactory.newContentSource(host, port, null, null, contentBase, options);
        }
        return ContentSourceFactory.newContentSource(host, port, userInfo[0], userInfo[1], contentBase, options);
    }

    public static ContentSource newContentSource(URI uri) throws XccConfigException {
        return ContentSourceFactory.newContentSource(uri, null);
    }

    public static ContentSource newContentSource(String host, int port, String user, String password, String contentbaseName, SecurityOptions options) {
        return ContentSourceFactory.newContentSource(options == null ? ContentSourceFactory.defaultConnectionProvider(host, port) : ContentSourceFactory.defaultSecureConnectionProvider(host, port, options), user, password, contentbaseName);
    }

    public static ContentSource newContentSource(String host, int port, String user, String password, String contentbaseName) {
        return ContentSourceFactory.newContentSource(host, port, user, password, contentbaseName, null);
    }

    public static ContentSource newContentSource(String host, int port, String user, String password) {
        return ContentSourceFactory.newContentSource(host, port, user, password, null);
    }

    public static ContentSource newContentSource(String host, int port) {
        return ContentSourceFactory.newContentSource(host, port, null, null, null);
    }

    static ConnectionProvider defaultConnectionProvider(String host, int port) {
        InetSocketAddress address = new InetSocketAddress(host, port);
        if (address.isUnresolved()) {
            throw new IllegalArgumentException("Default provider - Not a usable net address: " + address);
        }
        ConnectionProvider provider = standardProviders.get(address);
        if (provider == null) {
            provider = new SocketPoolProvider(address);
            standardProviders.put(address, provider);
        }
        return provider;
    }

    private static ConnectionProvider defaultSecureConnectionProvider(String host, int port, SecurityOptions options) {
        InetSocketAddress address = new InetSocketAddress(host, port);
        if (address.isUnresolved()) {
            throw new IllegalArgumentException("Default secure provider - Not a usable net address: " + address);
        }
        SecurityOptions securityOptions = new SecurityOptions(options);
        class Key {
            private final /* synthetic */ InetSocketAddress val$address;
            private final /* synthetic */ SecurityOptions val$securityOptions;

            Key(InetSocketAddress inetSocketAddress, SecurityOptions securityOptions) {
                this.val$address = inetSocketAddress;
                this.val$securityOptions = securityOptions;
            }

            public InetSocketAddress getAddress() {
                return this.val$address;
            }

            public SecurityOptions getSecurityOptions() {
                return this.val$securityOptions;
            }

            public int hashCode() {
                return this.val$address.hashCode() + this.val$securityOptions.hashCode();
            }

            public boolean equals(Object o) {
                if (o instanceof Key) {
                    Key k = (Key)o;
                    return this == k || this.val$address.equals(k.getAddress()) && this.val$securityOptions.equals(k.getSecurityOptions());
                }
                return false;
            }
        }
        Key key = new Key(address, securityOptions);
        ConnectionProvider provider = secureProviders.get(key);
        if (provider == null) {
            try {
                provider = new SSLSocketPoolProvider(address, securityOptions);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            secureProviders.put(key, provider);
        }
        return provider;
    }

    private static boolean validScheme(String scheme) {
        if (scheme == null) {
            return false;
        }
        int i = 0;
        while (i < knownSchemes.length) {
            if (scheme.equalsIgnoreCase(knownSchemes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean secureScheme(String scheme) {
        if (scheme == null) {
            return false;
        }
        int i = 0;
        while (i < secureSchemes.length) {
            if (scheme.equalsIgnoreCase(secureSchemes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectionProviderCache
    extends LinkedHashMap<Object, ConnectionProvider> {
        private static final long serialVersionUID = 1L;
        int capacity;

        public ConnectionProviderCache(int capacity) {
            super(capacity + 1, 1.0f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, ConnectionProvider> eldest) {
            return this.size() > this.capacity;
        }
    }
}

