/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.eclipse.wst.xquery.marklogic.io.SslByteChannel;
import org.eclipse.wst.xquery.marklogic.xcc.SecurityOptions;
import org.eclipse.wst.xquery.marklogic.xcc.impl.SSLSocketPoolProvider;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ConnectionProvider;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ServerConnection;

public class SSLConnection
implements ServerConnection {
    private final ServerConnection plainConn;
    private final ConnectionProvider provider;
    private final ByteChannel sslChannel;

    public SSLConnection(ServerConnection conn, SecurityOptions securityOptions, SSLSocketPoolProvider provider, Logger logger) throws IOException {
        String[] ciphers;
        if (!(conn.channel() instanceof SocketChannel)) {
            throw new IllegalArgumentException("Underlying channel is not a SocketChannel");
        }
        InetSocketAddress addr = provider.getAddress();
        SSLContext context = securityOptions.getSslContext();
        SSLEngine sslEngine = context.createSSLEngine(addr.getHostName(), addr.getPort());
        this.plainConn = conn;
        this.provider = provider;
        sslEngine.setUseClientMode(true);
        String[] protocols = securityOptions.getEnabledProtocols();
        if (protocols != null) {
            sslEngine.setEnabledProtocols(protocols);
        }
        if ((ciphers = securityOptions.getEnabledCipherSuites()) != null) {
            sslEngine.setEnabledCipherSuites(ciphers);
        }
        this.sslChannel = new SslByteChannel(this.plainConn.channel(), sslEngine, logger);
    }

    public ByteChannel channel() {
        return this.sslChannel;
    }

    public ConnectionProvider provider() {
        return this.provider;
    }

    public long getTimeoutMillis() {
        return this.plainConn.getTimeoutMillis();
    }

    @Deprecated
    public void setTimeoutMillis(long timeoutMillis) {
        this.plainConn.setTimeoutTime(timeoutMillis);
    }

    public long getTimeoutTime() {
        return this.plainConn.getTimeoutTime();
    }

    public void setTimeoutTime(long timeMillis) {
        this.plainConn.setTimeoutTime(timeMillis);
    }

    public void close() {
        try {
            this.sslChannel.close();
        }
        catch (IOException iOException) {}
    }

    public boolean isOpen() {
        return this.plainConn.isOpen();
    }
}

