/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.xquery.marklogic.io.SocketChannelPool;
import org.eclipse.wst.xquery.marklogic.xcc.Request;
import org.eclipse.wst.xquery.marklogic.xcc.RequestOptions;
import org.eclipse.wst.xquery.marklogic.xcc.Session;
import org.eclipse.wst.xquery.marklogic.xcc.impl.SimpleConnection;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ConnectionErrorAction;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ConnectionProvider;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ServerConnection;
import org.eclipse.wst.xquery.marklogic.xcc.spi.SingleHostAddress;

public class SocketPoolProvider
implements ConnectionProvider,
SingleHostAddress {
    private static final int DEFAULT_SOCKET_POOL_SIZE = 64;
    private static final int DEFAULT_SOCKET_BUFFER_SIZE = 131072;
    private static final String POOL_SIZE_PROPERTY = "xcc.socket.pool.max";
    private static final String SOCKET_SEND_BUFFER_PROPERTY = "xcc.socket.sendbuf";
    private static final String SOCKET_RECV_BUFFER_PROPERTY = "xcc.socket.recvbuf";
    private final int poolSize = Integer.getInteger("xcc.socket.pool.max", 64);
    private static final int socketSendBuffSize = Integer.getInteger("xcc.socket.sendbuf", 131072);
    private static final int socketRecvBuffSize = Integer.getInteger("xcc.socket.recvbuf", 131072);
    private final SocketChannelPool<SocketAddress> connectionPool;
    private final SocketAddress address;
    private final Logger logger = Logger.getLogger(ConnectionProvider.class.getName());

    public SocketPoolProvider(SocketAddress address) {
        this.logger.fine("constructing new SocketPoolProvider");
        this.address = address;
        this.connectionPool = new SocketChannelPool(this.poolSize);
    }

    public SocketPoolProvider(String host, int port) {
        this(new InetSocketAddress(host, port));
    }

    int getPoolSize() {
        return this.poolSize;
    }

    public ServerConnection obtainConnection(Session session, Request request, Logger logger) throws IOException {
        SocketChannel channel;
        if (this.getLogger(logger).isLoggable(Level.FINE)) {
            this.getLogger(logger).fine("obtainConnection for " + this.address);
        }
        if ((channel = this.connectionPool.get(this.address)) == null) {
            RequestOptions options;
            int timeout;
            channel = SocketChannel.open(this.address);
            Socket socket = channel.socket();
            socket.setSendBufferSize(socketSendBuffSize);
            socket.setReceiveBufferSize(socketRecvBuffSize);
            socket.setTcpNoDelay(true);
            socket.setSoLinger(false, 0);
            socket.setKeepAlive(true);
            if (request != null && (timeout = (options = request.getEffectiveOptions()).getTimeoutMillis()) >= 0) {
                socket.setSoTimeout(timeout);
            }
            this.getLogger(logger).fine("  pool empty, created new connection");
        } else {
            this.getLogger(logger).fine("  using connection from pool");
        }
        return new SimpleConnection(channel, this);
    }

    public void returnConnection(ServerConnection connection, Logger logger) {
        ByteChannel channel;
        if (this.getLogger(logger).isLoggable(Level.FINE)) {
            this.getLogger(logger).fine("returnConnection for " + this.address + ", expire=" + connection.getTimeoutMillis());
        }
        if ((channel = connection.channel()) == null || !(channel instanceof SocketChannel)) {
            this.getLogger(logger).fine("channel is not eligible for pooling, dropping");
            return;
        }
        SocketChannel socketChannel = (SocketChannel)channel;
        Socket socket = socketChannel.socket();
        if (!socketChannel.isOpen() || socket.isInputShutdown() || socket.isOutputShutdown()) {
            this.getLogger(logger).fine("channel has been closed, dropping");
            return;
        }
        long timeoutMillis = connection.getTimeoutMillis();
        if (timeoutMillis <= 0L) {
            this.getLogger(logger).fine("channel has already expired, closing");
            connection.close();
            return;
        }
        long timeoutTime = connection.getTimeoutTime();
        if (this.getLogger(logger).isLoggable(Level.FINE)) {
            this.getLogger(logger).fine("returning socket to pool (" + this.address + "), timeout time=" + timeoutTime);
        }
        this.connectionPool.put(this.address, (SocketChannel)channel, timeoutTime);
    }

    public ConnectionErrorAction returnErrorConnection(ServerConnection connection, Throwable exception, Logger logger) {
        this.getLogger(logger).fine("error return: " + exception);
        ByteChannel channel = connection.channel();
        if (channel != null) {
            if (channel.isOpen()) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {}
            } else {
                this.getLogger(logger).warning("returned error connection is closed, retrying");
                return ConnectionErrorAction.RETRY;
            }
        }
        this.getLogger(logger).fine("returning FAIL action");
        return ConnectionErrorAction.FAIL;
    }

    public void shutdown(Logger logger) {
        SocketChannel channel;
        this.getLogger(logger).fine("shutting down socket pool provider");
        while ((channel = this.connectionPool.get(this.address)) != null) {
            try {
                channel.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String toString() {
        return "address=" + this.address.toString() + ", pool=" + this.connectionPool.size(this.address) + "/" + this.poolSize;
    }

    public InetSocketAddress getAddress() {
        return (InetSocketAddress)(this.address instanceof InetSocketAddress ? this.address : null);
    }

    private Logger getLogger(Logger clientLogger) {
        return clientLogger == null ? this.logger : clientLogger;
    }
}

