/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.types.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.wst.xquery.marklogic.xcc.types.ValueType;
import org.eclipse.wst.xquery.marklogic.xcc.types.XSDouble;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.AbstractStringItem;

public class XsDoubleImpl
extends AbstractStringItem
implements XSDouble {
    private final Double value;
    private final BigDecimal bigDecimalValue;
    private final NumberFormatException formatException;

    public XsDoubleImpl(String bodyString) {
        super(ValueType.XS_DOUBLE, bodyString);
        this.value = Double.valueOf(this.scrubbedFloatValue(bodyString));
        BigDecimal tmpBigDecimal = null;
        NumberFormatException tmpEx = null;
        try {
            tmpBigDecimal = new BigDecimal(bodyString);
        }
        catch (NumberFormatException e) {
            tmpEx = e;
        }
        this.bigDecimalValue = tmpBigDecimal;
        this.formatException = tmpEx;
    }

    public XsDoubleImpl(Object value) {
        super(ValueType.XS_DOUBLE, value.toString());
        NumberFormatException tmpEx;
        BigDecimal tmpBigDecimal;
        if (value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Float || value instanceof BigDecimal || value instanceof BigInteger || value instanceof String) {
            this.value = new Double(value.toString());
            tmpBigDecimal = null;
            tmpEx = null;
            try {
                tmpBigDecimal = new BigDecimal(value.toString());
            }
            catch (NumberFormatException e) {
                tmpEx = e;
            }
        } else {
            throw new IllegalArgumentException("Cannot construct XSDouble from " + value.getClass().getName());
        }
        this.bigDecimalValue = tmpBigDecimal;
        this.formatException = tmpEx;
    }

    public Double asDouble() {
        return this.value;
    }

    public double asPrimitiveDouble() {
        return this.value;
    }

    public BigDecimal asBigDecimal() {
        if (this.bigDecimalValue == null) {
            throw this.formatException;
        }
        return this.bigDecimalValue;
    }
}

