/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.types.impl;

import java.math.BigInteger;
import org.eclipse.wst.xquery.marklogic.xcc.types.ValueType;
import org.eclipse.wst.xquery.marklogic.xcc.types.XSInteger;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.AbstractStringItem;

public class XsIntegerImpl
extends AbstractStringItem
implements XSInteger {
    private BigInteger value;

    public XsIntegerImpl(String value) {
        super(ValueType.XS_INTEGER, value);
        this.value = new BigInteger(value);
    }

    public XsIntegerImpl(Object value) {
        super(ValueType.XS_INTEGER, value.toString());
        if (!(value instanceof Integer || value instanceof Long || value instanceof BigInteger || value instanceof String)) {
            throw new IllegalArgumentException("Cannot construct XSInteger from " + value.getClass().getName());
        }
        this.value = new BigInteger(value.toString());
    }

    public BigInteger asBigInteger() {
        return this.value;
    }

    public Long asLong() {
        return new Long(this.value.longValue());
    }

    public long asPrimitiveLong() {
        return this.value.longValue();
    }

    public Integer asInteger() {
        return Integer.valueOf(this.asString());
    }

    public int asPrimitiveInt() {
        return (int)this.asPrimitiveLong();
    }
}

