/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.launching.marklogic;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.xquery.launching.IXQDTBuiltinDocProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkLogicBuiltinsDoc
implements IXQDTBuiltinDocProvider {
    private static Map<String, String> fDocs;

    public synchronized Map<String, String> getDocs() {
        if (fDocs == null) {
            fDocs = new HashMap<String, String>();
            MarkLogicBuiltinsDoc.loadMap();
        }
        return fDocs;
    }

    private static void loadMap() {
        fDocs.put("dbk:convert", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbk:convert(</div><div style=\"padding-left:2em;\">doc as node()?,</div><div style=\"padding-left:2em;\">options as element()?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Convert XHTML to DocBook lite vocabulary, if possible. The section structuring depends on the presence of div elements with mlsection markers, as produced by xhtml:restructure. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbk:convert\">Complete Information for dbk:convert</a></div></div>");
        fDocs.put("georss:point", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">georss:point(</div><div style=\"padding-left:2em;\">point as element(georss:point)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a cts:point value from a GeoRSS point element. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:georss:point\">Complete Information for georss:point</a></div></div>");
        fDocs.put("georss:circle", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">georss:circle(</div><div style=\"padding-left:2em;\">radius as xs:double,</div><div style=\"padding-left:2em;\">center as element(georss:point)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a cts:circle value from a radius and GeoRSS point element. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:georss:circle\">Complete Information for georss:circle</a></div></div>");
        fDocs.put("georss:geospatial-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">georss:geospatial-query(</div><div style=\"padding-left:2em;\">regions as cts:region*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a cts:query matching points within given regions. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:georss:geospatial-query\">Complete Information for georss:geospatial-query</a></div></div>");
        fDocs.put("xdmp:tidy", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:tidy(</div><div style=\"padding-left:2em;\">doc as xs:string,</div><div style=\"padding-left:2em;\">[options as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Run tidy on the specified html document to convert the document to well-formed and clean XHTML. Returns two nodes: the first is a status node indicating any errors or warning from tidy, and the second is an html node containing the cleaned xhtml. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:tidy\">Complete Information for xdmp:tidy</a></div></div>");
        fDocs.put("geo:point", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">geo:point(</div><div style=\"padding-left:2em;\">point as element()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a cts:point value from an element representing a point in one of the supported markup vocabularies. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:geo:point\">Complete Information for geo:point</a></div></div>");
        fDocs.put("geo:box", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">geo:box(</div><div style=\"padding-left:2em;\">box as element()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a cts:point value from an element representing a box in one of the supported markup vocabularies. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:geo:box\">Complete Information for geo:box</a></div></div>");
        fDocs.put("geo:circle", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">geo:circle(</div><div style=\"padding-left:2em;\">radius as xs:double,</div><div style=\"padding-left:2em;\">center as element()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a cts:circle value from a radius and an element representing a point in one of the supported markup vocabularies. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:geo:circle\">Complete Information for geo:circle</a></div></div>");
        fDocs.put("geo:polygon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">geo:polygon(</div><div style=\"padding-left:2em;\">points as element()+</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a cts:polygon value from a sequence of point elements in one of the supported markup vocabularies. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:geo:polygon\">Complete Information for geo:polygon</a></div></div>");
        fDocs.put("geo:polygon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">geo:polygon(</div><div style=\"padding-left:2em;\">polygon as element()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a cts:polygon value from a polygon element in one of the supported markup vocabularies. This polygon represents the exterior polygon for those vocabularies that include both exterior and interior polygons in their representation. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:geo:polygon\">Complete Information for geo:polygon</a></div></div>");
        fDocs.put("geo:interior-polygon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">geo:interior-polygon(</div><div style=\"padding-left:2em;\">polygon as element()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a sequence of cts:polygon values from a polygon element in one of the supported markup vocabularies. These polygons represent the interior polygons, if any. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:geo:interior-polygon\">Complete Information for geo:interior-polygon</a></div></div>");
        fDocs.put("geo:geospatial-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">geo:geospatial-query(</div><div style=\"padding-left:2em;\">regions as cts:region*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a cts:query matching points within given regions. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:geo:geospatial-query\">Complete Information for geo:geospatial-query</a></div></div>");
        fDocs.put("geo:geospatial-query-from-elements", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">geo:geospatial-query-from-elements(</div><div style=\"padding-left:2em;\">regions as element()*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a cts:query matching points within given regions. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:geo:geospatial-query-from-elements\">Complete Information for geo:geospatial-query-from-elements</a></div></div>");
        fDocs.put("fn:abs", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:abs(</div><div style=\"padding-left:2em;\">arg as numeric?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns the absolute value of $arg. If $arg is negative returns -$arg otherwise returns $arg. If type of $arg is one of the four numeric types xs:float, xs:double, xs:decimal or xs:integer the type of the result is the same as the type of $arg. If the type of $arg is a type derived from one of the numeric types, the result is an instance of the base numeric type. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For xs:float and xs:double arguments, if the argument is positive zero (+0) or negative zero (-0), then positive zero (+0) is returned. If the argument is positive or negative infinity, positive infinity is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For detailed type semantics, see Section 7.2.1 The fn:abs, fn:ceiling, fn:floor, fn:round, and fn:round-half-to-even functions of [XQuery 1.0 and XPath 2.0 Formal Semantics]. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:abs\">Complete Information for fn:abs</a></div></div>");
        fDocs.put("fn:ceiling", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:ceiling(</div><div style=\"padding-left:2em;\">arg as numeric?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns the smallest (closest to negative infinity) number with no fractional part that is not less than the value of $arg. If type of $arg is one of the four numeric types xs:float, xs:double, xs:decimal or xs:integer the type of the result is the same as the type of $arg. If the type of $arg is a type derived from one of the numeric types, the result is an instance of the base numeric type. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For xs:float and xs:double arguments, if the argument is positive zero, then positive zero is returned. If the argument is negative zero, then negative zero is returned. If the argument is less than zero and greater than -1, negative zero is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For detailed type semantics, see Section 7.2.3 The fn:abs, fn:ceiling, fn:floor, fn:round, and fn:round-half-to-even functions[FS]. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:ceiling\">Complete Information for fn:ceiling</a></div></div>");
        fDocs.put("fn:floor", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:floor(</div><div style=\"padding-left:2em;\">arg as numeric?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns the largest (closest to positive infinity) number with no fractional part that is not greater than the value of $arg. If type of $arg is one of the four numeric types xs:float, xs:double, xs:decimal or xs:integer the type of the result is the same as the type of $arg. If the type of $arg is a type derived from one of the numeric types, the result is an instance of the base numeric type. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For float and double arguments, if the argument is positive zero, then positive zero is returned. If the argument is negative zero, then negative zero is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For detailed type semantics, see Section 7.2.3 The fn:abs, fn:ceiling, fn:floor, fn:round, and fn:round-half-to-even functions[FS]. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:floor\">Complete Information for fn:floor</a></div></div>");
        fDocs.put("fn:round", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:round(</div><div style=\"padding-left:2em;\">arg as numeric?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns the number with no fractional part that is closest to the argument. If there are two such numbers, then the one that is closest to positive infinity is returned. If type of $arg is one of the four numeric types xs:float, xs:double, xs:decimal or xs:integer the type of the result is the same as the type of $arg. If the type of $arg is a type derived from one of the numeric types, the result is an instance of the base numeric type. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For xs:float and xs:double arguments, if the argument is positive infinity, then positive infinity is returned. If the argument is negative infinity, then negative infinity is returned. If the argument is positive zero, then positive zero is returned. If the argument is negative zero, then negative zero is returned. If the argument is less than zero, but greater than or equal to -0.5, then negative zero is returned. In the cases where positive zero or negative zero is returned, negative zero or positive zero may be returned as [XML Schema Part 2: Datatypes Second Edition] does not distinguish between the values positive zero and negative zero. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For the last two cases, note that the result is not the same as fn:floor(x+0.5). </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For detailed type semantics, see Section 7.2.3 The fn:abs, fn:ceiling, fn:floor, fn:round, and fn:round-half-to-even functions[FS]. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:round\">Complete Information for fn:round</a></div></div>");
        fDocs.put("fn:round-half-to-even", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:round-half-to-even(</div><div style=\"padding-left:2em;\">arg as numeric?,</div><div style=\"padding-left:2em;\">[precision as xs:integer]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> The value returned is the nearest (that is, numerically closest) numeric to $arg that is a multiple of ten to the power of minus $precision. If two such values are equally near (e.g. if the fractional part in $arg is exactly .500...), returns the one whose least significant digit is even. If type of $arg is one of the four numeric types xs:float, xs:double, xs:decimal or xs:integer the type of the result is the same as the type of $arg. If the type of $arg is a type derived from one of the numeric types, the result is an instance of the base numeric type. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If no precision is specified, the result produces is the same as with $precision=0. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For arguments of type xs:float and xs:double, if the argument is positive zero, then positive zero is returned. If the argument is negative zero, then negative zero is returned. If the argument is less than zero, but greater than or equal o -0.5, then negative zero is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is of type xs:float or xs:double, rounding occurs on the value of the mantissa computed with exponent = 0. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For detailed type semantics, see Section 7.2.3 The fn:abs, fn:ceiling, fn:floor, fn:round, and fn:round-half-to-even functions[FS]. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:round-half-to-even\">Complete Information for fn:round-half-to-even</a></div></div>");
        fDocs.put("fn:matches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:matches(</div><div style=\"padding-left:2em;\">input as xs:string?,</div><div style=\"padding-left:2em;\">pattern as xs:string,</div><div style=\"padding-left:2em;\">[flags as xs:string]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns <code xmlns=\"http://www.w3.org/1999/xhtml\">true</code> if the specified $input matches the specified $pattern, otherwise returns <code xmlns=\"http://www.w3.org/1999/xhtml\">false</code>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:matches\">Complete Information for fn:matches</a></div></div>");
        fDocs.put("fn:replace", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:replace(</div><div style=\"padding-left:2em;\">input as xs:string?,</div><div style=\"padding-left:2em;\">pattern as xs:string,</div><div style=\"padding-left:2em;\">replacement as xs:string,</div><div style=\"padding-left:2em;\">[flags as xs:string]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a string constructed by replacing the specified $pattern on the $input string with the specified $replacement string. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:replace\">Complete Information for fn:replace</a></div></div>");
        fDocs.put("fn:tokenize", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:tokenize(</div><div style=\"padding-left:2em;\">input as xs:string?,</div><div style=\"padding-left:2em;\">pattern as xs:string,</div><div style=\"padding-left:2em;\">[flags as xs:string]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of strings contructed by breaking the specified input into substrings separated by the specified $pattern. The specified $pattern is not returned as part of the returned items. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:tokenize\">Complete Information for fn:tokenize</a></div></div>");
        fDocs.put("fn:years-from-duration", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:years-from-duration(</div><div style=\"padding-left:2em;\">arg as xs:duration?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns an xs:integer representing the years component in the canonical lexical representation of the value of $arg. The result may be negative. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:years-from-duration\">Complete Information for fn:years-from-duration</a></div></div>");
        fDocs.put("fn:months-from-duration", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:months-from-duration(</div><div style=\"padding-left:2em;\">arg as xs:duration?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns an xs:integer representing the months component in the canonical lexical representation of the value of $arg. The result may be negative. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:months-from-duration\">Complete Information for fn:months-from-duration</a></div></div>");
        fDocs.put("fn:days-from-duration", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:days-from-duration(</div><div style=\"padding-left:2em;\">arg as xs:duration?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns an xs:integer representing the days component in the canonical lexical representation of the value of $arg. The result may be negative. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:days-from-duration\">Complete Information for fn:days-from-duration</a></div></div>");
        fDocs.put("fn:hours-from-duration", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:hours-from-duration(</div><div style=\"padding-left:2em;\">arg as xs:duration?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns an xs:integer representing the hours component in the canonical lexical representation of the value of $arg. The result may be negative. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:hours-from-duration\">Complete Information for fn:hours-from-duration</a></div></div>");
        fDocs.put("fn:minutes-from-duration", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:minutes-from-duration(</div><div style=\"padding-left:2em;\">arg as xs:duration?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns an xs:integer representing the minutes component in the canonical lexical representation of the value of $arg. The result may be negative. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:minutes-from-duration\">Complete Information for fn:minutes-from-duration</a></div></div>");
        fDocs.put("fn:seconds-from-duration", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:seconds-from-duration(</div><div style=\"padding-left:2em;\">arg as xs:duration?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns an xs:decimal representing the seconds component in the canonical lexical representation of the value of $arg. The result may be negative. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:seconds-from-duration\">Complete Information for fn:seconds-from-duration</a></div></div>");
        fDocs.put("fn:year-from-dateTime", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:year-from-dateTime(</div><div style=\"padding-left:2em;\">arg as xs:dateTime?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns an xs:integer representing the year component in the localized value of $arg. The result may be negative. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:year-from-dateTime\">Complete Information for fn:year-from-dateTime</a></div></div>");
        fDocs.put("fn:month-from-dateTime", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:month-from-dateTime(</div><div style=\"padding-left:2em;\">arg as xs:dateTime?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns an xs:integer between 1 and 12, both inclusive, representing the month component in the localized value of $arg. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:month-from-dateTime\">Complete Information for fn:month-from-dateTime</a></div></div>");
        fDocs.put("fn:day-from-dateTime", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:day-from-dateTime(</div><div style=\"padding-left:2em;\">arg as xs:dateTime?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns an xs:integer between 1 and 31, both inclusive, representing the day component in the localized value of $arg. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:day-from-dateTime\">Complete Information for fn:day-from-dateTime</a></div></div>");
        fDocs.put("fn:hours-from-dateTime", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:hours-from-dateTime(</div><div style=\"padding-left:2em;\">arg as xs:dateTime?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns an xs:integer between 0 and 23, both inclusive, representing the hours component in the localized value of $arg. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:hours-from-dateTime\">Complete Information for fn:hours-from-dateTime</a></div></div>");
        fDocs.put("fn:minutes-from-dateTime", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:minutes-from-dateTime(</div><div style=\"padding-left:2em;\">arg as xs:dateTime?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns an xs:integer value between 0 and 59, both inclusive, representing the minute component in the localized value of $arg. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:minutes-from-dateTime\">Complete Information for fn:minutes-from-dateTime</a></div></div>");
        fDocs.put("fn:seconds-from-dateTime", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:seconds-from-dateTime(</div><div style=\"padding-left:2em;\">arg as xs:dateTime?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns an xs:decimal value between 0 and 60.999..., both inclusive representing the seconds and fractional seconds in the localized value of $arg. Note that the value can be greater than 60 seconds to accommodate occasional leap seconds used to keep human time synchronized with the rotation of the planet. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:seconds-from-dateTime\">Complete Information for fn:seconds-from-dateTime</a></div></div>");
        fDocs.put("fn:timezone-from-dateTime", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:timezone-from-dateTime(</div><div style=\"padding-left:2em;\">arg as xs:dateTime?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns the timezone component of $arg if any. If $arg has a timezone component, then the result is an xs:dayTimeDuration that indicates deviation from UTC; its value may range from +14:00 to -14:00 hours, both inclusive. Otherwise, the result is the empty sequence. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:timezone-from-dateTime\">Complete Information for fn:timezone-from-dateTime</a></div></div>");
        fDocs.put("fn:year-from-date", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:year-from-date(</div><div style=\"padding-left:2em;\">arg as xs:dateTime?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns an xs:integer representing the year component in the localized value of $arg. The result may be negative. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:year-from-date\">Complete Information for fn:year-from-date</a></div></div>");
        fDocs.put("fn:month-from-date", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:month-from-date(</div><div style=\"padding-left:2em;\">arg as xs:dateTime?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns an xs:integer between 1 and 12, both inclusive, representing the month component in the localized value of $arg. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:month-from-date\">Complete Information for fn:month-from-date</a></div></div>");
        fDocs.put("fn:day-from-date", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:day-from-date(</div><div style=\"padding-left:2em;\">arg as xs:dateTime?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns an xs:integer between 1 and 31, both inclusive, representing the day component in the localized value of $arg. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:day-from-date\">Complete Information for fn:day-from-date</a></div></div>");
        fDocs.put("fn:timezone-from-date", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:timezone-from-date(</div><div style=\"padding-left:2em;\">arg as xs:dateTime?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns the timezone component of $arg if any. If $arg has a timezone component, then the result is an xs:dayTimeDuration that indicates deviation from UTC; its value may range from +14:00 to -14:00 hours, both inclusive. Otherwise, the result is the empty sequence. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:timezone-from-date\">Complete Information for fn:timezone-from-date</a></div></div>");
        fDocs.put("fn:hours-from-time", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:hours-from-time(</div><div style=\"padding-left:2em;\">arg as xs:time?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns an xs:integer between 0 and 23, both inclusive, representing the value of the hours component in the localized value of $arg. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:hours-from-time\">Complete Information for fn:hours-from-time</a></div></div>");
        fDocs.put("fn:minutes-from-time", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:minutes-from-time(</div><div style=\"padding-left:2em;\">arg as xs:time?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns an xs:integer value between 0 to 59, both inclusive, representing the value of the minutes component in the localized value of $arg. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:minutes-from-time\">Complete Information for fn:minutes-from-time</a></div></div>");
        fDocs.put("fn:seconds-from-time", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:seconds-from-time(</div><div style=\"padding-left:2em;\">arg as xs:time?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns an xs:decimal value between 0 and 60.999..., both inclusive, representing the seconds and fractional seconds in the localized value of $arg. Note that the value can be greater than 60 seconds to accommodate occasional leap seconds used to keep human time synchronized with the rotation of the planet. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:seconds-from-time\">Complete Information for fn:seconds-from-time</a></div></div>");
        fDocs.put("fn:timezone-from-time", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:timezone-from-time(</div><div style=\"padding-left:2em;\">arg as xs:time?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns the timezone component of $arg if any. If $arg has a timezone component, then the result is an xs:dayTimeDuration that indicates deviation from UTC; its value may range from +14:00 to -14:00 hours, both inclusive. Otherwise, the result is the empty sequence. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, returns the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:timezone-from-time\">Complete Information for fn:timezone-from-time</a></div></div>");
        fDocs.put("fn:adjust-dateTime-to-timezone", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:adjust-dateTime-to-timezone(</div><div style=\"padding-left:2em;\">arg as xs:dateTime?,</div><div style=\"padding-left:2em;\">[timezone as xs:dayTimeDuration?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Adjusts an xs:dateTime value to a specific timezone, or to no timezone at all. If $timezone is the empty sequence, returns an xs:dateTime without a timezone. Otherwise, returns an xs:dateTime with a timezone. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $timezone is not specified, then $timezone is the value of the implicit timezone in the dynamic context. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, then the result is the empty sequence. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> A dynamic error is raised [err:FODT0003] if $timezone is less than -PT14H or greater than PT14H or if does not contain an integral number of minutes. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg does not have a timezone component and $timezone is the empty sequence, then the result is $arg. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg does not have a timezone component and $timezone is not the empty sequence, then the result is $arg with $timezone as the timezone component. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg has a timezone component and $timezone is the empty sequence, then the result is the localized value of $arg without its timezone component. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg has a timezone component and $timezone is not the empty sequence, then the result is an xs:dateTime value with a timezone component of $timezone that is equal to $arg. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:adjust-dateTime-to-timezone\">Complete Information for fn:adjust-dateTime-to-timezone</a></div></div>");
        fDocs.put("fn:adjust-date-to-timezone", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:adjust-date-to-timezone(</div><div style=\"padding-left:2em;\">arg as xs:date?,</div><div style=\"padding-left:2em;\">[timezone as xs:dayTimeDuration?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Adjusts an xs:date value to a specific timezone, or to no timezone at all. If $timezone is the empty sequence, returns an xs:date without a timezone. Otherwise, returns an xs:date with a timezone. For purposes of timezone adjustment, an xs:date is treated as an xs:dateTime with time 00:00:00. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $timezone is not specified, then $timezone is the value of the implicit timezone in the dynamic context. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, then the result is the empty sequence. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> A dynamic error is raised [err:FODT0003] if $timezone is less than -PT14H or greater than PT14H or if does not contain an integral number of minutes. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg does not have a timezone component and $timezone is the empty sequence, then the result is $arg. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg does not have a timezone component and $timezone is not the empty sequence, then the result is $arg with $timezone as the timezone component. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg has a timezone component and $timezone is the empty sequence, then the result is the localized value of $arg without its timezone component. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg has a timezone component and $timezone is not the empty sequence, then: </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Let $srcdt be an xs:dateTime value, with 00:00:00 for the time component and date and timezone components that are the same as the date and timezone components of $arg. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Let $r be the result of evaluating fn:adjust-dateTime-to-timezone($srcdt, $timezone) </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The result of this function will be a date value that has date and timezone components that are the same as the date and timezone components of $r. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:adjust-date-to-timezone\">Complete Information for fn:adjust-date-to-timezone</a></div></div>");
        fDocs.put("fn:adjust-time-to-timezone", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:adjust-time-to-timezone(</div><div style=\"padding-left:2em;\">arg as xs:date?,</div><div style=\"padding-left:2em;\">[timezone as xs:dayTimeDuration?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Adjusts an xs:time value to a specific timezone, or to no timezone at all. If $timezone is the empty sequence, returns an xs:time without a timezone. Otherwise, returns an xs:time with a timezone. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $timezone is not specified, then $timezone is the value of the implicit timezone in the dynamic context. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, then the result is the empty sequence. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> A dynamic error is raised [err:FODT0003] if $timezone is less than -PT14H or greater than PT14H or if does not contain an integral number of minutes. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg does not have a timezone component and $timezone is the empty sequence, then the result is $arg. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg does not have a timezone component and $timezone is not the empty sequence, then the result is $arg with $timezone as the timezone component. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg has a timezone component and $timezone is the empty sequence, then the result is the localized value of $arg without its timezone component. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg has a timezone component and $timezone is not the empty sequence, then: </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Let $srcdt be an xs:dateTime value, with an arbitrary date for the date component and time and timezone components that are the same as the time and timezone components of $arg. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Let $r be the result of evaluating fn:adjust-dateTime-to-timezone($srcdt, $timezone) </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The result of this function will be a time value that has time and timezone components that are the same as the time and timezone components of $r. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:adjust-time-to-timezone\">Complete Information for fn:adjust-time-to-timezone</a></div></div>");
        fDocs.put("fn:subtract-dateTimes-yielding-yearMonthDuration", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:subtract-dateTimes-yielding-yearMonthDuration(</div><div style=\"padding-left:2em;\">srcval1 as xs:dateTime,</div><div style=\"padding-left:2em;\">srcval1 as xs:dateTime</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> [0.9-ml only, use the minus operator ( - ) instead] Returns the <code>xdt:yearMonthDuration</code> hat corresponds to the difference between the normalized value of $srcval1 and the normalized value of $srcval2. If either argument is the empty sequence, returns the empty sequence. If the normalized value of $srcval1 precedes in time the normalized value of $srcval2, the returned value is a negative duration. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:subtract-dateTimes-yielding-yearMonthDuration\">Complete Information for fn:subtract-dateTimes-yielding-yearMonthDuration</a></div></div>");
        fDocs.put("fn:subtract-dateTimes-yielding-dayTimeDuration", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:subtract-dateTimes-yielding-dayTimeDuration(</div><div style=\"padding-left:2em;\">srcval1 as xs:dateTime,</div><div style=\"padding-left:2em;\">srcval1 as xs:dateTime</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> [0.9-ml only, use the minus operator ( - ) instead] Returns the <code>xdt:dayTimeDuration</code> that corresponds to the difference between the normalized value of $srcval1 and the normalized value of $srcval2. If either argument is the empty sequence, returns the empty sequence. If the normalized value of $srcval1 precedes in time the normalized value of $srcval2, then the returned value is a negative duration. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:subtract-dateTimes-yielding-dayTimeDuration\">Complete Information for fn:subtract-dateTimes-yielding-dayTimeDuration</a></div></div>");
        fDocs.put("xdmp:zip-manifest", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:zip-manifest(</div><div style=\"padding-left:2em;\">zipfile as binary()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Return a manifest for this zip file. The manifest contains information about what is in the zip file. The form of the manifest is: <pre xml:space=\"preserve\" xmlns=\"http://www.w3.org/1999/xhtml\"> &lt;parts xmlns=\"xdmp:zip\"&gt; &lt;part uncompressed-size=\"[size]\" compressed-size=\"[size]\" encrypted=\"[true/false]\"&gt;path1&lt;/part&gt; &lt;part uncompressed-size=\"[size]\" compressed-size=\"[size]\" encrypted=\"[true/false]\"&gt;path2&lt;/part&gt; ...more parts &lt;/parts&gt; </pre> Each &lt;part&gt; is a file within the zip. The attributes specify the uncompressed size for the file, the compressed size for that file, whether or not the file is encrypted, and the last-modified timestamp. Note that MarkLogic cannot exctract encrypted files, attempting to do so will cause an error. Also note that due to a limitation in the zip file format, the last-modified time has a granularity of two seconds (e.g. 10:22:33 becomes 10:22:32). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:zip-manifest\">Complete Information for xdmp:zip-manifest</a></div></div>");
        fDocs.put("xdmp:zip-get", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:zip-get(</div><div style=\"padding-left:2em;\">zipfile as binary(),</div><div style=\"padding-left:2em;\">name as xs:string,</div><div style=\"padding-left:2em;\">[options as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Get a named file from a zip document. Unzips and returns the file in memory as a document node (for XML formats), a text node (for text formats), or a binary node (for binary formats). The format is determined either by the mimetype from the file name or by the <code xmlns=\"http://www.w3.org/1999/xhtml\">format</code> option. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:zip-get\">Complete Information for xdmp:zip-get</a></div></div>");
        fDocs.put("xdmp:zip-create", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:zip-create(</div><div style=\"padding-left:2em;\">manifest as node(),</div><div style=\"padding-left:2em;\">nodes as node()+</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a zip file from a list of nodes. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:zip-create\">Complete Information for xdmp:zip-create</a></div></div>");
        fDocs.put("cts:train", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:train(</div><div style=\"padding-left:2em;\">training-nodes as node()*,</div><div style=\"padding-left:2em;\">labels as element(cts:label)*,</div><div style=\"padding-left:2em;\">[options as element()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Produces a set of classifiers from a list of labeled training documents. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:train\">Complete Information for cts:train</a></div></div>");
        fDocs.put("cts:classify", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:classify(</div><div style=\"padding-left:2em;\">data-nodes as node()*,</div><div style=\"padding-left:2em;\">classifier as element(cts:classifier),</div><div style=\"padding-left:2em;\">options as element()?,</div><div style=\"padding-left:2em;\">training-nodes as node()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Classifies a sequence of nodes based on training data. The training data is in the form of a classifier specification, which is generated from the output of <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:train</code>. Returns labels for each of the input documents in the same order as the input document. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:classify\">Complete Information for cts:classify</a></div></div>");
        fDocs.put("cts:thresholds", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:thresholds(</div><div style=\"padding-left:2em;\">computed-labels as element(cts:label)*,</div><div style=\"padding-left:2em;\">known-labels as element(cts:label)*,</div><div style=\"padding-left:2em;\">[recall-weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Compute precision, recall, the F measure, and thresholds for the classes computed by the classifier, by comparing with the labels for the same set. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:thresholds\">Complete Information for cts:thresholds</a></div></div>");
        fDocs.put("msword:clean", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">msword:clean(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">doc as node()?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Clean up any conversion artifacts or other infelicities. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:msword:clean\">Complete Information for msword:clean</a></div></div>");
        fDocs.put("xdmp:host-status", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:host-status(</div><div style=\"padding-left:2em;\">host-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the status of a host. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:host-status\">Complete Information for xdmp:host-status</a></div></div>");
        fDocs.put("xdmp:forest-status", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:forest-status(</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the status of a forest. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:forest-status\">Complete Information for xdmp:forest-status</a></div></div>");
        fDocs.put("xdmp:server-status", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:server-status(</div><div style=\"padding-left:2em;\">host-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">server-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the status of an app-server on a host. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:server-status\">Complete Information for xdmp:server-status</a></div></div>");
        fDocs.put("xdmp:forest-counts", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:forest-counts(</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">[show-elements as xs:string*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns detailed forest statistics for a given forest. This built-in may require significantly more processing time than <code xmlns=\"http://www.w3.org/1999/xhtml\">xdmp:forest-status</code>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:forest-counts\">Complete Information for xdmp:forest-counts</a></div></div>");
        fDocs.put("xdmp:request-status", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:request-status(</div><div style=\"padding-left:2em;\">host-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">server-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">request-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns the status of a running request. If the request ID is that of the calling request, then no special permission is required. If the ID is for another request, then the calling request needs <code>http://marklogic.com/xdmp/privileges/status</code> permission. </p> <p xmlns=\"http://www.w3.org/1999/xhtml\"> The result of this builtin is exactly equivalent to <code>xdmp:server-status(xdmp:host(), xdmp:server())//*:request-status[*:request-id = $req]</code>, where <code>$req</code> is the ID of the request you are interested in. </p> <p xmlns=\"http://www.w3.org/1999/xhtml\"> In the 3.2 release this builtin is not cluster-aware, the first argument (host id) must be the same as the value returned by <code>xdmp:host()</code>. If you wish to obtain the status of a request running on a remote host, use the code snippet above to obtain the request status using <code>xdmp:server-status()</code>. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:request-status\">Complete Information for xdmp:request-status</a></div></div>");
        fDocs.put("kml:point", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">kml:point(</div><div style=\"padding-left:2em;\">point as element()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a cts:point value from a KML Point or Location element. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:kml:point\">Complete Information for kml:point</a></div></div>");
        fDocs.put("kml:box", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">kml:box(</div><div style=\"padding-left:2em;\">envelope as element(kml:LatLongBox)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a cts:point value from a KML LatLongBox element. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:kml:box\">Complete Information for kml:box</a></div></div>");
        fDocs.put("kml:circle", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">kml:circle(</div><div style=\"padding-left:2em;\">radius as xs:double,</div><div style=\"padding-left:2em;\">center as element()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a cts:circle value from a radius and KML Point or Location element. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:kml:circle\">Complete Information for kml:circle</a></div></div>");
        fDocs.put("kml:polygon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">kml:polygon(</div><div style=\"padding-left:2em;\">points as element(kml:Point)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a cts:polygon value from a sequence of KML Point or Location elements. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:kml:polygon\">Complete Information for kml:polygon</a></div></div>");
        fDocs.put("kml:polygon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">kml:polygon(</div><div style=\"padding-left:2em;\">points as element(kml:Polygon)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a cts:polygon value from a KML Polygon element. The polygon returned represents the exterior polygon. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:kml:polygon\">Complete Information for kml:polygon</a></div></div>");
        fDocs.put("kml:interior-polygon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">kml:interior-polygon(</div><div style=\"padding-left:2em;\">points as element(kml:Polygon)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a sequence of cts:polygon values from a KML Polygon element. The polygons returned represent the interior polygons, if any. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:kml:interior-polygon\">Complete Information for kml:interior-polygon</a></div></div>");
        fDocs.put("kml:geospatial-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">kml:geospatial-query(</div><div style=\"padding-left:2em;\">regions as cts:region*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a cts:query matching points within given regions. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:kml:geospatial-query\">Complete Information for kml:geospatial-query</a></div></div>");
        fDocs.put("kml:geospatial-query-from-elements", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">kml:geospatial-query-from-elements(</div><div style=\"padding-left:2em;\">regions as element()*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a cts:query matching points within given regions. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:kml:geospatial-query-from-elements\">Complete Information for kml:geospatial-query-from-elements</a></div></div>");
        fDocs.put("xdmp:url-encode", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:url-encode(</div><div style=\"padding-left:2em;\">plaintext as xs:string,</div><div style=\"padding-left:2em;\">[noSpacePlus as xs:boolean?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Converts plaintext into URL-encoded string. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:url-encode\">Complete Information for xdmp:url-encode</a></div></div>");
        fDocs.put("xdmp:url-decode", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:url-decode(</div><div style=\"padding-left:2em;\">encoded as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Converts URL-encoded string to plaintext. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:url-decode\">Complete Information for xdmp:url-decode</a></div></div>");
        fDocs.put("xdmp:login", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:login(</div><div style=\"padding-left:2em;\">name as xs:string,</div><div style=\"padding-left:2em;\">[password as xs:string?,]</div><div style=\"padding-left:2em;\">[set-session as xs:boolean?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Logs in a user on an application server that is using application-level authentication and deposits a session cookie. Returns true on success, false on failure.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\">If the user calling this function has the <code>xdmp:login</code> privilege, this function can be called without a password or with the empty sequence as the password. In this case, login will succeed if the specified user exists. Therefore, use the <code>xdmp:login</code> privilege carefully, as any user with that privilege will be able to execute code that uses the <code>xdmp:login</code> function to log in as any user.</p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:login\">Complete Information for xdmp:login</a></div></div>");
        fDocs.put("xdmp:logout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:logout(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Sets the current user to the default user defined in application-level authentication. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:logout\">Complete Information for xdmp:logout</a></div></div>");
        fDocs.put("xdmp:get-request-field-names", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get-request-field-names(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of the request field names. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get-request-field-names\">Complete Information for xdmp:get-request-field-names</a></div></div>");
        fDocs.put("xdmp:get-request-field", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get-request-field(</div><div style=\"padding-left:2em;\">name as xs:string,</div><div style=\"padding-left:2em;\">[default as xs:string?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the value of a named request field. If the request field is a <code xmlns=\"http://www.w3.org/1999/xhtml\">multipart/form-data</code> type in a POST form, you can use <code xmlns=\"http://www.w3.org/1999/xhtml\">xdmp:get-request-field</code> for file upload applications (see the <a href=\"#grf2\" xmlns=\"http://www.w3.org/1999/xhtml\">second example</a> below). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get-request-field\">Complete Information for xdmp:get-request-field</a></div></div>");
        fDocs.put("xdmp:get-request-field-filename", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get-request-field-filename(</div><div style=\"padding-left:2em;\">field-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a list of filenames from a multipart request for the field name specified. Returns an empty sequence for a field that does not exist. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get-request-field-filename\">Complete Information for xdmp:get-request-field-filename</a></div></div>");
        fDocs.put("xdmp:get-request-field-content-type", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get-request-field-content-type(</div><div style=\"padding-left:2em;\">field-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function is used to extract the content type from the request field. It returns a sequence of content types, one for each filename, in the same order as the filenames returned from <code xmlns=\"http://www.w3.org/1999/xhtml\">xdmp:get-request-field-filename</code>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get-request-field-content-type\">Complete Information for xdmp:get-request-field-content-type</a></div></div>");
        fDocs.put("xdmp:get-request-header-names", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get-request-header-names(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of request header names. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get-request-header-names\">Complete Information for xdmp:get-request-header-names</a></div></div>");
        fDocs.put("xdmp:get-request-header", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get-request-header(</div><div style=\"padding-left:2em;\">name as xs:string,</div><div style=\"padding-left:2em;\">[default as xs:string?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the value of a named request header. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get-request-header\">Complete Information for xdmp:get-request-header</a></div></div>");
        fDocs.put("xdmp:get-request-username", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get-request-username(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the username from the <code xmlns=\"http://www.w3.org/1999/xhtml\">Authorization</code> header of this App Server request. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get-request-username\">Complete Information for xdmp:get-request-username</a></div></div>");
        fDocs.put("xdmp:get-request-method", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get-request-method(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the HTTP request method. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get-request-method\">Complete Information for xdmp:get-request-method</a></div></div>");
        fDocs.put("xdmp:get-request-path", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get-request-path(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the HTTP request path. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get-request-path\">Complete Information for xdmp:get-request-path</a></div></div>");
        fDocs.put("xdmp:get-request-url", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get-request-url(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the portion of the URL following the host_name:port_number. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get-request-url\">Complete Information for xdmp:get-request-url</a></div></div>");
        fDocs.put("xdmp:get-session-field-names", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get-session-field-names(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of the HTTP session field names. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get-session-field-names\">Complete Information for xdmp:get-session-field-names</a></div></div>");
        fDocs.put("xdmp:get-session-field", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get-session-field(</div><div style=\"padding-left:2em;\">name as xs:string,</div><div style=\"padding-left:2em;\">[default as item()*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the value of a named HTTP session field. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get-session-field\">Complete Information for xdmp:get-session-field</a></div></div>");
        fDocs.put("xdmp:set-session-field", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:set-session-field(</div><div style=\"padding-left:2em;\">name as xs:string,</div><div style=\"padding-left:2em;\">value as item()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Sets the value of a named HTTP session field. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:set-session-field\">Complete Information for xdmp:set-session-field</a></div></div>");
        fDocs.put("xdmp:redirect-response", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:redirect-response(</div><div style=\"padding-left:2em;\">name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Redirects the App Server response to a given location. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:redirect-response\">Complete Information for xdmp:redirect-response</a></div></div>");
        fDocs.put("xdmp:set-response-code", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:set-response-code(</div><div style=\"padding-left:2em;\">code as xs:integer,</div><div style=\"padding-left:2em;\">message as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Sets the response code and message. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:set-response-code\">Complete Information for xdmp:set-response-code</a></div></div>");
        fDocs.put("xdmp:get-response-code", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get-response-code(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns two nodes, the first containing the HTTP response code and the second containing the HTTP response message. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get-response-code\">Complete Information for xdmp:get-response-code</a></div></div>");
        fDocs.put("xdmp:set-response-content-type", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:set-response-content-type(</div><div style=\"padding-left:2em;\">name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Sets the response content-type. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:set-response-content-type\">Complete Information for xdmp:set-response-content-type</a></div></div>");
        fDocs.put("xdmp:set-response-encoding", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:set-response-encoding(</div><div style=\"padding-left:2em;\">encoding as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Sets the response encoding. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:set-response-encoding\">Complete Information for xdmp:set-response-encoding</a></div></div>");
        fDocs.put("xdmp:get-response-encoding", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get-response-encoding(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the encoding that the response from this server is in. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get-response-encoding\">Complete Information for xdmp:get-response-encoding</a></div></div>");
        fDocs.put("xdmp:set-request-time-limit", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:set-request-time-limit(</div><div style=\"padding-left:2em;\">time-limit as xs:unsignedInt,</div><div style=\"padding-left:2em;\">[hostID as xs:unsignedLong?,]</div><div style=\"padding-left:2em;\">[serverID as xs:unsignedLong?,]</div><div style=\"padding-left:2em;\">[requestID as xs:unsignedLong?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Changes the time limit for an actively running request to the specified value. If you do not supply values for the last three parameters, the function sets the time limit for the current request. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:set-request-time-limit\">Complete Information for xdmp:set-request-time-limit</a></div></div>");
        fDocs.put("xdmp:add-response-header", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:add-response-header(</div><div style=\"padding-left:2em;\">name as xs:string,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Adds an HTTP response header field. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:add-response-header\">Complete Information for xdmp:add-response-header</a></div></div>");
        fDocs.put("xdmp:uri-is-file", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:uri-is-file(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns true if a given URI refers to a file which exists on the current application server. Returns false if the file does not exist. Returns the empty sequence if the URI is the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:uri-is-file\">Complete Information for xdmp:uri-is-file</a></div></div>");
        fDocs.put("xdmp:get-request-client-address", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get-request-client-address(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns as a string the internet address of the client from which the HTTP server request is issued. <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns the empty sequence if it is not called from an HTTP server.</p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get-request-client-address\">Complete Information for xdmp:get-request-client-address</a></div></div>");
        fDocs.put("xdmp:get-request-protocol", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get-request-protocol(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns as a string the request protocol (either \"http\" or \"https\") <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns the empty sequence if it is not called from an HTTP server.</p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get-request-protocol\">Complete Information for xdmp:get-request-protocol</a></div></div>");
        fDocs.put("xdmp:get-request-client-certificate", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get-request-client-certificate(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the PEM encoded client certificate if one was presented. <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns the empty sequence if it is not called from an HTTP server, if SSL is not enabled for the HTTP server, or if no certificate is available. A clients will not send its certificate unless the server requests it.</p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get-request-client-certificate\">Complete Information for xdmp:get-request-client-certificate</a></div></div>");
        fDocs.put("xdmp:get-request-body", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get-request-body(</div><div style=\"padding-left:2em;\">[format as xs:string?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the POST or PUT body of this request, if it is not application/x-www-form-urlencoded. <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns the empty sequence if it is not called from an application server.</p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get-request-body\">Complete Information for xdmp:get-request-body</a></div></div>");
        fDocs.put("cvt:basepath", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cvt:basepath(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Return the base path of the URI, cutting off the filename. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cvt:basepath\">Complete Information for cvt:basepath</a></div></div>");
        fDocs.put("cvt:basename", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cvt:basename(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Return the filename part of the URI, cutting off any query strings or fragments. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cvt:basename\">Complete Information for cvt:basename</a></div></div>");
        fDocs.put("cvt:destination-uri", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cvt:destination-uri(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">extension as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Construct the destination URI from the source URI using the following rules: The path prefix of the destination URI is the same as the source URI's. The filename in the destination maps '.' to '_' and appends the given extension. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cvt:destination-uri\">Complete Information for cvt:destination-uri</a></div></div>");
        fDocs.put("cvt:part-uri", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cvt:part-uri(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">part as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Construct the URI for the part using the following rules: The path prefix of the part URI is the same source URI's, followed by a subdirectory name. The subdirectory name is formed by mapping '.' to '_' in the source filename and appending '_parts' to it. The part's filename is unchanged, but any part path is removed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cvt:part-uri\">Complete Information for cvt:part-uri</a></div></div>");
        fDocs.put("cvt:save-converted-documents", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cvt:save-converted-documents(</div><div style=\"padding-left:2em;\">source-uri as xs:string,</div><div style=\"padding-left:2em;\">destination-uri as xs:string,</div><div style=\"padding-left:2em;\">manifest as element(),</div><div style=\"padding-left:2em;\">docs as document-node()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Save a set of converted documents, with appropriate links. If there is a main document, it must be the first listed in the manifest. The order in the manifest (as in xdmp:xxx-convert) must match the order of document nodes. Any cleaning or other preprocessing of the documents must already have been done. If certain parts should have been created in a certain state or with other initial properties, that must be done after the call to this function. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cvt:save-converted-documents\">Complete Information for cvt:save-converted-documents</a></div></div>");
        fDocs.put("thsr:load", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">thsr:load(</div><div style=\"padding-left:2em;\">path as xs:string,</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Load the file specified in $path to the thesaurus at $uri. Exisiting documents at $uri are overwritten. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:thsr:load\">Complete Information for thsr:load</a></div></div>");
        fDocs.put("thsr:insert", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">thsr:insert(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">thsr as element(thsr:thesaurus)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Load the entries in $thsr into the thesaurus at $uri. If there is no document at $uri a new one will be created. If there is a document at $uri it will be overwritten. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:thsr:insert\">Complete Information for thsr:insert</a></div></div>");
        fDocs.put("thsr:set-entry", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">thsr:set-entry(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">entry as element(thsr:entry)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Adds the entry $entry to the thesaurus at $uri. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:thsr:set-entry\">Complete Information for thsr:set-entry</a></div></div>");
        fDocs.put("thsr:remove-term", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">thsr:remove-term(</div><div style=\"padding-left:2em;\">uri as xs:string*,</div><div style=\"padding-left:2em;\">term as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Removes all entries with term $term from the thesaurus document(s) at $uri. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:thsr:remove-term\">Complete Information for thsr:remove-term</a></div></div>");
        fDocs.put("thsr:remove-entry", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">thsr:remove-entry(</div><div style=\"padding-left:2em;\">uri as xs:string*,</div><div style=\"padding-left:2em;\">entry as element(thsr:entry)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Removes all entries that exactly match $entry from the thesaurus documents(s) at $uri. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:thsr:remove-entry\">Complete Information for thsr:remove-entry</a></div></div>");
        fDocs.put("thsr:add-synonym", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">thsr:add-synonym(</div><div style=\"padding-left:2em;\">entry as element(thsr:entry),</div><div style=\"padding-left:2em;\">synonym as element(thsr:synonym)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Adds a synonym to the specified thesaurus entry. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:thsr:add-synonym\">Complete Information for thsr:add-synonym</a></div></div>");
        fDocs.put("thsr:remove-synonym", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">thsr:remove-synonym(</div><div style=\"padding-left:2em;\">entry as element(thsr:entry),</div><div style=\"padding-left:2em;\">synonym as element(thsr:synonym)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Removes synonym $synonym from thesaurus entry $entry. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:thsr:remove-synonym\">Complete Information for thsr:remove-synonym</a></div></div>");
        fDocs.put("thsr:lookup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">thsr:lookup(</div><div style=\"padding-left:2em;\">uri as xs:string*,</div><div style=\"padding-left:2em;\">term as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns all entries for term $term in the thesaurus document(s) at $uri. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:thsr:lookup\">Complete Information for thsr:lookup</a></div></div>");
        fDocs.put("thsr:query-lookup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">thsr:query-lookup(</div><div style=\"padding-left:2em;\">uri as xs:string*,</div><div style=\"padding-left:2em;\">query as cts:query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of all entries that are found by looking up terms in the query and/or subqueries of $query in the thesaurus document(s) at $uri. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:thsr:query-lookup\">Complete Information for thsr:query-lookup</a></div></div>");
        fDocs.put("thsr:expand", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">thsr:expand(</div><div style=\"padding-left:2em;\">query as cts:query,</div><div style=\"padding-left:2em;\">entries as element(thsr:entry)*,</div><div style=\"padding-left:2em;\">new-weight as xs:double?,</div><div style=\"padding-left:2em;\">min-weight as xs:double?,</div><div style=\"padding-left:2em;\">filter as node()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query that searches for all the query strings specified in $query and their synonyms as found in $entries. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:thsr:expand\">Complete Information for thsr:expand</a></div></div>");
        fDocs.put("cpf:success", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cpf:success(</div><div style=\"padding-left:2em;\">docid as xs:string,</div><div style=\"padding-left:2em;\">transition as element(*, p:transition)?,</div><div style=\"padding-left:2em;\">override-state as xs:anyURI?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Concludes the action successfully, advancing the state as defined by the transition. The action must call this method to indicate completion of successful processing, passing the external variables <code xmlns=\"http://www.w3.org/1999/xhtml\">$cpf:document-uri</code> and <code xmlns=\"http://www.w3.org/1999/xhtml\">$cpf:transition</code> as parameters. If the document does not exist, do nothing. <p xmlns=\"http://www.w3.org/1999/xhtml\">Side effects: Advances the document state to the transition's on-success state, if any, and marks the document as processed in the current state. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cpf:success\">Complete Information for cpf:success</a></div></div>");
        fDocs.put("cpf:failure", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cpf:failure(</div><div style=\"padding-left:2em;\">docid as xs:string,</div><div style=\"padding-left:2em;\">transition as element(*, p:transition)?,</div><div style=\"padding-left:2em;\">exception as node()?,</div><div style=\"padding-left:2em;\">override-state as xs:anyURI?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Concludes the state action in failure, advancing the state as defined by the state transition. The state action must call this method to indicate failure, passing the external variables <code xmlns=\"http://www.w3.org/1999/xhtml\">$cpf:document-uri</code>, <code xmlns=\"http://www.w3.org/1999/xhtml\">$cpf:transition</code>, and <code xmlns=\"http://www.w3.org/1999/xhtml\">$cpf:exception</code> as parameters. If the document does not exist, do nothing. <p xmlns=\"http://www.w3.org/1999/xhtml\">Side effects: Advances the document state to the transition's on-failure state, if any, and marks the document as processed in the current state. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cpf:failure\">Complete Information for cpf:failure</a></div></div>");
        fDocs.put("cpf:check-transition", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cpf:check-transition(</div><div style=\"padding-left:2em;\">docid as xs:string,</div><div style=\"padding-left:2em;\">transition as element(*, p:transition)?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Verify that the current transition is the correct one for the document. If a document is touched from multiple threads certain race conditions may apply that will cause the lookup of the transition to end up out of sync with the transition action when it is actually executed. In this case the action should do nothing; not even call cpf:success or cpf:failure. Some other CPF thread has already done the work on this document. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cpf:check-transition\">Complete Information for cpf:check-transition</a></div></div>");
        fDocs.put("cpf:document-get-state", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cpf:document-get-state(</div><div style=\"padding-left:2em;\">doc as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Determine the document's current state, if any. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cpf:document-get-state\">Complete Information for cpf:document-get-state</a></div></div>");
        fDocs.put("cpf:document-set-state", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cpf:document-set-state(</div><div style=\"padding-left:2em;\">doc as xs:string,</div><div style=\"padding-left:2em;\">state as xs:anyURI</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Set the document's state to the given state. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cpf:document-set-state\">Complete Information for cpf:document-set-state</a></div></div>");
        fDocs.put("cpf:document-get-processing-status", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cpf:document-get-processing-status(</div><div style=\"padding-left:2em;\">doc as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Determine the document's current processing status, if any. The status will be one of \"created\", \"updated\", \"deleted\", \"active\", or \"done\". </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cpf:document-get-processing-status\">Complete Information for cpf:document-get-processing-status</a></div></div>");
        fDocs.put("cpf:document-set-processing-status", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cpf:document-set-processing-status(</div><div style=\"padding-left:2em;\">doc as xs:string,</div><div style=\"padding-left:2em;\">processing-status as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Set the document's processing status to the given value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cpf:document-set-processing-status\">Complete Information for cpf:document-set-processing-status</a></div></div>");
        fDocs.put("cpf:document-get-last-updated", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cpf:document-get-last-updated(</div><div style=\"padding-left:2em;\">doc as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Determine the date and time of the last update to the document's content, if any. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cpf:document-get-last-updated\">Complete Information for cpf:document-get-last-updated</a></div></div>");
        fDocs.put("cpf:document-set-last-updated", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cpf:document-set-last-updated(</div><div style=\"padding-left:2em;\">doc as xs:string,</div><div style=\"padding-left:2em;\">last-updated as xs:dateTime</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Set the date and time of the document's last update. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cpf:document-set-last-updated\">Complete Information for cpf:document-set-last-updated</a></div></div>");
        fDocs.put("cpf:document-get-error", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cpf:document-get-error(</div><div style=\"padding-left:2em;\">doc as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Fetch a trace of the error that caused the document's processing to fail, if any. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cpf:document-get-error\">Complete Information for cpf:document-get-error</a></div></div>");
        fDocs.put("cpf:document-set-error", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cpf:document-set-error(</div><div style=\"padding-left:2em;\">doc as xs:string,</div><div style=\"padding-left:2em;\">error as node()?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Set the document's error trace to the given value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cpf:document-set-error\">Complete Information for cpf:document-set-error</a></div></div>");
        fDocs.put("sec:create-user", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:create-user(</div><div style=\"padding-left:2em;\">user-name as xs:string,</div><div style=\"padding-left:2em;\">description as xs:string?,</div><div style=\"padding-left:2em;\">password as xs:string,</div><div style=\"padding-left:2em;\">role-names as xs:string*,</div><div style=\"padding-left:2em;\">permissions as element(sec:permission)*,</div><div style=\"padding-left:2em;\">collections as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Creates a new user in the system database for the context database. Returns the user ID of the created user. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:create-user\">Complete Information for sec:create-user</a></div></div>");
        fDocs.put("sec:create-user-with-role", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:create-user-with-role(</div><div style=\"padding-left:2em;\">user-name as xs:string,</div><div style=\"padding-left:2em;\">description as xs:string?,</div><div style=\"padding-left:2em;\">password as xs:string,</div><div style=\"padding-left:2em;\">role-names as xs:string*,</div><div style=\"padding-left:2em;\">permissions as element(sec:permission)*,</div><div style=\"padding-left:2em;\">collections as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Creates a new user in the system database for the context database. Returns the user ID of the created user. Also creates a role by the same name and assigns the newly-created user to the newly-created role. Parameters that define roles, permissions, and collections are only applied to the new user. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:create-user-with-role\">Complete Information for sec:create-user-with-role</a></div></div>");
        fDocs.put("sec:user-set-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:user-set-name(</div><div style=\"padding-left:2em;\">user-name as xs:string,</div><div style=\"padding-left:2em;\">new-user-name as xs:string,</div><div style=\"padding-left:2em;\">password as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Changes the name of the user from $user-name to $new-user-name. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:user-set-name\">Complete Information for sec:user-set-name</a></div></div>");
        fDocs.put("sec:user-set-password", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:user-set-password(</div><div style=\"padding-left:2em;\">user-name as xs:string,</div><div style=\"padding-left:2em;\">password as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Changes the password for the user identified by $user-name to $password. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:user-set-password\">Complete Information for sec:user-set-password</a></div></div>");
        fDocs.put("sec:user-set-description", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:user-set-description(</div><div style=\"padding-left:2em;\">user-name as xs:string,</div><div style=\"padding-left:2em;\">description as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Changes the description of the user identified by $user-name to $description. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:user-set-description\">Complete Information for sec:user-set-description</a></div></div>");
        fDocs.put("sec:role-set-description", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:role-set-description(</div><div style=\"padding-left:2em;\">role-name as xs:string,</div><div style=\"padding-left:2em;\">description as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Changes the description of the role identified by $role-name to $description. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:role-set-description\">Complete Information for sec:role-set-description</a></div></div>");
        fDocs.put("sec:role-get-description", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:role-get-description(</div><div style=\"padding-left:2em;\">role-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the description for the specified role. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:role-get-description\">Complete Information for sec:role-get-description</a></div></div>");
        fDocs.put("sec:get-role-ids", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:get-role-ids(</div><div style=\"padding-left:2em;\">role-names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns sequence of unique sec:role-id's that corresponds to the sequence of role names $role-names. <br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> Duplicate names return a single id.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a role name in $role-names does not correspond to an existing role, an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:get-role-ids\">Complete Information for sec:get-role-ids</a></div></div>");
        fDocs.put("sec:get-role-names", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:get-role-names(</div><div style=\"padding-left:2em;\">role-ids as xs:unsignedLong*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns sequence of unique sec:role-name's that corresponds to the sequence of role IDs $role-ids. Duplicate IDs return a single name. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:get-role-names\">Complete Information for sec:get-role-names</a></div></div>");
        fDocs.put("sec:user-set-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:user-set-roles(</div><div style=\"padding-left:2em;\">user-name as xs:string,</div><div style=\"padding-left:2em;\">role-names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Assigns the user with name $user-name to have the roles identified by $role-names. Removes previously assigned roles.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a user with name equal to $user-name is not found, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a role name in $role-names does not correspond to an existing role, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If $role-names is the empty sequence, all existing roles for the user are removed.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If the current user is limited to granting only his/her roles, and $role-names is not a subset of the current user's roles or one of the removed roles is not a subset of the current user's roles, then an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:user-set-roles\">Complete Information for sec:user-set-roles</a></div></div>");
        fDocs.put("sec:user-add-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:user-add-roles(</div><div style=\"padding-left:2em;\">user-name as xs:string,</div><div style=\"padding-left:2em;\">role-names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Adds the roles ($role-names) to the list of roles granted to the user ($user-name).</p> <p xmlns=\"http://www.w3.org/1999/xhtml\"> If a user with name equal to $user-name is not found, an error is returned.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\"> If one of the $role-names does not correspond to an existing role, an error is returned.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\"> If the current user is limited to granting only his/her roles, and $role is not a subset of the current user's roles, then an error is returned. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:user-add-roles\">Complete Information for sec:user-add-roles</a></div></div>");
        fDocs.put("sec:user-remove-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:user-remove-roles(</div><div style=\"padding-left:2em;\">user-name as xs:string,</div><div style=\"padding-left:2em;\">role-names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Removes the roles ($role-names) from the list of roles granted to the user ($user-name).</p> <p xmlns=\"http://www.w3.org/1999/xhtml\">If a user with name equal to $user-name is not found, an error is returned.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\">If one of $role-names does not correspond to an existing role, an error is returned.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\">If the current user is limited to granting only his/her roles, and one of $role-names is not a subset of the current user's roles, then an error is returned. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:user-remove-roles\">Complete Information for sec:user-remove-roles</a></div></div>");
        fDocs.put("sec:user-get-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:user-get-roles(</div><div style=\"padding-left:2em;\">user-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of role names for the roles directly assigned to the user ($user-name). Does not flatten the roles to include \"inherited roles.\"<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a user with name equal to $user-name is not found, an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:user-get-roles\">Complete Information for sec:user-get-roles</a></div></div>");
        fDocs.put("sec:user-get-description", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:user-get-description(</div><div style=\"padding-left:2em;\">user-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the user's description. If a user with name equal to $user-name is not found, an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:user-get-description\">Complete Information for sec:user-get-description</a></div></div>");
        fDocs.put("sec:remove-user", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:remove-user(</div><div style=\"padding-left:2em;\">user-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Removes the user with name $user-name.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a user with name equal to $user-name is not found, an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:remove-user\">Complete Information for sec:remove-user</a></div></div>");
        fDocs.put("sec:create-role", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:create-role(</div><div style=\"padding-left:2em;\">role-name as xs:string,</div><div style=\"padding-left:2em;\">description as xs:string?,</div><div style=\"padding-left:2em;\">role-names as xs:string*,</div><div style=\"padding-left:2em;\">permissions as element(sec:permission)*,</div><div style=\"padding-left:2em;\">collections as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Creates a new role in the system database for the context database.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If $role-name is not unique, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If one of the $role-names does not identify a role, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If the current user is limited to granting only his/her roles, and $role-names is not a subset of the current user's roles, then an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> Returns the role-id. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:create-role\">Complete Information for sec:create-role</a></div></div>");
        fDocs.put("sec:role-set-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:role-set-name(</div><div style=\"padding-left:2em;\">role-name as xs:string,</div><div style=\"padding-left:2em;\">new-role-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Changes the sec:role-name of a role from $role-name to $new-role-name.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If $new-role-name is not unique, an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:role-set-name\">Complete Information for sec:role-set-name</a></div></div>");
        fDocs.put("sec:role-set-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:role-set-roles(</div><div style=\"padding-left:2em;\">role-name as xs:string,</div><div style=\"padding-left:2em;\">role-names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Assigns roles (named $role-names) to be the set of included roles for the role ($role-name). Removes previously assigned roles.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a role with name equal to $role-name is not found, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a role name in $role-names does not correspond to an existing role, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If $role-names is the empty sequence, all included roles for the role are removed.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If the current user is limited to granting only his/her roles, and $role-names is not a subset of the current user's roles, then an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:role-set-roles\">Complete Information for sec:role-set-roles</a></div></div>");
        fDocs.put("sec:role-add-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:role-add-roles(</div><div style=\"padding-left:2em;\">role-name as xs:string,</div><div style=\"padding-left:2em;\">new-roles as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Adds the roles ($new-roles) to the set of roles included by the role ($role-name).<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a role with name equal to $role-name is not found, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If one of $new-roles does not correspond to an existing role, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If the current user is limited to granting only his/her roles, and $new-role is not a subset of the current user's roles, then an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:role-add-roles\">Complete Information for sec:role-add-roles</a></div></div>");
        fDocs.put("sec:role-remove-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:role-remove-roles(</div><div style=\"padding-left:2em;\">role-name as xs:string,</div><div style=\"padding-left:2em;\">role-names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Removes the roles ($role-names) from the set of roles included by the role ($role-name).<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a role with name equal to $role-name is not found, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If one of $role-names does not correspond to an existing role, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If the current user is limited to granting only his/her roles, and $old-role is not a subset of the current user's roles, then an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:role-remove-roles\">Complete Information for sec:role-remove-roles</a></div></div>");
        fDocs.put("sec:remove-role", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:remove-role(</div><div style=\"padding-left:2em;\">role-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Removes the role ($role-name).<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a role with name equal to $role-name is not found, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> This function also removes all references to the role (privileges, amps, permissions and users). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:remove-role\">Complete Information for sec:remove-role</a></div></div>");
        fDocs.put("sec:remove-role-from-users", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:remove-role-from-users(</div><div style=\"padding-left:2em;\">role-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Removes references to the role ($role-name) from all users.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a role with name equal to $role-name is not found, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If the current user is limited to granting only his/her roles, and $role-name is not a subset of the current user's roles, then an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:remove-role-from-users\">Complete Information for sec:remove-role-from-users</a></div></div>");
        fDocs.put("sec:remove-role-from-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:remove-role-from-roles(</div><div style=\"padding-left:2em;\">role-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Removes references to the role ($role-name) from all other roles.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a role with name equal to $role-name is not found, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If the current user is limited to granting only his/her roles, and $role-name is not a subset of the current user's roles, then an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:remove-role-from-roles\">Complete Information for sec:remove-role-from-roles</a></div></div>");
        fDocs.put("sec:remove-role-from-privileges", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:remove-role-from-privileges(</div><div style=\"padding-left:2em;\">role-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Removes references to the role ($role-name) from all privileges.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a role with name equal to $role-name is not found, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If the current user is limited to granting only his/her roles, and $role-name is not a subset of the current user's roles, then an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:remove-role-from-privileges\">Complete Information for sec:remove-role-from-privileges</a></div></div>");
        fDocs.put("sec:remove-role-from-amps", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:remove-role-from-amps(</div><div style=\"padding-left:2em;\">role-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Removes references to the role ($role-name) from all amps.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a role with name equal to $role-name is not found, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If the current user is limited to granting only his/her roles, and $role-name is not a subset of the current user's roles, then an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:remove-role-from-amps\">Complete Information for sec:remove-role-from-amps</a></div></div>");
        fDocs.put("sec:create-privilege", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:create-privilege(</div><div style=\"padding-left:2em;\">privilege-name as xs:string,</div><div style=\"padding-left:2em;\">action as xs:string,</div><div style=\"padding-left:2em;\">kind as xs:string,</div><div style=\"padding-left:2em;\">role-names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Creates a new privilege and returns the new privilege-id. <br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> For execute privileges, the privilege is initially nothing more than a name. Use the <code xmlns=\"http://www.w3.org/1999/xhtml\">xdmp:security-assert()</code> function in your code to associate the privilege with a protected operation. <br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> For URI privleges, the <code xmlns=\"http://www.w3.org/1999/xhtml\">$action</code> parameter identifies the base URI to be protected. Users must have this privilege to access any of the documents or code under the specified URI. <br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If $action is not unique, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If $kind is not one of (\"execute\", \"uri\") then en error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If one of the $role-names names a role that does not exist, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If the current user is limited to granting only his/her roles, and $role-names is not a subset of the current user's roles, then an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:create-privilege\">Complete Information for sec:create-privilege</a></div></div>");
        fDocs.put("sec:privilege-set-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:privilege-set-name(</div><div style=\"padding-left:2em;\">action as xs:string,</div><div style=\"padding-left:2em;\">kind as xs:string,</div><div style=\"padding-left:2em;\">new-privilege-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Changes the sec:privilege-name of a sec:privilege to $new-privilege-name.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a privilege with the given $action and $kind is not found, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If $new-privilege-name is not unique, an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:privilege-set-name\">Complete Information for sec:privilege-set-name</a></div></div>");
        fDocs.put("sec:remove-privilege", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:remove-privilege(</div><div style=\"padding-left:2em;\">action as xs:string,</div><div style=\"padding-left:2em;\">kind as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Removes the privilege identified by ($action,$kind).<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a privilege identified by ($action,$kind) is not found, an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:remove-privilege\">Complete Information for sec:remove-privilege</a></div></div>");
        fDocs.put("sec:privilege-get-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:privilege-get-roles(</div><div style=\"padding-left:2em;\">action as xs:string,</div><div style=\"padding-left:2em;\">kind as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of role names for the roles assigned to the privilege ($action,$kind). <br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a privilege with action equal to $action is not found, an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:privilege-get-roles\">Complete Information for sec:privilege-get-roles</a></div></div>");
        fDocs.put("sec:privilege-set-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:privilege-set-roles(</div><div style=\"padding-left:2em;\">action as xs:string,</div><div style=\"padding-left:2em;\">kind as xs:string,</div><div style=\"padding-left:2em;\">role-names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Assigns the privilege ($action,$kind) to have the roles identified by $role-names. Removes the prviously assigned roles.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a privilege identified by ($action,$kind) is not found, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a role name in $role-names does not correspond to an existing role, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If $role-names is the empty sequence, all existing roles for the privilege are removed.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If the current user is limited to granting only his/her roles, and $role-names is not a subset of the current user's roles, then an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:privilege-set-roles\">Complete Information for sec:privilege-set-roles</a></div></div>");
        fDocs.put("sec:privilege-add-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:privilege-add-roles(</div><div style=\"padding-left:2em;\">action as xs:string,</div><div style=\"padding-left:2em;\">kind as xs:string,</div><div style=\"padding-left:2em;\">role-names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Adds the roles ($role-names) to the list of roles assigned to the privilege ($action,$kind).<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a privilege identified by ($action,$kind) is not found, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If one of $role-names does not correspond to an existing role, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If the current user is limited to granting only his/her roles, and $role is not a subset of the current user's roles, then an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:privilege-add-roles\">Complete Information for sec:privilege-add-roles</a></div></div>");
        fDocs.put("sec:privilege-remove-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:privilege-remove-roles(</div><div style=\"padding-left:2em;\">action as xs:string,</div><div style=\"padding-left:2em;\">kind as xs:string,</div><div style=\"padding-left:2em;\">role-names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Removes roles ($role-names) from the roles assigned to the privilege ($action,$kind).<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a privilege identified by ($action,$kind) is not found, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If one of $role-names does not correspond to an existing role, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If the current user is limited to granting only his/her roles, and $role is not a subset of the current user's roles, then an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:privilege-remove-roles\">Complete Information for sec:privilege-remove-roles</a></div></div>");
        fDocs.put("sec:create-amp", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:create-amp(</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">local-name as xs:string,</div><div style=\"padding-left:2em;\">document-uri as xs:string,</div><div style=\"padding-left:2em;\">database as xs:unsignedLong,</div><div style=\"padding-left:2em;\">role-names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Creates a new amp in the system database for the context database.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\"> If the tuple ($namespace, $local-name, $document-uri, $database) is not unique, an error is returned.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\"> If one of the $role-names does not identify a role, an error is returned.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\"> If the current user is limited to granting only his/her roles, and $role-names is not a subset of the current user's roles, then an error is returned.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns the amp-id.</p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:create-amp\">Complete Information for sec:create-amp</a></div></div>");
        fDocs.put("sec:amp-set-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:amp-set-roles(</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">local-name as xs:string,</div><div style=\"padding-left:2em;\">document-uri as xs:string,</div><div style=\"padding-left:2em;\">database as xs:unsignedLong,</div><div style=\"padding-left:2em;\">role-names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Assigns the amp identified by $namespace, $local-name and $document-uri to have the roles identified by $roles-names. Removes previously assigned roles.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If an amp with the given identifiers does not exist, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If a role name in $role-names does not correspond to an existing role, an error is returned.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If $role-names is the empty sequence, all roles assigned to the amp are removed.<br xmlns=\"http://www.w3.org/1999/xhtml\"/><br xmlns=\"http://www.w3.org/1999/xhtml\"/> If the current user is limited to granting only his/her roles, and $role-names is not a subset of the current user's roles, then an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:amp-set-roles\">Complete Information for sec:amp-set-roles</a></div></div>");
        fDocs.put("sec:amp-add-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:amp-add-roles(</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">local-name as xs:string,</div><div style=\"padding-left:2em;\">document-uri as xs:string,</div><div style=\"padding-left:2em;\">database as xs:unsignedLong,</div><div style=\"padding-left:2em;\">role-names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Adds the roles ($role-names) to the list of roles granted to the amp ($namespace, $local-name, $document-uri). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:amp-add-roles\">Complete Information for sec:amp-add-roles</a></div></div>");
        fDocs.put("sec:amp-get-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:amp-get-roles(</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">local-name as xs:string,</div><div style=\"padding-left:2em;\">document-uri as xs:string,</div><div style=\"padding-left:2em;\">database as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of role names for the roles directly assigned to the amp ($namespace, $local-name, $document-uri). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:amp-get-roles\">Complete Information for sec:amp-get-roles</a></div></div>");
        fDocs.put("sec:role-get-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:role-get-roles(</div><div style=\"padding-left:2em;\">role-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of role names for the roles directly assigned to the given role ($role-name). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:role-get-roles\">Complete Information for sec:role-get-roles</a></div></div>");
        fDocs.put("sec:amp-remove-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:amp-remove-roles(</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">local-name as xs:string,</div><div style=\"padding-left:2em;\">document-uri as xs:string,</div><div style=\"padding-left:2em;\">database as xs:unsignedLong,</div><div style=\"padding-left:2em;\">role-names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Removes a role ($role-name) from the set of roles included by the amp ($namespace, $local-name, $document-uri). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:amp-remove-roles\">Complete Information for sec:amp-remove-roles</a></div></div>");
        fDocs.put("sec:remove-amp", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:remove-amp(</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">local-name as xs:string,</div><div style=\"padding-left:2em;\">document-uri as xs:string,</div><div style=\"padding-left:2em;\">database as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Removes the amp ($namespace, $local-name, $document-uri, $database) and returns true after completion. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:remove-amp\">Complete Information for sec:remove-amp</a></div></div>");
        fDocs.put("sec:amp-doc-collections", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:amp-doc-collections(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of strings corresponding to the collection uri's that amps belong to. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:amp-doc-collections\">Complete Information for sec:amp-doc-collections</a></div></div>");
        fDocs.put("sec:amp-doc-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:amp-doc-permissions(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of permission elements that all newly created amp documents receive. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:amp-doc-permissions\">Complete Information for sec:amp-doc-permissions</a></div></div>");
        fDocs.put("sec:user-doc-collections", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:user-doc-collections(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of strings corresponding to the collection uri's that users belong to. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:user-doc-collections\">Complete Information for sec:user-doc-collections</a></div></div>");
        fDocs.put("sec:user-doc-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:user-doc-permissions(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of permission elements that all newly created user documents receive. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:user-doc-permissions\">Complete Information for sec:user-doc-permissions</a></div></div>");
        fDocs.put("sec:role-doc-collections", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:role-doc-collections(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of strings corresponding to the collection uri's that roles belong to. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:role-doc-collections\">Complete Information for sec:role-doc-collections</a></div></div>");
        fDocs.put("sec:role-doc-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:role-doc-permissions(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of permission elements that all newly created role documents receive. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:role-doc-permissions\">Complete Information for sec:role-doc-permissions</a></div></div>");
        fDocs.put("sec:get-amp", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:get-amp(</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">local-name as xs:string,</div><div style=\"padding-left:2em;\">document-uri as xs:string,</div><div style=\"padding-left:2em;\">database as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns an sec:amp element corresponding to an amp identified by ($namespace, $local-name, $document-uri). If no such amp is found, an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:get-amp\">Complete Information for sec:get-amp</a></div></div>");
        fDocs.put("sec:get-privilege", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:get-privilege(</div><div style=\"padding-left:2em;\">action as xs:string,</div><div style=\"padding-left:2em;\">kind as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sec:privilege element corresponding to a privilege identified by ($action,$kind). If no such privilege is found, an error is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:get-privilege\">Complete Information for sec:get-privilege</a></div></div>");
        fDocs.put("sec:get-unique-elem-id", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:get-unique-elem-id(</div><div style=\"padding-left:2em;\">elem as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a unique id for a given security element, $elem. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:get-unique-elem-id\">Complete Information for sec:get-unique-elem-id</a></div></div>");
        fDocs.put("sec:priv-doc-collections", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:priv-doc-collections(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of strings corresponding to the collection uri's that privileges belong to. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:priv-doc-collections\">Complete Information for sec:priv-doc-collections</a></div></div>");
        fDocs.put("sec:priv-doc-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:priv-doc-permissions(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of permission elements that all newly created privilege documents receive. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:priv-doc-permissions\">Complete Information for sec:priv-doc-permissions</a></div></div>");
        fDocs.put("sec:security-collection", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:security-collection(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a string corresponding to the uri for the Security collection. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:security-collection\">Complete Information for sec:security-collection</a></div></div>");
        fDocs.put("sec:security-namespace", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:security-namespace(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a string corresponding to the uri of the security namespace. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:security-namespace\">Complete Information for sec:security-namespace</a></div></div>");
        fDocs.put("sec:users-collection", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:users-collection(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a string corresponding to the uri for the users collection. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:users-collection\">Complete Information for sec:users-collection</a></div></div>");
        fDocs.put("sec:roles-collection", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:roles-collection(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a string corresponding to the uri for the roles collection. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:roles-collection\">Complete Information for sec:roles-collection</a></div></div>");
        fDocs.put("sec:privileges-collection", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:privileges-collection(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a string corresponding to the uri for the privileges collection. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:privileges-collection\">Complete Information for sec:privileges-collection</a></div></div>");
        fDocs.put("sec:amps-collection", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:amps-collection(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a string corresponding to the uri for the amps collection. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:amps-collection\">Complete Information for sec:amps-collection</a></div></div>");
        fDocs.put("sec:collections-collection", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:collections-collection(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a string corresponding to the uri for the protected collections collection. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:collections-collection\">Complete Information for sec:collections-collection</a></div></div>");
        fDocs.put("sec:user-set-default-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:user-set-default-permissions(</div><div style=\"padding-left:2em;\">user-name as xs:string,</div><div style=\"padding-left:2em;\">permissions as element(sec:permission)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Sets the default permissions for a user with name $user-name. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:user-set-default-permissions\">Complete Information for sec:user-set-default-permissions</a></div></div>");
        fDocs.put("sec:get-distinct-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:get-distinct-permissions(</div><div style=\"padding-left:2em;\">input-perms as element(sec:permission)*,</div><div style=\"padding-left:2em;\">output-perms as element(sec:permission)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of permission elements made up of a concatenation of $output-perms and the distinct permission elements of $input-perms. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:get-distinct-permissions\">Complete Information for sec:get-distinct-permissions</a></div></div>");
        fDocs.put("sec:role-set-default-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:role-set-default-permissions(</div><div style=\"padding-left:2em;\">role-name as xs:string,</div><div style=\"padding-left:2em;\">permissions as element(sec:permission)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Sets the default permissions for a role with name $role-name. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:role-set-default-permissions\">Complete Information for sec:role-set-default-permissions</a></div></div>");
        fDocs.put("sec:user-get-default-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:user-get-default-permissions(</div><div style=\"padding-left:2em;\">user-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of permission elements correspondinig to the user's default permissions. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:user-get-default-permissions\">Complete Information for sec:user-get-default-permissions</a></div></div>");
        fDocs.put("sec:role-get-default-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:role-get-default-permissions(</div><div style=\"padding-left:2em;\">role-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of permission elements correspondinig to the role's default permissions. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:role-get-default-permissions\">Complete Information for sec:role-get-default-permissions</a></div></div>");
        fDocs.put("sec:user-get-default-collections", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:user-get-default-collections(</div><div style=\"padding-left:2em;\">user-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of strings correspondinig to the uri's of the user's default collections. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:user-get-default-collections\">Complete Information for sec:user-get-default-collections</a></div></div>");
        fDocs.put("sec:role-get-default-collections", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:role-get-default-collections(</div><div style=\"padding-left:2em;\">role-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of strings correspondinig to the uri's of the role's default collections. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:role-get-default-collections\">Complete Information for sec:role-get-default-collections</a></div></div>");
        fDocs.put("sec:user-set-default-collections", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:user-set-default-collections(</div><div style=\"padding-left:2em;\">user-name as xs:string,</div><div style=\"padding-left:2em;\">collections as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Sets the default collections of a user with name $user-name to $collections. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:user-set-default-collections\">Complete Information for sec:user-set-default-collections</a></div></div>");
        fDocs.put("sec:role-set-default-collections", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:role-set-default-collections(</div><div style=\"padding-left:2em;\">role-name as xs:string,</div><div style=\"padding-left:2em;\">collections as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Sets the default collections of a role with name $role-name to $collections. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:role-set-default-collections\">Complete Information for sec:role-set-default-collections</a></div></div>");
        fDocs.put("sec:get-collection", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:get-collection(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Gets the security document corresponding to a protected collection with uri equal to $uri. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:get-collection\">Complete Information for sec:get-collection</a></div></div>");
        fDocs.put("sec:protect-collection", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:protect-collection(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">permissions as element(sec:permission)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Protects a collection $uri with the given permissions ($permissions). Returns the unique id of the protected collection. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:protect-collection\">Complete Information for sec:protect-collection</a></div></div>");
        fDocs.put("sec:unprotect-collection", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:unprotect-collection(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Removes the protection of a collection $uri. This does not remove the collection or any of its documents. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:unprotect-collection\">Complete Information for sec:unprotect-collection</a></div></div>");
        fDocs.put("sec:collection-set-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:collection-set-permissions(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">permissions as element(sec:permission)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Sets the permissions of a protected collection identified by $uri to $permissions. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:collection-set-permissions\">Complete Information for sec:collection-set-permissions</a></div></div>");
        fDocs.put("sec:collection-add-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:collection-add-permissions(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">permissions as element(sec:permission)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Add the permissions $permissions to the protected collection identified by $uri. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:collection-add-permissions\">Complete Information for sec:collection-add-permissions</a></div></div>");
        fDocs.put("sec:collection-remove-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:collection-remove-permissions(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">permissions as element(sec:permission)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Removes the permissions $permissions from the protected collection identified by $uri. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:collection-remove-permissions\">Complete Information for sec:collection-remove-permissions</a></div></div>");
        fDocs.put("sec:collection-get-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:collection-get-permissions(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of permission elements corresponding to the current permissions granted to the protected collection identified by $uri. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:collection-get-permissions\">Complete Information for sec:collection-get-permissions</a></div></div>");
        fDocs.put("sec:user-privileges", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:user-privileges(</div><div style=\"padding-left:2em;\">user-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a set of privilege elements corresponding to all privileges that a user has. (roles are flattened to give a complete set of privileges). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:user-privileges\">Complete Information for sec:user-privileges</a></div></div>");
        fDocs.put("sec:role-privileges", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:role-privileges(</div><div style=\"padding-left:2em;\">role-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a set of privilege elements corresponding to all privileges that a role has. (Roles are flattened to give a complete set of privileges). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:role-privileges\">Complete Information for sec:role-privileges</a></div></div>");
        fDocs.put("sec:security-installed", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:security-installed(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns fn:true() if security has been installed on the current database. Otherwise, returns false. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:security-installed\">Complete Information for sec:security-installed</a></div></div>");
        fDocs.put("sec:uid-for-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:uid-for-name(</div><div style=\"padding-left:2em;\">name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the uids for the named user or () if no such user exists. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:uid-for-name\">Complete Information for sec:uid-for-name</a></div></div>");
        fDocs.put("sec:get-user-names", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:get-user-names(</div><div style=\"padding-left:2em;\">user-ids as xs:unsignedLong*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns sequence of unique sec:user-name's that corresponds to the sequence of user IDs $user-ids. Duplicate IDs return a single name. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:get-user-names\">Complete Information for sec:get-user-names</a></div></div>");
        fDocs.put("sec:set-realm", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:set-realm(</div><div style=\"padding-left:2em;\">realm as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Changes the realm of this security database to $realm. If the realm is different from the old value this function also invalidates all the existing digest passwords since they will no longer work with the new realm. Warning: this invalidates all user's digest passwords, including the user running this function and users of the Admin Interface (if the Admin Interface is set to digest authentication, which is the default setting); once a user's digest password is invalidated, that user will no longer be able to log in with digest authentication. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:set-realm\">Complete Information for sec:set-realm</a></div></div>");
        fDocs.put("sec:check-admin", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:check-admin(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Throws an error if the current user does not have the admin role. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:check-admin\">Complete Information for sec:check-admin</a></div></div>");
        fDocs.put("sec:security-version", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">sec:security-version(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the current version of the security database. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:sec:security-version\">Complete Information for sec:security-version</a></div></div>");
        fDocs.put("pdf:clean", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">pdf:clean(</div><div style=\"padding-left:2em;\">doc as node()?,</div><div style=\"padding-left:2em;\">toc as element()?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Clean up any conversion artifacts or other infelicities. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:pdf:clean\">Complete Information for pdf:clean</a></div></div>");
        fDocs.put("pdf:get-toc", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">pdf:get-toc(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Fetch the linked TOC, if any. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:pdf:get-toc\">Complete Information for pdf:get-toc</a></div></div>");
        fDocs.put("pdf:make-toc", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">pdf:make-toc(</div><div style=\"padding-left:2em;\">toc as element()?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Clean and normalize the TOC produced by raw conversion. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:pdf:make-toc\">Complete Information for pdf:make-toc</a></div></div>");
        fDocs.put("pdf:insert-toc-headers", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">pdf:insert-toc-headers(</div><div style=\"padding-left:2em;\">doc as node()?,</div><div style=\"padding-left:2em;\">toc as element()?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Locate TOC anchors and make them properly refer to headers at the appropriate level. Returned the transformed document. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:pdf:insert-toc-headers\">Complete Information for pdf:insert-toc-headers</a></div></div>");
        fDocs.put("fn:error", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:error(</div><div style=\"padding-left:2em;\">[error as xs:QName?,]</div><div style=\"padding-left:2em;\">[description as xs:string,]</div><div style=\"padding-left:2em;\">[data as item()*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> [1.0 and 1.0-ml only, 0.9-ml has a different signature] Throw the given error. When an error is thrown, the XQuery program execution is stopped. For detailed semantics, see <a href=\"http://www.w3.org/TR/xpath-functions/#func-error\" xmlns=\"http://www.w3.org/1999/xhtml\">http://www.w3.org/TR/xpath-functions/#func-error</a>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:error\">Complete Information for fn:error</a></div></div>");
        fDocs.put("xdmp:to-json", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:to-json(</div><div style=\"padding-left:2em;\">item as item()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a string representing a JSON serialization of a given item sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:to-json\">Complete Information for xdmp:to-json</a></div></div>");
        fDocs.put("xdmp:from-json", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:from-json(</div><div style=\"padding-left:2em;\">arg as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Parses a string as JSON, returning an item sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:from-json\">Complete Information for xdmp:from-json</a></div></div>");
        fDocs.put("fn:name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:name(</div><div style=\"padding-left:2em;\">[arg as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns the name of a node, as an <code>xs:string</code> that is either the zero-length string, or has the lexical form of an <code>xs:QName</code>. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the argument is omitted, it defaults to the context node. If the context item is undefined an error is raised: [err:XPDY002]. If the context item is not a node an error is raised: [err:XPTY0004]. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the argument is supplied and is the empty sequence, the function returns the zero-length string. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the target node has no name (that is, if it is a document node, a comment, a text node, or a namespace node having no name), the function returns the zero-length string. </p> <p xmlns=\"http://www.w3.org/1999/xhtml\"> If the specified node was created with a namespace prefix, that namespace prefix is returned with the element localname (for example, <code>a:hello</code>). Note that the namespace prefix is not always the same prefix that would be returned if you serialized the QName of the node, as the serialized QName will use the namespace from the XQuery context in which it was serialized.</p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:name\">Complete Information for fn:name</a></div></div>");
        fDocs.put("fn:local-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:local-name(</div><div style=\"padding-left:2em;\">[arg as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns the local part of the name of $arg as an xs:string that will either be the zero-length string or will have the lexical form of an xs:NCName. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the argument is omitted, it defaults to the context node. If the context item is undefined an error is raised: [err:XPDY0002]. If the context item is not a node an error is raised: [err:XPTY0004]. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the argument is supplied and is the empty sequence, the function returns the zero-length string. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the target node has no name (that is, if it is a document node, a comment, a text node, or a namespace node having no name), the function returns the zero-length string. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Otherwise, the value returned will be the local part of the expanded-QName of the target node (as determined by the dm:node-name accessor in Section 5.11 node-name Accessor[DM]. This will be an xs:string whose lexical form is an xs:NCName. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:local-name\">Complete Information for fn:local-name</a></div></div>");
        fDocs.put("fn:namespace-uri", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:namespace-uri(</div><div style=\"padding-left:2em;\">[arg as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns the namespace URI of the xs:QName of $arg. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the argument is omitted, it defaults to the context node. If the context item is undefined an error is raised: [err:XPDY0002]. If the context item is not a node an error is raised: [err:XPTY0004]. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, the xs:anyURI corresponding to the zero-length string is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is neither an element nor an attribute node, or if it is an element or attribute node whose expanded-QName (as determined by the dm:node-name accessor in the Section 5.11 node-name Accessor[DM]) is in no namespace, then the function returns the xs:anyURI corresponding to the zero-length string. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:namespace-uri\">Complete Information for fn:namespace-uri</a></div></div>");
        fDocs.put("fn:number", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:number(</div><div style=\"padding-left:2em;\">[arg as xs:anyAtomicType?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns the value indicated by $arg or, if $arg is not specified, the context item after atomization, converted to an xs:double. If $arg is the empty sequence or if $arg or the context item cannot be converted to an xs:double, the xs:double value NaN is returned. If the context item is undefined an error is raised: [err:XPDY0002]. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Calling the zero-argument version of the function is defined to give the same result as calling the single-argument version with an argument of \".\". That is, fn:number() is equivalent to fn:number(.). </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, NaN is returned. Otherwise, $arg, or the context item after atomization, is converted to an xs:double following the rules of 17.1.3.2 Casting to xs:double. If the conversion to xs:double fails, the xs:double value NaN is returned. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:number\">Complete Information for fn:number</a></div></div>");
        fDocs.put("fn:lang", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:lang(</div><div style=\"padding-left:2em;\">testlang as xs:string?,</div><div style=\"padding-left:2em;\">[node as node()]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> This function tests whether the language of $node, or the context node if the second argument is omitted, as specified by xml:lang attributes is the same as, or is a sublanguage of, the language specified by $testlang. The language of the argument node, or the context node if the second argument is omitted, is determined by the value of the xml:lang attribute on the node, or, if the node has no such attribute, by the value of the xml:lang attribute on the nearest ancestor of the node that has an xml:lang attribute. If there is no such ancestor, then the function returns false </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the second argument is omitted and the context item is undefined an error is raised: [err:XPDY0002]. If the context item is not a node an error is raised [err:XPTY0004]. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $testlang is the empty sequence it is interpreted as the zero-length string. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The relevant xml:lang attribute is determined by the value of the XPath expression: (ancestor-or-self::* /@xml:lang)[last()] </p> <p xmlns=\"http://www.w3.org/1999/xhtml\">If this expression returns an empty sequence, the function returns false. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Otherwise, the function returns true if and only if the string-value of the relevant xml:lang attribute is equal to $testlang based on a caseless default match as specified in section 3.13 of [The Unicode Standard], or if the string-value of the relevant testlang attribute contains a hyphen, \"-\" (The character \"-\" is HYPHEN-MINUS, #x002D) such that the part of the string-value preceding that hyphen is equal to $testlang, using caseless matching. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:lang\">Complete Information for fn:lang</a></div></div>");
        fDocs.put("fn:root", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:root(</div><div style=\"padding-left:2em;\">[arg as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns the root of the tree to which $arg belongs. This will usually, but not necessarily, be a document node. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, the empty sequence is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is a document node, $arg is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the function is called without an argument, the context item is used as the default argument. If the context item is undefined an error is raised: [err:XPDY0002]. If the context item is not a node an error is raised: [err:XPTY0004]. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:root\">Complete Information for fn:root</a></div></div>");
        fDocs.put("ooxml:package-uris", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">ooxml:package-uris(</div><div style=\"padding-left:2em;\">package as node()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the list of files in the zip package. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:ooxml:package-uris\">Complete Information for ooxml:package-uris</a></div></div>");
        fDocs.put("ooxml:package-parts", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">ooxml:package-parts(</div><div style=\"padding-left:2em;\">package as node()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the documents within the zip package. Typically, the parts are returned as document nodes. They are returned in the order the package uris are returned, which is the manifest order. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:ooxml:package-parts\">Complete Information for ooxml:package-parts</a></div></div>");
        fDocs.put("ooxml:package-parts-insert", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">ooxml:package-parts-insert(</div><div style=\"padding-left:2em;\">directory as xs:string?,</div><div style=\"padding-left:2em;\">package-uris as xs:string*,</div><div style=\"padding-left:2em;\">package-parts as node()*,</div><div style=\"padding-left:2em;\">[permissions as element(sec:permission)*,]</div><div style=\"padding-left:2em;\">[collections as xs:string*,]</div><div style=\"padding-left:2em;\">[quality as xs:int?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function inserts one document in the database for each part at the specified URI. If a directory is given, then all parts are inserted into documents in that directory, with the rest of the URI determined by the $uris specified (typically from the manifest of a zip file or Office document). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:ooxml:package-parts-insert\">Complete Information for ooxml:package-parts-insert</a></div></div>");
        fDocs.put("entity:enrich", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">entity:enrich(</div><div style=\"padding-left:2em;\">node as node()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the entity-enriched XML for the given XML node. The entities conform to the Mark Logic-recommended entity markup. If a text node that is being enriched has a parent element with a schema definition that does not allow element children, then that text node is not enriched (for example, <code xmlns=\"http://www.w3.org/1999/xhtml\">style</code> elements in an xhtml document). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:entity:enrich\">Complete Information for entity:enrich</a></div></div>");
        fDocs.put("dls:document-history", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-history(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">Returns the version history of the document located at the specified URI. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-history\">Complete Information for dls:document-history</a></div></div>");
        fDocs.put("dls:document-manage", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-manage(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">deep as xs:boolean,</div><div style=\"padding-left:2em;\">[annotation as item()*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function places a document under management. A document must first be managed before it can be checked out. The document at the specified URI will become version 1 of this managed document. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-manage\">Complete Information for dls:document-manage</a></div></div>");
        fDocs.put("dls:document-unmanage", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-unmanage(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">deep as xs:boolean,</div><div style=\"padding-left:2em;\">remove-versions as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">Removes the specified document from management. You must have update permissions on the document to unmanage the document. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-unmanage\">Complete Information for dls:document-unmanage</a></div></div>");
        fDocs.put("dls:document-checkout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-checkout(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">deep as xs:boolean,</div><div style=\"padding-left:2em;\">[annotation as item()?,]</div><div style=\"padding-left:2em;\">[timeout as xs:unsignedLong?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function checks out (locks) the document at the specified URI to prevent other users from modifying the document. An exception is thrown if the document does not yet exist or does exist but is not managed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-checkout\">Complete Information for dls:document-checkout</a></div></div>");
        fDocs.put("dls:document-checkin", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-checkin(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">deep as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function checks in (unlocks) the document at the specified URI to allow other users to modify the document. This function does not create a new version of the document. You must explicitly use <code>dls:document-update()</code> to create new versions of a document. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-checkin\">Complete Information for dls:document-checkin</a></div></div>");
        fDocs.put("dls:document-version-as-of", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-version-as-of(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">as-of as xs:dateTime</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the most recent version of a document as of a point in time.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-version-as-of\">Complete Information for dls:document-version-as-of</a></div></div>");
        fDocs.put("dls:document-version", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-version(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">version-number as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns a particular version of a managed document. An error is thrown if there is no such version. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-version\">Complete Information for dls:document-version</a></div></div>");
        fDocs.put("dls:document-version-delete", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-version-delete(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">version as xs:integer,</div><div style=\"padding-left:2em;\">retain-history as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function removes the specified version of the managed document at the specified URI. This overrides any configured retention policies and should be used with care. You must have update permissions on the document version in order to delete it. <p/> If you set <code>$retain-history</code> to <code>true</code>, you can use <code>xdmp:document-properties</code> to view the deleted document's properties fragment in the database. For example, if you had deleted version 1 of <code>/foo/bar/baz.xml</code>, you can view its properties by calling: <p/> <code>xdmp:document-properties(\"/foo/bar/baz.xml_versions/1-baz.xml\")</code> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-version-delete\">Complete Information for dls:document-version-delete</a></div></div>");
        fDocs.put("dls:document-versions-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-versions-query(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns a query that matches any version of the specified URI. If the URI contains either of the wildcard characters '?' or '*', then the search is wildcarded. Specifying '*' matches any numbered version of any managed document. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-versions-query\">Complete Information for dls:document-versions-query</a></div></div>");
        fDocs.put("dls:document-version-uri", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-version-uri(</div><div style=\"padding-left:2em;\">document-uri as xs:string,</div><div style=\"padding-left:2em;\">version as xs:integer</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the URI of the specified version of the document located at the specified URI. The specified version of the document may, or may not, actually exist. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-version-uri\">Complete Information for dls:document-version-uri</a></div></div>");
        fDocs.put("dls:document-delete", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-delete(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">keep-old-versions as xs:boolean,</div><div style=\"padding-left:2em;\">retain-history as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function removes the specified managed document. You must have update permissions on the document to delete it. <p/> If you set <code>$retain-history</code> to <code>true</code>, you can use <code>xdmp:document-properties</code> to view the deleted document's properties fragment in the database. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-delete\">Complete Information for dls:document-delete</a></div></div>");
        fDocs.put("dls:document-is-managed", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-is-managed(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function determines whether or not the document at the specified URI is managed. This function returns <code>true</code> if the document at the URI is either a managed document or a numbered version of a managed document. Otherwise <code>false</code> is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-is-managed\">Complete Information for dls:document-is-managed</a></div></div>");
        fDocs.put("dls:retention-rule", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:retention-rule(</div><div style=\"padding-left:2em;\">name as xs:string,</div><div style=\"padding-left:2em;\">comment as item()*,</div><div style=\"padding-left:2em;\">num-versions as xs:unsignedInt?,</div><div style=\"padding-left:2em;\">duration as xs:duration?,</div><div style=\"padding-left:2em;\">document-query-text as xs:string?,</div><div style=\"padding-left:2em;\">document-query as cts:query?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function creates and returns a retention rule element. Use <code>dls:insert-retention-rule</code> to insert the retention rule into the database. <p/> Specifying multiple constraints implies AND between them. For example, specifying both <code>$num-versions</code> and <code>$duration</code> retains a numbered version only if it is both one of the N most recent versions and it was created more recently than \"now - duration.\" If neither <code>$num-versions</code> or <code>$duration</code> is specified, then any numbered version matching the document query is kept forever. <p/> The <code>$document-query-text</code> parameter is intended to be used for the human readable form of a query that was used to produce the corresponding <code>cts:query</code>. This may be the text that a user typed into a search text field in the UI. This parameter does NOT affect the retention policy. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:retention-rule\">Complete Information for dls:retention-rule</a></div></div>");
        fDocs.put("dls:retention-rule-insert", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:retention-rule-insert(</div><div style=\"padding-left:2em;\">rules as element(dls:retention-rule)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function inserts retention rules into the database. They will be readable by the dls-user role and modifiable/deletable by the dls-admin role. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:retention-rule-insert\">Complete Information for dls:retention-rule-insert</a></div></div>");
        fDocs.put("dls:retention-rules", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:retention-rules(</div><div style=\"padding-left:2em;\">names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the specified retention rules from the database. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:retention-rules\">Complete Information for dls:retention-rules</a></div></div>");
        fDocs.put("dls:retention-rule-remove", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:retention-rule-remove(</div><div style=\"padding-left:2em;\">names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function removes the specified retention rules from the database. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:retention-rule-remove\">Complete Information for dls:retention-rule-remove</a></div></div>");
        fDocs.put("dls:document-retention-rules", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-retention-rules(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the retention rules that apply to the document at the specified URI. This allows users to determine why a version of a document is being retained. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-retention-rules\">Complete Information for dls:document-retention-rules</a></div></div>");
        fDocs.put("dls:purge", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:purge(</div><div style=\"padding-left:2em;\">delete as xs:boolean,</div><div style=\"padding-left:2em;\">retain-history as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function deletes all numbered versions of managed documents and its referenced documents (such as <code>/foo/bar.xml_versions/1-bar.xml</code>), as specified by the rention policy set by one or more <code>dls:retention-rule</code> functions. Documents are deleted if they have no retention rule causing them to be kept and if they are not included by some document that cannot yet be deleted. If <code>$delete</code> is <code>false</code>, the document versions are not actually deleted and instead a list of the documents that would have been deleted is returned. This function returns a list of URIs that it would/did delete. <p/> If you set <code>$retain-history</code> to <code>true</code>, you can use <code>xdmp:document-properties</code> to view the deleted document's properties fragment in the database. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:purge\">Complete Information for dls:purge</a></div></div>");
        fDocs.put("dls:document-purge", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-purge(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">delete as xs:boolean,</div><div style=\"padding-left:2em;\">retain-history as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function deletes all numbered versions of the specified managed document and its referenced documents, as specified by the rention policies set by <code>dls:retention-rule</code>. The document versions are deleted if they have no retention rule causing them to be kept and if they are not included by documents that cannot yet be deleted. If <code>$delete</code> is <code>false</code>, the document's versions are not actually deleted and instead a list of the documents that would have been deleted is returned. <p/> If you set <code>$retain-history</code> to <code>true</code>, you can use <code>xdmp:document-properties</code> to view the deleted document's properties fragment in the database. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-purge\">Complete Information for dls:document-purge</a></div></div>");
        fDocs.put("dls:as-of-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:as-of-query(</div><div style=\"padding-left:2em;\">when as xs:dateTime</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns a query that matches the most recent numbered version of documents that were created before the specified date and time. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:as-of-query\">Complete Information for dls:as-of-query</a></div></div>");
        fDocs.put("dls:author-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:author-query(</div><div style=\"padding-left:2em;\">author as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns a query that matches documents authored by the specified user. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:author-query\">Complete Information for dls:author-query</a></div></div>");
        fDocs.put("dls:document-version-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-version-query(</div><div style=\"padding-left:2em;\">version as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns a query that matches the specified version of the managed documents. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-version-query\">Complete Information for dls:document-version-query</a></div></div>");
        fDocs.put("dls:documents-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:documents-query(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns a query that matches the latest versions of the managed documents in the database.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:documents-query\">Complete Information for dls:documents-query</a></div></div>");
        fDocs.put("dls:link-expand", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:link-expand(</div><div style=\"padding-left:2em;\">context as node(),</div><div style=\"padding-left:2em;\">ref as element(xi:include),</div><div style=\"padding-left:2em;\">restriction as cts:query?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function performs a single level expansion of a single XInclude reference. Any XInclude references in the referenced node are not expanded. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:link-expand\">Complete Information for dls:link-expand</a></div></div>");
        fDocs.put("dls:link-references", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:link-references(</div><div style=\"padding-left:2em;\">node as node(),</div><div style=\"padding-left:2em;\">restriction as cts:query?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns a list of all the distinct URIs of documents referenced (either directly or indirectly) in the expansion of the node. The URIs are mapped according to the specified restrictions. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:link-references\">Complete Information for dls:link-references</a></div></div>");
        fDocs.put("dls:node-expand", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:node-expand(</div><div style=\"padding-left:2em;\">node as node(),</div><div style=\"padding-left:2em;\">restriction as cts:query?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function recursively examines the node for XInclude references and expands them, following the rules of the XInclude specification. The result is a node in which all the XInclude references have been resolved, or an error if there were unresolvable references with no fallback specifications. The URIs are mapped according to the specified restrictions. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:node-expand\">Complete Information for dls:node-expand</a></div></div>");
        fDocs.put("dls:document-add-collections", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-add-collections(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">collections as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds the named document to the specified collections. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-add-collections\">Complete Information for dls:document-add-collections</a></div></div>");
        fDocs.put("dls:document-add-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-add-permissions(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">permissions as element(sec:permission)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds the specified permissions for the named document. Any permissions that were previously set for the document are retained. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-add-permissions\">Complete Information for dls:document-add-permissions</a></div></div>");
        fDocs.put("dls:document-get-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-get-permissions(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function gets the permissions for the specified document from the point of view of the Library Services API. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-get-permissions\">Complete Information for dls:document-get-permissions</a></div></div>");
        fDocs.put("dls:document-add-properties", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-add-properties(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">properties as element()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function adds the specified properties to any existing properties associated with the named document. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-add-properties\">Complete Information for dls:document-add-properties</a></div></div>");
        fDocs.put("dls:document-set-collections", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-set-collections(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">collections as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the named document to the specified collections. Any previously set collections for the document that are not specified are removed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-set-collections\">Complete Information for dls:document-set-collections</a></div></div>");
        fDocs.put("dls:document-set-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-set-permissions(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">permissions as element(sec:permission)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function sets the specified permissions for the named document. Any unspecified permissions that were previously set for the document are removed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-set-permissions\">Complete Information for dls:document-set-permissions</a></div></div>");
        fDocs.put("dls:document-set-properties", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-set-properties(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">properties as element()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function sets the properties of a document to the given sequence of elements. With the exception of the Library Services properties, any properties that already exist on the document are replaced. To preserve existing document properties, use <code>dls:document-add-properties</code>. Each element QName is the property name and the element value is the property value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-set-properties\">Complete Information for dls:document-set-properties</a></div></div>");
        fDocs.put("dls:document-set-property", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-set-property(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">property as element()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function sets a property on a document. If any properties with the same property QName exist, they are replaced with the new property. If no properties exist with the same QName, the new property is added. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-set-property\">Complete Information for dls:document-set-property</a></div></div>");
        fDocs.put("dls:document-set-quality", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-set-quality(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">quality as xs:int</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function sets the quality of the document with the given URI. If the quality of the document is positive, the relevance score of the document is increased in text search functions. The converse is true for \"negative\" quality.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-set-quality\">Complete Information for dls:document-set-quality</a></div></div>");
        fDocs.put("dls:document-remove-collections", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-remove-collections(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">collections as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function removes the named document from the specified collection.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-remove-collections\">Complete Information for dls:document-remove-collections</a></div></div>");
        fDocs.put("dls:document-remove-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-remove-permissions(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">permissions as element(sec:permission)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function removes the specified permissions from the named document. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-remove-permissions\">Complete Information for dls:document-remove-permissions</a></div></div>");
        fDocs.put("dls:document-remove-properties", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-remove-properties(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">property-names as xs:QName*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function removes the specified properties from the named document</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-remove-properties\">Complete Information for dls:document-remove-properties</a></div></div>");
        fDocs.put("dls:document-update", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-update(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">doc as node(),</div><div style=\"padding-left:2em;\">annotation as item()*,</div><div style=\"padding-left:2em;\">retain-history as xs:boolean,</div><div style=\"padding-left:2em;\">[permissions as element(sec:permission)*,]</div><div style=\"padding-left:2em;\">[collections as xs:string*,]</div><div style=\"padding-left:2em;\">[quality as xs:integer?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function updates the managed document at the specified URI with the specified contents. This function does an implicit <code>dls:document-purge</code> and returns the URI of any version of the document purged as the result of the established retention policy. <p/> You must first check out the document with <code>dls:document-checkout</code> before you can update, otherwise an exception is thrown. If the document does not exist, then an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-update\">Complete Information for dls:document-update</a></div></div>");
        fDocs.put("dls:break-checkout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:break-checkout(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">deep as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function breaks (unlocks) a checked-out document</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:break-checkout\">Complete Information for dls:break-checkout</a></div></div>");
        fDocs.put("dls:document-extract-part", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-extract-part(</div><div style=\"padding-left:2em;\">new-uri as xs:string,</div><div style=\"padding-left:2em;\">element as element(),</div><div style=\"padding-left:2em;\">annotation as item()*,</div><div style=\"padding-left:2em;\">retain-history as xs:boolean,</div><div style=\"padding-left:2em;\">[permissions as element(sec:permission)*,]</div><div style=\"padding-left:2em;\">[collections as xs:string*,]</div><div style=\"padding-left:2em;\">[quality as xs:integer?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function extracts an element from an existing document and creates a new document from the extracted element. The extracted element is removed from the root node document and replaced by an XInclude to the new document. A new version of the root node document is created. You must have already performed a <code>dls:document-checkout</code> of the document that contains the element to be extracted. <p/> The <code>$new-uri</code> must be an absolute path and is initially not checked out. This will create a new version of both the original document and the newly included document, with <code>$annotation</code> being used to create a <code>dls:annotation</code> property on each of them. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-extract-part\">Complete Information for dls:document-extract-part</a></div></div>");
        fDocs.put("dls:document-checkout-status", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-checkout-status(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns a <code>checkout</code> element containing the checkout status of the specified document.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-checkout-status\">Complete Information for dls:document-checkout-status</a></div></div>");
        fDocs.put("dls:document-include-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-include-query(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns a query that matches any managed document that has an XInclude link that exactly matches the specified URI. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-include-query\">Complete Information for dls:document-include-query</a></div></div>");
        fDocs.put("dls:document-insert-and-manage", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dls:document-insert-and-manage(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">deep as xs:boolean,</div><div style=\"padding-left:2em;\">doc as node(),</div><div style=\"padding-left:2em;\">[annotation as item()*,]</div><div style=\"padding-left:2em;\">[permissions as element(sec:permission)*,]</div><div style=\"padding-left:2em;\">[collections as xs:string*,]</div><div style=\"padding-left:2em;\">[quality as xs:integer?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function inserts a document into the database and places the document under management. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dls:document-insert-and-manage\">Complete Information for dls:document-insert-and-manage</a></div></div>");
        fDocs.put("spell:load", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">spell:load(</div><div style=\"padding-left:2em;\">path as xs:string,</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Add the words from the file specified in $path to the dictionary at $uri. If a document exists with the specified URI, it is replaced with this one. Note that words that are 64 characters or greater will never be returned as suggestions from <code xmlns=\"http://www.w3.org/1999/xhtml\">spell:suggest</code> or <code xmlns=\"http://www.w3.org/1999/xhtml\">spell:suggest-detailed</code>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:spell:load\">Complete Information for spell:load</a></div></div>");
        fDocs.put("spell:insert", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">spell:insert(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">dict as element(spell:dictionary)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Load the words in $dict into the dictionary at $uri. If there is no document at $uri a new one will be created. If there is a document at $uri it will be overwritten. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:spell:insert\">Complete Information for spell:insert</a></div></div>");
        fDocs.put("spell:add-word", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">spell:add-word(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">word as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Add the word $word to the dictionary at $uri. If the word is already in the dictionary (case-sensitive), then this function throws an exception. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:spell:add-word\">Complete Information for spell:add-word</a></div></div>");
        fDocs.put("spell:remove-word", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">spell:remove-word(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">word as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Remove the word $word from the dictionary at $uri. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:spell:remove-word\">Complete Information for spell:remove-word</a></div></div>");
        fDocs.put("spell:make-dictionary", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">spell:make-dictionary(</div><div style=\"padding-left:2em;\">words as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Creates a dictionary node from a sequence of words. Use <code xmlns=\"http://www.w3.org/1999/xhtml\">spell:load</code> to load the dictionary node into the database as a dictionary. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:spell:make-dictionary\">Complete Information for spell:make-dictionary</a></div></div>");
        fDocs.put("xdmp:user-last-login", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:user-last-login(</div><div style=\"padding-left:2em;\">user as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the last-login node for the specified user ID. If no user ID is specified, then the current user is assumed. If no last-login database is specified in the App Server configuration, then the empty sequence is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:user-last-login\">Complete Information for xdmp:user-last-login</a></div></div>");
        fDocs.put("excel:clean", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">excel:clean(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">doc as node()?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Clean up any conversion artifacts or other infelicities, putting each sheet into its own div element. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:excel:clean\">Complete Information for excel:clean</a></div></div>");
        fDocs.put("xdmp:forest-backup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:forest-backup(</div><div style=\"padding-left:2em;\">forestID as unsignedLong,</div><div style=\"padding-left:2em;\">pathname as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Backs up forest data files. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:forest-backup\">Complete Information for xdmp:forest-backup</a></div></div>");
        fDocs.put("xdmp:forest-restore", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:forest-restore(</div><div style=\"padding-left:2em;\">forestID as unsignedLong,</div><div style=\"padding-left:2em;\">pathname as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Restores forest data files. Restarts the forest to complete the restoration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:forest-restore\">Complete Information for xdmp:forest-restore</a></div></div>");
        fDocs.put("xdmp:forest-clear", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:forest-clear(</div><div style=\"padding-left:2em;\">forestIDs as unsignedLong*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Clears forest data files. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:forest-clear\">Complete Information for xdmp:forest-clear</a></div></div>");
        fDocs.put("xdmp:forest-restart", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:forest-restart(</div><div style=\"padding-left:2em;\">forestID as unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Restarts a forest. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:forest-restart\">Complete Information for xdmp:forest-restart</a></div></div>");
        fDocs.put("xdmp:database-backup-validate", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:database-backup-validate(</div><div style=\"padding-left:2em;\">forestIDs as unsignedLong*,</div><div style=\"padding-left:2em;\">pathname as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Validates that the specified list of forests can be backed up to the backup data directory. Returns a database backup set node. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:database-backup-validate\">Complete Information for xdmp:database-backup-validate</a></div></div>");
        fDocs.put("xdmp:database-backup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:database-backup(</div><div style=\"padding-left:2em;\">forestIDs as unsignedLong*,</div><div style=\"padding-left:2em;\">pathname as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Starts an asynchronous backup of the specified list of forests to the backup data directory. Returns a job ID that uniquely identifies the backup task. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:database-backup\">Complete Information for xdmp:database-backup</a></div></div>");
        fDocs.put("xdmp:database-backup-status", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:database-backup-status(</div><div style=\"padding-left:2em;\">jobid as unsignedLong,</div><div style=\"padding-left:2em;\">[hostid as unsignedLong]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Checks the status of the outstanding backup job with the specified job ID. Returns a database backup status node defined in the <code xmlns=\"http://www.w3.org/1999/xhtml\">job-status.xsd</code> schema. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:database-backup-status\">Complete Information for xdmp:database-backup-status</a></div></div>");
        fDocs.put("xdmp:database-backup-cancel", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:database-backup-cancel(</div><div style=\"padding-left:2em;\">jobid as unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Cancels an outstanding backup job with the specified job ID, returning true if the cancel operation is successful, false if the cancel operation is not successful. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:database-backup-cancel\">Complete Information for xdmp:database-backup-cancel</a></div></div>");
        fDocs.put("xdmp:database-restore-validate", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:database-restore-validate(</div><div style=\"padding-left:2em;\">forestIDs as unsignedLong*,</div><div style=\"padding-left:2em;\">pathname as xs:string,</div><div style=\"padding-left:2em;\">[restoreToTime as xs:dateTime]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Validates that the specified list of forests can be restored from the backup data directory. Returns a database restore set node. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:database-restore-validate\">Complete Information for xdmp:database-restore-validate</a></div></div>");
        fDocs.put("xdmp:database-restore", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:database-restore(</div><div style=\"padding-left:2em;\">forestIDs as unsignedLong*,</div><div style=\"padding-left:2em;\">pathname as xs:string,</div><div style=\"padding-left:2em;\">[restoreToTime as xs:dateTime?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Starts an asynchronous restore of the specified list of forests from the backup data directory. Returns a job ID that uniquely identifies the restore task. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:database-restore\">Complete Information for xdmp:database-restore</a></div></div>");
        fDocs.put("xdmp:database-restore-status", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:database-restore-status(</div><div style=\"padding-left:2em;\">jobid as unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Checks the status of the outstanding restore job with the specified job ID. Returns a database restore status node. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:database-restore-status\">Complete Information for xdmp:database-restore-status</a></div></div>");
        fDocs.put("xdmp:database-restore-cancel", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:database-restore-cancel(</div><div style=\"padding-left:2em;\">jobid as unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Cancels an outstanding restore job with the specified job ID, returning true if the cancel operation is successful, false if the cancel operation is not successful. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:database-restore-cancel\">Complete Information for xdmp:database-restore-cancel</a></div></div>");
        fDocs.put("xdmp:shutdown", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:shutdown(</div><div style=\"padding-left:2em;\">hostIDs as unsignedLong*,</div><div style=\"padding-left:2em;\">reason as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Shutdown servers on hosts. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:shutdown\">Complete Information for xdmp:shutdown</a></div></div>");
        fDocs.put("xdmp:restart", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:restart(</div><div style=\"padding-left:2em;\">hostIDs as unsignedLong*,</div><div style=\"padding-left:2em;\">reason as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Restart servers on hosts. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:restart\">Complete Information for xdmp:restart</a></div></div>");
        fDocs.put("xdmp:filesystem-directory", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:filesystem-directory(</div><div style=\"padding-left:2em;\">pathname as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Performs a directory listing of the given file pathname. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:filesystem-directory\">Complete Information for xdmp:filesystem-directory</a></div></div>");
        fDocs.put("xdmp:filesystem-file", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:filesystem-file(</div><div style=\"padding-left:2em;\">pathname as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Reads a file from the filesystem. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:filesystem-file\">Complete Information for xdmp:filesystem-file</a></div></div>");
        fDocs.put("xdmp:castable-as", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:castable-as(</div><div style=\"padding-left:2em;\">namespace-uri as xs:string,</div><div style=\"padding-left:2em;\">local-name as xs:string,</div><div style=\"padding-left:2em;\">item as item()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns true if a value is castable. This is similar to the \"castable as\" XQuery predicate, except that the type is determined at runtime. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:castable-as\">Complete Information for xdmp:castable-as</a></div></div>");
        fDocs.put("xdmp:merge-cancel", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:merge-cancel(</div><div style=\"padding-left:2em;\">forest-ID as xs:unsignedLong,</div><div style=\"padding-left:2em;\">merge-ID as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Cancel the merge with the specified merge ID on a forest with the specified forest ID. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:merge-cancel\">Complete Information for xdmp:merge-cancel</a></div></div>");
        fDocs.put("xdmp:request-cancel", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:request-cancel(</div><div style=\"padding-left:2em;\">hostID as xs:unsignedLong,</div><div style=\"padding-left:2em;\">serverID as xs:unsignedLong,</div><div style=\"padding-left:2em;\">requestID as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Cancel the request with the given host, server, and request IDs. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:request-cancel\">Complete Information for xdmp:request-cancel</a></div></div>");
        fDocs.put("xdmp:database-backup-purge", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:database-backup-purge(</div><div style=\"padding-left:2em;\">dir as xs:string,</div><div style=\"padding-left:2em;\">keep-num-backups as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Purge old backups from a directory. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:database-backup-purge\">Complete Information for xdmp:database-backup-purge</a></div></div>");
        fDocs.put("admin:get-database-ids", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:get-database-ids(</div><div style=\"padding-left:2em;\">config as element(configuration)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns all the database IDs from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:get-database-ids\">Complete Information for admin:get-database-ids</a></div></div>");
        fDocs.put("admin:get-host-ids", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:get-host-ids(</div><div style=\"padding-left:2em;\">config as element(configuration)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns all the host IDs from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:get-host-ids\">Complete Information for admin:get-host-ids</a></div></div>");
        fDocs.put("admin:get-group-ids", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:get-group-ids(</div><div style=\"padding-left:2em;\">config as element(configuration)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns all the group IDs from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:get-group-ids\">Complete Information for admin:get-group-ids</a></div></div>");
        fDocs.put("admin:get-forest-ids", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:get-forest-ids(</div><div style=\"padding-left:2em;\">config as element(configuration)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns all the forest IDs from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:get-forest-ids\">Complete Information for admin:get-forest-ids</a></div></div>");
        fDocs.put("admin:get-appserver-ids", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:get-appserver-ids(</div><div style=\"padding-left:2em;\">config as element(configuration)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns all the appserver IDs from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:get-appserver-ids\">Complete Information for admin:get-appserver-ids</a></div></div>");
        fDocs.put("admin:get-configuration", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:get-configuration(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">Loads the admin configuration into memory for use by other functions in the Admin module. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:get-configuration\">Complete Information for admin:get-configuration</a></div></div>");
        fDocs.put("admin:save-configuration-without-restart", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:save-configuration-without-restart(</div><div style=\"padding-left:2em;\">config as element(configuration)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function saves a configuration specification to the cluster configuration files, without restarting MarkLogic Server. If you use this function to save any changes that require a server restart (\"cold\" changes such as App Server port assignment changes), then the changes will not take effect until the next time MarkLogic Server restarts (although they will be saved in the configuration). If you want MarkLogic Server to automatically restart when needed, use <code xmlns=\"http://www.w3.org/1999/xhtml\">admin:save-configuration</code> instead. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:save-configuration-without-restart\">Complete Information for admin:save-configuration-without-restart</a></div></div>");
        fDocs.put("admin:save-configuration", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:save-configuration(</div><div style=\"padding-left:2em;\">config as element(configuration)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function saves a configuration specification to the cluster configuration files. It restarts MarkLogic Server for \"cold\" administrative tasks only (for example, for App Server port assignment changes). If you do not want those \"cold\" administrative tasks to automatically restart MarkLogic Server, use <code xmlns=\"http://www.w3.org/1999/xhtml\">admin:save-configuration-without-restart</code> instead. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:save-configuration\">Complete Information for admin:save-configuration</a></div></div>");
        fDocs.put("admin:restart-hosts", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:restart-hosts(</div><div style=\"padding-left:2em;\">hosts as xs:unsignedLong*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function restarts MarkLogic Server for the specified hosts. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:restart-hosts\">Complete Information for admin:restart-hosts</a></div></div>");
        fDocs.put("admin:database-delete", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-ids as xs:unsignedLong*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes the configuration from the specified database(s). It does not delete the configuration or data for any forests attached to the deleted database(s). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete\">Complete Information for admin:database-delete</a></div></div>");
        fDocs.put("admin:database-create", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-create(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-name as xs:string,</div><div style=\"padding-left:2em;\">security-db as xs:unsignedLong,</div><div style=\"padding-left:2em;\">schema-db as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function creates a new database specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-create\">Complete Information for admin:database-create</a></div></div>");
        fDocs.put("admin:database-copy", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-copy(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">database-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function creates a new database specification with the same settings as the database with the specified ID. The new database configuration will have the specified name. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-copy\">Complete Information for admin:database-copy</a></div></div>");
        fDocs.put("admin:database-detach-forest", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-detach-forest(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function detaches the specified forest from the specified database. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-detach-forest\">Complete Information for admin:database-detach-forest</a></div></div>");
        fDocs.put("admin:database-attach-forest", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-attach-forest(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function attaches the specified forest to the specified database. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-attach-forest\">Complete Information for admin:database-attach-forest</a></div></div>");
        fDocs.put("admin:database-get-backups", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-backups(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the scheduled backups for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-backups\">Complete Information for admin:database-get-backups</a></div></div>");
        fDocs.put("admin:database-weekly-backup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-weekly-backup(</div><div style=\"padding-left:2em;\">backup-dir as xs:string,</div><div style=\"padding-left:2em;\">backup-period as xs:positiveInteger,</div><div style=\"padding-left:2em;\">days as xs:string+,</div><div style=\"padding-left:2em;\">start-time as xs:time,</div><div style=\"padding-left:2em;\">max-backups as xs:unsignedLong,</div><div style=\"padding-left:2em;\">backup-security-db as xs:boolean,</div><div style=\"padding-left:2em;\">backup-schemas-db as xs:boolean,</div><div style=\"padding-left:2em;\">backup-triggers-db as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a weekly scheduled backup. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-weekly-backup\">Complete Information for admin:database-weekly-backup</a></div></div>");
        fDocs.put("admin:database-monthly-backup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-monthly-backup(</div><div style=\"padding-left:2em;\">backup-dir as xs:string,</div><div style=\"padding-left:2em;\">backup-period as xs:positiveInteger,</div><div style=\"padding-left:2em;\">backup-month-day as xs:unsignedLong,</div><div style=\"padding-left:2em;\">start-time as xs:time,</div><div style=\"padding-left:2em;\">max-backups as xs:unsignedLong,</div><div style=\"padding-left:2em;\">backup-security-db as xs:boolean,</div><div style=\"padding-left:2em;\">backup-schemas-db as xs:boolean,</div><div style=\"padding-left:2em;\">backup-triggers-db as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a monthly scheduled backup. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-monthly-backup\">Complete Information for admin:database-monthly-backup</a></div></div>");
        fDocs.put("admin:database-one-time-backup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-one-time-backup(</div><div style=\"padding-left:2em;\">backup-dir as xs:string,</div><div style=\"padding-left:2em;\">start as xs:dateTime,</div><div style=\"padding-left:2em;\">max-backups as xs:unsignedLong,</div><div style=\"padding-left:2em;\">backup-security-db as xs:boolean,</div><div style=\"padding-left:2em;\">backup-schemas-db as xs:boolean,</div><div style=\"padding-left:2em;\">backup-triggers-db as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a one-time backup. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-one-time-backup\">Complete Information for admin:database-one-time-backup</a></div></div>");
        fDocs.put("admin:database-add-backup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-backup(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">backups as element(db:database-backup)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds scheduled backup specifications for a database to a configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-backup\">Complete Information for admin:database-add-backup</a></div></div>");
        fDocs.put("admin:database-delete-backup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-backup(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">backups as element(db:database-backup)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes scheduled backup specifications for a database from a configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-backup\">Complete Information for admin:database-delete-backup</a></div></div>");
        fDocs.put("admin:database-get-merge-blackouts", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-merge-blackouts(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the merge blackouts specification for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-merge-blackouts\">Complete Information for admin:database-get-merge-blackouts</a></div></div>");
        fDocs.put("admin:database-recurring-merge-blackout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-recurring-merge-blackout(</div><div style=\"padding-left:2em;\">limit as xs:unsignedInt,</div><div style=\"padding-left:2em;\">days as xs:string+,</div><div style=\"padding-left:2em;\">start-time as xs:time?,</div><div style=\"padding-left:2em;\">end-time as xs:time?,</div><div style=\"padding-left:2em;\">duration as xs:duration?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a merge-blackout specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-recurring-merge-blackout\">Complete Information for admin:database-recurring-merge-blackout</a></div></div>");
        fDocs.put("admin:database-one-time-merge-blackout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-one-time-merge-blackout(</div><div style=\"padding-left:2em;\">limit as xs:unsignedInt,</div><div style=\"padding-left:2em;\">start as xs:dateTime,</div><div style=\"padding-left:2em;\">end as xs:dateTime?,</div><div style=\"padding-left:2em;\">duration as xs:duration?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a one-time merge-blackout specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-one-time-merge-blackout\">Complete Information for admin:database-one-time-merge-blackout</a></div></div>");
        fDocs.put("admin:database-add-merge-blackout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-merge-blackout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">merge-blackouts as element(db:merge-blackout)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds a merge blackout specification for a database to a configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-merge-blackout\">Complete Information for admin:database-add-merge-blackout</a></div></div>");
        fDocs.put("admin:database-delete-merge-blackout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-merge-blackout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">blackouts as element(db:merge-blackout)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes a merge blackout specification for a database from a configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-merge-blackout\">Complete Information for admin:database-delete-merge-blackout</a></div></div>");
        fDocs.put("admin:database-get-fragment-roots", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-fragment-roots(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the fragment roots specification for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-fragment-roots\">Complete Information for admin:database-get-fragment-roots</a></div></div>");
        fDocs.put("admin:database-fragment-root", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-fragment-root(</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">localname as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a fragment root specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-fragment-root\">Complete Information for admin:database-fragment-root</a></div></div>");
        fDocs.put("admin:database-add-fragment-root", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-fragment-root(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">fragment-roots as element(db:fragment-root)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds the specified fragment root to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-fragment-root\">Complete Information for admin:database-add-fragment-root</a></div></div>");
        fDocs.put("admin:database-delete-fragment-root", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-fragment-root(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">fragment-roots as element(db:fragment-root)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes the specified fragment root in the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-fragment-root\">Complete Information for admin:database-delete-fragment-root</a></div></div>");
        fDocs.put("admin:database-get-fragment-parents", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-fragment-parents(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the fragment parents specification for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-fragment-parents\">Complete Information for admin:database-get-fragment-parents</a></div></div>");
        fDocs.put("admin:database-fragment-parent", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-fragment-parent(</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">localname as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a fragment parent specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-fragment-parent\">Complete Information for admin:database-fragment-parent</a></div></div>");
        fDocs.put("admin:database-add-fragment-parent", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-fragment-parent(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">fragment-parents as element(db:fragment-parent)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds the specified fragment parent to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-fragment-parent\">Complete Information for admin:database-add-fragment-parent</a></div></div>");
        fDocs.put("admin:database-delete-fragment-parent", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-fragment-parent(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">fragment-parents as element(db:fragment-parent)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes the specified fragment parent in the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-fragment-parent\">Complete Information for admin:database-delete-fragment-parent</a></div></div>");
        fDocs.put("admin:database-range-element-index", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-range-element-index(</div><div style=\"padding-left:2em;\">scalar-type as xs:string,</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">localname as xs:string,</div><div style=\"padding-left:2em;\">collation as xs:string,</div><div style=\"padding-left:2em;\">range-value-positions as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a range element index specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-range-element-index\">Complete Information for admin:database-range-element-index</a></div></div>");
        fDocs.put("admin:database-get-range-element-indexes", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-range-element-indexes(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the range element indexes specification(s) for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-range-element-indexes\">Complete Information for admin:database-get-range-element-indexes</a></div></div>");
        fDocs.put("admin:database-add-range-element-index", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-range-element-index(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">range-indexes as element(db:range-element-index)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds a range element index to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-range-element-index\">Complete Information for admin:database-add-range-element-index</a></div></div>");
        fDocs.put("admin:database-delete-range-element-index", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-range-element-index(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">range-indexes as element(db:range-element-index)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes a range element index for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-range-element-index\">Complete Information for admin:database-delete-range-element-index</a></div></div>");
        fDocs.put("admin:database-get-range-element-attribute-indexes", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-range-element-attribute-indexes(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the range element attribute indexes specification(s) for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-range-element-attribute-indexes\">Complete Information for admin:database-get-range-element-attribute-indexes</a></div></div>");
        fDocs.put("admin:database-range-element-attribute-index", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-range-element-attribute-index(</div><div style=\"padding-left:2em;\">scalar-type as xs:string,</div><div style=\"padding-left:2em;\">parent-namespace as xs:string,</div><div style=\"padding-left:2em;\">parent-localname as xs:string,</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">localname as xs:string,</div><div style=\"padding-left:2em;\">collation as xs:string,</div><div style=\"padding-left:2em;\">range-value-positions as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a range element attribute index specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-range-element-attribute-index\">Complete Information for admin:database-range-element-attribute-index</a></div></div>");
        fDocs.put("admin:database-add-range-element-attribute-index", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-range-element-attribute-index(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">attribute-indexes as element(db:range-element-attribute-index)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds a range element attribute index to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-range-element-attribute-index\">Complete Information for admin:database-add-range-element-attribute-index</a></div></div>");
        fDocs.put("admin:database-delete-range-element-attribute-index", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-range-element-attribute-index(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">attribute-indexes as element(db:range-element-attribute-index)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes a range element attribute index for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-range-element-attribute-index\">Complete Information for admin:database-delete-range-element-attribute-index</a></div></div>");
        fDocs.put("admin:database-element-word-lexicon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-element-word-lexicon(</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">localname as xs:string,</div><div style=\"padding-left:2em;\">collation as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs an element word lexicon specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-element-word-lexicon\">Complete Information for admin:database-element-word-lexicon</a></div></div>");
        fDocs.put("admin:database-get-element-word-lexicons", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-element-word-lexicons(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the element word lexicons specification(s) for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-element-word-lexicons\">Complete Information for admin:database-get-element-word-lexicons</a></div></div>");
        fDocs.put("admin:database-add-element-word-lexicon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-element-word-lexicon(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">element-word-lexicons as element(db:element-word-lexicon)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds an element word lexicon to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-element-word-lexicon\">Complete Information for admin:database-add-element-word-lexicon</a></div></div>");
        fDocs.put("admin:database-delete-element-word-lexicon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-element-word-lexicon(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">element-word-lexicons as element(db:element-word-lexicon)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes an element word lexicon for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-element-word-lexicon\">Complete Information for admin:database-delete-element-word-lexicon</a></div></div>");
        fDocs.put("admin:database-element-attribute-word-lexicon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-element-attribute-word-lexicon(</div><div style=\"padding-left:2em;\">parent-namespace as xs:string,</div><div style=\"padding-left:2em;\">parent-localname as xs:string,</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">localname as xs:string,</div><div style=\"padding-left:2em;\">collation as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs an element attribute word lexicon specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-element-attribute-word-lexicon\">Complete Information for admin:database-element-attribute-word-lexicon</a></div></div>");
        fDocs.put("admin:database-get-element-attribute-word-lexicons", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-element-attribute-word-lexicons(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the element attribute word lexicons specification(s) for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-element-attribute-word-lexicons\">Complete Information for admin:database-get-element-attribute-word-lexicons</a></div></div>");
        fDocs.put("admin:database-add-element-attribute-word-lexicon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-element-attribute-word-lexicon(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">element-attribute-word-lexicons as element(db:element-attribute-word-lexicon)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds an element attribute word lexicon to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-element-attribute-word-lexicon\">Complete Information for admin:database-add-element-attribute-word-lexicon</a></div></div>");
        fDocs.put("admin:database-delete-element-attribute-word-lexicon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-element-attribute-word-lexicon(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">lexicons as element(db:element-attribute-word-lexicon)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes an element attribute word lexicon for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-element-attribute-word-lexicon\">Complete Information for admin:database-delete-element-attribute-word-lexicon</a></div></div>");
        fDocs.put("admin:database-phrase-through", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-phrase-through(</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">localname as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a phrase through specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-phrase-through\">Complete Information for admin:database-phrase-through</a></div></div>");
        fDocs.put("admin:database-get-phrase-throughs", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-phrase-throughs(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the phrase throughs specification(s) for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-phrase-throughs\">Complete Information for admin:database-get-phrase-throughs</a></div></div>");
        fDocs.put("admin:database-add-phrase-through", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-phrase-through(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">phrase-throughs as element(db:phrase-through)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds a phrase through to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-phrase-through\">Complete Information for admin:database-add-phrase-through</a></div></div>");
        fDocs.put("admin:database-delete-phrase-through", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-phrase-through(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">phrase-throughs as element(db:phrase-through)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes a phrase through for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-phrase-through\">Complete Information for admin:database-delete-phrase-through</a></div></div>");
        fDocs.put("admin:database-phrase-around", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-phrase-around(</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">localname as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a phrase through specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-phrase-around\">Complete Information for admin:database-phrase-around</a></div></div>");
        fDocs.put("admin:database-get-phrase-arounds", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-phrase-arounds(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the phrase arounds specification(s) for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-phrase-arounds\">Complete Information for admin:database-get-phrase-arounds</a></div></div>");
        fDocs.put("admin:database-add-phrase-around", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-phrase-around(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">phrase-arounds as element(db:phrase-around)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds a phrase around to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-phrase-around\">Complete Information for admin:database-add-phrase-around</a></div></div>");
        fDocs.put("admin:database-delete-phrase-around", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-phrase-around(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">phrase-arounds as element(db:phrase-around)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes a phrase around for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-phrase-around\">Complete Information for admin:database-delete-phrase-around</a></div></div>");
        fDocs.put("admin:database-element-word-query-through", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-element-word-query-through(</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">localname as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs an element word query through specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-element-word-query-through\">Complete Information for admin:database-element-word-query-through</a></div></div>");
        fDocs.put("admin:database-get-element-word-query-throughs", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-element-word-query-throughs(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the element word query throughs specification(s) for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-element-word-query-throughs\">Complete Information for admin:database-get-element-word-query-throughs</a></div></div>");
        fDocs.put("admin:database-add-element-word-query-through", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-element-word-query-through(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">element-word-query-throughs as element(db:element-word-query-through)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds an element word query through to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-element-word-query-through\">Complete Information for admin:database-add-element-word-query-through</a></div></div>");
        fDocs.put("admin:database-delete-element-word-query-through", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-element-word-query-through(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">throughs as element(db:element-word-query-through)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes an element word query through for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-element-word-query-through\">Complete Information for admin:database-delete-element-word-query-through</a></div></div>");
        fDocs.put("admin:database-word-lexicon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-word-lexicon(</div><div style=\"padding-left:2em;\">collation as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a word lexicon specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-word-lexicon\">Complete Information for admin:database-word-lexicon</a></div></div>");
        fDocs.put("admin:database-get-word-lexicons", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-word-lexicons(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the word lexicons specification(s) for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-word-lexicons\">Complete Information for admin:database-get-word-lexicons</a></div></div>");
        fDocs.put("admin:database-add-word-lexicon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-word-lexicon(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">word-lexicons as element(db:word-lexicon)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds a word lexicon to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-word-lexicon\">Complete Information for admin:database-add-word-lexicon</a></div></div>");
        fDocs.put("admin:database-delete-word-lexicon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-word-lexicon(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">word-lexicons as element(db:word-lexicon)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes a word lexicon for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-word-lexicon\">Complete Information for admin:database-delete-word-lexicon</a></div></div>");
        fDocs.put("admin:database-geospatial-element-index", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-geospatial-element-index(</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">localname as xs:string,</div><div style=\"padding-left:2em;\">coordinate-system as xs:string,</div><div style=\"padding-left:2em;\">range-value-positions as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a geospatial element index specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-geospatial-element-index\">Complete Information for admin:database-geospatial-element-index</a></div></div>");
        fDocs.put("admin:database-get-geospatial-element-indexes", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-geospatial-element-indexes(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the geospatial element indexes specification(s) for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-geospatial-element-indexes\">Complete Information for admin:database-get-geospatial-element-indexes</a></div></div>");
        fDocs.put("admin:database-add-geospatial-element-index", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-geospatial-element-index(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">geospatial-element-indexes as element(db:geospatial-element-index)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds a range element index to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-geospatial-element-index\">Complete Information for admin:database-add-geospatial-element-index</a></div></div>");
        fDocs.put("admin:database-delete-geospatial-element-index", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-geospatial-element-index(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">geospatial-element-indexes as element(db:geospatial-element-index)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes a geospatial element index for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-geospatial-element-index\">Complete Information for admin:database-delete-geospatial-element-index</a></div></div>");
        fDocs.put("admin:database-geospatial-element-child-index", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-geospatial-element-child-index(</div><div style=\"padding-left:2em;\">parent-namespace as xs:string,</div><div style=\"padding-left:2em;\">parent-localname as xs:string,</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">localname as xs:string,</div><div style=\"padding-left:2em;\">coordinate-system as xs:string,</div><div style=\"padding-left:2em;\">range-value-positions as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a geospatial element child index specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-geospatial-element-child-index\">Complete Information for admin:database-geospatial-element-child-index</a></div></div>");
        fDocs.put("admin:database-get-geospatial-element-child-indexes", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-geospatial-element-child-indexes(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the geospatial element child indexes specification(s) for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-geospatial-element-child-indexes\">Complete Information for admin:database-get-geospatial-element-child-indexes</a></div></div>");
        fDocs.put("admin:database-add-geospatial-element-child-index", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-geospatial-element-child-index(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">geospatial-element-child-indexes as element(db:geospatial-element-child-index)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds a geospatial element child index to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-geospatial-element-child-index\">Complete Information for admin:database-add-geospatial-element-child-index</a></div></div>");
        fDocs.put("admin:database-delete-geospatial-element-child-index", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-geospatial-element-child-index(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">geospatial-element-child-indexes as element(db:geospatial-element-child-index)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes a geospatial element child index for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-geospatial-element-child-index\">Complete Information for admin:database-delete-geospatial-element-child-index</a></div></div>");
        fDocs.put("admin:database-geospatial-element-pair-index", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-geospatial-element-pair-index(</div><div style=\"padding-left:2em;\">parent-namespace as xs:string,</div><div style=\"padding-left:2em;\">parent-localname as xs:string,</div><div style=\"padding-left:2em;\">latitude-namespace as xs:string,</div><div style=\"padding-left:2em;\">latitude-localname as xs:string,</div><div style=\"padding-left:2em;\">longitude-namespace as xs:string,</div><div style=\"padding-left:2em;\">longitude-localname as xs:string,</div><div style=\"padding-left:2em;\">coordinate-system as xs:string,</div><div style=\"padding-left:2em;\">range-value-positions as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a geospatial element pair index specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-geospatial-element-pair-index\">Complete Information for admin:database-geospatial-element-pair-index</a></div></div>");
        fDocs.put("admin:database-get-geospatial-element-pair-indexes", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-geospatial-element-pair-indexes(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the geospatial element pair indexes specification(s) for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-geospatial-element-pair-indexes\">Complete Information for admin:database-get-geospatial-element-pair-indexes</a></div></div>");
        fDocs.put("admin:database-add-geospatial-element-pair-index", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-geospatial-element-pair-index(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">geospatial-element-pair-indexes as element(db:geospatial-element-pair-index)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds a geospatial element pair index to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-geospatial-element-pair-index\">Complete Information for admin:database-add-geospatial-element-pair-index</a></div></div>");
        fDocs.put("admin:database-delete-geospatial-element-pair-index", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-geospatial-element-pair-index(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">geospatial-element-pair-indexes as element(db:geospatial-element-pair-index)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes a geospatial element pair index for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-geospatial-element-pair-index\">Complete Information for admin:database-delete-geospatial-element-pair-index</a></div></div>");
        fDocs.put("admin:database-geospatial-element-attribute-pair-index", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-geospatial-element-attribute-pair-index(</div><div style=\"padding-left:2em;\">parent-namespace as xs:string,</div><div style=\"padding-left:2em;\">parent-localname as xs:string,</div><div style=\"padding-left:2em;\">latitude-namespace as xs:string,</div><div style=\"padding-left:2em;\">latitude-localname as xs:string,</div><div style=\"padding-left:2em;\">longitude-namespace as xs:string,</div><div style=\"padding-left:2em;\">longitude-localname as xs:string,</div><div style=\"padding-left:2em;\">coordinate-system as xs:string,</div><div style=\"padding-left:2em;\">range-value-positions as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a geospatial element attribute pair index specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-geospatial-element-attribute-pair-index\">Complete Information for admin:database-geospatial-element-attribute-pair-index</a></div></div>");
        fDocs.put("admin:database-get-geospatial-element-attribute-pair-indexes", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-geospatial-element-attribute-pair-indexes(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the geospatial element attribute pair indexes specification(s) for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-geospatial-element-attribute-pair-indexes\">Complete Information for admin:database-get-geospatial-element-attribute-pair-indexes</a></div></div>");
        fDocs.put("admin:database-add-geospatial-element-attribute-pair-index", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-geospatial-element-attribute-pair-index(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">geospatial-element-attribute-pair-indexes as element(db:geospatial-element-attribute-pair-index)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds a geospatial element attribute pair index to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-geospatial-element-attribute-pair-index\">Complete Information for admin:database-add-geospatial-element-attribute-pair-index</a></div></div>");
        fDocs.put("admin:database-delete-geospatial-element-attribute-pair-index", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-geospatial-element-attribute-pair-index(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">indexes as element(db:geospatial-element-attribute-pair-index)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes a geospatial element attribute pair index in the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-geospatial-element-attribute-pair-index\">Complete Information for admin:database-delete-geospatial-element-attribute-pair-index</a></div></div>");
        fDocs.put("admin:database-set-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-name(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the name of the database with the specified ID to the specified name. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-name\">Complete Information for admin:database-set-name</a></div></div>");
        fDocs.put("admin:database-set-enabled", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-enabled(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the enabled value for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-enabled\">Complete Information for admin:database-set-enabled</a></div></div>");
        fDocs.put("admin:database-set-security-database", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-security-database(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the security database for a database to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-security-database\">Complete Information for admin:database-set-security-database</a></div></div>");
        fDocs.put("admin:database-set-schema-database", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-schema-database(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the schema database for a database to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-schema-database\">Complete Information for admin:database-set-schema-database</a></div></div>");
        fDocs.put("admin:database-set-triggers-database", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-triggers-database(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the triggers database to the specified database ID for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-triggers-database\">Complete Information for admin:database-set-triggers-database</a></div></div>");
        fDocs.put("admin:database-set-language", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-language(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the language for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-language\">Complete Information for admin:database-set-language</a></div></div>");
        fDocs.put("admin:database-set-stemmed-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-stemmed-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the stemmed searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-stemmed-searches\">Complete Information for admin:database-set-stemmed-searches</a></div></div>");
        fDocs.put("admin:database-set-word-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-word-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the word searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-word-searches\">Complete Information for admin:database-set-word-searches</a></div></div>");
        fDocs.put("admin:database-set-word-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-word-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the word positions setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-word-positions\">Complete Information for admin:database-set-word-positions</a></div></div>");
        fDocs.put("admin:database-set-fast-phrase-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-fast-phrase-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the fast phrase searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-fast-phrase-searches\">Complete Information for admin:database-set-fast-phrase-searches</a></div></div>");
        fDocs.put("admin:database-set-fast-case-sensitive-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-fast-case-sensitive-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the fast case sensitive searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-fast-case-sensitive-searches\">Complete Information for admin:database-set-fast-case-sensitive-searches</a></div></div>");
        fDocs.put("admin:database-set-fast-reverse-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-fast-reverse-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the fast reverse searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-fast-reverse-searches\">Complete Information for admin:database-set-fast-reverse-searches</a></div></div>");
        fDocs.put("admin:database-set-fast-diacritic-sensitive-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-fast-diacritic-sensitive-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the fast diacritic-sensitive searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-fast-diacritic-sensitive-searches\">Complete Information for admin:database-set-fast-diacritic-sensitive-searches</a></div></div>");
        fDocs.put("admin:database-set-fast-element-word-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-fast-element-word-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the element word searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-fast-element-word-searches\">Complete Information for admin:database-set-fast-element-word-searches</a></div></div>");
        fDocs.put("admin:database-set-element-word-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-element-word-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the element word positions setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-element-word-positions\">Complete Information for admin:database-set-element-word-positions</a></div></div>");
        fDocs.put("admin:database-set-fast-element-phrase-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-fast-element-phrase-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the fast element phrase searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-fast-element-phrase-searches\">Complete Information for admin:database-set-fast-element-phrase-searches</a></div></div>");
        fDocs.put("admin:database-set-element-value-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-element-value-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the element value positions setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-element-value-positions\">Complete Information for admin:database-set-element-value-positions</a></div></div>");
        fDocs.put("admin:database-set-attribute-value-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-attribute-value-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the attribute value positions setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-attribute-value-positions\">Complete Information for admin:database-set-attribute-value-positions</a></div></div>");
        fDocs.put("admin:database-set-trailing-wildcard-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-trailing-wildcard-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the trailing wildcard searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-trailing-wildcard-searches\">Complete Information for admin:database-set-trailing-wildcard-searches</a></div></div>");
        fDocs.put("admin:database-set-trailing-wildcard-word-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-trailing-wildcard-word-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the trailing wildcard word positions setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-trailing-wildcard-word-positions\">Complete Information for admin:database-set-trailing-wildcard-word-positions</a></div></div>");
        fDocs.put("admin:database-set-fast-element-trailing-wildcard-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-fast-element-trailing-wildcard-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the fast element trailing wildcard searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-fast-element-trailing-wildcard-searches\">Complete Information for admin:database-set-fast-element-trailing-wildcard-searches</a></div></div>");
        fDocs.put("admin:database-set-three-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-three-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the three character searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-three-character-searches\">Complete Information for admin:database-set-three-character-searches</a></div></div>");
        fDocs.put("admin:database-set-three-character-word-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-three-character-word-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the three character word positions setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-three-character-word-positions\">Complete Information for admin:database-set-three-character-word-positions</a></div></div>");
        fDocs.put("admin:database-set-two-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-two-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the two character searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-two-character-searches\">Complete Information for admin:database-set-two-character-searches</a></div></div>");
        fDocs.put("admin:database-set-one-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-one-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the one character searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-one-character-searches\">Complete Information for admin:database-set-one-character-searches</a></div></div>");
        fDocs.put("admin:database-set-fast-element-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-fast-element-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the fast element character searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-fast-element-character-searches\">Complete Information for admin:database-set-fast-element-character-searches</a></div></div>");
        fDocs.put("admin:database-set-uri-lexicon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-uri-lexicon(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the URI lexicon setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-uri-lexicon\">Complete Information for admin:database-set-uri-lexicon</a></div></div>");
        fDocs.put("admin:database-set-collection-lexicon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-collection-lexicon(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the collection lexicon setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-collection-lexicon\">Complete Information for admin:database-set-collection-lexicon</a></div></div>");
        fDocs.put("admin:database-set-reindexer-enable", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-reindexer-enable(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the reindexer enable setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-reindexer-enable\">Complete Information for admin:database-set-reindexer-enable</a></div></div>");
        fDocs.put("admin:database-set-maintain-last-modified", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-maintain-last-modified(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the maintain last modified setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-maintain-last-modified\">Complete Information for admin:database-set-maintain-last-modified</a></div></div>");
        fDocs.put("admin:database-set-maintain-directory-last-modified", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-maintain-directory-last-modified(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the maintain directory last modified setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-maintain-directory-last-modified\">Complete Information for admin:database-set-maintain-directory-last-modified</a></div></div>");
        fDocs.put("admin:database-set-inherit-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-inherit-permissions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the inherit permissions setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-inherit-permissions\">Complete Information for admin:database-set-inherit-permissions</a></div></div>");
        fDocs.put("admin:database-set-inherit-collections", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-inherit-collections(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the inherit collections setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-inherit-collections\">Complete Information for admin:database-set-inherit-collections</a></div></div>");
        fDocs.put("admin:database-set-inherit-quality", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-inherit-quality(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the inherit quality setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-inherit-quality\">Complete Information for admin:database-set-inherit-quality</a></div></div>");
        fDocs.put("admin:database-set-preallocate-journals", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-preallocate-journals(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the preallocate journals setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-preallocate-journals\">Complete Information for admin:database-set-preallocate-journals</a></div></div>");
        fDocs.put("admin:database-set-preload-mapped-data", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-preload-mapped-data(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the preload mapped data setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-preload-mapped-data\">Complete Information for admin:database-set-preload-mapped-data</a></div></div>");
        fDocs.put("admin:database-set-merge-enable", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-merge-enable(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the merge enable setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-merge-enable\">Complete Information for admin:database-set-merge-enable</a></div></div>");
        fDocs.put("admin:database-set-directory-creation", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-directory-creation(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the directory creation setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-directory-creation\">Complete Information for admin:database-set-directory-creation</a></div></div>");
        fDocs.put("admin:database-set-format-compatibility", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-format-compatibility(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the format cpmpatibility setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-format-compatibility\">Complete Information for admin:database-set-format-compatibility</a></div></div>");
        fDocs.put("admin:database-set-index-detection", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-index-detection(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the index detection setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-index-detection\">Complete Information for admin:database-set-index-detection</a></div></div>");
        fDocs.put("admin:database-set-expunge-locks", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-expunge-locks(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the expunge locks setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-expunge-locks\">Complete Information for admin:database-set-expunge-locks</a></div></div>");
        fDocs.put("admin:database-set-reindexer-timestamp", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-reindexer-timestamp(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the reindexer timestamp setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-reindexer-timestamp\">Complete Information for admin:database-set-reindexer-timestamp</a></div></div>");
        fDocs.put("admin:database-set-in-memory-limit", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-in-memory-limit(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the in-memory limit setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-in-memory-limit\">Complete Information for admin:database-set-in-memory-limit</a></div></div>");
        fDocs.put("admin:database-set-in-memory-list-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-in-memory-list-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the in-memory list size setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-in-memory-list-size\">Complete Information for admin:database-set-in-memory-list-size</a></div></div>");
        fDocs.put("admin:database-set-in-memory-tree-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-in-memory-tree-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the in-memory tree size setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-in-memory-tree-size\">Complete Information for admin:database-set-in-memory-tree-size</a></div></div>");
        fDocs.put("admin:database-set-in-memory-range-index-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-in-memory-range-index-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the in-memory range index size setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-in-memory-range-index-size\">Complete Information for admin:database-set-in-memory-range-index-size</a></div></div>");
        fDocs.put("admin:database-set-in-memory-reverse-index-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-in-memory-reverse-index-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the in-memory range reverse index size setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-in-memory-reverse-index-size\">Complete Information for admin:database-set-in-memory-reverse-index-size</a></div></div>");
        fDocs.put("admin:database-set-journal-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-journal-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the journal size setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-journal-size\">Complete Information for admin:database-set-journal-size</a></div></div>");
        fDocs.put("admin:database-set-positions-list-max-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-positions-list-max-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the positions list max size setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-positions-list-max-size\">Complete Information for admin:database-set-positions-list-max-size</a></div></div>");
        fDocs.put("admin:database-set-merge-max-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-merge-max-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the merge max size setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-merge-max-size\">Complete Information for admin:database-set-merge-max-size</a></div></div>");
        fDocs.put("admin:database-set-merge-min-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-merge-min-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the merge minimum size setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-merge-min-size\">Complete Information for admin:database-set-merge-min-size</a></div></div>");
        fDocs.put("admin:database-set-merge-min-ratio", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-merge-min-ratio(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the merge min ratio setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-merge-min-ratio\">Complete Information for admin:database-set-merge-min-ratio</a></div></div>");
        fDocs.put("admin:database-set-merge-timestamp", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-merge-timestamp(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the merge timestamp setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-merge-timestamp\">Complete Information for admin:database-set-merge-timestamp</a></div></div>");
        fDocs.put("admin:database-set-reindexer-throttle", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-reindexer-throttle(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the reindexer throttle setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-reindexer-throttle\">Complete Information for admin:database-set-reindexer-throttle</a></div></div>");
        fDocs.put("admin:database-get-attached-forests", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-attached-forests(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the attached forest IDs for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-attached-forests\">Complete Information for admin:database-get-attached-forests</a></div></div>");
        fDocs.put("admin:database-get-id", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-id(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the ID for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-id\">Complete Information for admin:database-get-id</a></div></div>");
        fDocs.put("admin:database-get-enabled", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-enabled(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the enabled value for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-enabled\">Complete Information for admin:database-get-enabled</a></div></div>");
        fDocs.put("admin:database-get-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-name(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the name for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-name\">Complete Information for admin:database-get-name</a></div></div>");
        fDocs.put("admin:database-get-security-database", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-security-database(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the ID of the security database for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-security-database\">Complete Information for admin:database-get-security-database</a></div></div>");
        fDocs.put("admin:database-get-schema-database", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-schema-database(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the ID of the schema database for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-schema-database\">Complete Information for admin:database-get-schema-database</a></div></div>");
        fDocs.put("admin:database-get-triggers-database", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-triggers-database(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the ID of the triggers database for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-triggers-database\">Complete Information for admin:database-get-triggers-database</a></div></div>");
        fDocs.put("admin:database-get-language", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-language(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the language for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-language\">Complete Information for admin:database-get-language</a></div></div>");
        fDocs.put("admin:database-get-stemmed-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-stemmed-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the stemmed searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-stemmed-searches\">Complete Information for admin:database-get-stemmed-searches</a></div></div>");
        fDocs.put("admin:database-get-word-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-word-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the word searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-word-searches\">Complete Information for admin:database-get-word-searches</a></div></div>");
        fDocs.put("admin:database-get-word-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-word-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the word positions setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-word-positions\">Complete Information for admin:database-get-word-positions</a></div></div>");
        fDocs.put("admin:database-get-fast-phrase-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-fast-phrase-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the fast phrase searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-fast-phrase-searches\">Complete Information for admin:database-get-fast-phrase-searches</a></div></div>");
        fDocs.put("admin:database-get-fast-case-sensitive-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-fast-case-sensitive-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the fast case sensitive searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-fast-case-sensitive-searches\">Complete Information for admin:database-get-fast-case-sensitive-searches</a></div></div>");
        fDocs.put("admin:database-get-fast-reverse-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-fast-reverse-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the fast reverse searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-fast-reverse-searches\">Complete Information for admin:database-get-fast-reverse-searches</a></div></div>");
        fDocs.put("admin:database-get-fast-diacritic-sensitive-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-fast-diacritic-sensitive-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the fast diacritic sensitive searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-fast-diacritic-sensitive-searches\">Complete Information for admin:database-get-fast-diacritic-sensitive-searches</a></div></div>");
        fDocs.put("admin:database-get-fast-element-word-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-fast-element-word-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the fast element word searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-fast-element-word-searches\">Complete Information for admin:database-get-fast-element-word-searches</a></div></div>");
        fDocs.put("admin:database-get-element-word-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-element-word-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the element word positions setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-element-word-positions\">Complete Information for admin:database-get-element-word-positions</a></div></div>");
        fDocs.put("admin:database-get-fast-element-phrase-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-fast-element-phrase-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the fast element phrase searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-fast-element-phrase-searches\">Complete Information for admin:database-get-fast-element-phrase-searches</a></div></div>");
        fDocs.put("admin:database-get-element-value-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-element-value-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the element value positions setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-element-value-positions\">Complete Information for admin:database-get-element-value-positions</a></div></div>");
        fDocs.put("admin:database-get-attribute-value-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-attribute-value-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the attribute value positions setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-attribute-value-positions\">Complete Information for admin:database-get-attribute-value-positions</a></div></div>");
        fDocs.put("admin:database-get-trailing-wildcard-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-trailing-wildcard-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the trailing wildcard searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-trailing-wildcard-searches\">Complete Information for admin:database-get-trailing-wildcard-searches</a></div></div>");
        fDocs.put("admin:database-get-trailing-wildcard-word-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-trailing-wildcard-word-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the trailing wildcard word positions setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-trailing-wildcard-word-positions\">Complete Information for admin:database-get-trailing-wildcard-word-positions</a></div></div>");
        fDocs.put("admin:database-get-fast-element-trailing-wildcard-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-fast-element-trailing-wildcard-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the trailing wildcard searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-fast-element-trailing-wildcard-searches\">Complete Information for admin:database-get-fast-element-trailing-wildcard-searches</a></div></div>");
        fDocs.put("admin:database-get-three-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-three-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the three character searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-three-character-searches\">Complete Information for admin:database-get-three-character-searches</a></div></div>");
        fDocs.put("admin:database-get-three-character-word-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-three-character-word-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the three character word positions setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-three-character-word-positions\">Complete Information for admin:database-get-three-character-word-positions</a></div></div>");
        fDocs.put("admin:database-get-two-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-two-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the two character searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-two-character-searches\">Complete Information for admin:database-get-two-character-searches</a></div></div>");
        fDocs.put("admin:database-get-one-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-one-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the one character searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-one-character-searches\">Complete Information for admin:database-get-one-character-searches</a></div></div>");
        fDocs.put("admin:database-get-fast-element-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-fast-element-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the fast element character searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-fast-element-character-searches\">Complete Information for admin:database-get-fast-element-character-searches</a></div></div>");
        fDocs.put("admin:database-get-uri-lexicon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-uri-lexicon(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the URI lexicon setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-uri-lexicon\">Complete Information for admin:database-get-uri-lexicon</a></div></div>");
        fDocs.put("admin:database-get-collection-lexicon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-collection-lexicon(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the collection lexicon setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-collection-lexicon\">Complete Information for admin:database-get-collection-lexicon</a></div></div>");
        fDocs.put("admin:database-get-reindexer-enable", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-reindexer-enable(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the reindexer enable setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-reindexer-enable\">Complete Information for admin:database-get-reindexer-enable</a></div></div>");
        fDocs.put("admin:database-get-maintain-last-modified", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-maintain-last-modified(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the maintain last modified setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-maintain-last-modified\">Complete Information for admin:database-get-maintain-last-modified</a></div></div>");
        fDocs.put("admin:database-get-maintain-directory-last-modified", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-maintain-directory-last-modified(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the maintain directory last modified setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-maintain-directory-last-modified\">Complete Information for admin:database-get-maintain-directory-last-modified</a></div></div>");
        fDocs.put("admin:database-get-inherit-permissions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-inherit-permissions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the inherit positions setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-inherit-permissions\">Complete Information for admin:database-get-inherit-permissions</a></div></div>");
        fDocs.put("admin:database-get-inherit-collections", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-inherit-collections(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the inherit collections setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-inherit-collections\">Complete Information for admin:database-get-inherit-collections</a></div></div>");
        fDocs.put("admin:database-get-inherit-quality", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-inherit-quality(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the inherit quality setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-inherit-quality\">Complete Information for admin:database-get-inherit-quality</a></div></div>");
        fDocs.put("admin:database-get-preallocate-journals", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-preallocate-journals(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the preallocate journals setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-preallocate-journals\">Complete Information for admin:database-get-preallocate-journals</a></div></div>");
        fDocs.put("admin:database-get-preload-mapped-data", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-preload-mapped-data(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the preload mapped data setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-preload-mapped-data\">Complete Information for admin:database-get-preload-mapped-data</a></div></div>");
        fDocs.put("admin:database-get-merge-enable", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-merge-enable(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the merge enable setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-merge-enable\">Complete Information for admin:database-get-merge-enable</a></div></div>");
        fDocs.put("admin:database-get-directory-creation", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-directory-creation(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the directory creation setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-directory-creation\">Complete Information for admin:database-get-directory-creation</a></div></div>");
        fDocs.put("admin:database-get-format-compatibility", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-format-compatibility(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the format compatibility setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-format-compatibility\">Complete Information for admin:database-get-format-compatibility</a></div></div>");
        fDocs.put("admin:database-get-index-detection", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-index-detection(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the index detection setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-index-detection\">Complete Information for admin:database-get-index-detection</a></div></div>");
        fDocs.put("admin:database-get-expunge-locks", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-expunge-locks(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the expunge locks setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-expunge-locks\">Complete Information for admin:database-get-expunge-locks</a></div></div>");
        fDocs.put("admin:database-get-reindexer-timestamp", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-reindexer-timestamp(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the reindexer timestamp setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-reindexer-timestamp\">Complete Information for admin:database-get-reindexer-timestamp</a></div></div>");
        fDocs.put("admin:database-get-in-memory-limit", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-in-memory-limit(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the in memory limit setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-in-memory-limit\">Complete Information for admin:database-get-in-memory-limit</a></div></div>");
        fDocs.put("admin:database-get-in-memory-list-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-in-memory-list-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the im memory list size setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-in-memory-list-size\">Complete Information for admin:database-get-in-memory-list-size</a></div></div>");
        fDocs.put("admin:database-get-in-memory-tree-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-in-memory-tree-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the in memory tree size setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-in-memory-tree-size\">Complete Information for admin:database-get-in-memory-tree-size</a></div></div>");
        fDocs.put("admin:database-get-in-memory-range-index-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-in-memory-range-index-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the in memory range index size setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-in-memory-range-index-size\">Complete Information for admin:database-get-in-memory-range-index-size</a></div></div>");
        fDocs.put("admin:database-get-in-memory-reverse-index-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-in-memory-reverse-index-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the in memory reverse index size setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-in-memory-reverse-index-size\">Complete Information for admin:database-get-in-memory-reverse-index-size</a></div></div>");
        fDocs.put("admin:database-get-journal-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-journal-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the journal size setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-journal-size\">Complete Information for admin:database-get-journal-size</a></div></div>");
        fDocs.put("admin:database-get-positions-list-max-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-positions-list-max-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the positions list max size setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-positions-list-max-size\">Complete Information for admin:database-get-positions-list-max-size</a></div></div>");
        fDocs.put("admin:database-get-merge-max-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-merge-max-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the merge max size setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-merge-max-size\">Complete Information for admin:database-get-merge-max-size</a></div></div>");
        fDocs.put("admin:database-get-merge-min-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-merge-min-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the merge min size setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-merge-min-size\">Complete Information for admin:database-get-merge-min-size</a></div></div>");
        fDocs.put("admin:database-get-merge-min-ratio", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-merge-min-ratio(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the merge min ratio setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-merge-min-ratio\">Complete Information for admin:database-get-merge-min-ratio</a></div></div>");
        fDocs.put("admin:database-get-merge-timestamp", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-merge-timestamp(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the merge timestamp setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-merge-timestamp\">Complete Information for admin:database-get-merge-timestamp</a></div></div>");
        fDocs.put("admin:database-get-reindexer-throttle", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-reindexer-throttle(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the reindexer throttle setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-reindexer-throttle\">Complete Information for admin:database-get-reindexer-throttle</a></div></div>");
        fDocs.put("admin:database-included-element", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-included-element(</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">localname as xs:string,</div><div style=\"padding-left:2em;\">weight as xs:double,</div><div style=\"padding-left:2em;\">attribute-namespace as xs:string,</div><div style=\"padding-left:2em;\">attribute-localname as xs:string,</div><div style=\"padding-left:2em;\">attribute-value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs an included element specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-included-element\">Complete Information for admin:database-included-element</a></div></div>");
        fDocs.put("admin:database-excluded-element", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-excluded-element(</div><div style=\"padding-left:2em;\">namespace as xs:string,</div><div style=\"padding-left:2em;\">localname as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs an excluded element specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-excluded-element\">Complete Information for admin:database-excluded-element</a></div></div>");
        fDocs.put("admin:database-field", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-field(</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">include-root as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a field specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-field\">Complete Information for admin:database-field</a></div></div>");
        fDocs.put("admin:database-get-word-query-included-elements", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-word-query-included-elements(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the word query included elements setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-word-query-included-elements\">Complete Information for admin:database-get-word-query-included-elements</a></div></div>");
        fDocs.put("admin:database-get-word-query-excluded-elements", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-word-query-excluded-elements(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the word query excluded elements setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-word-query-excluded-elements\">Complete Information for admin:database-get-word-query-excluded-elements</a></div></div>");
        fDocs.put("admin:database-get-fields", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-fields(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the fields specification(s) for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-fields\">Complete Information for admin:database-get-fields</a></div></div>");
        fDocs.put("admin:database-get-field-included-elements", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-field-included-elements(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the fields included elements specification for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-field-included-elements\">Complete Information for admin:database-get-field-included-elements</a></div></div>");
        fDocs.put("admin:database-get-field-excluded-elements", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-field-excluded-elements(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the field excluded elements specification for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-field-excluded-elements\">Complete Information for admin:database-get-field-excluded-elements</a></div></div>");
        fDocs.put("admin:database-get-field", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-field(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the field specification for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-field\">Complete Information for admin:database-get-field</a></div></div>");
        fDocs.put("admin:database-add-field", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-field(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">fields as element(db:field)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds the field specification to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-field\">Complete Information for admin:database-add-field</a></div></div>");
        fDocs.put("admin:database-delete-field", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-field(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes the field specification in the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-field\">Complete Information for admin:database-delete-field</a></div></div>");
        fDocs.put("admin:database-add-word-query-included-element", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-word-query-included-element(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">included-elements as element(db:included-element)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds the word query included element specification to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-word-query-included-element\">Complete Information for admin:database-add-word-query-included-element</a></div></div>");
        fDocs.put("admin:database-delete-word-query-included-element", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-word-query-included-element(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">included-elements as element(db:included-element)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes the word query included element specification in the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-word-query-included-element\">Complete Information for admin:database-delete-word-query-included-element</a></div></div>");
        fDocs.put("admin:database-add-field-included-element", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-field-included-element(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">included-elements as element(db:included-element)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds the field included element specification tn the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-field-included-element\">Complete Information for admin:database-add-field-included-element</a></div></div>");
        fDocs.put("admin:database-delete-field-included-element", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-field-included-element(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">included-elements as element(db:included-element)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes the field included element specification in the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-field-included-element\">Complete Information for admin:database-delete-field-included-element</a></div></div>");
        fDocs.put("admin:database-add-word-query-excluded-element", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-word-query-excluded-element(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">excluded-elements as element(db:excluded-element)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds the word query excluded element specification for the specified database to the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-word-query-excluded-element\">Complete Information for admin:database-add-word-query-excluded-element</a></div></div>");
        fDocs.put("admin:database-delete-word-query-excluded-element", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-word-query-excluded-element(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">excluded-elements as element(db:excluded-element)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes the word query excluded element specification in the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-word-query-excluded-element\">Complete Information for admin:database-delete-word-query-excluded-element</a></div></div>");
        fDocs.put("admin:database-add-field-excluded-element", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-field-excluded-element(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">excluded-elements as element(db:excluded-element)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds the field excluded element specification in the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-field-excluded-element\">Complete Information for admin:database-add-field-excluded-element</a></div></div>");
        fDocs.put("admin:database-delete-field-excluded-element", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-field-excluded-element(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">excluded-elements as element(db:excluded-element)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes the field excluded element specification in the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-field-excluded-element\">Complete Information for admin:database-delete-field-excluded-element</a></div></div>");
        fDocs.put("admin:database-get-field-word-lexicons", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-field-word-lexicons(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the word lexicons specification(s) for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-field-word-lexicons\">Complete Information for admin:database-get-field-word-lexicons</a></div></div>");
        fDocs.put("admin:database-add-field-word-lexicon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-add-field-word-lexicon(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">word-lexicons as element(db:word-lexicon)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds a word lexicon to the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-add-field-word-lexicon\">Complete Information for admin:database-add-field-word-lexicon</a></div></div>");
        fDocs.put("admin:database-delete-field-word-lexicon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-delete-field-word-lexicon(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">word-lexicons as element(db:word-lexicon)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes a word lexicon for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-delete-field-word-lexicon\">Complete Information for admin:database-delete-field-word-lexicon</a></div></div>");
        fDocs.put("admin:database-get-word-query-include-document-root", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-word-query-include-document-root(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the word query include document root setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-word-query-include-document-root\">Complete Information for admin:database-get-word-query-include-document-root</a></div></div>");
        fDocs.put("admin:database-get-word-query-stemmed-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-word-query-stemmed-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the reindexer word query stemmed searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-word-query-stemmed-searches\">Complete Information for admin:database-get-word-query-stemmed-searches</a></div></div>");
        fDocs.put("admin:database-get-word-query-word-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-word-query-word-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the word query searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-word-query-word-searches\">Complete Information for admin:database-get-word-query-word-searches</a></div></div>");
        fDocs.put("admin:database-get-word-query-fast-phrase-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-word-query-fast-phrase-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the word query fast phrase searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-word-query-fast-phrase-searches\">Complete Information for admin:database-get-word-query-fast-phrase-searches</a></div></div>");
        fDocs.put("admin:database-get-word-query-fast-case-sensitive-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-word-query-fast-case-sensitive-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the word query fast case sensitive searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-word-query-fast-case-sensitive-searches\">Complete Information for admin:database-get-word-query-fast-case-sensitive-searches</a></div></div>");
        fDocs.put("admin:database-get-word-query-fast-diacritic-sensitive-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-word-query-fast-diacritic-sensitive-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the word query fast diacritic sensitive searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-word-query-fast-diacritic-sensitive-searches\">Complete Information for admin:database-get-word-query-fast-diacritic-sensitive-searches</a></div></div>");
        fDocs.put("admin:database-get-word-query-trailing-wildcard-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-word-query-trailing-wildcard-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the word query trailing wildcard searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-word-query-trailing-wildcard-searches\">Complete Information for admin:database-get-word-query-trailing-wildcard-searches</a></div></div>");
        fDocs.put("admin:database-get-word-query-trailing-wildcard-word-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-word-query-trailing-wildcard-word-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the word query trailing wildcard word positions setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-word-query-trailing-wildcard-word-positions\">Complete Information for admin:database-get-word-query-trailing-wildcard-word-positions</a></div></div>");
        fDocs.put("admin:database-get-word-query-three-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-word-query-three-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the word query three character searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-word-query-three-character-searches\">Complete Information for admin:database-get-word-query-three-character-searches</a></div></div>");
        fDocs.put("admin:database-get-word-query-three-character-word-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-word-query-three-character-word-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the word query three character word positions setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-word-query-three-character-word-positions\">Complete Information for admin:database-get-word-query-three-character-word-positions</a></div></div>");
        fDocs.put("admin:database-get-word-query-two-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-word-query-two-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the word query two character searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-word-query-two-character-searches\">Complete Information for admin:database-get-word-query-two-character-searches</a></div></div>");
        fDocs.put("admin:database-get-word-query-one-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-word-query-one-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the word query one character searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-word-query-one-character-searches\">Complete Information for admin:database-get-word-query-one-character-searches</a></div></div>");
        fDocs.put("admin:database-set-word-query-stemmed-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-word-query-stemmed-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the word query stemmed searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-word-query-stemmed-searches\">Complete Information for admin:database-set-word-query-stemmed-searches</a></div></div>");
        fDocs.put("admin:database-set-word-query-word-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-word-query-word-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the word query word searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-word-query-word-searches\">Complete Information for admin:database-set-word-query-word-searches</a></div></div>");
        fDocs.put("admin:database-set-word-query-fast-phrase-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-word-query-fast-phrase-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the word query fast phrase searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-word-query-fast-phrase-searches\">Complete Information for admin:database-set-word-query-fast-phrase-searches</a></div></div>");
        fDocs.put("admin:database-set-word-query-fast-case-sensitive-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-word-query-fast-case-sensitive-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the word query fast case sensitive searches setting for the specified database from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-word-query-fast-case-sensitive-searches\">Complete Information for admin:database-set-word-query-fast-case-sensitive-searches</a></div></div>");
        fDocs.put("admin:database-set-word-query-fast-diacritic-sensitive-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-word-query-fast-diacritic-sensitive-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the word query fast diacritic sensitive searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-word-query-fast-diacritic-sensitive-searches\">Complete Information for admin:database-set-word-query-fast-diacritic-sensitive-searches</a></div></div>");
        fDocs.put("admin:database-set-word-query-trailing-wildcard-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-word-query-trailing-wildcard-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the word query trailing wildcard searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-word-query-trailing-wildcard-searches\">Complete Information for admin:database-set-word-query-trailing-wildcard-searches</a></div></div>");
        fDocs.put("admin:database-set-word-query-trailing-wildcard-word-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-word-query-trailing-wildcard-word-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the word query trailing wildcard word positions setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-word-query-trailing-wildcard-word-positions\">Complete Information for admin:database-set-word-query-trailing-wildcard-word-positions</a></div></div>");
        fDocs.put("admin:database-set-word-query-three-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-word-query-three-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the word query three character searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-word-query-three-character-searches\">Complete Information for admin:database-set-word-query-three-character-searches</a></div></div>");
        fDocs.put("admin:database-set-word-query-three-character-word-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-word-query-three-character-word-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the word query three character word positions setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-word-query-three-character-word-positions\">Complete Information for admin:database-set-word-query-three-character-word-positions</a></div></div>");
        fDocs.put("admin:database-set-word-query-two-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-word-query-two-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the word query two character searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-word-query-two-character-searches\">Complete Information for admin:database-set-word-query-two-character-searches</a></div></div>");
        fDocs.put("admin:database-set-word-query-one-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-word-query-one-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the word query one character searches setting for the specified field in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-word-query-one-character-searches\">Complete Information for admin:database-set-word-query-one-character-searches</a></div></div>");
        fDocs.put("admin:database-set-word-query-include-document-root", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-word-query-include-document-root(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the word query include document root setting for the specified field in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-word-query-include-document-root\">Complete Information for admin:database-set-word-query-include-document-root</a></div></div>");
        fDocs.put("admin:database-get-field-include-document-root", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-field-include-document-root(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the field include document root setting for the specified field from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-field-include-document-root\">Complete Information for admin:database-get-field-include-document-root</a></div></div>");
        fDocs.put("admin:database-get-field-stemmed-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-field-stemmed-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns stemmed searches setting for the specified field if configured. Otherwise, it returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-field-stemmed-searches\">Complete Information for admin:database-get-field-stemmed-searches</a></div></div>");
        fDocs.put("admin:database-get-field-word-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-field-word-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns true if the word searches setting for the specified field is enabled. Otherwise, it returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-field-word-searches\">Complete Information for admin:database-get-field-word-searches</a></div></div>");
        fDocs.put("admin:database-get-field-fast-phrase-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-field-fast-phrase-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns true if the fast phrase searches setting for the specified field is enabled. Otherwise, it returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-field-fast-phrase-searches\">Complete Information for admin:database-get-field-fast-phrase-searches</a></div></div>");
        fDocs.put("admin:database-get-field-fast-case-sensitive-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-field-fast-case-sensitive-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns true if the fast case sensitive searches setting for the specified field is enabled. Otherwise, it returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-field-fast-case-sensitive-searches\">Complete Information for admin:database-get-field-fast-case-sensitive-searches</a></div></div>");
        fDocs.put("admin:database-get-field-fast-diacritic-sensitive-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-field-fast-diacritic-sensitive-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns true if the fast diacritic sensitive searches setting for the specified field is enabled. Otherwise, it returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-field-fast-diacritic-sensitive-searches\">Complete Information for admin:database-get-field-fast-diacritic-sensitive-searches</a></div></div>");
        fDocs.put("admin:database-get-field-trailing-wildcard-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-field-trailing-wildcard-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns true if the trailing wildcard searches setting for the specified field is enabled. Otherwise, it returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-field-trailing-wildcard-searches\">Complete Information for admin:database-get-field-trailing-wildcard-searches</a></div></div>");
        fDocs.put("admin:database-get-field-trailing-wildcard-word-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-field-trailing-wildcard-word-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns true if the trailing wildcard word positions setting for the specified field is enabled. Otherwise, it returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-field-trailing-wildcard-word-positions\">Complete Information for admin:database-get-field-trailing-wildcard-word-positions</a></div></div>");
        fDocs.put("admin:database-get-field-three-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-field-three-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns true if the three character searches setting for the specified field is enabled. Otherwise, it returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-field-three-character-searches\">Complete Information for admin:database-get-field-three-character-searches</a></div></div>");
        fDocs.put("admin:database-get-field-three-character-word-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-field-three-character-word-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns true if the three character word positions setting for the specified field is enabled. Otherwise, it returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-field-three-character-word-positions\">Complete Information for admin:database-get-field-three-character-word-positions</a></div></div>");
        fDocs.put("admin:database-get-field-two-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-field-two-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns true if the two character searches setting for the specified field is enabled. Otherwise, it returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-field-two-character-searches\">Complete Information for admin:database-get-field-two-character-searches</a></div></div>");
        fDocs.put("admin:database-get-field-one-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-field-one-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns true if the one character searches setting for the specified field is enabled. Otherwise, it returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-field-one-character-searches\">Complete Information for admin:database-get-field-one-character-searches</a></div></div>");
        fDocs.put("admin:database-set-field-stemmed-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-field-stemmed-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">value as xs:string?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the field stemmed searches setting for the specified field in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-field-stemmed-searches\">Complete Information for admin:database-set-field-stemmed-searches</a></div></div>");
        fDocs.put("admin:database-set-field-word-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-field-word-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the field word searches setting for the specified field in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-field-word-searches\">Complete Information for admin:database-set-field-word-searches</a></div></div>");
        fDocs.put("admin:database-set-field-fast-phrase-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-field-fast-phrase-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the field fast phrase searches setting for the specified field in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-field-fast-phrase-searches\">Complete Information for admin:database-set-field-fast-phrase-searches</a></div></div>");
        fDocs.put("admin:database-set-field-fast-case-sensitive-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-field-fast-case-sensitive-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the field fast case sensitive searches setting for the specified field in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-field-fast-case-sensitive-searches\">Complete Information for admin:database-set-field-fast-case-sensitive-searches</a></div></div>");
        fDocs.put("admin:database-set-field-fast-diacritic-sensitive-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-field-fast-diacritic-sensitive-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the field fast diacritic sensitive searches setting for the specified field in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-field-fast-diacritic-sensitive-searches\">Complete Information for admin:database-set-field-fast-diacritic-sensitive-searches</a></div></div>");
        fDocs.put("admin:database-set-field-trailing-wildcard-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-field-trailing-wildcard-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the field trailing wildcard searches setting for the specified database in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-field-trailing-wildcard-searches\">Complete Information for admin:database-set-field-trailing-wildcard-searches</a></div></div>");
        fDocs.put("admin:database-set-field-trailing-wildcard-word-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-field-trailing-wildcard-word-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the field trailing wildcard word positions setting for the specified field in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-field-trailing-wildcard-word-positions\">Complete Information for admin:database-set-field-trailing-wildcard-word-positions</a></div></div>");
        fDocs.put("admin:database-set-field-three-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-field-three-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the field three character searches setting for the specified field in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-field-three-character-searches\">Complete Information for admin:database-set-field-three-character-searches</a></div></div>");
        fDocs.put("admin:database-set-field-three-character-word-positions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-field-three-character-word-positions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the field three character word positions setting for the specified field in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-field-three-character-word-positions\">Complete Information for admin:database-set-field-three-character-word-positions</a></div></div>");
        fDocs.put("admin:database-set-field-two-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-field-two-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the field two character searches setting for the specified field in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-field-two-character-searches\">Complete Information for admin:database-set-field-two-character-searches</a></div></div>");
        fDocs.put("admin:database-set-field-one-character-searches", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-field-one-character-searches(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">value as xs:boolean?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the field one character searches setting for the specified field in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-field-one-character-searches\">Complete Information for admin:database-set-field-one-character-searches</a></div></div>");
        fDocs.put("admin:database-set-field-include-document-root", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-field-include-document-root(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the field include document root setting for the specified field in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-field-include-document-root\">Complete Information for admin:database-set-field-include-document-root</a></div></div>");
        fDocs.put("admin:database-set-field-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-field-name(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">field-name as xs:string,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the field name setting for the specified field in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-field-name\">Complete Information for admin:database-set-field-name</a></div></div>");
        fDocs.put("admin:forest-get-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-get-name(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the name(s) of the specified forest(s), given the forest ID(s). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-get-name\">Complete Information for admin:forest-get-name</a></div></div>");
        fDocs.put("admin:forest-get-host", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-get-host(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the ID of the host in which the specicified forest resides. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-get-host\">Complete Information for admin:forest-get-host</a></div></div>");
        fDocs.put("admin:forest-get-id", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-get-id(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the ID of the forest with the specified name, from the specified configuration. The difference between this function and <code xmlns=\"http://www.w3.org/1999/xhtml\">xdmp:forest</code> is that the ID from this function can come from a forest that has not yet been saved (that is, from a forest that has been created in the same query with the Admin library but has not yet been saved to the cluster configuration files). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-get-id\">Complete Information for admin:forest-get-id</a></div></div>");
        fDocs.put("admin:forest-get-enabled", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-get-enabled(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the enabled state of the specified forest. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-get-enabled\">Complete Information for admin:forest-get-enabled</a></div></div>");
        fDocs.put("admin:forest-get-data-directory", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-get-data-directory(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the name of the data directory of the specified forest. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-get-data-directory\">Complete Information for admin:forest-get-data-directory</a></div></div>");
        fDocs.put("admin:forest-get-failover-enable", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-get-failover-enable(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the state of whether failover is enabled for the specified forest. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-get-failover-enable\">Complete Information for admin:forest-get-failover-enable</a></div></div>");
        fDocs.put("admin:forest-get-updates-allowed", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-get-updates-allowed(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the state of what kinds of updates are allowed for the specified forest. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-get-updates-allowed\">Complete Information for admin:forest-get-updates-allowed</a></div></div>");
        fDocs.put("admin:forest-get-failover-hosts", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-get-failover-hosts(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the forest IDs of the hosts defined as failover hosts for this forest. The order in which the hosts IDs are returned is significant, with the first ID being the primary host, the second (if there is one) being the secondary, and so on. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-get-failover-hosts\">Complete Information for admin:forest-get-failover-hosts</a></div></div>");
        fDocs.put("admin:forest-set-host", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-set-host(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets a forest configuration to a new host. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-set-host\">Complete Information for admin:forest-set-host</a></div></div>");
        fDocs.put("admin:forest-set-enabled", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-set-enabled(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the enabled state for a forest configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-set-enabled\">Complete Information for admin:forest-set-enabled</a></div></div>");
        fDocs.put("admin:forest-set-failover-enable", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-set-failover-enable(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the forest failover enabled state for a forest configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-set-failover-enable\">Complete Information for admin:forest-set-failover-enable</a></div></div>");
        fDocs.put("admin:forest-set-updates-allowed", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-set-updates-allowed(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the updates-allowed state for a forest configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-set-updates-allowed\">Complete Information for admin:forest-set-updates-allowed</a></div></div>");
        fDocs.put("admin:forest-add-failover-host", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-add-failover-host(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">hosts as xs:unsignedLong*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds a failover host to the list of failover hosts for the specified forest in the specified configuration. If there are already any hosts specified, this host is added to the end of the list of failover hosts. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-add-failover-host\">Complete Information for admin:forest-add-failover-host</a></div></div>");
        fDocs.put("admin:forest-delete-failover-host", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-delete-failover-host(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">hosts as xs:unsignedLong*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes the specified failover host(s) from the failover-host list in the specified configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-delete-failover-host\">Complete Information for admin:forest-delete-failover-host</a></div></div>");
        fDocs.put("admin:forest-delete", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-delete(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-ids as xs:unsignedLong*,</div><div style=\"padding-left:2em;\">delete-data as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes the configuration for the specified forest from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-delete\">Complete Information for admin:forest-delete</a></div></div>");
        fDocs.put("admin:forest-create", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-create(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-name as xs:string,</div><div style=\"padding-left:2em;\">host-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">data-directory as xs:string?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function creates a new forest configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-create\">Complete Information for admin:forest-create</a></div></div>");
        fDocs.put("admin:forest-copy", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-copy(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">forest-name as xs:string,</div><div style=\"padding-left:2em;\">data-directory as xs:string?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function creates a new forest specification with the same settings as the forest with the specified ID. The new forest configuration will have the specified name. It copies the forest configuration, but does not copy the forest data. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-copy\">Complete Information for admin:forest-copy</a></div></div>");
        fDocs.put("admin:forest-get-backups", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-get-backups(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the scheduled backups for the specified forest from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-get-backups\">Complete Information for admin:forest-get-backups</a></div></div>");
        fDocs.put("admin:forest-weekly-backup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-weekly-backup(</div><div style=\"padding-left:2em;\">backup-dir as xs:string,</div><div style=\"padding-left:2em;\">backup-period as xs:positiveInteger,</div><div style=\"padding-left:2em;\">days as xs:string+,</div><div style=\"padding-left:2em;\">start-time as xs:time</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a weekly scheduled backup. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-weekly-backup\">Complete Information for admin:forest-weekly-backup</a></div></div>");
        fDocs.put("admin:forest-monthly-backup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-monthly-backup(</div><div style=\"padding-left:2em;\">backup-dir as xs:string,</div><div style=\"padding-left:2em;\">backup-period as xs:positiveInteger,</div><div style=\"padding-left:2em;\">backup-month-day as xs:unsignedInt,</div><div style=\"padding-left:2em;\">start-time as xs:time</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a monthly scheduled backup. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-monthly-backup\">Complete Information for admin:forest-monthly-backup</a></div></div>");
        fDocs.put("admin:forest-one-time-backup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-one-time-backup(</div><div style=\"padding-left:2em;\">backup-dir as xs:string,</div><div style=\"padding-left:2em;\">start as xs:dateTime</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a one-time backup. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-one-time-backup\">Complete Information for admin:forest-one-time-backup</a></div></div>");
        fDocs.put("admin:forest-add-backup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-add-backup(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">backups as element(as:forest-backup)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds scheduled backup specifications for a forest to a configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-add-backup\">Complete Information for admin:forest-add-backup</a></div></div>");
        fDocs.put("admin:forest-delete-backup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-delete-backup(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">forest-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">backups as element(as:forest-backup)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes scheduled backup specifications for a forest from a configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-delete-backup\">Complete Information for admin:forest-delete-backup</a></div></div>");
        fDocs.put("admin:host-get-id", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:host-get-id(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">host-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function return the ID for the specified host from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:host-get-id\">Complete Information for admin:host-get-id</a></div></div>");
        fDocs.put("admin:host-get-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:host-get-name(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">host-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the name for the host with the specified ID. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:host-get-name\">Complete Information for admin:host-get-name</a></div></div>");
        fDocs.put("admin:host-get-group", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:host-get-group(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">host-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the group ID for the host with the specified ID. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:host-get-group\">Complete Information for admin:host-get-group</a></div></div>");
        fDocs.put("admin:host-get-port", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:host-get-port(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">host-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the bind port for the host with the specified ID. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:host-get-port\">Complete Information for admin:host-get-port</a></div></div>");
        fDocs.put("admin:host-set-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:host-set-name(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">host-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the name of an existing host to the newly specified value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:host-set-name\">Complete Information for admin:host-set-name</a></div></div>");
        fDocs.put("admin:host-set-group", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:host-set-group(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">host-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the group to which an existing host belongs to the newly specified value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:host-set-group\">Complete Information for admin:host-set-group</a></div></div>");
        fDocs.put("admin:host-set-port", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:host-set-port(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">host-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the bind port value for the host to the newly specified value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:host-set-port\">Complete Information for admin:host-set-port</a></div></div>");
        fDocs.put("admin:appserver-get-type", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-type(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the type of appserver with the specified ID. It will be either \"http\", \"xdbc\", or \"WebDAV\". </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-type\">Complete Information for admin:appserver-get-type</a></div></div>");
        fDocs.put("admin:appserver-get-group-id", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-group-id(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the ID of the specified App Server's group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-group-id\">Complete Information for admin:appserver-get-group-id</a></div></div>");
        fDocs.put("admin:appserver-get-host-ids", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-host-ids(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the ID(s) of the hosts the specified App Server's is currently running on. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-host-ids\">Complete Information for admin:appserver-get-host-ids</a></div></div>");
        fDocs.put("admin:appserver-get-id", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-id(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-ids as xs:unsignedLong*,</div><div style=\"padding-left:2em;\">appserver-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the ID of the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-id\">Complete Information for admin:appserver-get-id</a></div></div>");
        fDocs.put("admin:appserver-get-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-name(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the name of the appserver with the specified ID. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-name\">Complete Information for admin:appserver-get-name</a></div></div>");
        fDocs.put("admin:appserver-get-root", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-root(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the root for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-root\">Complete Information for admin:appserver-get-root</a></div></div>");
        fDocs.put("admin:appserver-get-port", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-port(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the port for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-port\">Complete Information for admin:appserver-get-port</a></div></div>");
        fDocs.put("admin:appserver-get-modules-database", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-modules-database(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the ID of the database set as the modules database for the specified database. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-modules-database\">Complete Information for admin:appserver-get-modules-database</a></div></div>");
        fDocs.put("admin:appserver-get-database", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-database(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the ID of the database to which the App Server is set to execute queries against for the specified database. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-database\">Complete Information for admin:appserver-get-database</a></div></div>");
        fDocs.put("admin:appserver-get-last-login", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-last-login(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the ID of the database to which the App Server stores users' last login information. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-last-login\">Complete Information for admin:appserver-get-last-login</a></div></div>");
        fDocs.put("admin:appserver-get-display-last-login", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-display-last-login(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value of the whether or not the appserver should display users' last login information. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-display-last-login\">Complete Information for admin:appserver-get-display-last-login</a></div></div>");
        fDocs.put("admin:appserver-get-address", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-address(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the IP address of the App Server configuration. The default is <code xmlns=\"http://www.w3.org/1999/xhtml\">0.0.0.0</code>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-address\">Complete Information for admin:appserver-get-address</a></div></div>");
        fDocs.put("admin:appserver-get-backlog", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-backlog(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the socket listen backlog setting for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-backlog\">Complete Information for admin:appserver-get-backlog</a></div></div>");
        fDocs.put("admin:appserver-get-threads", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-threads(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the maximum number of threads configured for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-threads\">Complete Information for admin:appserver-get-threads</a></div></div>");
        fDocs.put("admin:appserver-get-request-timeout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-request-timeout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the request timeout value configured for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-request-timeout\">Complete Information for admin:appserver-get-request-timeout</a></div></div>");
        fDocs.put("admin:appserver-get-keep-alive-timeout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-keep-alive-timeout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the keep alive timeout value configured for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-keep-alive-timeout\">Complete Information for admin:appserver-get-keep-alive-timeout</a></div></div>");
        fDocs.put("admin:appserver-get-session-timeout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-session-timeout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the session timeout value configured for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-session-timeout\">Complete Information for admin:appserver-get-session-timeout</a></div></div>");
        fDocs.put("admin:appserver-get-default-time-limit", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-default-time-limit(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the default time limit value configured for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-default-time-limit\">Complete Information for admin:appserver-get-default-time-limit</a></div></div>");
        fDocs.put("admin:appserver-get-max-time-limit", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-max-time-limit(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the max time limit value configured for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-max-time-limit\">Complete Information for admin:appserver-get-max-time-limit</a></div></div>");
        fDocs.put("admin:appserver-get-pre-commit-trigger-depth", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-pre-commit-trigger-depth(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the pre commit trigger depth value configured for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-pre-commit-trigger-depth\">Complete Information for admin:appserver-get-pre-commit-trigger-depth</a></div></div>");
        fDocs.put("admin:appserver-get-pre-commit-trigger-limit", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-pre-commit-trigger-limit(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the pre commit trigger limit value configured for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-pre-commit-trigger-limit\">Complete Information for admin:appserver-get-pre-commit-trigger-limit</a></div></div>");
        fDocs.put("admin:appserver-get-collation", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-collation(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the collation URI set in the configuration for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-collation\">Complete Information for admin:appserver-get-collation</a></div></div>");
        fDocs.put("admin:appserver-get-authentication", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-authentication(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the authentication scheme (basic, digest, digestbasic, or application-level) configured for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-authentication\">Complete Information for admin:appserver-get-authentication</a></div></div>");
        fDocs.put("admin:appserver-get-default-user", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-default-user(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the default user value configured for the specified App Server. The default user only is used with application-level authentication. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-default-user\">Complete Information for admin:appserver-get-default-user</a></div></div>");
        fDocs.put("admin:appserver-get-privilege", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-privilege(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the privilege ID for the specified App Server. If no privilege is configured, It returns 0. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-privilege\">Complete Information for admin:appserver-get-privilege</a></div></div>");
        fDocs.put("admin:appserver-get-concurrent-request-limit", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-concurrent-request-limit(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the concurrent request limit for any user for the specified App Server. 0 indicates no bound on the number of concurrent requests. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-concurrent-request-limit\">Complete Information for admin:appserver-get-concurrent-request-limit</a></div></div>");
        fDocs.put("admin:appserver-get-log-errors", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-log-errors(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value of the log errors setting configured for this App Server, where true indicates that the App Server will send uncaught exceptions to the <code xmlns=\"http://www.w3.org/1999/xhtml\">ErrorLog.txt</code> file, and false indicates that it will not. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-log-errors\">Complete Information for admin:appserver-get-log-errors</a></div></div>");
        fDocs.put("admin:appserver-get-debug-allow", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-debug-allow(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value of debug allow setting configured for this App Server, where true indicates that the App Server will allow queries to be debugged, and false indicates that it will not. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-debug-allow\">Complete Information for admin:appserver-get-debug-allow</a></div></div>");
        fDocs.put("admin:appserver-get-profile-allow", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-profile-allow(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value of the profile allow setting configured for this App Server, where true indicates that the App Server will allow queries to be profiled, and false indicates that it will not. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-profile-allow\">Complete Information for admin:appserver-get-profile-allow</a></div></div>");
        fDocs.put("admin:appserver-get-default-xquery-version", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-default-xquery-version(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value of the default xquery version configured for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-default-xquery-version\">Complete Information for admin:appserver-get-default-xquery-version</a></div></div>");
        fDocs.put("admin:appserver-get-output-sgml-character-entities", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-output-sgml-character-entities(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the output sgml character entities setting for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-output-sgml-character-entities\">Complete Information for admin:appserver-get-output-sgml-character-entities</a></div></div>");
        fDocs.put("admin:appserver-get-output-encoding", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-output-encoding(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the output encoding setting for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-output-encoding\">Complete Information for admin:appserver-get-output-encoding</a></div></div>");
        fDocs.put("admin:appserver-get-error-handler", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-error-handler(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the path to the error handler configured for this App Server. If no error handler is configured, returns the empty string. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-error-handler\">Complete Information for admin:appserver-get-error-handler</a></div></div>");
        fDocs.put("admin:appserver-get-url-rewriter", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-url-rewriter(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the path to the URL rewriter configured for this App Server. If no URL rewriter is configured, returns the empty string. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-url-rewriter\">Complete Information for admin:appserver-get-url-rewriter</a></div></div>");
        fDocs.put("admin:appserver-get-enabled", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-enabled(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the enabled state for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-enabled\">Complete Information for admin:appserver-get-enabled</a></div></div>");
        fDocs.put("admin:appserver-get-schemas", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-schemas(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value of any schemas definitions predefined for the specified App Server. If none are defined, returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-schemas\">Complete Information for admin:appserver-get-schemas</a></div></div>");
        fDocs.put("admin:appserver-get-namespaces", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-namespaces(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value of any namespace definitions predefined for the specified App Server. If none are defined, returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-namespaces\">Complete Information for admin:appserver-get-namespaces</a></div></div>");
        fDocs.put("admin:appserver-get-static-expires", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-static-expires(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value of the \"expires\" HTTP header for static content to expire after this many seconds port for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-static-expires\">Complete Information for admin:appserver-get-static-expires</a></div></div>");
        fDocs.put("admin:appserver-get-compute-content-length", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-compute-content-length(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value of whether the WebDAV server computes content length. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-compute-content-length\">Complete Information for admin:appserver-get-compute-content-length</a></div></div>");
        fDocs.put("admin:appserver-set-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-name(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the name of an existing App Server to the newly specified value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-name\">Complete Information for admin:appserver-set-name</a></div></div>");
        fDocs.put("admin:appserver-set-root", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-root(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the root for a specified App Server to the newly specified value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-root\">Complete Information for admin:appserver-set-root</a></div></div>");
        fDocs.put("admin:appserver-set-port", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-port(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the port in the configuration for the specified App Server to the specified number. Changing the port is a \"cold\" operation; when you use <code xmlns=\"http://www.w3.org/1999/xhtml\">admin:save-configuration</code> to save the configuration, it will automatically restart MarkLogic Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-port\">Complete Information for admin:appserver-set-port</a></div></div>");
        fDocs.put("admin:appserver-set-modules-database", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-modules-database(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">database-id as item()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value in the configuration of modules database for the specified App Server to the specified database ID. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-modules-database\">Complete Information for admin:appserver-set-modules-database</a></div></div>");
        fDocs.put("admin:appserver-set-database", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-database(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value in the configuration of the database for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-database\">Complete Information for admin:appserver-set-database</a></div></div>");
        fDocs.put("admin:appserver-set-last-login", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-last-login(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedLong?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value in the configuration of the last login database for the specified App Server. If the value is equal to 0, then the last-login feature is disabled for this appserver. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-last-login\">Complete Information for admin:appserver-set-last-login</a></div></div>");
        fDocs.put("admin:appserver-set-display-last-login", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-display-last-login(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the display last login setting in the configuration for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-display-last-login\">Complete Information for admin:appserver-set-display-last-login</a></div></div>");
        fDocs.put("admin:appserver-set-address", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-address(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the IP Address in the configuration for the specified App Server to the specified address. Changing the address is a \"cold\" operation; when you use <code xmlns=\"http://www.w3.org/1999/xhtml\">admin:save-configuration</code> to save the configuration, it will automatically restart MarkLogic Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-address\">Complete Information for admin:appserver-set-address</a></div></div>");
        fDocs.put("admin:appserver-set-backlog", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-backlog(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value in the configuration of the backlog (the maximum number of pending connections allowed on the HTTP socket) for the specified App Server. This is a \"cold\" operation; when you use <code xmlns=\"http://www.w3.org/1999/xhtml\">admin:save-configuration</code> to save the configuration, it will automatically restart MarkLogic Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-backlog\">Complete Information for admin:appserver-set-backlog</a></div></div>");
        fDocs.put("admin:appserver-set-threads", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-threads(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value in the configuration of the maximum number of threads for the specified App Server. This is a \"cold\" operation; when you use <code xmlns=\"http://www.w3.org/1999/xhtml\">admin:save-configuration</code> to save the configuration, it will automatically restart MarkLogic Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-threads\">Complete Information for admin:appserver-set-threads</a></div></div>");
        fDocs.put("admin:appserver-set-request-timeout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-request-timeout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value of the socket request timeout (the number of seconds before the socket times out) in the configuration for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-request-timeout\">Complete Information for admin:appserver-set-request-timeout</a></div></div>");
        fDocs.put("admin:appserver-set-keep-alive-timeout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-keep-alive-timeout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the keep-alive timeout (the maximum number of second for subsequent socket requests to time out) in the configuration for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-keep-alive-timeout\">Complete Information for admin:appserver-set-keep-alive-timeout</a></div></div>");
        fDocs.put("admin:appserver-set-session-timeout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-session-timeout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the session timeout value (in seconds) in the configuration for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-session-timeout\">Complete Information for admin:appserver-set-session-timeout</a></div></div>");
        fDocs.put("admin:appserver-set-default-time-limit", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-default-time-limit(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the default time limit (the maximum total amount of time to service a request before the App Server throws a timeout exception) in the configuration for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-default-time-limit\">Complete Information for admin:appserver-set-default-time-limit</a></div></div>");
        fDocs.put("admin:appserver-set-max-time-limit", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-max-time-limit(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the max time limit (the maximum total amount of time to service a request before the App Server throws a timeout exception) in the configuration for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-max-time-limit\">Complete Information for admin:appserver-set-max-time-limit</a></div></div>");
        fDocs.put("admin:appserver-set-pre-commit-trigger-depth", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-pre-commit-trigger-depth(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the maximum depth (how many triggers can cause other triggers to fire, which in turn cause others to fire, and so on) in the configuration for the specifed App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-pre-commit-trigger-depth\">Complete Information for admin:appserver-set-pre-commit-trigger-depth</a></div></div>");
        fDocs.put("admin:appserver-set-pre-commit-trigger-limit", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-pre-commit-trigger-limit(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value in the configuration for the maximum number of pre-commit triggers a single statement can invoke for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-pre-commit-trigger-limit\">Complete Information for admin:appserver-set-pre-commit-trigger-limit</a></div></div>");
        fDocs.put("admin:appserver-set-collation", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-collation(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the default collation in the configuration for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-collation\">Complete Information for admin:appserver-set-collation</a></div></div>");
        fDocs.put("admin:appserver-set-authentication", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-authentication(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the authentication scheme in the configuration for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-authentication\">Complete Information for admin:appserver-set-authentication</a></div></div>");
        fDocs.put("admin:appserver-set-default-user", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-default-user(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the default user (for use with application-level authentication) in the configuration for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-default-user\">Complete Information for admin:appserver-set-default-user</a></div></div>");
        fDocs.put("admin:appserver-set-privilege", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-privilege(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets an execute privilege in the configuration for the specified App Server. When a privilege is set, the user who makes a request to the App Server must have been granted (via a role, either directly or indirectly) the specified privilege. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-privilege\">Complete Information for admin:appserver-set-privilege</a></div></div>");
        fDocs.put("admin:appserver-set-concurrent-request-limit", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-concurrent-request-limit(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the limit on concurrent requests that any user may have on a particular appserver. Setting the limit to 0 indicates there is no bound on the number of concurrent requests. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-concurrent-request-limit\">Complete Information for admin:appserver-set-concurrent-request-limit</a></div></div>");
        fDocs.put("admin:appserver-set-log-errors", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-log-errors(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the log errors setting in the configuration for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-log-errors\">Complete Information for admin:appserver-set-log-errors</a></div></div>");
        fDocs.put("admin:appserver-set-debug-allow", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-debug-allow(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the debug allow setting in the configuration for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-debug-allow\">Complete Information for admin:appserver-set-debug-allow</a></div></div>");
        fDocs.put("admin:appserver-set-profile-allow", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-profile-allow(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the profile allow setting in the configuration for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-profile-allow\">Complete Information for admin:appserver-set-profile-allow</a></div></div>");
        fDocs.put("admin:appserver-set-default-xquery-version", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-default-xquery-version(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the default XQuery version setting in the configuration for this App Server. This setting determines the XQuery dialect used in queries against this App Server when one is not explicitly specified in the XQuery version declaration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-default-xquery-version\">Complete Information for admin:appserver-set-default-xquery-version</a></div></div>");
        fDocs.put("admin:appserver-set-output-sgml-character-entities", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-output-sgml-character-entities(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the SGML character entity output setting in the configuration for the specified App Server. The SGML setting determines how characters that can be represented as SGML entites are serialized upon output by default in a query against the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-output-sgml-character-entities\">Complete Information for admin:appserver-set-output-sgml-character-entities</a></div></div>");
        fDocs.put("admin:appserver-set-output-encoding", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-output-encoding(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value for the default output encoding in the configuration for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-output-encoding\">Complete Information for admin:appserver-set-output-encoding</a></div></div>");
        fDocs.put("admin:appserver-set-error-handler", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-error-handler(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value of the path to the error handler in the configuration for the specified App Server. The path should specify a relative or absolute path to an XQuery module that is executed in the event of any 400 or 500 series HTTP errors (sometime known as a \"sorry\" server to give the user a clean error page). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-error-handler\">Complete Information for admin:appserver-set-error-handler</a></div></div>");
        fDocs.put("admin:appserver-set-url-rewriter", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-url-rewriter(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value of the path to the URL rewriter in the configuration for the specified App Server. The path should specify a relative or absolute path to an XQuery module that is executed to rewrite incoming URLs. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-url-rewriter\">Complete Information for admin:appserver-set-url-rewriter</a></div></div>");
        fDocs.put("admin:appserver-set-enabled", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-enabled(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the enabled state in the configuration for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-enabled\">Complete Information for admin:appserver-set-enabled</a></div></div>");
        fDocs.put("admin:appserver-set-static-expires", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-static-expires(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the value of the \"expires\" HTTP header for a specified App Server to the newly specified value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-static-expires\">Complete Information for admin:appserver-set-static-expires</a></div></div>");
        fDocs.put("admin:appserver-set-compute-content-length", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-compute-content-length(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the value whether a WebDAV server computes content length. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-compute-content-length\">Complete Information for admin:appserver-set-compute-content-length</a></div></div>");
        fDocs.put("admin:appserver-get-request-blackouts", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-request-blackouts(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the request blackouts specification for the specified appserver from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-request-blackouts\">Complete Information for admin:appserver-get-request-blackouts</a></div></div>");
        fDocs.put("admin:appserver-recurring-request-blackout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-recurring-request-blackout(</div><div style=\"padding-left:2em;\">users as xs:unsignedLong*,</div><div style=\"padding-left:2em;\">roles as xs:unsignedLong*,</div><div style=\"padding-left:2em;\">days as xs:string*,</div><div style=\"padding-left:2em;\">start-time as xs:time?,</div><div style=\"padding-left:2em;\">end-time as xs:time?,</div><div style=\"padding-left:2em;\">duration as xs:duration?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a request-blackout specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-recurring-request-blackout\">Complete Information for admin:appserver-recurring-request-blackout</a></div></div>");
        fDocs.put("admin:appserver-one-time-request-blackout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-one-time-request-blackout(</div><div style=\"padding-left:2em;\">users as xs:unsignedLong*,</div><div style=\"padding-left:2em;\">roles as xs:unsignedLong*,</div><div style=\"padding-left:2em;\">start as xs:dateTime,</div><div style=\"padding-left:2em;\">end as xs:dateTime?,</div><div style=\"padding-left:2em;\">duration as xs:duration?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a one-time request-blackout specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-one-time-request-blackout\">Complete Information for admin:appserver-one-time-request-blackout</a></div></div>");
        fDocs.put("admin:appserver-add-request-blackout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-add-request-blackout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">request-blackouts as element(gr:request-blackout)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds a request blackout specification for a appserver to a configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-add-request-blackout\">Complete Information for admin:appserver-add-request-blackout</a></div></div>");
        fDocs.put("admin:appserver-delete-request-blackout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-delete-request-blackout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">blackouts as element(gr:request-blackout)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes a request blackout specification for a appserver from a configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-delete-request-blackout\">Complete Information for admin:appserver-delete-request-blackout</a></div></div>");
        fDocs.put("admin:group-schema", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-schema(</div><div style=\"padding-left:2em;\">namespace-uri as xs:string,</div><div style=\"padding-left:2em;\">schema-location as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a schema element with the specified prefix and URI. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-schema\">Complete Information for admin:group-schema</a></div></div>");
        fDocs.put("admin:appserver-add-schema", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-add-schema(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">schemas as element(gr:schema)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds a schema binding definition to the existing schema binding definitions in the configuration for the specified App Server. Schemas with a schema binding definition are automatically imported into queries run against the App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-add-schema\">Complete Information for admin:appserver-add-schema</a></div></div>");
        fDocs.put("admin:appserver-delete-schema", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-delete-schema(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">schemas as element(gr:schema)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes a schema definition in the configuration for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-delete-schema\">Complete Information for admin:appserver-delete-schema</a></div></div>");
        fDocs.put("admin:group-namespace", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-namespace(</div><div style=\"padding-left:2em;\">prefix as xs:string,</div><div style=\"padding-left:2em;\">namespace-uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a namespace element with the specified prefix and URI. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-namespace\">Complete Information for admin:group-namespace</a></div></div>");
        fDocs.put("admin:appserver-add-namespace", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-add-namespace(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">namespaces as element(gr:namespace)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Add one or more namespaces to an App Server configuration, which will predefine the namespace(s) for all requests evaluated against the App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-add-namespace\">Complete Information for admin:appserver-add-namespace</a></div></div>");
        fDocs.put("admin:appserver-delete-namespace", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-delete-namespace(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">namespaces as element(gr:namespace)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes a namespace configuration from the configuration for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-delete-namespace\">Complete Information for admin:appserver-delete-namespace</a></div></div>");
        fDocs.put("admin:appserver-delete", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-delete(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-ids as xs:unsignedLong*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes one or more App Servers in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-delete\">Complete Information for admin:appserver-delete</a></div></div>");
        fDocs.put("admin:http-server-create", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:http-server-create(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">appserver-name as xs:string,</div><div style=\"padding-left:2em;\">root as xs:string,</div><div style=\"padding-left:2em;\">port as xs:unsignedLong,</div><div style=\"padding-left:2em;\">modules-id as item(),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function creates a new HTTP App Server with the specified name, root, and port in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:http-server-create\">Complete Information for admin:http-server-create</a></div></div>");
        fDocs.put("admin:xdbc-server-create", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:xdbc-server-create(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">appserver-name as xs:string,</div><div style=\"padding-left:2em;\">root as xs:string,</div><div style=\"padding-left:2em;\">port as xs:unsignedLong,</div><div style=\"padding-left:2em;\">modules-id as item(),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function creates a new XDBC App Server with the specified name, root, and port in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:xdbc-server-create\">Complete Information for admin:xdbc-server-create</a></div></div>");
        fDocs.put("admin:webdav-server-create", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:webdav-server-create(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">appserver-name as xs:string,</div><div style=\"padding-left:2em;\">root as xs:string,</div><div style=\"padding-left:2em;\">port as xs:unsignedLong,</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function creates a new WebDAV App Server with the specified name, library, and port in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:webdav-server-create\">Complete Information for admin:webdav-server-create</a></div></div>");
        fDocs.put("admin:appserver-copy", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-copy(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">target-group-id as xs:unsignedLong?,</div><div style=\"padding-left:2em;\">appserver-name as xs:string,</div><div style=\"padding-left:2em;\">port as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function creates a new App Server specification with the same settings as the App Server with the specified ID. The new App Server configuration will have the specified name. You can copy the App Server to a new one either in the same group (by specifying $old-group-id and $new-group-id with the same group ID) or in a different group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-copy\">Complete Information for admin:appserver-copy</a></div></div>");
        fDocs.put("admin:taskserver-get-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-get-name(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the name of the task server for the specified group from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-get-name\">Complete Information for admin:taskserver-get-name</a></div></div>");
        fDocs.put("admin:taskserver-get-threads", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-get-threads(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the number of threads configured on the task server for the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-get-threads\">Complete Information for admin:taskserver-get-threads</a></div></div>");
        fDocs.put("admin:taskserver-get-debug-threads", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-get-debug-threads(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the number of debug threads configured on the task server for the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-get-debug-threads\">Complete Information for admin:taskserver-get-debug-threads</a></div></div>");
        fDocs.put("admin:taskserver-get-default-time-limit", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-get-default-time-limit(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the default time limit configured on the task server for the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-get-default-time-limit\">Complete Information for admin:taskserver-get-default-time-limit</a></div></div>");
        fDocs.put("admin:taskserver-get-max-time-limit", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-get-max-time-limit(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the maximum time limit configured on the task server for the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-get-max-time-limit\">Complete Information for admin:taskserver-get-max-time-limit</a></div></div>");
        fDocs.put("admin:taskserver-get-queue-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-get-queue-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the number queue size configured on the task server for the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-get-queue-size\">Complete Information for admin:taskserver-get-queue-size</a></div></div>");
        fDocs.put("admin:taskserver-get-pre-commit-trigger-depth", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-get-pre-commit-trigger-depth(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the maximum pre-commit trigger depth configured on the task server for the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-get-pre-commit-trigger-depth\">Complete Information for admin:taskserver-get-pre-commit-trigger-depth</a></div></div>");
        fDocs.put("admin:taskserver-get-post-commit-trigger-depth", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-get-post-commit-trigger-depth(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the maximum post-commit trigger depth configured on the task server for the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-get-post-commit-trigger-depth\">Complete Information for admin:taskserver-get-post-commit-trigger-depth</a></div></div>");
        fDocs.put("admin:taskserver-get-pre-commit-trigger-limit", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-get-pre-commit-trigger-limit(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the pre-commit trigger limit configured on the task server for the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-get-pre-commit-trigger-limit\">Complete Information for admin:taskserver-get-pre-commit-trigger-limit</a></div></div>");
        fDocs.put("admin:taskserver-get-log-errors", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-get-log-errors(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the log-errors setting configured on the task server for the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-get-log-errors\">Complete Information for admin:taskserver-get-log-errors</a></div></div>");
        fDocs.put("admin:taskserver-get-debug-allow", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-get-debug-allow(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the debug-allow setting configured on the task server for the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-get-debug-allow\">Complete Information for admin:taskserver-get-debug-allow</a></div></div>");
        fDocs.put("admin:taskserver-get-profile-allow", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-get-profile-allow(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the profile-allow setting configured on the task server for the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-get-profile-allow\">Complete Information for admin:taskserver-get-profile-allow</a></div></div>");
        fDocs.put("admin:taskserver-set-threads", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-set-threads(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value in the configuration of the maximum number of threads for the specified task server. This is a \"cold\" operation; when you use <code xmlns=\"http://www.w3.org/1999/xhtml\">admin:save-configuration</code> to save the configuration, it will automatically restart MarkLogic Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-set-threads\">Complete Information for admin:taskserver-set-threads</a></div></div>");
        fDocs.put("admin:taskserver-set-debug-threads", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-set-debug-threads(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value in the configuration of the maximum number of debug threads for the specified task server. This is a \"cold\" operation; when you use <code xmlns=\"http://www.w3.org/1999/xhtml\">admin:save-configuration</code> to save the configuration, it will automatically restart MarkLogic Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-set-debug-threads\">Complete Information for admin:taskserver-set-debug-threads</a></div></div>");
        fDocs.put("admin:taskserver-set-default-time-limit", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-set-default-time-limit(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the task server default time limit in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-set-default-time-limit\">Complete Information for admin:taskserver-set-default-time-limit</a></div></div>");
        fDocs.put("admin:taskserver-set-max-time-limit", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-set-max-time-limit(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the task server max time limit in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-set-max-time-limit\">Complete Information for admin:taskserver-set-max-time-limit</a></div></div>");
        fDocs.put("admin:taskserver-set-queue-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-set-queue-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value in the configuration of the maximum queue size for the specified task server. This is a \"cold\" operation; when you use <code xmlns=\"http://www.w3.org/1999/xhtml\">admin:save-configuration</code> to save the configuration, it will automatically restart MarkLogic Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-set-queue-size\">Complete Information for admin:taskserver-set-queue-size</a></div></div>");
        fDocs.put("admin:taskserver-set-pre-commit-trigger-depth", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-set-pre-commit-trigger-depth(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value for the task server pre-commit trigger depth in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-set-pre-commit-trigger-depth\">Complete Information for admin:taskserver-set-pre-commit-trigger-depth</a></div></div>");
        fDocs.put("admin:taskserver-set-post-commit-trigger-depth", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-set-post-commit-trigger-depth(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value for the task server post-commit trigger depth in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-set-post-commit-trigger-depth\">Complete Information for admin:taskserver-set-post-commit-trigger-depth</a></div></div>");
        fDocs.put("admin:taskserver-set-pre-commit-trigger-limit", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-set-pre-commit-trigger-limit(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value for the task server pre-commit trigger depth in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-set-pre-commit-trigger-limit\">Complete Information for admin:taskserver-set-pre-commit-trigger-limit</a></div></div>");
        fDocs.put("admin:taskserver-set-log-errors", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-set-log-errors(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value for the log errors setting for the task server in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-set-log-errors\">Complete Information for admin:taskserver-set-log-errors</a></div></div>");
        fDocs.put("admin:taskserver-set-debug-allow", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-set-debug-allow(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value for the debug allow setting for the task server in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-set-debug-allow\">Complete Information for admin:taskserver-set-debug-allow</a></div></div>");
        fDocs.put("admin:taskserver-set-profile-allow", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:taskserver-set-profile-allow(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets the value for the profile allow setting for the task server in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:taskserver-set-profile-allow\">Complete Information for admin:taskserver-set-profile-allow</a></div></div>");
        fDocs.put("admin:group-get-host-ids", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-host-ids(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the IDs of all hosts belonging to the group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-host-ids\">Complete Information for admin:group-get-host-ids</a></div></div>");
        fDocs.put("admin:group-get-appserver-ids", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-appserver-ids(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the IDs of all appservers belonging to the group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-appserver-ids\">Complete Information for admin:group-get-appserver-ids</a></div></div>");
        fDocs.put("admin:group-get-httpserver-ids", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-httpserver-ids(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the IDs of all httpservers belonging to the group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-httpserver-ids\">Complete Information for admin:group-get-httpserver-ids</a></div></div>");
        fDocs.put("admin:group-get-xdbcserver-ids", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-xdbcserver-ids(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the IDs of all xdbcservers belonging to the group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-xdbcserver-ids\">Complete Information for admin:group-get-xdbcserver-ids</a></div></div>");
        fDocs.put("admin:group-get-webdavserver-ids", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-webdavserver-ids(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the IDs of all webdavservers belonging to the group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-webdavserver-ids\">Complete Information for admin:group-get-webdavserver-ids</a></div></div>");
        fDocs.put("admin:group-get-taskserver-id", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-taskserver-id(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the ID of of the taskserver belonging to the group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-taskserver-id\">Complete Information for admin:group-get-taskserver-id</a></div></div>");
        fDocs.put("admin:group-get-id", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-id(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the ID of the group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-id\">Complete Information for admin:group-get-id</a></div></div>");
        fDocs.put("admin:group-get-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-name(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the name of the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-name\">Complete Information for admin:group-get-name</a></div></div>");
        fDocs.put("admin:group-get-list-cache-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-list-cache-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the list cache size setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-list-cache-size\">Complete Information for admin:group-get-list-cache-size</a></div></div>");
        fDocs.put("admin:group-get-list-cache-partitions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-list-cache-partitions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the list cache partitions setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-list-cache-partitions\">Complete Information for admin:group-get-list-cache-partitions</a></div></div>");
        fDocs.put("admin:group-get-compressed-tree-cache-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-compressed-tree-cache-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the compressed tree cache size setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-compressed-tree-cache-size\">Complete Information for admin:group-get-compressed-tree-cache-size</a></div></div>");
        fDocs.put("admin:group-get-compressed-tree-cache-partitions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-compressed-tree-cache-partitions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the compressed tree cache partitions setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-compressed-tree-cache-partitions\">Complete Information for admin:group-get-compressed-tree-cache-partitions</a></div></div>");
        fDocs.put("admin:group-get-compressed-tree-read-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-compressed-tree-read-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the compressed tree read size (in kilobytes) setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-compressed-tree-read-size\">Complete Information for admin:group-get-compressed-tree-read-size</a></div></div>");
        fDocs.put("admin:group-get-expanded-tree-cache-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-expanded-tree-cache-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the expanded tree cache size setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-expanded-tree-cache-size\">Complete Information for admin:group-get-expanded-tree-cache-size</a></div></div>");
        fDocs.put("admin:group-get-expanded-tree-cache-partitions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-expanded-tree-cache-partitions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the expanded tree cache partitions setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-expanded-tree-cache-partitions\">Complete Information for admin:group-get-expanded-tree-cache-partitions</a></div></div>");
        fDocs.put("admin:group-get-smtp-relay", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-smtp-relay(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the smtp relay setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-smtp-relay\">Complete Information for admin:group-get-smtp-relay</a></div></div>");
        fDocs.put("admin:group-get-smtp-timeout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-smtp-timeout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the smtp timeout setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-smtp-timeout\">Complete Information for admin:group-get-smtp-timeout</a></div></div>");
        fDocs.put("admin:group-get-http-user-agent", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-http-user-agent(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the http user agent setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-http-user-agent\">Complete Information for admin:group-get-http-user-agent</a></div></div>");
        fDocs.put("admin:group-get-http-timeout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-http-timeout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the http timeout setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-http-timeout\">Complete Information for admin:group-get-http-timeout</a></div></div>");
        fDocs.put("admin:group-get-xdqp-timeout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-xdqp-timeout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the xdqp timeout setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-xdqp-timeout\">Complete Information for admin:group-get-xdqp-timeout</a></div></div>");
        fDocs.put("admin:group-get-host-timeout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-host-timeout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the host timeout setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-host-timeout\">Complete Information for admin:group-get-host-timeout</a></div></div>");
        fDocs.put("admin:group-get-host-initial-timeout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-host-initial-timeout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the host initial timeout setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-host-initial-timeout\">Complete Information for admin:group-get-host-initial-timeout</a></div></div>");
        fDocs.put("admin:group-get-retry-timeout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-retry-timeout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the number of seconds a request will retry before timing out. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-retry-timeout\">Complete Information for admin:group-get-retry-timeout</a></div></div>");
        fDocs.put("admin:group-get-system-log-level", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-system-log-level(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the system log level setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-system-log-level\">Complete Information for admin:group-get-system-log-level</a></div></div>");
        fDocs.put("admin:group-get-file-log-level", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-file-log-level(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the file log level setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-file-log-level\">Complete Information for admin:group-get-file-log-level</a></div></div>");
        fDocs.put("admin:group-get-rotate-log-files", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-rotate-log-files(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the rotate log files setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-rotate-log-files\">Complete Information for admin:group-get-rotate-log-files</a></div></div>");
        fDocs.put("admin:group-get-keep-log-files", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-keep-log-files(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the keep log files setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-keep-log-files\">Complete Information for admin:group-get-keep-log-files</a></div></div>");
        fDocs.put("admin:group-get-failover-enable", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-failover-enable(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the failover enable setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-failover-enable\">Complete Information for admin:group-get-failover-enable</a></div></div>");
        fDocs.put("admin:group-get-trace-events-activated", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-trace-events-activated(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the trace events activated setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-trace-events-activated\">Complete Information for admin:group-get-trace-events-activated</a></div></div>");
        fDocs.put("admin:group-get-schemas", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-schemas(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value of any schemas definitions predefined for the specified group. If none are defined, returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-schemas\">Complete Information for admin:group-get-schemas</a></div></div>");
        fDocs.put("admin:group-get-namespaces", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-namespaces(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value of any namespace definitions predefined for the specified group. If none are defined, returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-namespaces\">Complete Information for admin:group-get-namespaces</a></div></div>");
        fDocs.put("admin:group-get-trace-events", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-trace-events(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value of any trace events activated for the specified group. If none are defined, returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-trace-events\">Complete Information for admin:group-get-trace-events</a></div></div>");
        fDocs.put("admin:group-set-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-name(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the name of the group with the specified ID to the specified name. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-name\">Complete Information for admin:group-set-name</a></div></div>");
        fDocs.put("admin:group-set-list-cache-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-list-cache-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the list cache size setting of the group with the specified ID to the specified value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-list-cache-size\">Complete Information for admin:group-set-list-cache-size</a></div></div>");
        fDocs.put("admin:group-set-list-cache-partitions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-list-cache-partitions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the list cache partitions setting of the group with the specified ID to the specified value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-list-cache-partitions\">Complete Information for admin:group-set-list-cache-partitions</a></div></div>");
        fDocs.put("admin:group-set-compressed-tree-cache-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-compressed-tree-cache-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the compressed tree cache size setting of the group with the specified ID to the specified value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-compressed-tree-cache-size\">Complete Information for admin:group-set-compressed-tree-cache-size</a></div></div>");
        fDocs.put("admin:group-set-compressed-tree-cache-partitions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-compressed-tree-cache-partitions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the compressed tree cache partitions setting of the group with the specified ID to the specified value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-compressed-tree-cache-partitions\">Complete Information for admin:group-set-compressed-tree-cache-partitions</a></div></div>");
        fDocs.put("admin:group-set-compressed-tree-read-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-compressed-tree-read-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the compressed tree read size setting of the group with the specified ID to the specified value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-compressed-tree-read-size\">Complete Information for admin:group-set-compressed-tree-read-size</a></div></div>");
        fDocs.put("admin:group-set-expanded-tree-cache-size", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-expanded-tree-cache-size(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the expanded tree cache size setting of the group with the specified ID to the specified value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-expanded-tree-cache-size\">Complete Information for admin:group-set-expanded-tree-cache-size</a></div></div>");
        fDocs.put("admin:group-set-expanded-tree-cache-partitions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-expanded-tree-cache-partitions(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the expanded tree cache partitions setting of the group with the specified ID to the specified value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-expanded-tree-cache-partitions\">Complete Information for admin:group-set-expanded-tree-cache-partitions</a></div></div>");
        fDocs.put("admin:group-set-smtp-relay", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-smtp-relay(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the SMTP relay setting for the group in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-smtp-relay\">Complete Information for admin:group-set-smtp-relay</a></div></div>");
        fDocs.put("admin:group-set-smtp-timeout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-smtp-timeout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the SMTP timeout setting for the group in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-smtp-timeout\">Complete Information for admin:group-set-smtp-timeout</a></div></div>");
        fDocs.put("admin:group-set-http-user-agent", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-http-user-agent(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the HTTP User-Agent setting for the group in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-http-user-agent\">Complete Information for admin:group-set-http-user-agent</a></div></div>");
        fDocs.put("admin:group-set-http-timeout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-http-timeout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the HTTP timeout setting for the group in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-http-timeout\">Complete Information for admin:group-set-http-timeout</a></div></div>");
        fDocs.put("admin:group-set-xdqp-timeout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-xdqp-timeout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the XDQP timeout setting (the timeout for communication between data nodes and evaluator nodes) for the group in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-xdqp-timeout\">Complete Information for admin:group-set-xdqp-timeout</a></div></div>");
        fDocs.put("admin:group-set-host-timeout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-host-timeout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the host timeout setting (the timeout for communication between hosts) for the group in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-host-timeout\">Complete Information for admin:group-set-host-timeout</a></div></div>");
        fDocs.put("admin:group-set-host-initial-timeout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-host-initial-timeout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the host initial timeout setting (the time the cluster will wait for a host to come online during cluster startup) for the group in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-host-initial-timeout\">Complete Information for admin:group-set-host-initial-timeout</a></div></div>");
        fDocs.put("admin:group-set-retry-timeout", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-retry-timeout(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the the number of seconds a request will retry before timing out. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-retry-timeout\">Complete Information for admin:group-set-retry-timeout</a></div></div>");
        fDocs.put("admin:group-set-system-log-level", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-system-log-level(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the host system log level setting for the group in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-system-log-level\">Complete Information for admin:group-set-system-log-level</a></div></div>");
        fDocs.put("admin:group-set-file-log-level", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-file-log-level(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the host file log level setting for the group in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-file-log-level\">Complete Information for admin:group-set-file-log-level</a></div></div>");
        fDocs.put("admin:group-set-rotate-log-files", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-rotate-log-files(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the rotate log files setting for the group in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-rotate-log-files\">Complete Information for admin:group-set-rotate-log-files</a></div></div>");
        fDocs.put("admin:group-set-keep-log-files", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-keep-log-files(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the keep log files setting for the group in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-keep-log-files\">Complete Information for admin:group-set-keep-log-files</a></div></div>");
        fDocs.put("admin:group-set-failover-enable", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-failover-enable(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the failover enable setting for the group in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-failover-enable\">Complete Information for admin:group-set-failover-enable</a></div></div>");
        fDocs.put("admin:group-set-trace-events-activated", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-trace-events-activated(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the value for trace events in the group configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-trace-events-activated\">Complete Information for admin:group-set-trace-events-activated</a></div></div>");
        fDocs.put("admin:group-add-schema", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-add-schema(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">schemas as element(gr:schema)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds a schema binding definition to the existing schema binding definitions in the configuration for the specified Group. Schemas with a schema binding definition are automatically imported into queries run against any App Server in the group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-add-schema\">Complete Information for admin:group-add-schema</a></div></div>");
        fDocs.put("admin:group-delete-schema", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-delete-schema(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">schemas as element(gr:schema)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes a schema binding definition to the existing schema binding definitions in the configuration for the specified Group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-delete-schema\">Complete Information for admin:group-delete-schema</a></div></div>");
        fDocs.put("admin:group-add-namespace", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-add-namespace(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">namespaces as element(gr:namespace)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Add one or more namespaces to a Group configuration, which will predefine the namespace(s) for all requests evaluated against any App Server in the Group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-add-namespace\">Complete Information for admin:group-add-namespace</a></div></div>");
        fDocs.put("admin:group-delete-namespace", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-delete-namespace(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">namespaces as element(gr:namespace)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes the specified namespaces from the configuration for the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-delete-namespace\">Complete Information for admin:group-delete-namespace</a></div></div>");
        fDocs.put("admin:group-trace-event", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-trace-event(</div><div style=\"padding-left:2em;\">event-id as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs an event element for the specified event name. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-trace-event\">Complete Information for admin:group-trace-event</a></div></div>");
        fDocs.put("admin:group-add-trace-event", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-add-trace-event(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">events as element(gr:event)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds trace events to the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-add-trace-event\">Complete Information for admin:group-add-trace-event</a></div></div>");
        fDocs.put("admin:group-delete-trace-event", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-delete-trace-event(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">events as element(gr:event)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes the specified trace events from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-delete-trace-event\">Complete Information for admin:group-delete-trace-event</a></div></div>");
        fDocs.put("admin:group-delete", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-delete(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-ids as xs:unsignedLong*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes one or more groups in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-delete\">Complete Information for admin:group-delete</a></div></div>");
        fDocs.put("admin:group-create", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-create(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function creates a new group with the specified name in the configuration. The new group has the default values. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-create\">Complete Information for admin:group-create</a></div></div>");
        fDocs.put("admin:group-copy", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-copy(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">group-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function creates a new group specification with the same settings as the group with the specified ID. The new group configuration will have the specified name. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-copy\">Complete Information for admin:group-copy</a></div></div>");
        fDocs.put("admin:group-get-audit-enabled", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-audit-enabled(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the audit enabled setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-audit-enabled\">Complete Information for admin:group-get-audit-enabled</a></div></div>");
        fDocs.put("admin:group-set-audit-enabled", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-audit-enabled(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the audit enabled setting for the group in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-audit-enabled\">Complete Information for admin:group-set-audit-enabled</a></div></div>");
        fDocs.put("admin:group-get-rotate-audit-files", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-rotate-audit-files(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the rotate audit files setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-rotate-audit-files\">Complete Information for admin:group-get-rotate-audit-files</a></div></div>");
        fDocs.put("admin:group-get-keep-audit-files", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-keep-audit-files(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the value for the keep audit files setting from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-keep-audit-files\">Complete Information for admin:group-get-keep-audit-files</a></div></div>");
        fDocs.put("admin:group-set-rotate-audit-files", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-rotate-audit-files(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the rotate audit files setting for the group in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-rotate-audit-files\">Complete Information for admin:group-set-rotate-audit-files</a></div></div>");
        fDocs.put("admin:group-set-keep-audit-files", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-keep-audit-files(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedInt</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the keep audit files setting for the group in the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-keep-audit-files\">Complete Information for admin:group-set-keep-audit-files</a></div></div>");
        fDocs.put("admin:group-enable-audit-event-type", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-enable-audit-event-type(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">event-type as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the audit event type(s) enabled setting for the audit configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-enable-audit-event-type\">Complete Information for admin:group-enable-audit-event-type</a></div></div>");
        fDocs.put("admin:group-disable-audit-event-type", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-disable-audit-event-type(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">event-type as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function changes the audit event type(s) enabled setting for the audit configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-disable-audit-event-type\">Complete Information for admin:group-disable-audit-event-type</a></div></div>");
        fDocs.put("admin:group-get-audit-event-type-enabled", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-audit-event-type-enabled(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">event-type as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the audit event type's enabled setting for the audit configuration. A value of <code xmlns=\"http://www.w3.org/1999/xhtml\">true</code> is returned is the specified event type is set. Otherwise <code xmlns=\"http://www.w3.org/1999/xhtml\">false</code> is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-audit-event-type-enabled\">Complete Information for admin:group-get-audit-event-type-enabled</a></div></div>");
        fDocs.put("admin:group-set-audit-user-restriction", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-audit-user-restriction(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">restriction-type as xs:string,</div><div style=\"padding-left:2em;\">users as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function restricts the audit configuration by excluding or including by user. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-audit-user-restriction\">Complete Information for admin:group-set-audit-user-restriction</a></div></div>");
        fDocs.put("admin:group-get-audit-excluded-users", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-audit-excluded-users(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the users excluded from auditing. If auditing has a \"inclusion\" restriction, this function returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-audit-excluded-users\">Complete Information for admin:group-get-audit-excluded-users</a></div></div>");
        fDocs.put("admin:group-get-audit-included-users", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-audit-included-users(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the users included from auditing. If auditing has a \"exclusion\" restriction, this function returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-audit-included-users\">Complete Information for admin:group-get-audit-included-users</a></div></div>");
        fDocs.put("admin:group-set-audit-role-restriction", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-audit-role-restriction(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">restriction-type as xs:string,</div><div style=\"padding-left:2em;\">roles as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function restricts the audit configuration by excluding or including by role. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-audit-role-restriction\">Complete Information for admin:group-set-audit-role-restriction</a></div></div>");
        fDocs.put("admin:group-get-audit-excluded-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-audit-excluded-roles(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the roles excluded from auditing. If auditing has a \"inclusion\" restriction, this function returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-audit-excluded-roles\">Complete Information for admin:group-get-audit-excluded-roles</a></div></div>");
        fDocs.put("admin:group-get-audit-included-roles", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-audit-included-roles(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the roles included from auditing. If auditing has a \"exclusion\" restriction, this function returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-audit-included-roles\">Complete Information for admin:group-get-audit-included-roles</a></div></div>");
        fDocs.put("admin:group-set-audit-uri-restriction", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-audit-uri-restriction(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">restriction-type as xs:string,</div><div style=\"padding-left:2em;\">uris as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function restricts the audit configuration by excluding or including by document uri(s). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-audit-uri-restriction\">Complete Information for admin:group-set-audit-uri-restriction</a></div></div>");
        fDocs.put("admin:group-get-audit-excluded-uris", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-audit-excluded-uris(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the uris excluded from auditing. If auditing has a \"inclusion\" restriction, this function returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-audit-excluded-uris\">Complete Information for admin:group-get-audit-excluded-uris</a></div></div>");
        fDocs.put("admin:group-get-audit-included-uris", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-audit-included-uris(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the uris included from auditing. If auditing has a \"exclusion\" restriction, this function returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-audit-included-uris\">Complete Information for admin:group-get-audit-included-uris</a></div></div>");
        fDocs.put("admin:group-set-audit-outcome-restriction", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-audit-outcome-restriction(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">outcome as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function restricts the audit configuration by auditing events only if they are \"success\" or \"failure\" events. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-audit-outcome-restriction\">Complete Information for admin:group-set-audit-outcome-restriction</a></div></div>");
        fDocs.put("admin:group-get-audit-outcome-restriction", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-audit-outcome-restriction(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns whether auditing events are restricted by a success or failure outcome. Returns \"success\",\"failure\", or \"both\" </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-audit-outcome-restriction\">Complete Information for admin:group-get-audit-outcome-restriction</a></div></div>");
        fDocs.put("admin:mimetypes-add", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:mimetypes-add(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">mimetypes as element(mt:mimetype)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function adds mimetypes to the configuration. This function always requires a server restart to take effect. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:mimetypes-add\">Complete Information for admin:mimetypes-add</a></div></div>");
        fDocs.put("admin:mimetypes-delete", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:mimetypes-delete(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">mimetypes as element(mt:mimetype)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function deletes mimetypes from the configuration. This function always requires a server restart to take effect. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:mimetypes-delete\">Complete Information for admin:mimetypes-delete</a></div></div>");
        fDocs.put("admin:mimetypes-get", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:mimetypes-get(</div><div style=\"padding-left:2em;\">config as element(configuration)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns all the mimetypes from the configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:mimetypes-get\">Complete Information for admin:mimetypes-get</a></div></div>");
        fDocs.put("admin:mimetype", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:mimetype(</div><div style=\"padding-left:2em;\">name as xs:string,</div><div style=\"padding-left:2em;\">extensions as xs:string,</div><div style=\"padding-left:2em;\">format as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function constructs a mimetype specification. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:mimetype\">Complete Information for admin:mimetype</a></div></div>");
        fDocs.put("admin:database-daily-backup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-daily-backup(</div><div style=\"padding-left:2em;\">backup-dir as xs:string,</div><div style=\"padding-left:2em;\">backup-period as xs:positiveInteger,</div><div style=\"padding-left:2em;\">start-time as xs:time,</div><div style=\"padding-left:2em;\">max-backups as xs:unsignedLong,</div><div style=\"padding-left:2em;\">backup-security-db as xs:boolean,</div><div style=\"padding-left:2em;\">backup-schemas-db as xs:boolean,</div><div style=\"padding-left:2em;\">backup-triggers-db as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function constructs a daily scheduled database backup.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-daily-backup\">Complete Information for admin:database-daily-backup</a></div></div>");
        fDocs.put("admin:database-hourly-backup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-hourly-backup(</div><div style=\"padding-left:2em;\">backup-dir as xs:string,</div><div style=\"padding-left:2em;\">backup-period as xs:positiveInteger,</div><div style=\"padding-left:2em;\">start-minute as xs:nonNegativeInteger,</div><div style=\"padding-left:2em;\">max-backups as xs:unsignedLong,</div><div style=\"padding-left:2em;\">backup-security-db as xs:boolean,</div><div style=\"padding-left:2em;\">backup-schemas-db as xs:boolean,</div><div style=\"padding-left:2em;\">backup-triggers-db as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function constructs a hourly scheduled database backup.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-hourly-backup\">Complete Information for admin:database-hourly-backup</a></div></div>");
        fDocs.put("admin:database-minutely-backup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-minutely-backup(</div><div style=\"padding-left:2em;\">backup-dir as xs:string,</div><div style=\"padding-left:2em;\">backup-period as xs:positiveInteger,</div><div style=\"padding-left:2em;\">max-backups as xs:unsignedLong,</div><div style=\"padding-left:2em;\">backup-security-db as xs:boolean,</div><div style=\"padding-left:2em;\">backup-schemas-db as xs:boolean,</div><div style=\"padding-left:2em;\">backup-triggers-db as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function constructs a scheduled database backup on a number-of-minutes basis. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-minutely-backup\">Complete Information for admin:database-minutely-backup</a></div></div>");
        fDocs.put("admin:forest-hourly-backup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-hourly-backup(</div><div style=\"padding-left:2em;\">backup-dir as xs:string,</div><div style=\"padding-left:2em;\">backup-period as xs:positiveInteger,</div><div style=\"padding-left:2em;\">start-minute as xs:nonNegativeInteger</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function constructs a hourly scheduled forest backup.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-hourly-backup\">Complete Information for admin:forest-hourly-backup</a></div></div>");
        fDocs.put("admin:forest-minutely-backup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-minutely-backup(</div><div style=\"padding-left:2em;\">backup-dir as xs:string,</div><div style=\"padding-left:2em;\">backup-period as xs:positiveInteger</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function constructs a scheduled forest backup on a number-of-minutes basis. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-minutely-backup\">Complete Information for admin:forest-minutely-backup</a></div></div>");
        fDocs.put("admin:group-get-scheduled-tasks", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-scheduled-tasks(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns all of the tasks scheduled for the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-scheduled-tasks\">Complete Information for admin:group-get-scheduled-tasks</a></div></div>");
        fDocs.put("admin:group-add-scheduled-task", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-add-scheduled-task(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">scheduled-tasks as element(gr:scheduled-task)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function adds one or more scheduled tasks to the specified group.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-add-scheduled-task\">Complete Information for admin:group-add-scheduled-task</a></div></div>");
        fDocs.put("admin:group-delete-scheduled-task", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-delete-scheduled-task(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">scheduled-tasks as element(gr:scheduled-task)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function deletes one or more scheduled tasks from the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-delete-scheduled-task\">Complete Information for admin:group-delete-scheduled-task</a></div></div>");
        fDocs.put("admin:group-one-time-scheduled-task", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-one-time-scheduled-task(</div><div style=\"padding-left:2em;\">task-path as xs:string,</div><div style=\"padding-left:2em;\">task-root as xs:string,</div><div style=\"padding-left:2em;\">task-start as xs:dateTime,</div><div style=\"padding-left:2em;\">task-database as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-modules as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-user as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-host as xs:unsignedLong?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function constructs a task to be invoked once, at a specific calendar day and time. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-one-time-scheduled-task\">Complete Information for admin:group-one-time-scheduled-task</a></div></div>");
        fDocs.put("admin:group-monthly-scheduled-task", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-monthly-scheduled-task(</div><div style=\"padding-left:2em;\">task-path as xs:string,</div><div style=\"padding-left:2em;\">task-root as xs:string,</div><div style=\"padding-left:2em;\">task-period as xs:positiveInteger,</div><div style=\"padding-left:2em;\">task-month-day as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-start-time as xs:time,</div><div style=\"padding-left:2em;\">task-database as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-modules as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-user as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-host as xs:unsignedLong?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function constructs a task to be invoked at monthly intervals. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-monthly-scheduled-task\">Complete Information for admin:group-monthly-scheduled-task</a></div></div>");
        fDocs.put("admin:group-weekly-scheduled-task", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-weekly-scheduled-task(</div><div style=\"padding-left:2em;\">task-path as xs:string,</div><div style=\"padding-left:2em;\">task-root as xs:string,</div><div style=\"padding-left:2em;\">task-period as xs:positiveInteger,</div><div style=\"padding-left:2em;\">task-days as xs:string+,</div><div style=\"padding-left:2em;\">task-start-time as xs:time,</div><div style=\"padding-left:2em;\">task-database as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-modules as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-user as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-host as xs:unsignedLong?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function constructs a task to be invoked at weekly intervals.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-weekly-scheduled-task\">Complete Information for admin:group-weekly-scheduled-task</a></div></div>");
        fDocs.put("admin:group-daily-scheduled-task", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-daily-scheduled-task(</div><div style=\"padding-left:2em;\">task-path as xs:string,</div><div style=\"padding-left:2em;\">task-root as xs:string,</div><div style=\"padding-left:2em;\">task-period as xs:positiveInteger,</div><div style=\"padding-left:2em;\">task-start-time as xs:time,</div><div style=\"padding-left:2em;\">task-database as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-modules as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-user as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-host as xs:unsignedLong?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function constructs a task to be invoked at daily intervals.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-daily-scheduled-task\">Complete Information for admin:group-daily-scheduled-task</a></div></div>");
        fDocs.put("admin:group-hourly-scheduled-task", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-hourly-scheduled-task(</div><div style=\"padding-left:2em;\">task-path as xs:string,</div><div style=\"padding-left:2em;\">task-root as xs:string,</div><div style=\"padding-left:2em;\">task-period as xs:positiveInteger,</div><div style=\"padding-left:2em;\">task-minute as xs:nonNegativeInteger,</div><div style=\"padding-left:2em;\">task-database as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-modules as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-user as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-host as xs:unsignedLong?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function constructs a task to be invoked at hourly intervals.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-hourly-scheduled-task\">Complete Information for admin:group-hourly-scheduled-task</a></div></div>");
        fDocs.put("admin:group-minutely-scheduled-task", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-minutely-scheduled-task(</div><div style=\"padding-left:2em;\">task-path as xs:string,</div><div style=\"padding-left:2em;\">task-root as xs:string,</div><div style=\"padding-left:2em;\">task-period as xs:positiveInteger,</div><div style=\"padding-left:2em;\">task-database as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-modules as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-user as xs:unsignedLong,</div><div style=\"padding-left:2em;\">task-host as xs:unsignedLong?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function constructs a task to be invoked at intervals defined in terms of minutes. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-minutely-scheduled-task\">Complete Information for admin:group-minutely-scheduled-task</a></div></div>");
        fDocs.put("admin:appserver-get-ssl-certificate-template", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-ssl-certificate-template(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the id of the SSL certificate template used by the specified App Server. If no template is set for the App Server, 0 is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-ssl-certificate-template\">Complete Information for admin:appserver-get-ssl-certificate-template</a></div></div>");
        fDocs.put("admin:appserver-get-ssl-ciphers", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-ssl-ciphers(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the SSL ciphers set for the App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-ssl-ciphers\">Complete Information for admin:appserver-get-ssl-ciphers</a></div></div>");
        fDocs.put("admin:appserver-get-ssl-hostname", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-ssl-hostname(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function returns the SSL hostname for the specified App Server. If no hostname is set, nothing is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-ssl-hostname\">Complete Information for admin:appserver-get-ssl-hostname</a></div></div>");
        fDocs.put("admin:appserver-set-ssl-certificate-template", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-ssl-certificate-template(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets an SSL certificate template for the specified App Server.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-ssl-certificate-template\">Complete Information for admin:appserver-set-ssl-certificate-template</a></div></div>");
        fDocs.put("admin:appserver-set-ssl-ciphers", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-ssl-ciphers(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets SSL ciphers for the specified App Server. This is the standard cipher specification string for OpenSSL. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-ssl-ciphers\">Complete Information for admin:appserver-set-ssl-ciphers</a></div></div>");
        fDocs.put("admin:appserver-set-ssl-hostname", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-ssl-hostname(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> This function sets an SSL hostname for the specified App Server. <p xmlns=\"http://www.w3.org/1999/xhtml\"> The SSL hostname should only be set when a proxy or load balancer is used to represent multiple servers. In this case, you can specify an SSL hostname with this function and all instances of the application server will identify themselves as that host.</p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-ssl-hostname\">Complete Information for admin:appserver-set-ssl-hostname</a></div></div>");
        fDocs.put("admin:appserver-get-ssl-allow-sslv3", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-ssl-allow-sslv3(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns true if the SSL v3 protocol is enabled for the specified App Server, or false if SSL v3 is disabled. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-ssl-allow-sslv3\">Complete Information for admin:appserver-get-ssl-allow-sslv3</a></div></div>");
        fDocs.put("admin:appserver-get-ssl-allow-tls", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-ssl-allow-tls(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns true if the TLS protocol is enabled for the specified App Server, or false if TLS is disabled.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-ssl-allow-tls\">Complete Information for admin:appserver-get-ssl-allow-tls</a></div></div>");
        fDocs.put("admin:appserver-get-ssl-client-certificate-authorities", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-get-ssl-client-certificate-authorities(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the id(s) of the client certificate authority for the specified App Server. If no client certificate authority is set, this function returns an empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-get-ssl-client-certificate-authorities\">Complete Information for admin:appserver-get-ssl-client-certificate-authorities</a></div></div>");
        fDocs.put("admin:appserver-set-ssl-allow-sslv3", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-ssl-allow-sslv3(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function enables or disables the SSL v3 protocol for the specified App Server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-ssl-allow-sslv3\">Complete Information for admin:appserver-set-ssl-allow-sslv3</a></div></div>");
        fDocs.put("admin:appserver-set-ssl-allow-tls", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-ssl-allow-tls(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function enables or disables the TLS protocol for the specified App Server.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-ssl-allow-tls\">Complete Information for admin:appserver-set-ssl-allow-tls</a></div></div>");
        fDocs.put("admin:appserver-set-ssl-client-certificate-authorities", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:appserver-set-ssl-client-certificate-authorities(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">appserver-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:unsignedLong*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function sets one or more client certificate authorities that sign client certificates for the specified App Server. This function is typically used along with the <code xmlns=\"http://www.w3.org/1999/xhtml\">pki:insert-trusted-certificates</code> and <code xmlns=\"http://www.w3.org/1999/xhtml\">pki:get-trusted-certificate-ids</code> functions to import trusted Certificate Authorities for client certificates. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:appserver-set-ssl-client-certificate-authorities\">Complete Information for admin:appserver-set-ssl-client-certificate-authorities</a></div></div>");
        fDocs.put("admin:forest-daily-backup", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:forest-daily-backup(</div><div style=\"padding-left:2em;\">backup-dir as xs:string,</div><div style=\"padding-left:2em;\">backup-period as xs:positiveInteger,</div><div style=\"padding-left:2em;\">start-time as xs:time</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function constructs a daily scheduled forest backup. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:forest-daily-backup\">Complete Information for admin:forest-daily-backup</a></div></div>");
        fDocs.put("admin:database-set-tf-normalization", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-set-tf-normalization(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function specifies whether to use the default term-frequency normalization (<code xmlns=\"http://www.w3.org/1999/xhtml\">scaled-log</code>), which scales the term frequency based on the size of the document, or to use the <code xmlns=\"http://www.w3.org/1999/xhtml\">unscaled-log</code>, which uses term frequency as a function of the actual term frequency in a document, regardless of the document size. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-set-tf-normalization\">Complete Information for admin:database-set-tf-normalization</a></div></div>");
        fDocs.put("admin:database-get-tf-normalization", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:database-get-tf-normalization(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">database-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the current term-frequency normalization setting for the database. The returned value is either (<code xmlns=\"http://www.w3.org/1999/xhtml\">scaled-log</code>), which means to scale the term frequency based on the size of the document, or <code xmlns=\"http://www.w3.org/1999/xhtml\">unscaled-log</code>, which means to use term frequency as a function of the actual term frequency in a document, regardless of the document size. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:database-get-tf-normalization\">Complete Information for admin:database-get-tf-normalization</a></div></div>");
        fDocs.put("admin:group-get-xdqp-ssl-enabled", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-xdqp-ssl-enabled(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns <code xmlns=\"http://www.w3.org/1999/xhtml\">true</code> if SSL is enabled for the group. Otherwise, <code xmlns=\"http://www.w3.org/1999/xhtml\">false</code> is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-xdqp-ssl-enabled\">Complete Information for admin:group-get-xdqp-ssl-enabled</a></div></div>");
        fDocs.put("admin:group-get-xdqp-ssl-allow-sslv3", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-xdqp-ssl-allow-sslv3(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns <code xmlns=\"http://www.w3.org/1999/xhtml\">true</code> if the SSL v3 protocol is enabled for the group. Otherwise, <code xmlns=\"http://www.w3.org/1999/xhtml\">false</code> is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-xdqp-ssl-allow-sslv3\">Complete Information for admin:group-get-xdqp-ssl-allow-sslv3</a></div></div>");
        fDocs.put("admin:group-get-xdqp-ssl-allow-tls", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-xdqp-ssl-allow-tls(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns <code xmlns=\"http://www.w3.org/1999/xhtml\">true</code> if the TLS protocol is enabled for the group. Otherwise, <code xmlns=\"http://www.w3.org/1999/xhtml\">false</code> is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-xdqp-ssl-allow-tls\">Complete Information for admin:group-get-xdqp-ssl-allow-tls</a></div></div>");
        fDocs.put("admin:group-get-xdqp-ssl-ciphers", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-get-xdqp-ssl-ciphers(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the SSL ciphers set for the group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-get-xdqp-ssl-ciphers\">Complete Information for admin:group-get-xdqp-ssl-ciphers</a></div></div>");
        fDocs.put("admin:group-set-xdqp-ssl-enabled", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-xdqp-ssl-enabled(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function enables or disables SSL for the group.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-xdqp-ssl-enabled\">Complete Information for admin:group-set-xdqp-ssl-enabled</a></div></div>");
        fDocs.put("admin:group-set-xdqp-ssl-allow-sslv3", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-xdqp-ssl-allow-sslv3(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function enables or disables the SSL v3 protocol for the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-xdqp-ssl-allow-sslv3\">Complete Information for admin:group-set-xdqp-ssl-allow-sslv3</a></div></div>");
        fDocs.put("admin:group-set-xdqp-ssl-allow-tls", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-xdqp-ssl-allow-tls(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function enables or disables the TLS protocol for the specified group. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-xdqp-ssl-allow-tls\">Complete Information for admin:group-set-xdqp-ssl-allow-tls</a></div></div>");
        fDocs.put("admin:group-set-xdqp-ssl-ciphers", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">admin:group-set-xdqp-ssl-ciphers(</div><div style=\"padding-left:2em;\">config as element(configuration),</div><div style=\"padding-left:2em;\">group-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">value as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function sets SSL ciphers for the specified group. This is the standard cipher specification string for OpenSSL. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:admin:group-set-xdqp-ssl-ciphers\">Complete Information for admin:group-set-xdqp-ssl-ciphers</a></div></div>");
        fDocs.put("fn:position", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:position(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the context position from the dynamic context. (See <a href=\"http://www.w3.org/TR/xpath20/#id-xp-evaluation-context-components\" xmlns=\"http://www.w3.org/1999/xhtml\">Section C.2 Dynamic Context Components[XP]</a>.) If the context item is undefined, an error is raised [err:FONC0001]. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:position\">Complete Information for fn:position</a></div></div>");
        fDocs.put("fn:last", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:last(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the context size from the dynamic context. (See <a href=\"http://www.w3.org/TR/xpath20/#id-xp-evaluation-context-components\" xmlns=\"http://www.w3.org/1999/xhtml\">Section C.2 Dynamic Context Components[XP]</a>.) If the context item is undefined, an error is raised [err:FONC0001]. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:last\">Complete Information for fn:last</a></div></div>");
        fDocs.put("fn:current-dateTime", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:current-dateTime(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the current dateTime value (with timezone) from the dynamic context. (See <a href=\"http://www.w3.org/TR/xpath20/#id-xp-evaluation-context-components\" xmlns=\"http://www.w3.org/1999/xhtml\">Section C.2 Dynamic Context Components[XP]</a>.) This is an <code xmlns=\"http://www.w3.org/1999/xhtml\">xs:dateTime</code> that is current at some time during the evaluation of a query or transformation in which <code xmlns=\"http://www.w3.org/1999/xhtml\">fn:current-dateTime()</code> is executed. This function is *stable*. The precise instant during the query or transformation represented by the value of <code xmlns=\"http://www.w3.org/1999/xhtml\">fn:current-dateTime()</code> is *implementation dependent*. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:current-dateTime\">Complete Information for fn:current-dateTime</a></div></div>");
        fDocs.put("fn:current-date", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:current-date(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns <code xmlns=\"http://www.w3.org/1999/xhtml\">xs:date(fn:current-dateTime())</code>. This is an <code xmlns=\"http://www.w3.org/1999/xhtml\">xs:date</code> (with timezone) that is current at some time during the evaluation of a query or transformation in which <code xmlns=\"http://www.w3.org/1999/xhtml\">fn:current-date()</code> is executed. This function is *stable*. The precise instant during the query or transformation represented by the value of <code xmlns=\"http://www.w3.org/1999/xhtml\">fn:current-date()</code> is *implementation dependent*. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:current-date\">Complete Information for fn:current-date</a></div></div>");
        fDocs.put("fn:current-time", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:current-time(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns <code xmlns=\"http://www.w3.org/1999/xhtml\">xs:time(fn:current-dateTime())</code>. This is an <code xmlns=\"http://www.w3.org/1999/xhtml\">xs:time</code> (with timezone) that is current at some time during the evaluation of a query or transformation in which <code xmlns=\"http://www.w3.org/1999/xhtml\">fn:current-time()</code> is executed. This function is *stable*. The precise instant during the query or transformation represented by the value of <code xmlns=\"http://www.w3.org/1999/xhtml\">fn:current-time()</code> is *implementation dependent*. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:current-time\">Complete Information for fn:current-time</a></div></div>");
        fDocs.put("fn:implicit-timezone", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:implicit-timezone(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the value of the implicit timezone property from the dynamic context. Components of the dynamic context are discussed in <a href=\"http://www.w3.org/TR/xpath20/#id-xp-evaluation-context-components\" xmlns=\"http://www.w3.org/1999/xhtml\">Section C.2 Dynamic Context Components[XP]</a>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:implicit-timezone\">Complete Information for fn:implicit-timezone</a></div></div>");
        fDocs.put("fn:default-collation", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:default-collation(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns the value of the default collation property from the static context. Components of the static context are discussed in <a href=\"http://www.w3.org/TR/xpath20/#id-xp-evaluation-context-components\">Section C.1 Static Context Components[XP]</a>. </p> <p xmlns=\"http://www.w3.org/1999/xhtml\">The default collation property can never be undefined. If it is not explicitly defined, a system defined default codepoint is used. In the <code>1.0</code> XQuery dialect, if this is not provided, the Unicode code point collation (<code>http://www.w3.org/2005/xpath-functions/collation/codepoint</code>) is used. In the <code>1.0-ml</code> and <code>0.9-ml</code> XQuery dialects, the Mark Logic-defined codepoint URI is used (<code>http://marklogic.com/collation/codepoint</code>). </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:default-collation\">Complete Information for fn:default-collation</a></div></div>");
        fDocs.put("fn:static-base-uri", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:static-base-uri(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the value of the base-uri property from the static context. If the base-uri property is undefined, the empty sequence is returned. Components of the static context are discussed in <a href=\"http://www.w3.org/TR/xpath20/#id-xp-evaluation-context-components\" xmlns=\"http://www.w3.org/1999/xhtml\">Section C.1 Static Context Components[XP]</a>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:static-base-uri\">Complete Information for fn:static-base-uri</a></div></div>");
        fDocs.put("css:get", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">css:get(</div><div style=\"padding-left:2em;\">doc as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Fetch the CSS for the given document, be it embedded or linked. Limitation: doesn't account for @import directives in the CSS; assumes the linked CSS is in the database. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:css:get\">Complete Information for css:get</a></div></div>");
        fDocs.put("css:convert", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">css:convert(</div><div style=\"padding-left:2em;\">css as xs:string,</div><div style=\"padding-left:2em;\">options as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Convert CSS text to an equivalent XML representation that is more suitable for analysis. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:css:convert\">Complete Information for css:convert</a></div></div>");
        fDocs.put("fn:resolve-uri", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:resolve-uri(</div><div style=\"padding-left:2em;\">relative as xs:string?,</div><div style=\"padding-left:2em;\">[base as xs:string]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Resolves a relative URI against an absolute URI. If $base is specified, the URI is resolved relative to that base. If $base is not specified, the base is set to the base-uri property from the static context, if the property exists; if it does not exist, an error is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:resolve-uri\">Complete Information for fn:resolve-uri</a></div></div>");
        fDocs.put("fn:trace", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:trace(</div><div style=\"padding-left:2em;\">value as item()*,</div><div style=\"padding-left:2em;\">label as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Return the input $value unchanged and, if $label is the name of an enabled server event, emit that server event to the server log file (<code xmlns=\"http://www.w3.org/1999/xhtml\">ErrorLog.txt</code>) with $value as its data. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:trace\">Complete Information for fn:trace</a></div></div>");
        fDocs.put("xdmp:md5", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:md5(</div><div style=\"padding-left:2em;\">encoded as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Calculates the md5 hash of the given argument. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:md5\">Complete Information for xdmp:md5</a></div></div>");
        fDocs.put("fn:true", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:true(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the <code xmlns=\"http://www.w3.org/1999/xhtml\">xs:boolean</code> value <code xmlns=\"http://www.w3.org/1999/xhtml\">true</code>. Equivalent to <code xmlns=\"http://www.w3.org/1999/xhtml\">xs:boolean(\"1\")</code>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:true\">Complete Information for fn:true</a></div></div>");
        fDocs.put("fn:false", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:false(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the <code xmlns=\"http://www.w3.org/1999/xhtml\">xs:boolean</code> value <code xmlns=\"http://www.w3.org/1999/xhtml\">false</code>. Equivalent to <code xmlns=\"http://www.w3.org/1999/xhtml\">xs:boolean(\"0\")</code>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:false\">Complete Information for fn:false</a></div></div>");
        fDocs.put("fn:not", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:not(</div><div style=\"padding-left:2em;\">arg as item()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns <code xmlns=\"http://www.w3.org/1999/xhtml\">true</code> if the effective boolean value is <code xmlns=\"http://www.w3.org/1999/xhtml\">false</code>, and <code xmlns=\"http://www.w3.org/1999/xhtml\">false</code> if the effective boolean value is <code xmlns=\"http://www.w3.org/1999/xhtml\">true</code>. The <code xmlns=\"http://www.w3.org/1999/xhtml\">$arg</code> parameter is first reduced to an effective boolean value by applying the <code xmlns=\"http://www.w3.org/1999/xhtml\">fn:boolean</code> function. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:not\">Complete Information for fn:not</a></div></div>");
        fDocs.put("cts:and-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:and-query(</div><div style=\"padding-left:2em;\">queries as cts:query*,</div><div style=\"padding-left:2em;\">[options as xs:string*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query specifying the intersection of the matches specified by the sub-queries. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:and-query\">Complete Information for cts:and-query</a></div></div>");
        fDocs.put("cts:and-query-queries", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:and-query-queries(</div><div style=\"padding-left:2em;\">query as cts:and-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of the queries that were used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:and-query-queries\">Complete Information for cts:and-query-queries</a></div></div>");
        fDocs.put("cts:and-query-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:and-query-options(</div><div style=\"padding-left:2em;\">query as cts:and-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the options for the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:and-query-options\">Complete Information for cts:and-query-options</a></div></div>");
        fDocs.put("cts:or-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:or-query(</div><div style=\"padding-left:2em;\">queries as cts:query*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query specifying the union of the matches specified by the sub-queries. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:or-query\">Complete Information for cts:or-query</a></div></div>");
        fDocs.put("cts:or-query-queries", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:or-query-queries(</div><div style=\"padding-left:2em;\">query as cts:or-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of the queries that were used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:or-query-queries\">Complete Information for cts:or-query-queries</a></div></div>");
        fDocs.put("cts:and-not-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:and-not-query(</div><div style=\"padding-left:2em;\">positive-query as cts:query,</div><div style=\"padding-left:2em;\">negative-query as cts:query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query specifying the set difference of the matches specified by two sub-queries. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:and-not-query\">Complete Information for cts:and-not-query</a></div></div>");
        fDocs.put("cts:and-not-query-positive-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:and-not-query-positive-query(</div><div style=\"padding-left:2em;\">query as cts:and-not-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the positive (first parameter) query used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:and-not-query-positive-query\">Complete Information for cts:and-not-query-positive-query</a></div></div>");
        fDocs.put("cts:and-not-query-negative-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:and-not-query-negative-query(</div><div style=\"padding-left:2em;\">query as cts:and-not-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the negative (second parameter) query used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:and-not-query-negative-query\">Complete Information for cts:and-not-query-negative-query</a></div></div>");
        fDocs.put("cts:not-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:not-query(</div><div style=\"padding-left:2em;\">query as cts:query,</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query specifying the matches not specified by its sub-query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:not-query\">Complete Information for cts:not-query</a></div></div>");
        fDocs.put("cts:not-query-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:not-query-query(</div><div style=\"padding-left:2em;\">query as cts:not-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the query used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:not-query-query\">Complete Information for cts:not-query-query</a></div></div>");
        fDocs.put("cts:not-query-weight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:not-query-weight(</div><div style=\"padding-left:2em;\">query as cts:element-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the weight with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:not-query-weight\">Complete Information for cts:not-query-weight</a></div></div>");
        fDocs.put("cts:word-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:word-query(</div><div style=\"padding-left:2em;\">text as xs:string*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query matching text content containing a given phrase. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:word-query\">Complete Information for cts:word-query</a></div></div>");
        fDocs.put("cts:word-query-text", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:word-query-text(</div><div style=\"padding-left:2em;\">query as cts:word-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the text used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:word-query-text\">Complete Information for cts:word-query-text</a></div></div>");
        fDocs.put("cts:word-query-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:word-query-options(</div><div style=\"padding-left:2em;\">query as cts:word-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the options for the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:word-query-options\">Complete Information for cts:word-query-options</a></div></div>");
        fDocs.put("cts:word-query-weight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:word-query-weight(</div><div style=\"padding-left:2em;\">query as cts:word-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the weight with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:word-query-weight\">Complete Information for cts:word-query-weight</a></div></div>");
        fDocs.put("cts:element-range-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-range-query(</div><div style=\"padding-left:2em;\">element-name as xs:QName*,</div><div style=\"padding-left:2em;\">operator as xs:string,</div><div style=\"padding-left:2em;\">value as xs:anyAtomicType*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:query</code> matching elements by name with a range-index entry equal a given value. Searches with the <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:element-range-query</code> constructor require an element range index on the specified QName(s); if there is no range index configured, then an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-range-query\">Complete Information for cts:element-range-query</a></div></div>");
        fDocs.put("cts:element-range-query-element-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-range-query-element-name(</div><div style=\"padding-left:2em;\">query as cts:element-range-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-range-query-element-name\">Complete Information for cts:element-range-query-element-name</a></div></div>");
        fDocs.put("cts:element-range-query-operator", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-range-query-operator(</div><div style=\"padding-left:2em;\">query as cts:element-range-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the operator used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-range-query-operator\">Complete Information for cts:element-range-query-operator</a></div></div>");
        fDocs.put("cts:element-range-query-value", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-range-query-value(</div><div style=\"padding-left:2em;\">query as cts:element-range-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the value used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-range-query-value\">Complete Information for cts:element-range-query-value</a></div></div>");
        fDocs.put("cts:element-range-query-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-range-query-options(</div><div style=\"padding-left:2em;\">query as cts:element-range-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the options for the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-range-query-options\">Complete Information for cts:element-range-query-options</a></div></div>");
        fDocs.put("cts:element-range-query-weight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-range-query-weight(</div><div style=\"padding-left:2em;\">query as cts:element-range-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the weight with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-range-query-weight\">Complete Information for cts:element-range-query-weight</a></div></div>");
        fDocs.put("cts:element-value-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-value-query(</div><div style=\"padding-left:2em;\">element-name as xs:QName*,</div><div style=\"padding-left:2em;\">text as xs:string*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query matching elements by name with text content equal a given phrase. <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:element-value-query</code> only matches against simple elements (that is, elements that contain only text and have no element children). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-value-query\">Complete Information for cts:element-value-query</a></div></div>");
        fDocs.put("cts:element-value-query-element-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-value-query-element-name(</div><div style=\"padding-left:2em;\">query as cts:element-value-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-value-query-element-name\">Complete Information for cts:element-value-query-element-name</a></div></div>");
        fDocs.put("cts:element-value-query-text", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-value-query-text(</div><div style=\"padding-left:2em;\">query as cts:element-value-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the text used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-value-query-text\">Complete Information for cts:element-value-query-text</a></div></div>");
        fDocs.put("cts:element-value-query-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-value-query-options(</div><div style=\"padding-left:2em;\">query as cts:element-value-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the options for the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-value-query-options\">Complete Information for cts:element-value-query-options</a></div></div>");
        fDocs.put("cts:element-value-query-weight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-value-query-weight(</div><div style=\"padding-left:2em;\">query as cts:element-value-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the weight with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-value-query-weight\">Complete Information for cts:element-value-query-weight</a></div></div>");
        fDocs.put("cts:element-word-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-word-query(</div><div style=\"padding-left:2em;\">element-name as xs:QName*,</div><div style=\"padding-left:2em;\">text as xs:string*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query matching elements by name with text content containing a given phrase. Searches only through immediate text node children of the specified element as well as any text node children of child elements defined in the Admin Interface as element-word-query-throughs or phrase-throughs; does not search through any other children of the specified element. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-word-query\">Complete Information for cts:element-word-query</a></div></div>");
        fDocs.put("cts:element-word-query-text", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-word-query-text(</div><div style=\"padding-left:2em;\">query as cts:element-word-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the text used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-word-query-text\">Complete Information for cts:element-word-query-text</a></div></div>");
        fDocs.put("cts:element-word-query-element-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-word-query-element-name(</div><div style=\"padding-left:2em;\">query as cts:element-word-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-word-query-element-name\">Complete Information for cts:element-word-query-element-name</a></div></div>");
        fDocs.put("cts:element-word-query-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-word-query-options(</div><div style=\"padding-left:2em;\">query as cts:element-word-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the options for the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-word-query-options\">Complete Information for cts:element-word-query-options</a></div></div>");
        fDocs.put("cts:element-word-query-weight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-word-query-weight(</div><div style=\"padding-left:2em;\">query as cts:element-word-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the weight with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-word-query-weight\">Complete Information for cts:element-word-query-weight</a></div></div>");
        fDocs.put("cts:field-word-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:field-word-query(</div><div style=\"padding-left:2em;\">field-name as xs:string*,</div><div style=\"padding-left:2em;\">text as xs:string*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query matching text content containing a given phrase in the specified field. If the specified field does not exist, <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:field-word-query</code> throws an exception. A field is a named object that specified elements to include and exclude from a search, and can include score weights for any included elements. You create fields at the database level using the Admin Interface. For details on fields, see the chapter on \"Fields Database Settings\" in the <em xmlns=\"http://www.w3.org/1999/xhtml\">Administrator's Guide</em>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:field-word-query\">Complete Information for cts:field-word-query</a></div></div>");
        fDocs.put("cts:field-word-query-text", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:field-word-query-text(</div><div style=\"padding-left:2em;\">query as cts:field-word-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the text used to construct the specified <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:field-word-query</code>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:field-word-query-text\">Complete Information for cts:field-word-query-text</a></div></div>");
        fDocs.put("cts:field-word-query-field-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:field-word-query-field-name(</div><div style=\"padding-left:2em;\">query as cts:field-word-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the names used to construct the specified <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:field-word-query</code>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:field-word-query-field-name\">Complete Information for cts:field-word-query-field-name</a></div></div>");
        fDocs.put("cts:field-word-query-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:field-word-query-options(</div><div style=\"padding-left:2em;\">query as cts:field-word-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the options for the specified <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:field-word-query</code>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:field-word-query-options\">Complete Information for cts:field-word-query-options</a></div></div>");
        fDocs.put("cts:field-word-query-weight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:field-word-query-weight(</div><div style=\"padding-left:2em;\">query as cts:field-word-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the weight with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:field-word-query-weight\">Complete Information for cts:field-word-query-weight</a></div></div>");
        fDocs.put("cts:element-attribute-range-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-range-query(</div><div style=\"padding-left:2em;\">element-name as xs:QName*,</div><div style=\"padding-left:2em;\">attribute-name as xs:QName*,</div><div style=\"padding-left:2em;\">operator as xs:string,</div><div style=\"padding-left:2em;\">value as xs:anyAtomicType*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:query</code> matching elements by name with a range-index entry equal a given value. Searches with the <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:element-attribute-range-query</code> constructor require an attribute range index on the specified QName(s); if there is no range index configured, then an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-range-query\">Complete Information for cts:element-attribute-range-query</a></div></div>");
        fDocs.put("cts:element-attribute-range-query-element-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-range-query-element-name(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-range-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-range-query-element-name\">Complete Information for cts:element-attribute-range-query-element-name</a></div></div>");
        fDocs.put("cts:element-attribute-range-query-attribute-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-range-query-attribute-name(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-range-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-range-query-attribute-name\">Complete Information for cts:element-attribute-range-query-attribute-name</a></div></div>");
        fDocs.put("cts:element-attribute-range-query-operator", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-range-query-operator(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-range-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the operator used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-range-query-operator\">Complete Information for cts:element-attribute-range-query-operator</a></div></div>");
        fDocs.put("cts:element-attribute-range-query-value", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-range-query-value(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-range-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the value used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-range-query-value\">Complete Information for cts:element-attribute-range-query-value</a></div></div>");
        fDocs.put("cts:element-attribute-range-query-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-range-query-options(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-range-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the options for the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-range-query-options\">Complete Information for cts:element-attribute-range-query-options</a></div></div>");
        fDocs.put("cts:element-attribute-range-query-weight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-range-query-weight(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-range-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the weight with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-range-query-weight\">Complete Information for cts:element-attribute-range-query-weight</a></div></div>");
        fDocs.put("cts:element-attribute-value-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-value-query(</div><div style=\"padding-left:2em;\">element-name as xs:QName*,</div><div style=\"padding-left:2em;\">attribute-name as xs:QName*,</div><div style=\"padding-left:2em;\">text as xs:string*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query matching elements by name with attributes by name with text content equal a given phrase. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-value-query\">Complete Information for cts:element-attribute-value-query</a></div></div>");
        fDocs.put("cts:element-attribute-value-query-text", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-value-query-text(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-value-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the text used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-value-query-text\">Complete Information for cts:element-attribute-value-query-text</a></div></div>");
        fDocs.put("cts:element-attribute-value-query-element-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-value-query-element-name(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-value-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the element QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-value-query-element-name\">Complete Information for cts:element-attribute-value-query-element-name</a></div></div>");
        fDocs.put("cts:element-attribute-value-query-attribute-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-value-query-attribute-name(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-value-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the attribute QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-value-query-attribute-name\">Complete Information for cts:element-attribute-value-query-attribute-name</a></div></div>");
        fDocs.put("cts:element-attribute-value-query-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-value-query-options(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-value-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the options for the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-value-query-options\">Complete Information for cts:element-attribute-value-query-options</a></div></div>");
        fDocs.put("cts:element-attribute-value-query-weight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-value-query-weight(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-value-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the weight with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-value-query-weight\">Complete Information for cts:element-attribute-value-query-weight</a></div></div>");
        fDocs.put("cts:element-attribute-word-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-word-query(</div><div style=\"padding-left:2em;\">element-name as xs:QName*,</div><div style=\"padding-left:2em;\">attribute-name as xs:QName*,</div><div style=\"padding-left:2em;\">text as xs:string*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query matching elements by name with attributes by name with text content containing a given phrase. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-word-query\">Complete Information for cts:element-attribute-word-query</a></div></div>");
        fDocs.put("cts:element-attribute-word-query-text", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-word-query-text(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-word-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the text used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-word-query-text\">Complete Information for cts:element-attribute-word-query-text</a></div></div>");
        fDocs.put("cts:element-attribute-word-query-element-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-word-query-element-name(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-word-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the element QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-word-query-element-name\">Complete Information for cts:element-attribute-word-query-element-name</a></div></div>");
        fDocs.put("cts:element-attribute-word-query-attribute-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-word-query-attribute-name(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-word-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the attribute QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-word-query-attribute-name\">Complete Information for cts:element-attribute-word-query-attribute-name</a></div></div>");
        fDocs.put("cts:element-attribute-word-query-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-word-query-options(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-word-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the options for the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-word-query-options\">Complete Information for cts:element-attribute-word-query-options</a></div></div>");
        fDocs.put("cts:element-attribute-word-query-weight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-word-query-weight(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-word-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the weight with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-word-query-weight\">Complete Information for cts:element-attribute-word-query-weight</a></div></div>");
        fDocs.put("cts:similar-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:similar-query(</div><div style=\"padding-left:2em;\">nodes as node()*,</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query matching nodes similar to the model nodes. It uses an algorithm which finds the 16 most \"relevant\" terms in the model nodes (that is, the 16 terms with the highest scores), and then creates a query equivalent to a <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:or-query</code> of those 16 terms. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:similar-query\">Complete Information for cts:similar-query</a></div></div>");
        fDocs.put("cts:similar-query-nodes", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:similar-query-nodes(</div><div style=\"padding-left:2em;\">query as cts:similar-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the nodes used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:similar-query-nodes\">Complete Information for cts:similar-query-nodes</a></div></div>");
        fDocs.put("cts:similar-query-weight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:similar-query-weight(</div><div style=\"padding-left:2em;\">query as cts:similar-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the weight with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:similar-query-weight\">Complete Information for cts:similar-query-weight</a></div></div>");
        fDocs.put("cts:contains", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:contains(</div><div style=\"padding-left:2em;\">nodes as node()*,</div><div style=\"padding-left:2em;\">query as cts:query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns true if any of a sequence of nodes matches a query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:contains\">Complete Information for cts:contains</a></div></div>");
        fDocs.put("cts:search", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:search(</div><div style=\"padding-left:2em;\">expression as node()*,</div><div style=\"padding-left:2em;\">query as cts:query?,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a relevance-ordered sequence of nodes specified by a given query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:search\">Complete Information for cts:search</a></div></div>");
        fDocs.put("cts:quality", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:quality(</div><div style=\"padding-left:2em;\">[node as node()]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the quality of a node, or of the context node if no node is provided. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:quality\">Complete Information for cts:quality</a></div></div>");
        fDocs.put("cts:score", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:score(</div><div style=\"padding-left:2em;\">[node as node()]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the score of a node, or of the context node if no node is provided. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:score\">Complete Information for cts:score</a></div></div>");
        fDocs.put("cts:confidence", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:confidence(</div><div style=\"padding-left:2em;\">[node as node()]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the confidence of a node, or of the context node if no node is provided. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:confidence\">Complete Information for cts:confidence</a></div></div>");
        fDocs.put("cts:fitness", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:fitness(</div><div style=\"padding-left:2em;\">[node as node()]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the fitness of a node, or of the context node if no node is provided. Fitness is a normalized measure of relevance that is based on how well a node matches the query issued, not taking into account the number of documents in which the query term(s) occur. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:fitness\">Complete Information for cts:fitness</a></div></div>");
        fDocs.put("cts:remainder", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:remainder(</div><div style=\"padding-left:2em;\">[node as node()]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns an estimated search result size for a node, or of the context node if no node is provided. The search result size for a node is the number of fragments remaining (including the current node) in the result sequence containing the node. This is useful to quickly estimate the size of a search result sequence, without using <code xmlns=\"http://www.w3.org/1999/xhtml\">fn:count()</code> or <code xmlns=\"http://www.w3.org/1999/xhtml\">xdmp:estimate()</code>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:remainder\">Complete Information for cts:remainder</a></div></div>");
        fDocs.put("cts:tokenize", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:tokenize(</div><div style=\"padding-left:2em;\">text as xs:string,</div><div style=\"padding-left:2em;\">[language as xs:string?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Tokenizes text into words, punctuation, and spaces. Returns output in the type <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:token</code>, which has subtypes <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:word</code>, <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:punctuation</code>, and <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:space</code>, all of which are subtypes of <code xmlns=\"http://www.w3.org/1999/xhtml\">xs:string</code>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:tokenize\">Complete Information for cts:tokenize</a></div></div>");
        fDocs.put("cts:stem", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:stem(</div><div style=\"padding-left:2em;\">text as xs:string,</div><div style=\"padding-left:2em;\">[language as xs:string?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the stem(s) for a word. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:stem\">Complete Information for cts:stem</a></div></div>");
        fDocs.put("cts:walk", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:walk(</div><div style=\"padding-left:2em;\">node as node(),</div><div style=\"padding-left:2em;\">query as cts:query,</div><div style=\"padding-left:2em;\">expr as item()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Walks a node, evaluating an expression with any text matching a query. It returns a sequence of all the values returned by the expression evaluations. This is similar to <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:highlight</code> in how it evaluates its expression, but it is different in what it returns. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:walk\">Complete Information for cts:walk</a></div></div>");
        fDocs.put("cts:highlight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:highlight(</div><div style=\"padding-left:2em;\">node as node(),</div><div style=\"padding-left:2em;\">query as cts:query,</div><div style=\"padding-left:2em;\">expr as item()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a copy of the node, replacing any text matching the query with the specified expression. You can use this function to easily highlight any text found in a query. Unlike <code xmlns=\"http://www.w3.org/1999/xhtml\">fn:replace</code> and other XQuery string functions that match literal text, <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:highlight</code> matches every term that matches the search, including stemmed matches or matches with different capitalization. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:highlight\">Complete Information for cts:highlight</a></div></div>");
        fDocs.put("cts:entity-highlight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:entity-highlight(</div><div style=\"padding-left:2em;\">node as node(),</div><div style=\"padding-left:2em;\">expr as item()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a copy of the node, replacing any entities found with the specified expression. You can use this function to easily highlight any entities in an XML document in an arbitrary manner. If you do not need fine-grained control of the XML markup returned, you can use the <code xmlns=\"http://www.w3.org/1999/xhtml\">entity:enrich</code> XQuery module function instead. A valid entity enrichment license key is required to use <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:entity-highlight</code>; without a valid license key, it throws an exception. If you have a valid license for entity enrichment, you can entity enrich text in English and in any other languages for which you have a valid license key. For languages in which you do not have a valid license key, <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:entity-highlight</code> finds no entities for text in that language. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:entity-highlight\">Complete Information for cts:entity-highlight</a></div></div>");
        fDocs.put("cts:near-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:near-query(</div><div style=\"padding-left:2em;\">queries as cts:query*,</div><div style=\"padding-left:2em;\">[distance as xs:double?,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[distance-weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query matching all of the specified queries, where the matches occur within the specified distance from each other. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:near-query\">Complete Information for cts:near-query</a></div></div>");
        fDocs.put("cts:near-query-queries", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:near-query-queries(</div><div style=\"padding-left:2em;\">query as cts:near-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the query sequence used to construct the near query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:near-query-queries\">Complete Information for cts:near-query-queries</a></div></div>");
        fDocs.put("cts:near-query-distance", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:near-query-distance(</div><div style=\"padding-left:2em;\">query as cts:near-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the distance used to construct the near query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:near-query-distance\">Complete Information for cts:near-query-distance</a></div></div>");
        fDocs.put("cts:near-query-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:near-query-options(</div><div style=\"padding-left:2em;\">query as cts:near-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the options for the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:near-query-options\">Complete Information for cts:near-query-options</a></div></div>");
        fDocs.put("cts:near-query-weight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:near-query-weight(</div><div style=\"padding-left:2em;\">query as cts:near-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the weight with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:near-query-weight\">Complete Information for cts:near-query-weight</a></div></div>");
        fDocs.put("cts:element-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-query(</div><div style=\"padding-left:2em;\">element-name as xs:QName*,</div><div style=\"padding-left:2em;\">query as cts:query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:query</code> matching elements by name with the content constrained by the given <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:query</code> in the second parameter. Searches for matches in the specified element and all of its children. If the specified query in the second parameter has any <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:element-attribute-*-query</code> constructors, it will search attributes directly on the specified element and attributes on any child elements (see the <a href=\"#eq2\" xmlns=\"http://www.w3.org/1999/xhtml\">second example</a> below). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-query\">Complete Information for cts:element-query</a></div></div>");
        fDocs.put("cts:element-query-element-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-query-element-name(</div><div style=\"padding-left:2em;\">query as cts:element-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-query-element-name\">Complete Information for cts:element-query-element-name</a></div></div>");
        fDocs.put("cts:element-query-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-query-query(</div><div style=\"padding-left:2em;\">query as cts:element-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the query used to construct the element query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-query-query\">Complete Information for cts:element-query-query</a></div></div>");
        fDocs.put("cts:document-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:document-query(</div><div style=\"padding-left:2em;\">uris as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query matching documents with the given URIs. It will match both documents and properties documents with the given URIs. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:document-query\">Complete Information for cts:document-query</a></div></div>");
        fDocs.put("cts:document-query-uris", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:document-query-uris(</div><div style=\"padding-left:2em;\">query as cts:document-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the URIs used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:document-query-uris\">Complete Information for cts:document-query-uris</a></div></div>");
        fDocs.put("cts:collection-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:collection-query(</div><div style=\"padding-left:2em;\">uris as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query matching documents in the collections with the given URIs. It will match both documents and properties documents in the collections with the given URIs. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:collection-query\">Complete Information for cts:collection-query</a></div></div>");
        fDocs.put("cts:collection-query-uris", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:collection-query-uris(</div><div style=\"padding-left:2em;\">query as cts:collection-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the URIs used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:collection-query-uris\">Complete Information for cts:collection-query-uris</a></div></div>");
        fDocs.put("cts:directory-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:directory-query(</div><div style=\"padding-left:2em;\">uris as xs:string*,</div><div style=\"padding-left:2em;\">[depth as xs:string?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query matching documents in the directories with the given URIs. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:directory-query\">Complete Information for cts:directory-query</a></div></div>");
        fDocs.put("cts:directory-query-uris", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:directory-query-uris(</div><div style=\"padding-left:2em;\">query as cts:directory-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the URIs used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:directory-query-uris\">Complete Information for cts:directory-query-uris</a></div></div>");
        fDocs.put("cts:directory-query-depth", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:directory-query-depth(</div><div style=\"padding-left:2em;\">query as cts:directory-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the depth used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:directory-query-depth\">Complete Information for cts:directory-query-depth</a></div></div>");
        fDocs.put("cts:register", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:register(</div><div style=\"padding-left:2em;\">query as cts:query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Register a query for later use. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:register\">Complete Information for cts:register</a></div></div>");
        fDocs.put("cts:deregister", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:deregister(</div><div style=\"padding-left:2em;\">id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Deregister a registered query, explicitly releasing the associated resources. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:deregister\">Complete Information for cts:deregister</a></div></div>");
        fDocs.put("cts:registered-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:registered-query(</div><div style=\"padding-left:2em;\">ids as xs:unsignedLong*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query matching fragments specified by previously registered queries (see <a href=\"#cts:register\" xmlns=\"http://www.w3.org/1999/xhtml\"><code>cts:register</code></a>). If a registered query with the specified ID(s) is not found, then a <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:search</code> operation with an invalid <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:registered-query</code> throws an XDMP-UNREGISTERED exception. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:registered-query\">Complete Information for cts:registered-query</a></div></div>");
        fDocs.put("cts:registered-query-ids", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:registered-query-ids(</div><div style=\"padding-left:2em;\">query as cts:registered-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the registered query identifiers used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:registered-query-ids\">Complete Information for cts:registered-query-ids</a></div></div>");
        fDocs.put("cts:registered-query-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:registered-query-options(</div><div style=\"padding-left:2em;\">query as cts:registered-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the options for the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:registered-query-options\">Complete Information for cts:registered-query-options</a></div></div>");
        fDocs.put("cts:registered-query-weight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:registered-query-weight(</div><div style=\"padding-left:2em;\">query as cts:registered-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the weight with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:registered-query-weight\">Complete Information for cts:registered-query-weight</a></div></div>");
        fDocs.put("cts:words", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:words(</div><div style=\"padding-left:2em;\">[start as xs:string?,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns words from the word lexicon. This function requires the word lexicon to be enabled. If the word lexicon is not enabled, an exception is thrown. The words are returned in collation order. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:words\">Complete Information for cts:words</a></div></div>");
        fDocs.put("cts:word-match", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:word-match(</div><div style=\"padding-left:2em;\">pattern as xs:string,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns words from the word lexicon that match the wildcard pattern. This function requires the word lexicon to be enabled. If the word lexicon is not enabled, an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:word-match\">Complete Information for cts:word-match</a></div></div>");
        fDocs.put("cts:element-words", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-words(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">[start as xs:string?,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns words from the specified element word lexicon. This function requires an element word lexicon for each of the element specified in the function. If there is not an element word lexicon configured for any of the specified elements, an exception is thrown. The words are returned in collation order. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-words\">Complete Information for cts:element-words</a></div></div>");
        fDocs.put("cts:element-word-match", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-word-match(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">pattern as xs:string,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns words from the specified element word lexicon(s) that match a wildcard pattern. This function requires an element word lexicon configured for each of the specified elements in the function. If there is not an element word lexicon configured for any of the specified elements, an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-word-match\">Complete Information for cts:element-word-match</a></div></div>");
        fDocs.put("cts:element-values", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-values(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">[start as xs:anyAtomicType?,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns values from the specified element value lexicon(s). Value lexicons are implemented using range indexes; consequently this function requires an element range index for each element specified in the function. If there is not a range index configured for each of the specified elements, an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-values\">Complete Information for cts:element-values</a></div></div>");
        fDocs.put("cts:element-value-match", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-value-match(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">pattern as xs:anyAtomicType,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns values from the specified element value lexicon(s) that match the specified wildcard pattern. Element value lexicons are implemented using range indexes; consequently this function requires an element range index for each element specified in the function. If there is not a range index configured for each of the specified elements, then an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-value-match\">Complete Information for cts:element-value-match</a></div></div>");
        fDocs.put("cts:element-value-co-occurrences", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-value-co-occurrences(</div><div style=\"padding-left:2em;\">element-name-1 as xs:QName,</div><div style=\"padding-left:2em;\">element-name-2 as xs:QName,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns value co-occurrences (that is, pairs of values, both of which appear in the same fragment) from the specified element value lexicon(s). The values are returned as an XML element with two children, each child containing one of the co-occurring values. You can use <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:frequency</code> on each item returned to find how many times the pair occurs. Value lexicons are implemented using range indexes; consequently this function requires an element range index for each element specified in the function, and the range index must have range value positions set to true. If there is not a range index configured for each of the specified elements, and if the range value positions is not enabled for the any of the range indexes, an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-value-co-occurrences\">Complete Information for cts:element-value-co-occurrences</a></div></div>");
        fDocs.put("cts:element-attribute-value-co-occurrences", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-value-co-occurrences(</div><div style=\"padding-left:2em;\">element-name-1 as xs:QName,</div><div style=\"padding-left:2em;\">attribute-name-1 as xs:QName?,</div><div style=\"padding-left:2em;\">element-name-2 as xs:QName,</div><div style=\"padding-left:2em;\">attribute-name-2 as xs:QName?,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns value co-occurrences from the specified element or element-attribute value lexicon(s). Value lexicons are implemented using range indexes; consequently this function requires a range index for each element/attribute pairs specified in the function. If there is not a range index configured for each of the specified element or element/attribute pairs, then an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-value-co-occurrences\">Complete Information for cts:element-attribute-value-co-occurrences</a></div></div>");
        fDocs.put("cts:element-value-ranges", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-value-ranges(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">[bounds as xs:anyAtomicType*,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns value ranges from the specified element value lexicon(s). Value lexicons are implemented using range indexes; consequently this function requires an element range index for each element specified in the function. If there is not a range index configured for each of the specified elements, an exception is thrown.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\">The values are divided into buckets. The $bounds parameter specifies the number of buckets and the size of each bucket. All included values are bucketed, even those less than the lowest bound or greater than the highest bound. An empty sequence for $bounds specifies one bucket, a single value specifies two buckets, two values specify three buckets, and so on.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\">If you have string values and you pass a $bounds parameter as in the following call:</p> <pre xml:space=\"preserve\" xmlns=\"http://www.w3.org/1999/xhtml\">cts:element-value-ranges(xs:QName(\"myElement\"), (\"f\", \"m\"))</pre> <p xmlns=\"http://www.w3.org/1999/xhtml\">The first bucket contains string values that are less than the string <code>f</code>, the second bucket contains string values greater than or equal to <code>f</code> but less than <code>m</code>, and the third bucket contains string values that are greater than or equal to <code>m</code>.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\">For each non-empty bucket, a <code>cts:range</code> element is returned. Each <code>cts:range</code> element has a <code>cts:minimum</code> child and a <code>cts:maximum</code> child. If a bucket is bounded, its <code>cts:range</code> element will also have a <code>cts:lower-bound</code> child if it is bounded from below, and a <code>cts:upper-bound</code> element if it is bounded from above. Empty buckets return nothing unless the \"empties\" option is specified.</p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-value-ranges\">Complete Information for cts:element-value-ranges</a></div></div>");
        fDocs.put("cts:frequency", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:frequency(</div><div style=\"padding-left:2em;\">value as item()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns an integer representing the number of times in which a particular value occurs in a value lexicon lookup (for example, <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:element-values</code>). When using the <code xmlns=\"http://www.w3.org/1999/xhtml\">fragment-frequency</code> lexicon option, <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:frequency</code> returns the number of fragments in which the lexicon value occurs. When using the <code xmlns=\"http://www.w3.org/1999/xhtml\">item-frequency</code> lexicon option, <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:frequency</code> returns the total number of times in which the lexicon value occurs in each item. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:frequency\">Complete Information for cts:frequency</a></div></div>");
        fDocs.put("cts:uris", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:uris(</div><div style=\"padding-left:2em;\">[start as xs:string?,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns values from the URI lexicon. This function requires the uri-lexicon database configuration parameter to be enabled. If the uri-lexicon database-configuration parameter is not enabled, an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:uris\">Complete Information for cts:uris</a></div></div>");
        fDocs.put("cts:uri-match", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:uri-match(</div><div style=\"padding-left:2em;\">pattern as xs:string,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns values from the URI lexicon that match the specified wildcard pattern. This function requires the uri-lexicon database configuration parameter to be enabled. If the uri-lexicon database-configuration parameter is not enabled, an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:uri-match\">Complete Information for cts:uri-match</a></div></div>");
        fDocs.put("cts:collections", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:collections(</div><div style=\"padding-left:2em;\">[start as xs:string?,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns values from the collection lexicon. This function requires the collection-lexicon database configuration parameter to be enabled. If the collection-lexicon database-configuration parameter is not enabled, an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:collections\">Complete Information for cts:collections</a></div></div>");
        fDocs.put("cts:collection-match", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:collection-match(</div><div style=\"padding-left:2em;\">pattern as xs:string,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns values from the collection lexicon that match the specified wildcard pattern. This function requires the collection-lexicon database configuration parameter to be enabled. If the uri-lexicon database-configuration parameter is not enabled, an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:collection-match\">Complete Information for cts:collection-match</a></div></div>");
        fDocs.put("cts:element-attribute-words", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-words(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">attribute-names as xs:QName*,</div><div style=\"padding-left:2em;\">[start as xs:string?,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns words from the specified element-attribute word lexicon(s). This function requires an element-attribute word lexicon for each of the element/attribute pairs specified in the function. If there is not an element/attribute word lexicon configured for any of the specified element/attribute pairs, then an exception is thrown. The words are returned in collation order. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-words\">Complete Information for cts:element-attribute-words</a></div></div>");
        fDocs.put("cts:element-attribute-word-match", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-word-match(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">attribute-names as xs:QName*,</div><div style=\"padding-left:2em;\">pattern as xs:string,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns words from the specified element-attribute word lexicon(s) that match a wildcard pattern. This function requires an element-attribute word lexicon for each of the element/attribute pairs specified in the function. If there is not an element-attribute word lexicon configured for any of the specified element/attribute pairs, then an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-word-match\">Complete Information for cts:element-attribute-word-match</a></div></div>");
        fDocs.put("cts:element-attribute-values", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-values(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">attribute-names as xs:QName*,</div><div style=\"padding-left:2em;\">[start as xs:anyAtomicType?,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns values from the specified element-attribute value lexicon(s). Element-attribute value lexicons are implemented using indexes; consequently this function requires an attribute range index of for each of the element/attribute pairs specified in the function. If there is not a range index configured for each of the specified element/attribute pairs, then an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-values\">Complete Information for cts:element-attribute-values</a></div></div>");
        fDocs.put("cts:element-attribute-value-match", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-value-match(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">attribute-names as xs:QName*,</div><div style=\"padding-left:2em;\">pattern as xs:anyAtomicType,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns values from the specified element-attribute value lexicon(s) that match the specified pattern. Element-attribute value lexicons are implemented using range indexes; consequently this function requires an attribute range index for each of the element/attribute pairs specified in the function. If there is not a range index configured for each of the specified element/attribute pairs, then an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-value-match\">Complete Information for cts:element-attribute-value-match</a></div></div>");
        fDocs.put("cts:element-attribute-value-ranges", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-value-ranges(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">attribute-names as xs:QName*,</div><div style=\"padding-left:2em;\">[bounds as xs:anyAtomicType*,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns value ranges from the specified element-attribute value lexicon(s). Element-attribute value lexicons are implemented using indexes; consequently this function requires an attribute range index of for each of the element/attribute pairs specified in the function. If there is not a range index configured for each of the specified element/attribute pairs, then an exception is thrown.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\">The values are divided into buckets. The $bounds parameter specifies the number of buckets and the size of each bucket. All included values are bucketed, even those less than the lowest bound or greater than the highest bound. An empty sequence for $bounds specifies one bucket, a single value specifies two buckets, two values specify three buckets, and so on.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\">If you have string values and you pass a $bounds parameter as in the following call:</p> <pre xml:space=\"preserve\" xmlns=\"http://www.w3.org/1999/xhtml\">cts:element-value-ranges(xs:QName(\"myElement\"), (\"f\", \"m\"))</pre> <p xmlns=\"http://www.w3.org/1999/xhtml\">The first bucket contains string values that are less than the string <code>f</code>, the second bucket contains string values greater than or equal to <code>f</code> but less than <code>m</code>, and the third bucket contains string values that are greater than or equal to <code>m</code>.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\">For each non-empty bucket, a <code>cts:range</code> element is returned. Each <code>cts:range</code> element has a <code>cts:minimum</code> child and a <code>cts:maximum</code> child. If a bucket is bounded, its <code>cts:range</code> element will also have a <code>cts:lower-bound</code> child if it is bounded from below, and a <code>cts:upper-bound</code> element if it is bounded from above. Empty buckets return nothing unless the \"empties\" option is specified.</p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-value-ranges\">Complete Information for cts:element-attribute-value-ranges</a></div></div>");
        fDocs.put("cts:field-words", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:field-words(</div><div style=\"padding-left:2em;\">field-names as xs:string*,</div><div style=\"padding-left:2em;\">[start as xs:string?,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns words from the specified field word lexicon. This function requires an field lexicon for each of the field specified in the function. If there is not an field word lexicon configured for any of the specified fields, an exception is thrown. The words are returned in collation order. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:field-words\">Complete Information for cts:field-words</a></div></div>");
        fDocs.put("cts:field-word-match", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:field-word-match(</div><div style=\"padding-left:2em;\">field-names as xs:string*,</div><div style=\"padding-left:2em;\">pattern as xs:string,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns words from the specified field word lexicon(s) that match a wildcard pattern. This function requires an field word lexicon configured for each of the specified fields in the function. If there is not an field word lexicon configured for any of the specified fields, an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:field-word-match\">Complete Information for cts:field-word-match</a></div></div>");
        fDocs.put("cts:reverse-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:reverse-query(</div><div style=\"padding-left:2em;\">nodes as node()*,</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query matching the model nodes. Use with a <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:search</code> or a <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:contains</code> over serialized <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:query</code> nodes. The serialized <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:query</code> nodes can be either stored in the database or passed in as XML. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:reverse-query\">Complete Information for cts:reverse-query</a></div></div>");
        fDocs.put("cts:reverse-query-nodes", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:reverse-query-nodes(</div><div style=\"padding-left:2em;\">query as cts:reverse-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the nodes used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:reverse-query-nodes\">Complete Information for cts:reverse-query-nodes</a></div></div>");
        fDocs.put("cts:reverse-query-weight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:reverse-query-weight(</div><div style=\"padding-left:2em;\">query as cts:reverse-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the weight with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:reverse-query-weight\">Complete Information for cts:reverse-query-weight</a></div></div>");
        fDocs.put("cts:properties-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:properties-query(</div><div style=\"padding-left:2em;\">query as cts:query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a query that matches all documents where <code xmlns=\"http://www.w3.org/1999/xhtml\">$query</code> matches the document properties. When searching against documents, <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:properties-query</code> provides a convenient way to constrain the search against a document's corresponding properties documents. This constraint is a join between the document at a given URI and the properties document at that same URI. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:properties-query\">Complete Information for cts:properties-query</a></div></div>");
        fDocs.put("cts:properties-query-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:properties-query-query(</div><div style=\"padding-left:2em;\">query as cts:properties-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the query used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:properties-query-query\">Complete Information for cts:properties-query-query</a></div></div>");
        fDocs.put("cts:query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:query(</div><div style=\"padding-left:2em;\">[query as element()]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Creates a query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:query\">Complete Information for cts:query</a></div></div>");
        fDocs.put("ppt:clean", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">ppt:clean(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">doc as node()?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Clean up any conversion artifacts or other infelicities, putting each slide into its own div element. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:ppt:clean\">Complete Information for ppt:clean</a></div></div>");
        fDocs.put("alert:make-config", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:make-config(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">name as xs:string,</div><div style=\"padding-left:2em;\">description as xs:string,</div><div style=\"padding-left:2em;\">options as element(alert:options)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">Create an alerting configuration associated with a particular URI. The URI will be used to create a protected collection when the config is inserted into the database with <code xmlns=\"http://www.w3.org/1999/xhtml\">alert:config-insert</code>. This URI will also be used as a directory for all documents (config, actions, and rules) associated with the config. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:make-config\">Complete Information for alert:make-config</a></div></div>");
        fDocs.put("alert:config-insert", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-insert(</div><div style=\"padding-left:2em;\">config as element(alert:config)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">Inserts a config into the database. If this is the first time the config has been inserted, a protected collection will be created for the config's URI. A user must have the alert-admin privilege to call this function.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-insert\">Complete Information for alert:config-insert</a></div></div>");
        fDocs.put("alert:config-get", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-get(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">Gets the config associated with the specified URI. The user must have the alert-user privilege to call this function.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-get\">Complete Information for alert:config-get</a></div></div>");
        fDocs.put("alert:config-delete", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-delete(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">Remove an alerting configuration identified by the specified URI. If the config does not exist, an exception will be thrown. Any triggers associated with the alerting configuration will be automatically removed. Any actions and/or rules associated by the config will also be removed as well as the protected collection. The caller must have the alert-admin privilege to call this function. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-delete\">Complete Information for alert:config-delete</a></div></div>");
        fDocs.put("alert:config-get-id", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-get-id(</div><div style=\"padding-left:2em;\">config as element(alert:config)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function provides convenient access to the specified sub-element within an alerting config. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-get-id\">Complete Information for alert:config-get-id</a></div></div>");
        fDocs.put("alert:config-set-uri", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-set-uri(</div><div style=\"padding-left:2em;\">config as element(alert:config),</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function provides convenient access to the specified sub-element within an alerting config.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-set-uri\">Complete Information for alert:config-set-uri</a></div></div>");
        fDocs.put("alert:config-get-uri", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-get-uri(</div><div style=\"padding-left:2em;\">config as element(alert:config)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function provides convenient access to the specified sub-element within an alerting config.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-get-uri\">Complete Information for alert:config-get-uri</a></div></div>");
        fDocs.put("alert:config-set-uri", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-set-uri(</div><div style=\"padding-left:2em;\">config as element(alert:config),</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function provides convenient access to the specified sub-element within an alerting config.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-set-uri\">Complete Information for alert:config-set-uri</a></div></div>");
        fDocs.put("alert:config-get-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-get-name(</div><div style=\"padding-left:2em;\">config as element(alert:config)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function provides convenient access to the specified sub-element within an alerting config.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-get-name\">Complete Information for alert:config-get-name</a></div></div>");
        fDocs.put("alert:config-set-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-set-name(</div><div style=\"padding-left:2em;\">config as element(alert:config),</div><div style=\"padding-left:2em;\">name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function provides convenient access to the specified sub-element within an alerting config.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-set-name\">Complete Information for alert:config-set-name</a></div></div>");
        fDocs.put("alert:config-get-description", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-get-description(</div><div style=\"padding-left:2em;\">config as element(alert:config)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function provides convenient access to the specified sub-element within an alerting config.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-get-description\">Complete Information for alert:config-get-description</a></div></div>");
        fDocs.put("alert:config-set-description", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-set-description(</div><div style=\"padding-left:2em;\">config as element(alert:config),</div><div style=\"padding-left:2em;\">description as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function provides convenient access to the specified sub-element within an alerting config. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-set-description\">Complete Information for alert:config-set-description</a></div></div>");
        fDocs.put("alert:config-get-trigger-ids", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-get-trigger-ids(</div><div style=\"padding-left:2em;\">config as element(alert:config)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function provides convenient access to the specified sub-element within an alerting config.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-get-trigger-ids\">Complete Information for alert:config-get-trigger-ids</a></div></div>");
        fDocs.put("alert:config-set-trigger-ids", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-set-trigger-ids(</div><div style=\"padding-left:2em;\">config as element(alert:config),</div><div style=\"padding-left:2em;\">ids as xs:unsignedLong*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function provides convenient access to the specified sub-element within an alerting config. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-set-trigger-ids\">Complete Information for alert:config-set-trigger-ids</a></div></div>");
        fDocs.put("alert:config-get-cpf-domain-ids", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-get-cpf-domain-ids(</div><div style=\"padding-left:2em;\">config as element(alert:config)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function provides convenient access to the specified sub-element within an alerting config. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-get-cpf-domain-ids\">Complete Information for alert:config-get-cpf-domain-ids</a></div></div>");
        fDocs.put("alert:config-get-cpf-domain-names", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-get-cpf-domain-names(</div><div style=\"padding-left:2em;\">config as element(alert:config)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function provides convenient access to the specified sub-element within an alerting config. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-get-cpf-domain-names\">Complete Information for alert:config-get-cpf-domain-names</a></div></div>");
        fDocs.put("alert:config-set-cpf-domain-names", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-set-cpf-domain-names(</div><div style=\"padding-left:2em;\">config as element(alert:config),</div><div style=\"padding-left:2em;\">names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function provides convenient access to the specified sub-element within an alerting config.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-set-cpf-domain-names\">Complete Information for alert:config-set-cpf-domain-names</a></div></div>");
        fDocs.put("alert:config-set-cpf-domain-ids", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-set-cpf-domain-ids(</div><div style=\"padding-left:2em;\">config as element(alert:config),</div><div style=\"padding-left:2em;\">ids as xs:unsignedLong*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function provides convenient access to the specified sub-element within an alerting config. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-set-cpf-domain-ids\">Complete Information for alert:config-set-cpf-domain-ids</a></div></div>");
        fDocs.put("alert:config-get-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-get-options(</div><div style=\"padding-left:2em;\">config as element(alert:config)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function provides convenient access to the specified sub-element within an alerting config. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-get-options\">Complete Information for alert:config-get-options</a></div></div>");
        fDocs.put("alert:config-set-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:config-set-options(</div><div style=\"padding-left:2em;\">config as element(alert:config),</div><div style=\"padding-left:2em;\">options as element(alert:options)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function provides convenient access to the specified sub-element within an alerting config. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:config-set-options\">Complete Information for alert:config-set-options</a></div></div>");
        fDocs.put("alert:create-triggers", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:create-triggers(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">events as element(trgr:data-event)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">Create triggers that invoke the standard alerting trigger module. The caller must have the <code xmlns=\"http://www.w3.org/1999/xhtml\">alert-admin</code> privilege. The returned trigger IDs must be associated with the config using <code xmlns=\"http://www.w3.org/1999/xhtml\">alert:config-set-trigger-ids</code> and then saving the updated config with <code xmlns=\"http://www.w3.org/1999/xhtml\">alert:config-insert</code>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:create-triggers\">Complete Information for alert:create-triggers</a></div></div>");
        fDocs.put("alert:remove-triggers", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:remove-triggers(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">Remove triggers whose IDs are listed in the config. The caller must have the alert-admin privilege. This function writes the updated configuration to the database, so if you need to delete the configuration as well (using <code xmlns=\"http://www.w3.org/1999/xhtml\">admin:delete-config</code>, for example), you should do so in another transaction. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:remove-triggers\">Complete Information for alert:remove-triggers</a></div></div>");
        fDocs.put("alert:find-matching-rules", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:find-matching-rules(</div><div style=\"padding-left:2em;\">config-uri as xs:string,</div><div style=\"padding-left:2em;\">doc as node()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">Returns a list of all rules associated with the specified config that match the specified document. You must have the <code xmlns=\"http://www.w3.org/1999/xhtml\">alert-admin</code> privilege to call this function. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:find-matching-rules\">Complete Information for alert:find-matching-rules</a></div></div>");
        fDocs.put("alert:invoke-matching-actions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:invoke-matching-actions(</div><div style=\"padding-left:2em;\">config-uri as xs:string,</div><div style=\"padding-left:2em;\">doc as node(),</div><div style=\"padding-left:2em;\">options as node()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">Finds the rules that match the specified document and invokes their associated actions. The actions will be invoked as the user who owns each rule. The caller can use options to control whether the actions run in the same or a different transaction. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:invoke-matching-actions\">Complete Information for alert:invoke-matching-actions</a></div></div>");
        fDocs.put("alert:spawn-matching-actions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:spawn-matching-actions(</div><div style=\"padding-left:2em;\">config-uri as xs:string,</div><div style=\"padding-left:2em;\">doc as node(),</div><div style=\"padding-left:2em;\">options as node()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">Finds the rules that match the specified document and spawns their associated actions. The spawned tasks will run as the user that owns the rule. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:spawn-matching-actions\">Complete Information for alert:spawn-matching-actions</a></div></div>");
        fDocs.put("alert:make-rule", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:make-rule(</div><div style=\"padding-left:2em;\">name as xs:string,</div><div style=\"padding-left:2em;\">description as xs:string,</div><div style=\"padding-left:2em;\">user-id as xs:unsignedLong,</div><div style=\"padding-left:2em;\">query as cts:query,</div><div style=\"padding-left:2em;\">action as xs:string,</div><div style=\"padding-left:2em;\">options as element(alert:options)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function creates the XML representing a rule. If the caller does not have the <code xmlns=\"http://www.w3.org/1999/xhtml\">alert-admin</code> privilege then <code xmlns=\"http://www.w3.org/1999/xhtml\">$user-id</code> must be the ID of the current user from the security database. If <code xmlns=\"http://www.w3.org/1999/xhtml\">$user-id</code> is 0, it will be automatically replaced with the current user's ID.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:make-rule\">Complete Information for alert:make-rule</a></div></div>");
        fDocs.put("alert:rule-insert", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-insert(</div><div style=\"padding-left:2em;\">config-uri as xs:string,</div><div style=\"padding-left:2em;\">rule as element(alert:rule)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function inserts rule into the database associated with the specified alerting configuration. A user must have the alert-user privilege to call this function.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-insert\">Complete Information for alert:rule-insert</a></div></div>");
        fDocs.put("alert:rule-remove", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-remove(</div><div style=\"padding-left:2em;\">config-uri as xs:string,</div><div style=\"padding-left:2em;\">id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function removes the XML representing the rule from the collection. A user must have the <code xmlns=\"http://www.w3.org/1999/xhtml\">alert-user</code> privilege to call this function. An exception is thrown if the rule does not exist. A user must have the <code xmlns=\"http://www.w3.org/1999/xhtml\">alert-admin</code> privilege to delete other users' rules.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-remove\">Complete Information for alert:rule-remove</a></div></div>");
        fDocs.put("alert:get-all-rules", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:get-all-rules(</div><div style=\"padding-left:2em;\">config-uri as xs:string,</div><div style=\"padding-left:2em;\">query as cts:query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns all rules visible to the current user.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:get-all-rules\">Complete Information for alert:get-all-rules</a></div></div>");
        fDocs.put("alert:get-my-rules", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:get-my-rules(</div><div style=\"padding-left:2em;\">config-uri as xs:string,</div><div style=\"padding-left:2em;\">query as cts:query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns all rules associated with the current user. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:get-my-rules\">Complete Information for alert:get-my-rules</a></div></div>");
        fDocs.put("alert:rule-id-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-id-query(</div><div style=\"padding-left:2em;\">ids as xs:unsignedLong*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function creates a query to find rules with any of the specified IDs. Returns a query to be passed to <code xmlns=\"http://www.w3.org/1999/xhtml\">alert:get-my-rules</code> or <code xmlns=\"http://www.w3.org/1999/xhtml\">alert:get-all-rules</code>.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-id-query\">Complete Information for alert:rule-id-query</a></div></div>");
        fDocs.put("alert:rule-name-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-name-query(</div><div style=\"padding-left:2em;\">names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function creates a query to find rules with any of the specified names. Returns a query to be passed to <code xmlns=\"http://www.w3.org/1999/xhtml\">alert:get-my-rules</code> or <code xmlns=\"http://www.w3.org/1999/xhtml\">alert:get-all-rules</code>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-name-query\">Complete Information for alert:rule-name-query</a></div></div>");
        fDocs.put("alert:rule-user-id-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-user-id-query(</div><div style=\"padding-left:2em;\">user-ids as xs:unsignedLong*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function creates a query to find rules with any of the specified user IDs. Returns a query to be passed to <code xmlns=\"http://www.w3.org/1999/xhtml\">alert:get-my-rules</code> or <code xmlns=\"http://www.w3.org/1999/xhtml\">alert:get-all-rules</code>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-user-id-query\">Complete Information for alert:rule-user-id-query</a></div></div>");
        fDocs.put("alert:rule-action-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-action-query(</div><div style=\"padding-left:2em;\">actions as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function creates a query to find rules with any of the specified actions. Returns a query to be passed to <code xmlns=\"http://www.w3.org/1999/xhtml\">alert:get-my-rules</code> or <code xmlns=\"http://www.w3.org/1999/xhtml\">alert:get-all-rules</code>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-action-query\">Complete Information for alert:rule-action-query</a></div></div>");
        fDocs.put("alert:rule-get-id", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-get-id(</div><div style=\"padding-left:2em;\">rule as element(alert:rule)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the ID of a given rule. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-get-id\">Complete Information for alert:rule-get-id</a></div></div>");
        fDocs.put("alert:rule-get-user-id", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-get-user-id(</div><div style=\"padding-left:2em;\">rule as element(alert:rule)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the user ID of a given rule. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-get-user-id\">Complete Information for alert:rule-get-user-id</a></div></div>");
        fDocs.put("alert:rule-set-user-id", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-set-user-id(</div><div style=\"padding-left:2em;\">rule as element(alert:rule),</div><div style=\"padding-left:2em;\">user-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the rule with the user ID updated. If the caller does not have the <code xmlns=\"http://www.w3.org/1999/xhtml\">alert-config</code> privilege, an exception will be thrown if the caller attempts to save a rule for a user other than himself. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-set-user-id\">Complete Information for alert:rule-set-user-id</a></div></div>");
        fDocs.put("alert:rule-get-action", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-get-action(</div><div style=\"padding-left:2em;\">rule as element(alert:rule)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the action of a given rule. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-get-action\">Complete Information for alert:rule-get-action</a></div></div>");
        fDocs.put("alert:rule-set-action", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-set-action(</div><div style=\"padding-left:2em;\">rule as element(alert:rule),</div><div style=\"padding-left:2em;\">action as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the rule with the action updated.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-set-action\">Complete Information for alert:rule-set-action</a></div></div>");
        fDocs.put("alert:rule-get-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-get-name(</div><div style=\"padding-left:2em;\">rule as element(alert:rule)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the name of a given rule.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-get-name\">Complete Information for alert:rule-get-name</a></div></div>");
        fDocs.put("alert:rule-set-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-set-name(</div><div style=\"padding-left:2em;\">rule as element(alert:rule),</div><div style=\"padding-left:2em;\">name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the rule with the name of the rule updated.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-set-name\">Complete Information for alert:rule-set-name</a></div></div>");
        fDocs.put("alert:rule-get-description", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-get-description(</div><div style=\"padding-left:2em;\">rule as element(alert:rule)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the description of a given rule.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-get-description\">Complete Information for alert:rule-get-description</a></div></div>");
        fDocs.put("alert:rule-set-description", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-set-description(</div><div style=\"padding-left:2em;\">rule as element(alert:rule),</div><div style=\"padding-left:2em;\">description as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the rule with the description of the rule updated. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-set-description\">Complete Information for alert:rule-set-description</a></div></div>");
        fDocs.put("alert:rule-get-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-get-query(</div><div style=\"padding-left:2em;\">rule as element(alert:rule)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">Get the <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:query</code> corresponding to the rule's query expression. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-get-query\">Complete Information for alert:rule-get-query</a></div></div>");
        fDocs.put("alert:rule-set-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-set-query(</div><div style=\"padding-left:2em;\">rule as element(alert:rule),</div><div style=\"padding-left:2em;\">query as cts:query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">Set the cts:query corresponding to the rule's query expression.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-set-query\">Complete Information for alert:rule-set-query</a></div></div>");
        fDocs.put("alert:rule-get-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-get-options(</div><div style=\"padding-left:2em;\">rule as element(alert:rule)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the options of a given rule. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-get-options\">Complete Information for alert:rule-get-options</a></div></div>");
        fDocs.put("alert:rule-set-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:rule-set-options(</div><div style=\"padding-left:2em;\">rule as element(alert:rule),</div><div style=\"padding-left:2em;\">options as element(alert:options)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the rule with the options of the rule updated. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:rule-set-options\">Complete Information for alert:rule-set-options</a></div></div>");
        fDocs.put("alert:action-get-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:action-get-name(</div><div style=\"padding-left:2em;\">action as element(alert:action)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the name of a given action. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:action-get-name\">Complete Information for alert:action-get-name</a></div></div>");
        fDocs.put("alert:action-set-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:action-set-name(</div><div style=\"padding-left:2em;\">action as element(alert:action),</div><div style=\"padding-left:2em;\">name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the action with the name of the action updated. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:action-set-name\">Complete Information for alert:action-set-name</a></div></div>");
        fDocs.put("alert:action-get-description", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:action-get-description(</div><div style=\"padding-left:2em;\">action as element(alert:action)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the description of a given action. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:action-get-description\">Complete Information for alert:action-get-description</a></div></div>");
        fDocs.put("alert:action-set-description", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:action-set-description(</div><div style=\"padding-left:2em;\">action as element(alert:action),</div><div style=\"padding-left:2em;\">description as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the action with the description of the action updated. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:action-set-description\">Complete Information for alert:action-set-description</a></div></div>");
        fDocs.put("alert:action-get-module-db", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:action-get-module-db(</div><div style=\"padding-left:2em;\">action as element(alert:action)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the module database of a given action. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:action-get-module-db\">Complete Information for alert:action-get-module-db</a></div></div>");
        fDocs.put("alert:action-set-module-db", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:action-set-module-db(</div><div style=\"padding-left:2em;\">action as element(alert:action),</div><div style=\"padding-left:2em;\">module-db as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function sets the module database of a given action.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:action-set-module-db\">Complete Information for alert:action-set-module-db</a></div></div>");
        fDocs.put("alert:action-get-module-root", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:action-get-module-root(</div><div style=\"padding-left:2em;\">action as element(alert:action)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the module root of a given action.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:action-get-module-root\">Complete Information for alert:action-get-module-root</a></div></div>");
        fDocs.put("alert:action-set-module-root", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:action-set-module-root(</div><div style=\"padding-left:2em;\">action as element(alert:action),</div><div style=\"padding-left:2em;\">module-root as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function sets the module root of a given action.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:action-set-module-root\">Complete Information for alert:action-set-module-root</a></div></div>");
        fDocs.put("alert:action-get-module", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:action-get-module(</div><div style=\"padding-left:2em;\">action as element(alert:action)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the module of a given action. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:action-get-module\">Complete Information for alert:action-get-module</a></div></div>");
        fDocs.put("alert:action-set-module", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:action-set-module(</div><div style=\"padding-left:2em;\">action as element(alert:action),</div><div style=\"padding-left:2em;\">module as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the action with the module of the action updated. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:action-set-module\">Complete Information for alert:action-set-module</a></div></div>");
        fDocs.put("alert:action-get-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:action-get-options(</div><div style=\"padding-left:2em;\">action as element(alert:action)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the options of a given action. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:action-get-options\">Complete Information for alert:action-get-options</a></div></div>");
        fDocs.put("alert:action-set-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:action-set-options(</div><div style=\"padding-left:2em;\">action as element(alert:action),</div><div style=\"padding-left:2em;\">options as element(alert:options)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns the action with the options of the action updated. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:action-set-options\">Complete Information for alert:action-set-options</a></div></div>");
        fDocs.put("alert:make-action", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:make-action(</div><div style=\"padding-left:2em;\">name as xs:string,</div><div style=\"padding-left:2em;\">description as xs:string,</div><div style=\"padding-left:2em;\">module-db as xs:unsignedLong,</div><div style=\"padding-left:2em;\">module-root as xs:string,</div><div style=\"padding-left:2em;\">module as xs:string,</div><div style=\"padding-left:2em;\">options as element(alert:options)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"><p xmlns=\"http://www.w3.org/1999/xhtml\"> This function creates the xml representing an action. When a rule associated with the action matches a document, the action's module will be invoked with the following external variables set: </p><pre xml:space=\"preserve\" xmlns=\"http://www.w3.org/1999/xhtml\"> declare variable $alert:config-uri as xs:string external; declare variable $alert:doc as node() external; declare variable $alert:rule as element(alert:rule) external; declare variable $alert:action as element(alert:action) external;</pre> <p xmlns=\"http://www.w3.org/1999/xhtml\">All actions must accept these external variables.</p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:make-action\">Complete Information for alert:make-action</a></div></div>");
        fDocs.put("alert:make-log-action", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:make-log-action(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"><p xmlns=\"http://www.w3.org/1999/xhtml\">Create a standard logging action named \"log\". Rules that reference this action must provide an <code>&lt;alert:directory/&gt;</code> element that specifies where the log file should be created. The inserted document will have a random long integer ID and its filename will be ID.xml within the specified directory. </p> Rules that reference this action may also provide options with an <code xmlns=\"http://www.w3.org/1999/xhtml\">&lt;alert:permissions&gt;</code> element containing a series of <code xmlns=\"http://www.w3.org/1999/xhtml\">&lt;sec:permission&gt;</code> elements and/or an <code xmlns=\"http://www.w3.org/1999/xhtml\">&lt;alert:collections&gt;</code> element containing <code xmlns=\"http://www.w3.org/1999/xhtml\">&lt;alert:collection&gt;</code> elements that specify the permissions and collections for the log document. This information is simply passed through to <code xmlns=\"http://www.w3.org/1999/xhtml\">xdmp:document-insert</code>. An example of the rule's options is as follows: <pre xml:space=\"preserve\" xmlns=\"http://www.w3.org/1999/xhtml\"> &lt;alert:options&gt; &lt;alert:directory&gt;/some/directory&lt;/alert:directory&gt; &lt;alert:permissions&gt; &lt;sec:permission&gt; &lt;sec:capability&gt;read&lt;/sec:capability&gt; &lt;sec:role-id&gt;129382323&lt;/sec:role-id&gt; &lt;/sec:permission&gt; &lt;/alert:permissions&gt; &lt;alert:collections&gt; &lt;alert:collection&gt;http://acme.com/alert-log&lt;/alert:collection&gt; &lt;/alert:collections&gt; &lt;/alert:options&gt; The log document has the following structure: &lt;alert:log&gt; &lt;alert:log-id&gt;82388423&lt;/alert:log-id&gt; &lt;alert:config-uri&gt;http://acme.com/alert/message-board&lt;/alert:config-uri&gt; &lt;alert:rule-id&gt;12352&lt;/alert:rule-id&gt; &lt;alert:user-id&gt;8271938239&lt;/alert:user-id&gt; &lt;alert:document-uri&gt;/the/URI/of/the/matching/document&lt;/alert:document-uri&gt; &lt;alert:timestamp&gt;2008-05-31T08:20:00-08:00&lt;/alert:timestamp&gt; &lt;/alert:log&gt; The log document insertion will be performed as the user who created the rule, and the user must have permission to create documents in any collections they specify. The log-id is a random number chosen by the action.</pre> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:make-log-action\">Complete Information for alert:make-log-action</a></div></div>");
        fDocs.put("alert:action-insert", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:action-insert(</div><div style=\"padding-left:2em;\">config-uri as xs:string,</div><div style=\"padding-left:2em;\">action as element(alert:action)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function inserts the xml representing the action into the collection. The caller must have the <code xmlns=\"http://www.w3.org/1999/xhtml\">alert-admin</code> privilege to call this function.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:action-insert\">Complete Information for alert:action-insert</a></div></div>");
        fDocs.put("alert:action-remove", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:action-remove(</div><div style=\"padding-left:2em;\">config-uri as xs:string,</div><div style=\"padding-left:2em;\">name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function removes the named action from the database or throws an exception if the action does not exist. The caller must have the <code xmlns=\"http://www.w3.org/1999/xhtml\">alert-admin</code> privilege to call this function. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:action-remove\">Complete Information for alert:action-remove</a></div></div>");
        fDocs.put("alert:get-actions", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">alert:get-actions(</div><div style=\"padding-left:2em;\">config-uri as xs:string,</div><div style=\"padding-left:2em;\">names as xs:string*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function retrieves all the named actions in the specified config URI. Returns a list of actions. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:alert:get-actions\">Complete Information for alert:get-actions</a></div></div>");
        fDocs.put("xinc:link-expand", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xinc:link-expand(</div><div style=\"padding-left:2em;\">context as node(),</div><div style=\"padding-left:2em;\">ref as element(xi:include)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function performs a single level expansion of a single XInclude reference. XInclude references in the referenced node will not be expanded.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xinc:link-expand\">Complete Information for xinc:link-expand</a></div></div>");
        fDocs.put("xinc:node-expand", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xinc:node-expand(</div><div style=\"padding-left:2em;\">node as node()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function recursively examines the node for XInclude references and expands them, following the rules of the XInclude specification. The result is a node in which all the XInclude references have been resolved, or an error if there were unresolvable references with no fallback specifications.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xinc:node-expand\">Complete Information for xinc:node-expand</a></div></div>");
        fDocs.put("xinc:link-references", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xinc:link-references(</div><div style=\"padding-left:2em;\">node as node()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">This function returns a list of all the distinct URIs of documents referenced (either directly or indirectly) in the expansion of the node.</apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xinc:link-references\">Complete Information for xinc:link-references</a></div></div>");
        fDocs.put("dbg:invoke", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:invoke(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">[vars as item()*,]</div><div style=\"padding-left:2em;\">[options as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Invoke a module for debugging. Module evaluation will be stopped at the start of the first expression. Returns the request-id after creating the request. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:invoke\">Complete Information for dbg:invoke</a></div></div>");
        fDocs.put("dbg:eval", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:eval(</div><div style=\"padding-left:2em;\">xquery as xs:string,</div><div style=\"padding-left:2em;\">[vars as item()*,]</div><div style=\"padding-left:2em;\">[options as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Evaluate a string as an XQuery for debugging. Module evaluation will be stopped at the start of the first expression. Returns the request-id after creating the request. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:eval\">Complete Information for dbg:eval</a></div></div>");
        fDocs.put("dbg:attach", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:attach(</div><div style=\"padding-left:2em;\">request-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Attach to a request and stop it for debugging. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:attach\">Complete Information for dbg:attach</a></div></div>");
        fDocs.put("dbg:detach", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:detach(</div><div style=\"padding-left:2em;\">request-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Detach from a stopped request. All breakpoints set will be cancelled and the request will continue evaluating. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:detach\">Complete Information for dbg:detach</a></div></div>");
        fDocs.put("dbg:connect", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:connect(</div><div style=\"padding-left:2em;\">server as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Connect to a Server (http, xdbc, or task) for debugging. Any running requests will be stopped and new requests will stop at the first expression. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:connect\">Complete Information for dbg:connect</a></div></div>");
        fDocs.put("dbg:disconnect", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:disconnect(</div><div style=\"padding-left:2em;\">server as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> End the debugging of a server. Already stopped requests will remain stopped. New requests will evaluate without stopping at first expression. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:disconnect\">Complete Information for dbg:disconnect</a></div></div>");
        fDocs.put("dbg:status", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:status(</div><div style=\"padding-left:2em;\">request-id as xs:unsignedLong*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Return the debugging status of given requests. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:status\">Complete Information for dbg:status</a></div></div>");
        fDocs.put("dbg:stopped", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:stopped(</div><div style=\"padding-left:2em;\">[server as xs:unsignedLong]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Return the request ID's of stopped requests in a given server. If server isn't supplied, returns a list of all stopped requests on host. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:stopped\">Complete Information for dbg:stopped</a></div></div>");
        fDocs.put("dbg:attached", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:attached(</div><div style=\"padding-left:2em;\">[server as xs:unsignedLong]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Return the request ID's of attached requests in a given server. If server isn't supplied, returns a list of all attached requests on host. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:attached\">Complete Information for dbg:attached</a></div></div>");
        fDocs.put("dbg:stack", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:stack(</div><div style=\"padding-left:2em;\">request as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Return the stack trace for a given request. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:stack\">Complete Information for dbg:stack</a></div></div>");
        fDocs.put("dbg:out", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:out(</div><div style=\"padding-left:2em;\">request as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Continue evaluation of the request until the end of the current expression. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:out\">Complete Information for dbg:out</a></div></div>");
        fDocs.put("dbg:finish", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:finish(</div><div style=\"padding-left:2em;\">request as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Continue evaluation of the request until the end of the current function. If evaluation is not inside of a function, this request is equivalent to continue(). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:finish\">Complete Information for dbg:finish</a></div></div>");
        fDocs.put("dbg:step", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:step(</div><div style=\"padding-left:2em;\">request as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Continue evaluation of the request until the beginning or end of an expression. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:step\">Complete Information for dbg:step</a></div></div>");
        fDocs.put("dbg:next", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:next(</div><div style=\"padding-left:2em;\">request as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Continue evaluation of the request until the beginning or end of an expression that is not a descendant of the current expression. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:next\">Complete Information for dbg:next</a></div></div>");
        fDocs.put("dbg:continue", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:continue(</div><div style=\"padding-left:2em;\">request as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Continue evaluation of the request. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:continue\">Complete Information for dbg:continue</a></div></div>");
        fDocs.put("dbg:wait", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:wait(</div><div style=\"padding-left:2em;\">request-id as xs:unsignedLong*,</div><div style=\"padding-left:2em;\">timeout as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Wait until at least one of the given requests stops or all complete evaluating. Wait will return the empty sequence after a requested timeout if none of the requests have stopped. Otherwise, it returns the request-id of a stopped (or finished) request. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:wait\">Complete Information for dbg:wait</a></div></div>");
        fDocs.put("dbg:break", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:break(</div><div style=\"padding-left:2em;\">request as xs:unsignedLong,</div><div style=\"padding-left:2em;\">[expression as xs:unsignedLong]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Set a breakpoint at the given expression ID. If no expression ID is given, then the identified request is stopped. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:break\">Complete Information for dbg:break</a></div></div>");
        fDocs.put("dbg:clear", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:clear(</div><div style=\"padding-left:2em;\">request as xs:unsignedLong,</div><div style=\"padding-left:2em;\">expression as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Clear a breakpoint at the given expression ID. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:clear\">Complete Information for dbg:clear</a></div></div>");
        fDocs.put("dbg:breakpoints", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:breakpoints(</div><div style=\"padding-left:2em;\">request as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of expression ID's representing existing breakpoints for the given request. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:breakpoints\">Complete Information for dbg:breakpoints</a></div></div>");
        fDocs.put("dbg:stop", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:stop(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Placing this call in XQuery will instruct the evaluator to stop a request for debugging. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:stop\">Complete Information for dbg:stop</a></div></div>");
        fDocs.put("dbg:value", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:value(</div><div style=\"padding-left:2em;\">request as xs:unsignedLong,</div><div style=\"padding-left:2em;\">[expr as xs:string]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Evaluate an expression in the context of the identified stopped request. If no expression is given and the request is stopped at the end of an expression, then the expression's value is returned. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:value\">Complete Information for dbg:value</a></div></div>");
        fDocs.put("dbg:line", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:line(</div><div style=\"padding-left:2em;\">request as xs:unsignedLong,</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">line as xs:unsigned</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of expression ID's found on a given line of a stopped request. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:line\">Complete Information for dbg:line</a></div></div>");
        fDocs.put("dbg:function", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:function(</div><div style=\"padding-left:2em;\">request as xs:unsignedLong,</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">function as xs:QName</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the expression ID representing the function defined in a module with a given name. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:function\">Complete Information for dbg:function</a></div></div>");
        fDocs.put("dbg:expr", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">dbg:expr(</div><div style=\"padding-left:2em;\">request as xs:unsignedLong,</div><div style=\"padding-left:2em;\">expression as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a description/representation of a given expression. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:dbg:expr\">Complete Information for dbg:expr</a></div></div>");
        fDocs.put("xdmp:pdf-convert", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:pdf-convert(</div><div style=\"padding-left:2em;\">doc as node(),</div><div style=\"padding-left:2em;\">filename as xs:string,</div><div style=\"padding-left:2em;\">[options as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Converts a PDF file to XHTML. Returns several nodes, including a parts node, the converted document xml node, and any other document parts (for example, css files and images). The first node is the parts node, which contains a manefest of all of the parts generated as result of the conversion. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:pdf-convert\">Complete Information for xdmp:pdf-convert</a></div></div>");
        fDocs.put("p:insert", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">p:insert(</div><div style=\"padding-left:2em;\">pipeline as element(p:pipeline)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">Insert a fully constructed content processing pipeline, returning its unique id. If a pipeline with the same name already exists in the database, that pipeline will be replaced. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:p:insert\">Complete Information for p:insert</a></div></div>");
        fDocs.put("p:create", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">p:create(</div><div style=\"padding-left:2em;\">name as xs:string,</div><div style=\"padding-left:2em;\">description as xs:string,</div><div style=\"padding-left:2em;\">success-action as element(p:action)?,</div><div style=\"padding-left:2em;\">failure-action as element(p:action)?,</div><div style=\"padding-left:2em;\">status-transitions as element(p:status-transition)*,</div><div style=\"padding-left:2em;\">state-transitions as element(p:state-transition)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\">Create a new content processing pipeline. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:p:create\">Complete Information for p:create</a></div></div>");
        fDocs.put("p:remove", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">p:remove(</div><div style=\"padding-left:2em;\">pipeline-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Remove the named pipeline. An error is raised if no such pipeline exists. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:p:remove\">Complete Information for p:remove</a></div></div>");
        fDocs.put("p:get", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">p:get(</div><div style=\"padding-left:2em;\">pipeline-name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Find a particular pipeline. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:p:get\">Complete Information for p:get</a></div></div>");
        fDocs.put("p:get-by-id", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">p:get-by-id(</div><div style=\"padding-left:2em;\">pipeline-id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Find a particular pipeline. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:p:get-by-id\">Complete Information for p:get-by-id</a></div></div>");
        fDocs.put("p:collection", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">p:collection(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Return the name of the collection in which pipelines are stored. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:p:collection\">Complete Information for p:collection</a></div></div>");
        fDocs.put("p:pipelines", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">p:pipelines(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Return all the pipelines. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:p:pipelines\">Complete Information for p:pipelines</a></div></div>");
        fDocs.put("p:state-transition", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">p:state-transition(</div><div style=\"padding-left:2em;\">state as xs:anyURI,</div><div style=\"padding-left:2em;\">description as xs:string,</div><div style=\"padding-left:2em;\">on-success as xs:anyURI?,</div><div style=\"padding-left:2em;\">on-failure as xs:anyURI?,</div><div style=\"padding-left:2em;\">priority as xs:unsignedLong?,</div><div style=\"padding-left:2em;\">default-action as element(p:action)?,</div><div style=\"padding-left:2em;\">rules as element(p:execute)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Construct a new state transition element. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:p:state-transition\">Complete Information for p:state-transition</a></div></div>");
        fDocs.put("p:status-transition", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">p:status-transition(</div><div style=\"padding-left:2em;\">status as xs:string,</div><div style=\"padding-left:2em;\">description as xs:string,</div><div style=\"padding-left:2em;\">on-success as xs:anyURI?,</div><div style=\"padding-left:2em;\">on-failure as xs:anyURI?,</div><div style=\"padding-left:2em;\">priority as xs:unsignedLong?,</div><div style=\"padding-left:2em;\">default-action as element(p:action)?,</div><div style=\"padding-left:2em;\">rules as element(p:execute)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Construct a new status transition element. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:p:status-transition\">Complete Information for p:status-transition</a></div></div>");
        fDocs.put("p:execute", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">p:execute(</div><div style=\"padding-left:2em;\">condition as element(p:condition)?,</div><div style=\"padding-left:2em;\">action as element(p:action)?,</div><div style=\"padding-left:2em;\">description as xs:string?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Construct a execute element. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:p:execute\">Complete Information for p:execute</a></div></div>");
        fDocs.put("p:condition", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">p:condition(</div><div style=\"padding-left:2em;\">module as xs:string,</div><div style=\"padding-left:2em;\">description as xs:string?,</div><div style=\"padding-left:2em;\">options as element()?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Construct a condition element. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:p:condition\">Complete Information for p:condition</a></div></div>");
        fDocs.put("p:action", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">p:action(</div><div style=\"padding-left:2em;\">module as xs:string,</div><div style=\"padding-left:2em;\">description as xs:string?,</div><div style=\"padding-left:2em;\">options as element()?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Construct an action element. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:p:action\">Complete Information for p:action</a></div></div>");
        fDocs.put("cts:point", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:point(</div><div style=\"padding-left:2em;\">latitude as xs:float,</div><div style=\"padding-left:2em;\">longitude as xs:float</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a point value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:point\">Complete Information for cts:point</a></div></div>");
        fDocs.put("cts:point-latitude", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:point-latitude(</div><div style=\"padding-left:2em;\">point as cts:point</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a point's latitude value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:point-latitude\">Complete Information for cts:point-latitude</a></div></div>");
        fDocs.put("cts:point-longitude", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:point-longitude(</div><div style=\"padding-left:2em;\">point as cts:point</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a point's longitude value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:point-longitude\">Complete Information for cts:point-longitude</a></div></div>");
        fDocs.put("cts:box", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:box(</div><div style=\"padding-left:2em;\">south as xs:float,</div><div style=\"padding-left:2em;\">west as xs:float,</div><div style=\"padding-left:2em;\">north as xs:float,</div><div style=\"padding-left:2em;\">east as xs:float</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a geospatial box value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:box\">Complete Information for cts:box</a></div></div>");
        fDocs.put("cts:box-south", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:box-south(</div><div style=\"padding-left:2em;\">box as cts:box</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a box's southern boundary. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:box-south\">Complete Information for cts:box-south</a></div></div>");
        fDocs.put("cts:box-west", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:box-west(</div><div style=\"padding-left:2em;\">box as cts:box</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a box's western boundary. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:box-west\">Complete Information for cts:box-west</a></div></div>");
        fDocs.put("cts:box-north", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:box-north(</div><div style=\"padding-left:2em;\">box as cts:box</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a box's northern boundary. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:box-north\">Complete Information for cts:box-north</a></div></div>");
        fDocs.put("cts:box-east", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:box-east(</div><div style=\"padding-left:2em;\">box as cts:box</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a box's eastern boundary. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:box-east\">Complete Information for cts:box-east</a></div></div>");
        fDocs.put("cts:circle", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:circle(</div><div style=\"padding-left:2em;\">radius as xs:float,</div><div style=\"padding-left:2em;\">center as cts:point</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a geospatial circle value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:circle\">Complete Information for cts:circle</a></div></div>");
        fDocs.put("cts:circle-radius", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:circle-radius(</div><div style=\"padding-left:2em;\">circle as cts:circle</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a circle's radius. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:circle-radius\">Complete Information for cts:circle-radius</a></div></div>");
        fDocs.put("cts:circle-center", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:circle-center(</div><div style=\"padding-left:2em;\">circle as cts:circle</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a circle's center point. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:circle-center\">Complete Information for cts:circle-center</a></div></div>");
        fDocs.put("cts:polygon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:polygon(</div><div style=\"padding-left:2em;\">vertices as cts:point*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a geospatial polygon value. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:polygon\">Complete Information for cts:polygon</a></div></div>");
        fDocs.put("cts:polygon-vertices", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:polygon-vertices(</div><div style=\"padding-left:2em;\">polygon as cts:polygon</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a polygon's vertices. The first vertex and last vertex will always be the same. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:polygon-vertices\">Complete Information for cts:polygon-vertices</a></div></div>");
        fDocs.put("cts:element-geospatial-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-geospatial-query(</div><div style=\"padding-left:2em;\">element-name as xs:QName*,</div><div style=\"padding-left:2em;\">regions as cts:region*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:query</code> matching elements by name whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-geospatial-query\">Complete Information for cts:element-geospatial-query</a></div></div>");
        fDocs.put("cts:element-geospatial-query-element-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-geospatial-query-element-name(</div><div style=\"padding-left:2em;\">query as cts:element-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-geospatial-query-element-name\">Complete Information for cts:element-geospatial-query-element-name</a></div></div>");
        fDocs.put("cts:element-geospatial-query-region", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-geospatial-query-region(</div><div style=\"padding-left:2em;\">query as cts:element-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the geographical regions with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-geospatial-query-region\">Complete Information for cts:element-geospatial-query-region</a></div></div>");
        fDocs.put("cts:element-geospatial-query-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-geospatial-query-options(</div><div style=\"padding-left:2em;\">query as cts:element-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the options for the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-geospatial-query-options\">Complete Information for cts:element-geospatial-query-options</a></div></div>");
        fDocs.put("cts:element-geospatial-query-weight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-geospatial-query-weight(</div><div style=\"padding-left:2em;\">query as cts:element-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the weight with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-geospatial-query-weight\">Complete Information for cts:element-geospatial-query-weight</a></div></div>");
        fDocs.put("cts:element-child-geospatial-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-child-geospatial-query(</div><div style=\"padding-left:2em;\">parent-element-name as xs:QName*,</div><div style=\"padding-left:2em;\">child-element-names as xs:QName*,</div><div style=\"padding-left:2em;\">regions as cts:box*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:query</code> matching elements by name which has specific element children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-child-geospatial-query\">Complete Information for cts:element-child-geospatial-query</a></div></div>");
        fDocs.put("cts:element-child-geospatial-query-element-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-child-geospatial-query-element-name(</div><div style=\"padding-left:2em;\">query as cts:element-child-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-child-geospatial-query-element-name\">Complete Information for cts:element-child-geospatial-query-element-name</a></div></div>");
        fDocs.put("cts:element-child-geospatial-query-child-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-child-geospatial-query-child-name(</div><div style=\"padding-left:2em;\">query as cts:element-child-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-child-geospatial-query-child-name\">Complete Information for cts:element-child-geospatial-query-child-name</a></div></div>");
        fDocs.put("cts:element-child-geospatial-query-region", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-child-geospatial-query-region(</div><div style=\"padding-left:2em;\">query as cts:element-child-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the geographical regions with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-child-geospatial-query-region\">Complete Information for cts:element-child-geospatial-query-region</a></div></div>");
        fDocs.put("cts:element-child-geospatial-query-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-child-geospatial-query-options(</div><div style=\"padding-left:2em;\">query as cts:element-child-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the options for the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-child-geospatial-query-options\">Complete Information for cts:element-child-geospatial-query-options</a></div></div>");
        fDocs.put("cts:element-child-geospatial-query-weight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-child-geospatial-query-weight(</div><div style=\"padding-left:2em;\">query as cts:element-child-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the weight with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-child-geospatial-query-weight\">Complete Information for cts:element-child-geospatial-query-weight</a></div></div>");
        fDocs.put("cts:element-pair-geospatial-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-pair-geospatial-query(</div><div style=\"padding-left:2em;\">element-name as xs:QName*,</div><div style=\"padding-left:2em;\">latitude-element-names as xs:QName*,</div><div style=\"padding-left:2em;\">longitude-element-names as xs:QName*,</div><div style=\"padding-left:2em;\">regions as cts:box*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:query</code> matching elements by name which has specific element children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-pair-geospatial-query\">Complete Information for cts:element-pair-geospatial-query</a></div></div>");
        fDocs.put("cts:element-pair-geospatial-query-element-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-pair-geospatial-query-element-name(</div><div style=\"padding-left:2em;\">query as cts:element-pair-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-pair-geospatial-query-element-name\">Complete Information for cts:element-pair-geospatial-query-element-name</a></div></div>");
        fDocs.put("cts:element-pair-geospatial-query-latitude-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-pair-geospatial-query-latitude-name(</div><div style=\"padding-left:2em;\">query as cts:element-pair-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-pair-geospatial-query-latitude-name\">Complete Information for cts:element-pair-geospatial-query-latitude-name</a></div></div>");
        fDocs.put("cts:element-pair-geospatial-query-longitude-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-pair-geospatial-query-longitude-name(</div><div style=\"padding-left:2em;\">query as cts:element-pair-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-pair-geospatial-query-longitude-name\">Complete Information for cts:element-pair-geospatial-query-longitude-name</a></div></div>");
        fDocs.put("cts:element-pair-geospatial-query-region", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-pair-geospatial-query-region(</div><div style=\"padding-left:2em;\">query as cts:element-pair-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the geographical regions with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-pair-geospatial-query-region\">Complete Information for cts:element-pair-geospatial-query-region</a></div></div>");
        fDocs.put("cts:element-pair-geospatial-query-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-pair-geospatial-query-options(</div><div style=\"padding-left:2em;\">query as cts:element-pair-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the options for the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-pair-geospatial-query-options\">Complete Information for cts:element-pair-geospatial-query-options</a></div></div>");
        fDocs.put("cts:element-pair-geospatial-query-weight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-pair-geospatial-query-weight(</div><div style=\"padding-left:2em;\">query as cts:element-pair-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the weight with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-pair-geospatial-query-weight\">Complete Information for cts:element-pair-geospatial-query-weight</a></div></div>");
        fDocs.put("cts:element-attribute-pair-geospatial-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-pair-geospatial-query(</div><div style=\"padding-left:2em;\">element-name as xs:QName*,</div><div style=\"padding-left:2em;\">latitude-attribute-names as xs:QName*,</div><div style=\"padding-left:2em;\">longitude-attribute-names as xs:QName*,</div><div style=\"padding-left:2em;\">regions as cts:region*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:query</code> matching elements by name which has specific attributes representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-pair-geospatial-query\">Complete Information for cts:element-attribute-pair-geospatial-query</a></div></div>");
        fDocs.put("cts:element-attribute-pair-geospatial-query-element-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-pair-geospatial-query-element-name(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-pair-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-pair-geospatial-query-element-name\">Complete Information for cts:element-attribute-pair-geospatial-query-element-name</a></div></div>");
        fDocs.put("cts:element-attribute-pair-geospatial-query-latitude-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-pair-geospatial-query-latitude-name(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-pair-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-pair-geospatial-query-latitude-name\">Complete Information for cts:element-attribute-pair-geospatial-query-latitude-name</a></div></div>");
        fDocs.put("cts:element-attribute-pair-geospatial-query-longitude-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-pair-geospatial-query-longitude-name(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-pair-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the QNames used to construct the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-pair-geospatial-query-longitude-name\">Complete Information for cts:element-attribute-pair-geospatial-query-longitude-name</a></div></div>");
        fDocs.put("cts:element-attribute-pair-geospatial-query-region", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-pair-geospatial-query-region(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-pair-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the geographical regions with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-pair-geospatial-query-region\">Complete Information for cts:element-attribute-pair-geospatial-query-region</a></div></div>");
        fDocs.put("cts:element-attribute-pair-geospatial-query-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-pair-geospatial-query-options(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-pair-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the options for the specified query. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-pair-geospatial-query-options\">Complete Information for cts:element-attribute-pair-geospatial-query-options</a></div></div>");
        fDocs.put("cts:element-attribute-pair-geospatial-query-weight", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-pair-geospatial-query-weight(</div><div style=\"padding-left:2em;\">query as cts:element-attribute-pair-geospatial-query</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the weight with which the specified query was constructed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-pair-geospatial-query-weight\">Complete Information for cts:element-attribute-pair-geospatial-query-weight</a></div></div>");
        fDocs.put("cts:element-geospatial-boxes", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-geospatial-boxes(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">[latitude-bounds as xs:double*,]</div><div style=\"padding-left:2em;\">[longitude-bounds as xs:double*,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns boxes derived from the specified element point lexicon(s). Element point lexicons are implemented using geospatial indexes; consequently this function requires an element geospatial index for each element specified in the function. If there is not a geospatial index configured for each of the specified elements, an exception is thrown.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\">The points are divided into box-shaped buckets. The $latitude-bounds and $longitude-bounds parameters specify the number and the size of each box-shaped bucket. All included points are bucketed, even those outside the bounds. An empty sequence for both $latitude-bounds and $longitude-bounds specifies one bucket, a single value for both specifies four buckets, two values for both specify nine buckets, and so on.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\">For each non-empty bucket, a <code>cts:box</code> value is returned. By default, the <code>cts:box</code> value is the minimum bounding box of all the points in the bucket. If the \"gridded\" option is specified, then if a bucket is bounded on a side, its corresponding <code>cts:box</code> side is the bound. Empty buckets return nothing unless the \"empties\" option is specified.</p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-geospatial-boxes\">Complete Information for cts:element-geospatial-boxes</a></div></div>");
        fDocs.put("cts:element-child-geospatial-boxes", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-child-geospatial-boxes(</div><div style=\"padding-left:2em;\">parent-element-names as xs:QName*,</div><div style=\"padding-left:2em;\">child-element-names as xs:QName*,</div><div style=\"padding-left:2em;\">[latitude-bounds as xs:double*,]</div><div style=\"padding-left:2em;\">[longitude-bounds as xs:double*,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns boxes derived from the specified element point lexicon(s). Element point lexicons are implemented using geospatial indexes; consequently this function requires an element child geospatial index for each element specified in the function. If there is not a geospatial index configured for each of the specified element/child combinations, an exception is thrown.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\">The points are divided into box-shaped buckets. The $latitude-bounds and $longitude-bounds parameters specify the number and the size of each box-shaped bucket. All included points are bucketed, even those outside the bounds. An empty sequence for both $latitude-bounds and $longitude-bounds specifies one bucket, a single value for both specifies four buckets, two values for both specify nine buckets, and so on.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\">For each non-empty bucket, a <code>cts:box</code> value is returned. By default, the <code>cts:box</code> value is the minimum bounding box of all the points in the bucket. If the \"gridded\" option is specified, then if a bucket is bounded on a side, its corresponding <code>cts:box</code> side is the bound. Empty buckets return nothing unless the \"empties\" option is specified.</p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-child-geospatial-boxes\">Complete Information for cts:element-child-geospatial-boxes</a></div></div>");
        fDocs.put("cts:element-pair-geospatial-boxes", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-pair-geospatial-boxes(</div><div style=\"padding-left:2em;\">parent-element-names as xs:QName*,</div><div style=\"padding-left:2em;\">latitude-names as xs:QName*,</div><div style=\"padding-left:2em;\">longitude-names as xs:QName*,</div><div style=\"padding-left:2em;\">[latitude-bounds as xs:double*,]</div><div style=\"padding-left:2em;\">[longitude-bounds as xs:double*,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns boxes derived from the specified element point lexicon(s). Element point lexicons are implemented using geospatial indexes; consequently this function requires a geospatial element pair index for each parent and pair of child elements specified in the function. If there is not a geospatial index configured for each of the specified combinations, an exception is thrown.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\">The points are divided into box-shaped buckets. The $latitude-bounds and $longitude-bounds parameters specify the number and the size of each box-shaped bucket. All included points are bucketed, even those outside the bounds. An empty sequence for both $latitude-bounds and $longitude-bounds specifies one bucket, a single value for both specifies four buckets, two values for both specify nine buckets, and so on.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\">For each non-empty bucket, a <code>cts:box</code> value is returned. By default, the <code>cts:box</code> value is the minimum bounding box of all the points in the bucket. If the \"gridded\" option is specified, then if a bucket is bounded on a side, its corresponding <code>cts:box</code> side is the bound. Empty buckets return nothing unless the \"empties\" option is specified.</p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-pair-geospatial-boxes\">Complete Information for cts:element-pair-geospatial-boxes</a></div></div>");
        fDocs.put("cts:element-attribute-pair-geospatial-boxes", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-pair-geospatial-boxes(</div><div style=\"padding-left:2em;\">parent-element-names as xs:QName*,</div><div style=\"padding-left:2em;\">latitude-names as xs:QName*,</div><div style=\"padding-left:2em;\">longitude-names as xs:QName*,</div><div style=\"padding-left:2em;\">[latitude-bounds as xs:double*,]</div><div style=\"padding-left:2em;\">[longitude-bounds as xs:double*,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns boxes derived from the specified element point lexicon(s). Element point lexicons are implemented using geospatial indexes; consequently this function requires a geospatial element attribute pair index for each prarent element and attribute pair specified in the function. If there is not a geospatial index configured for each of the specified combinations, an exception is thrown.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\">The points are divided into box-shaped buckets. The $latitude-bounds and $longitude-bounds parameters specify the number and the size of each box-shaped bucket. All included points are bucketed, even those outside the bounds. An empty sequence for both $latitude-bounds and $longitude-bounds specifies one bucket, a single value for both specifies four buckets, two values for both specify nine buckets, and so on.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\">For each non-empty bucket, a <code>cts:box</code> value is returned. By default, the <code>cts:box</code> value is the minimum bounding box of all the points in the bucket. If the \"gridded\" option is specified, then if a bucket is bounded on a side, its corresponding <code>cts:box</code> side is the bound. Empty buckets return nothing unless the \"empties\" option is specified.</p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-pair-geospatial-boxes\">Complete Information for cts:element-attribute-pair-geospatial-boxes</a></div></div>");
        fDocs.put("cts:element-geospatial-values", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-geospatial-values(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">[start as cts:point?,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns values from the specified element geospatial value lexicon(s). Geospatial value lexicons are implemented using geospatial indexes; consequently this function requires an element geospatial index for each element specified in the function. If there is not a geospatial index configured for each of the specified elements, an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-geospatial-values\">Complete Information for cts:element-geospatial-values</a></div></div>");
        fDocs.put("cts:element-child-geospatial-values", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-child-geospatial-values(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">child-names as xs:QName*,</div><div style=\"padding-left:2em;\">[start as cts:point?,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns values from the specified element-child geospatial value lexicon(s). Element-child geospatial value lexicons are implemented using geospatial indexes; consequently this function requires an element-child geospatial index of for each of the element/child pairs specified in the function. If there is not a range index configured for each of the specified element/child pairs, then an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-child-geospatial-values\">Complete Information for cts:element-child-geospatial-values</a></div></div>");
        fDocs.put("cts:element-pair-geospatial-values", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-pair-geospatial-values(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">latitude-names as xs:QName*,</div><div style=\"padding-left:2em;\">longitude-names as xs:QName*,</div><div style=\"padding-left:2em;\">[start as cts:point?,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns values from the specified element-pair geospatial value lexicon(s). element-pair geospatial value lexicons are implemented using geospatial indexes; consequently this function requires an element-pair geospatial index of for each of the combinatation specified in the function. If there is not a geospatial index configured for each of the specified combinations, then an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-pair-geospatial-values\">Complete Information for cts:element-pair-geospatial-values</a></div></div>");
        fDocs.put("cts:element-attribute-pair-geospatial-values", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-pair-geospatial-values(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">latitude-names as xs:QName*,</div><div style=\"padding-left:2em;\">longitude-names as xs:QName*,</div><div style=\"padding-left:2em;\">[start as cts:point?,]</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns values from the specified element-attribute-pair geospatial value lexicon(s). element-attribute-pair geospatial value lexicons are implemented using geospatial indexes; consequently this function requires an element-attribute-pair geospatial index of for each of the combinatation specified in the function. If there is not a geospatial index configured for each of the specified combinations, then an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-pair-geospatial-values\">Complete Information for cts:element-attribute-pair-geospatial-values</a></div></div>");
        fDocs.put("cts:element-geospatial-value-match", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-geospatial-value-match(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">pattern as xs:anyAtomicType,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns values from the specified element geospatial value lexicon(s) that match the specified wildcard pattern. Element geospatial value lexicons are implemented using geospatial indexes; consequently this function requires an element geospatial index for each element specified in the function. If there is not a geospatial index configured for each of the specified elements, then an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-geospatial-value-match\">Complete Information for cts:element-geospatial-value-match</a></div></div>");
        fDocs.put("cts:element-child-geospatial-value-match", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-child-geospatial-value-match(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">child-names as xs:QName*,</div><div style=\"padding-left:2em;\">pattern as xs:anyAtomicType,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns values from the specified element child geospatial value lexicon(s) that match the specified wildcard pattern. Element child geospatial value lexicons are implemented using geospatial indexes; consequently this function requires an element child geospatial index for each element and child specified in the function. If there is not a geospatial index configured for each of the specified elements/child combinations, then an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-child-geospatial-value-match\">Complete Information for cts:element-child-geospatial-value-match</a></div></div>");
        fDocs.put("cts:element-pair-geospatial-value-match", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-pair-geospatial-value-match(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">latitude-names as xs:QName*,</div><div style=\"padding-left:2em;\">longitude-names as xs:QName*,</div><div style=\"padding-left:2em;\">pattern as xs:anyAtomicType,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns values from the specified element pair geospatial value lexicon(s) that match the specified wildcard pattern. Element pair geospatial value lexicons are implemented using geospatial indexes; consequently this function requires an element pair geospatial index for each combination of elements specified in the function. If there is not a geospatial index configured for each of the specified combinations, then an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-pair-geospatial-value-match\">Complete Information for cts:element-pair-geospatial-value-match</a></div></div>");
        fDocs.put("cts:element-attribute-pair-geospatial-value-match", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-pair-geospatial-value-match(</div><div style=\"padding-left:2em;\">element-names as xs:QName*,</div><div style=\"padding-left:2em;\">latitude-names as xs:QName*,</div><div style=\"padding-left:2em;\">longitude-names as xs:QName*,</div><div style=\"padding-left:2em;\">pattern as xs:anyAtomicType,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns values from the specified element attribute pair geospatial value lexicon(s) that match the specified wildcard pattern. Element attribute pair geospatial value lexicons are implemented using geospatial indexes; consequently this function requires an element attribute pair geospatial index for each combination of elements and attributes specified in the function. If there is not a geospatial index configured for each of the specified combinations, then an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-pair-geospatial-value-match\">Complete Information for cts:element-attribute-pair-geospatial-value-match</a></div></div>");
        fDocs.put("cts:element-value-geospatial-co-occurrences", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-value-geospatial-co-occurrences(</div><div style=\"padding-left:2em;\">element-name-1 as xs:QName,</div><div style=\"padding-left:2em;\">geo-element-name as xs:QName,</div><div style=\"padding-left:2em;\">child-name-1 as xs:QName?,</div><div style=\"padding-left:2em;\">child-name-2 as xs:QName?,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns value co-occurrences from the specified element value lexicon with the specified geospatial lexicon. Value lexicons are implemented using range indexes; consequently this function requires a range index for the element specified in the function. If there is not a range index configured for the specified element, then an exception is thrown. Geospatial lexicons are implemented using geospatial indexes; consequently this function requires a geospatial index for the element/attribute combination specified in the function. If there is not a geospatial index configured for the specified element/attribute combination, then an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-value-geospatial-co-occurrences\">Complete Information for cts:element-value-geospatial-co-occurrences</a></div></div>");
        fDocs.put("cts:element-attribute-value-geospatial-co-occurrences", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:element-attribute-value-geospatial-co-occurrences(</div><div style=\"padding-left:2em;\">element-name-1 as xs:QName,</div><div style=\"padding-left:2em;\">attribute-name-1 as xs:QName?,</div><div style=\"padding-left:2em;\">geo-element-name as xs:QName,</div><div style=\"padding-left:2em;\">child-name-1 as xs:QName?,</div><div style=\"padding-left:2em;\">child-name-2 as xs:QName?,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns value co-occurrences from the specified element-attribute value lexicon with the specified geospatial lexicon. Value lexicons are implemented using range indexes; consequently this function requires a range index for the element and attribute pair specified in the function. If there is not a range index configured for the specified element and attribute pair, then an exception is thrown. Geospatial lexicons are implemented using geospatial indexes; consequently this function requires a geospatial index for the element/attribute combination specified in the function. If there is not a geospatial index configured for the specified element/attribute combination, then an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:element-attribute-value-geospatial-co-occurrences\">Complete Information for cts:element-attribute-value-geospatial-co-occurrences</a></div></div>");
        fDocs.put("cts:geospatial-co-occurrences", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:geospatial-co-occurrences(</div><div style=\"padding-left:2em;\">geo-element-name-1 as xs:QName,</div><div style=\"padding-left:2em;\">child-1-name-1 as xs:QName?,</div><div style=\"padding-left:2em;\">child-1-name-2 as xs:QName?,</div><div style=\"padding-left:2em;\">geo-element-name-2 as xs:QName,</div><div style=\"padding-left:2em;\">child-2-name-1 as xs:QName?,</div><div style=\"padding-left:2em;\">child-2-name-2 as xs:QName?,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[query as cts:query?,]</div><div style=\"padding-left:2em;\">[quality-weight as xs:double?,]</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns value co-occurrences from the geospatial lexicons. Geospatial lexicons are implemented using geospatial indexes; consequently this function requires a geospatial index for each combination of elements and attributes specified in the function. If there is not a geospatial index configured for the specified element/attribute combination, then an exception is thrown. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:geospatial-co-occurrences\">Complete Information for cts:geospatial-co-occurrences</a></div></div>");
        fDocs.put("cts:distance", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:distance(</div><div style=\"padding-left:2em;\">p1 as cts:point,</div><div style=\"padding-left:2em;\">p2 as cts:point,</div><div style=\"padding-left:2em;\">[options as xs:string*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the distance (in miles) between two points. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:distance\">Complete Information for cts:distance</a></div></div>");
        fDocs.put("cts:shortest-distance", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:shortest-distance(</div><div style=\"padding-left:2em;\">p1 as cts:point,</div><div style=\"padding-left:2em;\">v as cts:point+,</div><div style=\"padding-left:2em;\">[options as xs:string*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the great circle distance (in miles) between a point and an arc. The arc is defined by a pair of points. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:shortest-distance\">Complete Information for cts:shortest-distance</a></div></div>");
        fDocs.put("cts:bearing", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:bearing(</div><div style=\"padding-left:2em;\">p1 as cts:point,</div><div style=\"padding-left:2em;\">p2 as cts:point,</div><div style=\"padding-left:2em;\">[options as xs:string*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the true bearing in radians of the path from the first point to the second. An error is raised if the two points are the same. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:bearing\">Complete Information for cts:bearing</a></div></div>");
        fDocs.put("cts:destination", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:destination(</div><div style=\"padding-left:2em;\">p as cts:point,</div><div style=\"padding-left:2em;\">bearing as xs:double,</div><div style=\"padding-left:2em;\">distance as xs:double,</div><div style=\"padding-left:2em;\">[options as xs:string*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the point at the given distance (in miles) along the given bearing (in radians) from the starting point. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:destination\">Complete Information for cts:destination</a></div></div>");
        fDocs.put("cts:arc-intersection", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">cts:arc-intersection(</div><div style=\"padding-left:2em;\">p1 as cts:point,</div><div style=\"padding-left:2em;\">p2 as cts:point,</div><div style=\"padding-left:2em;\">q1 as cts:point,</div><div style=\"padding-left:2em;\">q2 as cts:point,</div><div style=\"padding-left:2em;\">[options as xs:string*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the point at the intersection of two arcs. If the arcs do not intersect, or lie on the same great circle, or if either arc covers more than 180 degrees, an error is raised. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:cts:arc-intersection\">Complete Information for cts:arc-intersection</a></div></div>");
        fDocs.put("gml:point", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">gml:point(</div><div style=\"padding-left:2em;\">point as element(gml:Point)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a cts:point value from a GML Point element. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:gml:point\">Complete Information for gml:point</a></div></div>");
        fDocs.put("gml:box", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">gml:box(</div><div style=\"padding-left:2em;\">box as element(gml:Envelope)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:box</code> value from a GML Envelope element. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:gml:box\">Complete Information for gml:box</a></div></div>");
        fDocs.put("gml:circle", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">gml:circle(</div><div style=\"padding-left:2em;\">radius as xs:double,</div><div style=\"padding-left:2em;\">center as element(gml:Point)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:circle</code> value from a radius and GML Point element. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:gml:circle\">Complete Information for gml:circle</a></div></div>");
        fDocs.put("gml:polygon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">gml:polygon(</div><div style=\"padding-left:2em;\">points as element(gml:Point)*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:polygon</code> value from a sequence of GML Point elements. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:gml:polygon\">Complete Information for gml:polygon</a></div></div>");
        fDocs.put("gml:polygon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">gml:polygon(</div><div style=\"padding-left:2em;\">polygon as element(gml:Polygon)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:polygon</code> value from a GML Polygon element. The polygon returned represents the exterior polygon. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:gml:polygon\">Complete Information for gml:polygon</a></div></div>");
        fDocs.put("gml:interior-polygon", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">gml:interior-polygon(</div><div style=\"padding-left:2em;\">polygon as element(gml:Polygon)</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Create a sequence of <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:polygon</code> values from a GML Polygon element. The polygons returned represent the interior polygons, if any. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:gml:interior-polygon\">Complete Information for gml:interior-polygon</a></div></div>");
        fDocs.put("gml:geospatial-query", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">gml:geospatial-query(</div><div style=\"padding-left:2em;\">regions as cts:region*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:query</code> matching points within given regions. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:gml:geospatial-query\">Complete Information for gml:geospatial-query</a></div></div>");
        fDocs.put("gml:geospatial-query-from-elements", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">gml:geospatial-query-from-elements(</div><div style=\"padding-left:2em;\">regions as cts:region*,</div><div style=\"padding-left:2em;\">[options as xs:string*,]</div><div style=\"padding-left:2em;\">[weight as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a <code xmlns=\"http://www.w3.org/1999/xhtml\">cts:query</code> matching points within given regions. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:gml:geospatial-query-from-elements\">Complete Information for gml:geospatial-query-from-elements</a></div></div>");
        fDocs.put("fn:boolean", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:boolean(</div><div style=\"padding-left:2em;\">arg as item()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Computes the effective boolean value of the sequence $arg. See Section 2.4.3 Effective Boolean Value[XP]. </p> <p xmlns=\"http://www.w3.org/1999/xhtml\">NOTE: NEW 1.0 SEMANTICS NOT IMPLEMENTED: STILL USES MAY 2003 SEMANTICS.</p> <p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, fn:boolean returns false. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is a sequence whose first item is a node, fn:boolean returns true. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is a singleton value of type xs:boolean or a derived from xs:boolean, fn:boolean returns $arg. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is a singleton value of type xs:string or a type derived from xs:string or xs:untypedAtomic, fn:boolean returns false if the operand value has zero length; otherwise it returns true. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is a singleton value of any numeric type or a type derived from a numeric type, fn:boolean returns false if the operand value is NaN or is numerically equal to zero; otherwise it returns true. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> In all other cases, fn:boolean raises a type error [err:FORG0006]. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The static semantics of this function are described in <a href=\"http://www.w3.org/TR/xquery-semantics/#sec_fn_boolean\">Section 7.2.4 The fn:boolean function[FS]</a>. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Note: </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The result of this function is not necessarily the same as \" $arg cast as xs:boolean \". For example, fn:boolean(\"false\") returns the value \"true\" whereas \"false\" cast as xs:boolean returns false. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:boolean\">Complete Information for fn:boolean</a></div></div>");
        fDocs.put("fn:index-of", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:index-of(</div><div style=\"padding-left:2em;\">seqParam as xs:anyAtomicType*,</div><div style=\"padding-left:2em;\">srchParam as xs:anyAtomicType,</div><div style=\"padding-left:2em;\">collationLiteral as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns a sequence of positive integers giving the positions within the sequence $seqParam of items that are equal to $srchParam. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The collation used by the invocation of this function is determined according to the rules in 7.3.1 Collations. The collation is used when string comparison is required. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The items in the sequence $seqParam are compared with $srchParam under the rules for the eq operator. Values that cannot be compared, i.e. the eq operator is not defined for their types, are considered to be distinct. If an item compares equal, then the position of that item in the sequence $srchParam is included in the result. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the value of $seqParam is the empty sequence, or if no item in $seqParam matches $srchParam, then the empty sequence is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The first item in a sequence is at position 1, not position 0. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The result sequence is in ascending numeric order. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:index-of\">Complete Information for fn:index-of</a></div></div>");
        fDocs.put("fn:empty", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:empty(</div><div style=\"padding-left:2em;\">arg as item()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> If the value of $arg is the empty sequence, the function returns true; otherwise, the function returns false. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:empty\">Complete Information for fn:empty</a></div></div>");
        fDocs.put("fn:exists", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:exists(</div><div style=\"padding-left:2em;\">arg as item()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> If the value of $arg is not the empty sequence, the function returns true; otherwise, the function returns false. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:exists\">Complete Information for fn:exists</a></div></div>");
        fDocs.put("fn:distinct-nodes", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:distinct-nodes(</div><div style=\"padding-left:2em;\">nodes as node()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> [0.9-ml only] Returns the sequence resulting from removing from the input sequence all but one of a set of nodes that have the same identity as one another. If the empty sequence is input, <code xmlns=\"http://www.w3.org/1999/xhtml\">fn:distinct-nodes</code> returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:distinct-nodes\">Complete Information for fn:distinct-nodes</a></div></div>");
        fDocs.put("fn:distinct-values", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:distinct-values(</div><div style=\"padding-left:2em;\">arg as xs:anyAtomicType*,</div><div style=\"padding-left:2em;\">[collation as xs:string]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns the sequence that results from removing from $arg all but one of a set of values that are eq to one other. Values that cannot be compared, i.e. the eq operator is not defined for their types, are considered to be distinct. Values of type xs:untypedAtomic are compared as if they were of type xs:string. The order in which the sequence of values is returned is implementation dependent. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The static type of the result is a sequence of prime types as defined in <a href=\"http://www.w3.org/TR/xquery-semantics/#sec_fn_distinct_node_vals\">Section 7.2.7 The fn:distinct-values function[FS]</a>. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The collation used by the invocation of this function is determined according to the rules in 7.3.1 Collations. The collation is used when string comparison is required. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, the empty sequence is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For xs:float and xs:double values, positive zero is equal to negative zero and, although NaN does not equal itself, if $arg contains multiple NaN values a single NaN is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If xs:dateTime, xs:date or xs:time values do not have a timezone, they are considered to have the implicit timezone provided by the dynamic context for the purpose of comparison. Note that xs:dateTime, xs:date or xs:time values can compare equal even if their timezones are different. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Which value of a set of values that compare equal is returned is implementation dependent. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:distinct-values\">Complete Information for fn:distinct-values</a></div></div>");
        fDocs.put("fn:insert-before", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:insert-before(</div><div style=\"padding-left:2em;\">target as item()*,</div><div style=\"padding-left:2em;\">position as xs:integer,</div><div style=\"padding-left:2em;\">inserts as item()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns a new sequence constructed from the value of $target with the value of $inserts inserted at the position specified by the value of $position. (The value of $target is not affected by the sequence construction.) </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $target is the empty sequence, $inserts is returned. If $inserts is the empty sequence, $target is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The value returned by the function consists of all items of $target whose index is less than $position, followed by all items of $inserts, followed by the remaining elements of $target, in that sequence. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $position is less than one (1), the first position, the effective value of $position is one (1). If $position is greater than the number of items in $target, then the effective value of $position is equal to the number of items in $target plus 1. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For detailed semantics see, <a href=\"http://www.w3.org/TR/xquery-semantics/#sec_fn_insert_before\">Section 7.2.15 The fn:insert-before function[FS]</a>. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:insert-before\">Complete Information for fn:insert-before</a></div></div>");
        fDocs.put("fn:remove", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:remove(</div><div style=\"padding-left:2em;\">target as item()*,</div><div style=\"padding-left:2em;\">position as xs:integer</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns a new sequence constructed from the value of $target with the item at the position specified by the value of $position removed. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $position is less than 1 or greater than the number of items in $target, $target is returned. Otherwise, the value returned by the function consists of all items of $target whose index is less than $position, followed by all items of $target whose index is greater than $position. If $target is the empty sequence, the empty sequence is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For detailed type semantics, see <a href=\"http://www.w3.org/TR/xquery-semantics/#sec_fn_remove\">Section 7.2.11 The fn:remove function[FS]</a>. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:remove\">Complete Information for fn:remove</a></div></div>");
        fDocs.put("fn:reverse", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:reverse(</div><div style=\"padding-left:2em;\">target as item()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Reverses the order of items in a sequence. If $arg is the empty sequence, the empty sequence is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For detailed type semantics, see <a href=\"http://www.w3.org/TR/xquery-semantics/#sec_fn_reverse\">Section 7.2.12 The fn:reverse function[FS]</a>. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:reverse\">Complete Information for fn:reverse</a></div></div>");
        fDocs.put("fn:subsequence", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:subsequence(</div><div style=\"padding-left:2em;\">sourceSeq as item()*,</div><div style=\"padding-left:2em;\">startingLoc as xs:double,</div><div style=\"padding-left:2em;\">[length as xs:double]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns the contiguous sequence of items in the value of $sourceSeq beginning at the position indicated by the value of $startingLoc and continuing for the number of items indicated by the value of $length. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> In the two-argument case, returns: </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> $sourceSeq[fn:round($startingLoc) le $p] </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> In the three-argument case, returns: </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> $sourceSeq[fn:round($startingLoc) le $p and $p lt fn:round($startingLoc) + fn:round($length)] </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Notes: </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $sourceSeq is the empty sequence, the empty sequence is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $startingLoc is zero or negative, the subsequence includes items from the beginning of the $sourceSeq. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $length is not specified, the subsequence includes items to the end of $sourceSeq. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $length is greater than the number of items in the value of $sourceSeq following $startingLoc, the subsequence includes items to the end of $sourceSeq. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The first item of a sequence is located at position 1, not position 0. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For detailed type semantics, see Section 7.2.13 The fn:subsequence functionFS. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The reason the function accepts arguments of type xs:double is that many computations on untyped data return an xs:double result; and the reason for the rounding rules is to compensate for any imprecision in these floating-point computations. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:subsequence\">Complete Information for fn:subsequence</a></div></div>");
        fDocs.put("fn:unordered", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:unordered(</div><div style=\"padding-left:2em;\">sourceSeq as item()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns the items of $sourceSeq in an implementation dependent order. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Note: </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Query optimizers may be able to do a better job if the order of the output sequence is not specified. For example, when retrieving prices from a purchase order, if an index exists on prices, it may be more efficient to return the prices in index order rather than in document order. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:unordered\">Complete Information for fn:unordered</a></div></div>");
        fDocs.put("fn:zero-or-one", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:zero-or-one(</div><div style=\"padding-left:2em;\">arg as item()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns $arg if it contains zero or one items. Otherwise, raises an error [err:FORG0003]. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For detailed type semantics, see <a href=\"http://www.w3.org/TR/xquery-semantics/#sec_fn_cardinality_funcs\">Section 7.2.16 The fn:zero-or-one, fn:one-or-more, and fn:exactly-one functions[FS]</a>. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:zero-or-one\">Complete Information for fn:zero-or-one</a></div></div>");
        fDocs.put("fn:one-or-more", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:one-or-more(</div><div style=\"padding-left:2em;\">arg as item()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns $arg if it contains one or more items. Otherwise, raises an error [err:FORG0004]. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For detailed type semantics, see <a href=\"http://www.w3.org/TR/xquery-semantics/#sec_fn_cardinality_funcs\">Section 7.2.16 The fn:zero-or-one, fn:one-or-more, and fn:exactly-one functions[FS]</a>. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:one-or-more\">Complete Information for fn:one-or-more</a></div></div>");
        fDocs.put("fn:exactly-one", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:exactly-one(</div><div style=\"padding-left:2em;\">arg as item()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns $arg if it contains exactly one item. Otherwise, raises an error [err:FORG0005]. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For detailed type semantics, see <a href=\"http://www.w3.org/TR/xquery-semantics/#sec_fn_cardinality_funcs\">Section 7.2.16 The fn:zero-or-one, fn:one-or-more, and fn:exactly-one functions[FS]</a>. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:exactly-one\">Complete Information for fn:exactly-one</a></div></div>");
        fDocs.put("fn:deep-equal", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:deep-equal(</div><div style=\"padding-left:2em;\">parameter1 as item()*,</div><div style=\"padding-left:2em;\">parameter2 as item()*,</div><div style=\"padding-left:2em;\">[collation as xs:string]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">This function assesses whether two sequences are deep-equal to each other. To be deep-equal, they must contain items that are pairwise deep-equal; and for two items to be deep-equal, they must either be atomic values that compare equal, or nodes of the same kind, with the same name, whose children are deep-equal. This is defined in more detail below. The $collation argument identifies a collation which is used at all levels of recursion when strings are compared (but not when names are compared), according to the rules in 7.3.1 Collations. </p> <p xmlns=\"http://www.w3.org/1999/xhtml\">If the two sequences are both empty, the function returns true. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the two sequences are of different lengths, the function returns false. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the two sequences are of the same length, the function returns true if and only if every item in the sequence $parameter1 is deep-equal to the item at the same position in the sequence $parameter2. The rules for deciding whether two items are deep-equal follow. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Call the two items $i1 and $i2 respectively. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $i1 and $i2 are both atomic values, they are deep-equal if and only if ($i1 eq $i2) is true. Or if both values are NaN. If the eq operator is not defined for $i1 and $i2, the function returns false. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If one of the pair $i1 or $i2 is an atomic value and the other is a node, the function returns false. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $i1 and $i2 are both nodes, they are compared as described below: </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the two nodes are of different kinds, the result is false. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the two nodes are both document nodes then they are deep-equal if and only if the sequence $i1/(*|text()) is deep-equal to the sequence $i2/(*|text()). </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the two nodes are both element nodes then they are deep-equal if and only if all of the following conditions are satisfied: </p> <ol xmlns=\"http://www.w3.org/1999/xhtml\"> <li>the two nodes have the same name, that is (node-name($i1) eq node-name($i2)).</li> <li>the two nodes are both annotated as having simple content or both nodes are annotated as having complex content.</li> <li>the two nodes have the same number of attributes, and for every attribute $a1 in $i1/@* there exists an attribute $a2 in $i2/@* such that $a1 and $a2 are deep-equal. </li> <li>One of the following conditions holds: <ul> <li>Both element nodes have a type annotation that is simple content, and the typed value of $i1 is deep-equal to the typed value of $i2. </li> <li>Both element nodes have a type annotation that is complex content with elementOnly content, and each child element of $i1 is deep-equal to the corresponding child element of $i2. </li> <li>Both element nodes have a type annotation that is complex content with mixed content, and the sequence $i1/(*|text()) is deep-equal to the sequence $i2/(*|text()). </li> <li>Both element nodes have a type annotation that is complex content with empty content. </li> </ul> </li> </ol> <p xmlns=\"http://www.w3.org/1999/xhtml\"> If the two nodes are both attribute nodes then they are deep-equal if and only if both the following conditions are satisfied: </p> <ol xmlns=\"http://www.w3.org/1999/xhtml\"> <li>the two nodes have the same name, that is (node-name($i1) eq node-name($i2)).</li> <li>the typed value of $i1 is deep-equal to the typed value of $i2.</li> </ol> <p xmlns=\"http://www.w3.org/1999/xhtml\"> If the two nodes are both processing instruction nodes or namespace bindings, then they are deep-equal if and only if both the following conditions are satisfied: </p> <ol xmlns=\"http://www.w3.org/1999/xhtml\"> <li>the two nodes have the same name, that is (node-name($i1) eq node-name($i2)). </li> <li>the string value of $i1 is equal to the string value of $i2.</li> </ol> <p xmlns=\"http://www.w3.org/1999/xhtml\"> If the two nodes are both text nodes or comment nodes, then they are deep-equal if and only if their string-values are equal. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Notes: </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The two nodes are not required to have the same type annotation, and they are not required to have the same in-scope namespaces. They may also differ in their parent, their base URI, and the values returned by the is-id and is-idrefs accesors (see Section 5.5 is-id Accessor[DM] and Section 5.6 is-idrefs Accessor[DM]). The order of children is significant, but the order of attributes is insignificant. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The following note applies to the Jan 2007 XQuery specification, but not to the May 2003 XQuery specification: The contents of comments and processing instructions are significant only if these nodes appear directly as items in the two sequences being compared. The content of a comment or processing instruction that appears as a descendant of an item in one of the sequences being compared does not affect the result. However, the presence of a comment or processing instruction, if it causes a text node to be split into two text nodes, may affect the result. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The result of fn:deep-equal(1, current-dateTime()) is false; it does not raise an error. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:deep-equal\">Complete Information for fn:deep-equal</a></div></div>");
        fDocs.put("fn:count", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:count(</div><div style=\"padding-left:2em;\">arg as item()*,</div><div style=\"padding-left:2em;\">[maximum as xs:double]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">Returns the number of items in the value of $arg. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns 0 if $arg is the empty sequence. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:count\">Complete Information for fn:count</a></div></div>");
        fDocs.put("fn:avg", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:avg(</div><div style=\"padding-left:2em;\">arg as xs:anyAtomicType*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns the average of the values in the input sequence $arg, that is, the sum of the values divided by the number of values. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg is the empty sequence, the empty sequence is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If $arg contains values of type xs:untypedAtomic they are cast to xs:double. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Duration values must either all be xs:yearMonthDuration values or must all be xs:dayTimeDuration values. For numeric values, the numeric promotion rules defined in 6.2 Operators on Numeric Values are used to promote all values to a single common type. After these operations, $arg must contain items of a single type, which must be one of the four numeric types,xs:yearMonthDuration or xs:dayTimeDuration or one if its subtypes. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the above conditions are not met, then a type error is raised [err:FORG0006]. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Otherwise, returns the average of the values computed as sum($arg) div count($arg). </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For detailed type semantics, see <a href=\"http://www.w3.org/TR/xquery-semantics/#sec_fn_aggregates\">Section 7.2.10 The fn:min, fn:max, fn:avg, and fn:sum functions[FS]</a>. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:avg\">Complete Information for fn:avg</a></div></div>");
        fDocs.put("fn:max", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:max(</div><div style=\"padding-left:2em;\">arg as xs:anyAtomicType*,</div><div style=\"padding-left:2em;\">[collation as xs:string]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Selects an item from the input sequence $arg whose value is greater than or equal to the value of every other item in the input sequence. If there are two or more such items, then the specific item whose value is returned is implementation dependent. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The following rules are applied to the input sequence: </p> <ul xmlns=\"http://www.w3.org/1999/xhtml\"> <li>Values of type xs:untypedAtomic in $arg are cast to xs:double.</li> <li>For numeric values, the numeric promotion rules defined in 6.2 Operators on Numeric Values are used to promote all values to a single common type. </li> </ul> <p xmlns=\"http://www.w3.org/1999/xhtml\"> The items in the resulting sequence may be reordered in an arbitrary order. The resulting sequence is referred to below as the converted sequence.This function returns an item from the converted sequence rather than the input sequence. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the converted sequence is empty, the empty sequence is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> All items in $arg must be numeric or derived from a single base type for which the ge operator is defined. In addition, the values in the sequence must have a total order. If date/time values do not have a timezone, they are considered to have the implicit timezone provided by the dynamic context for purposes of comparison. Duration values must either all be xs:yearMonthDuration values or must all be xs:dayTimeDuration values. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If any of these conditions is not met, then a type error is raised [err:FORG0006]. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the converted sequence contains the value NaN, the value NaN is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the items in the value of $arg are of type xs:string or types derived by restriction from xs:string, then the determination of the item with the largest value is made according to the collation that is used. If the type of the items in $arg is not xs:string and $collation is specified, the collation is ignored. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The collation used by the invocation of this function is determined according to the rules in 7.3.1 Collations. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Otherwise, the result of the function is the result of the expression: </p><pre xml:space=\"preserve\" xmlns=\"http://www.w3.org/1999/xhtml\"> if (every $v in $c satisfies $c[1] ge $v) then $c[1] else fn:max(fn:subsequence($c, 2)) </pre> <p xmlns=\"http://www.w3.org/1999/xhtml\"> evaluated with $collation as the default collation if specified, and with $c as the converted sequence. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For detailed type semantics, see <a href=\"http://www.w3.org/TR/xquery-semantics/#sec_fn_aggregates\">Section 7.2.10 The fn:min, fn:max, fn:avg, and fn:sum functions[FS]</a>. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Notes: </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the converted sequence contains exactly one value then that value is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The default type when the fn:max function is applied to xs:untypedAtomic values is xs:double. This differs from the default type for operators such as gt, and for sorting in XQuery and XSLT, which is xs:string. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:max\">Complete Information for fn:max</a></div></div>");
        fDocs.put("fn:min", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:min(</div><div style=\"padding-left:2em;\">arg as xs:anyAtomicType*,</div><div style=\"padding-left:2em;\">[collation as xs:string]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Selects an item from the input sequence $arg whose value is less than or equal to the value of every other item in the input sequence. If there are two or more such items, then the specific item whose value is returned is implementation dependent. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The following rules are applied to the input sequence: </p> <ul xmlns=\"http://www.w3.org/1999/xhtml\"> <li>Values of type xs:untypedAtomic in $arg are cast to xs:double.</li> <li>For numeric values, the numeric promotion rules defined in 6.2 Operators on Numeric Values are used to promote all values to a single common type. </li> </ul> <p xmlns=\"http://www.w3.org/1999/xhtml\"> The items in the resulting sequence may be reordered in an arbitrary order. The resulting sequence is referred to below as the converted sequence.This function returns an item from the converted sequence rather than the input sequence. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the converted sequence is empty, the empty sequence is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> All items in $arg must be numeric or derived from a single base type for which the le operator is defined. In addition, the values in the sequence must have a total order. If date/time values do not have a timezone, they are considered to have the implicit timezone provided by the dynamic context for purposes of comparison. Duration values must either all be xs:yearMonthDuration values or must all be xs:dayTimeDuration values. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If any of these conditions is not met, then a type error is raised [err:FORG0006]. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the converted sequence contains the value NaN, the value NaN is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the items in the value of $arg are of type xs:string or types derived by restriction from xs:string, then the determination of the item with the largest value is made according to the collation that is used. If the type of the items in $arg is not xs:string and $collation is specified, the collation is ignored. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The collation used by the invocation of this function is determined according to the rules in 7.3.1 Collations. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Otherwise, the result of the function is the result of the expression: </p><pre xml:space=\"preserve\" xmlns=\"http://www.w3.org/1999/xhtml\"> if (every $v in $c satisfies $c[1] le $v) then $c[1] else fn:min(fn:subsequence($c, 2)) </pre> <p xmlns=\"http://www.w3.org/1999/xhtml\"> evaluated with $collation as the default collation if specified, and with $c as the converted sequence. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For detailed type semantics, see <a href=\"http://www.w3.org/TR/xquery-semantics/#sec_fn_aggregates\">Section 7.2.10 The fn:min, fn:max, fn:avg, and fn:sum functions[FS]</a>. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Notes: </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the converted sequence contains exactly one value then that value is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The default type when the fn:min function is applied to xs:untypedAtomic values is xs:double. This differs from the default type for operators such as gt, and for sorting in XQuery and XSLT, which is xs:string. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:min\">Complete Information for fn:min</a></div></div>");
        fDocs.put("fn:sum", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:sum(</div><div style=\"padding-left:2em;\">arg as xs:anyAtomicType*,</div><div style=\"padding-left:2em;\">[zero as xs:anyAtomicType?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns a value obtained by adding together the values in $arg. If $zero is not specified, then the value returned for an empty sequence is the xs:integer value 0. If $zero is specified, then the value returned for an empty sequence is $zero. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Any values of type xs:untypedAtomic in $arg are cast to xs:double. The items in the resulting sequence may be reordered in an arbitrary order. The resulting sequence is referred to below as the converted sequence. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the converted sequence is empty, then the single-argument form of the function returns the xs:integer value 0; the two-argument form returns the value of the argument $zero. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the converted sequence contains the value NaN, NaN is returned. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> All items in $arg must be numeric or derived from a single base type. In addition, the type must support addition. Duration values must either all be xs:yearMonthDuration values or must all be xs:dayTimeDuration values. For numeric values, the numeric promotion rules defined in 6.2 Operators on Numeric Values are used to promote all values to a single common type. The sum of a sequence of integers will therefore be an integer, while the sum of a numeric sequence that includes at least one xs:double will be an xs:double. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the above conditions are not met, a type error is raised [err:FORG0006]. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Otherwise, the result of the function, using the second signature, is the result of the expression: </p><pre xml:space=\"preserve\" xmlns=\"http://www.w3.org/1999/xhtml\"> if (fn:count($c) eq 0) then $zero else if (fn:count($c) eq 1) then $c[1] else $c[1] + fn:sum(subsequence($c, 2)) </pre> <p xmlns=\"http://www.w3.org/1999/xhtml\"> where $c is the converted sequence. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The result of the function, using the first signature, is the result of the expression:fn:sum($arg, 0). </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> For detailed type semantics, see <a href=\"http://www.w3.org/TR/xquery-semantics/#sec_fn_aggregates\">Section 7.2.10 The fn:min, fn:max, fn:avg, and fn:sum functions[FS]</a>. </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> Notes: </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> The second argument allows an appropriate value to be defined to represent the sum of an empty sequence. For example, when summing a sequence of durations it would be appropriate to return a zero-length duration of the appropriate type. This argument is necessary because a system that does dynamic typing cannot distinguish \"an empty sequence of integers\", for example, from \"an empty sequence of durations\". </p><p xmlns=\"http://www.w3.org/1999/xhtml\"> If the converted sequence contains exactly one value then that value is returned. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:sum\">Complete Information for fn:sum</a></div></div>");
        fDocs.put("fn:id", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:id(</div><div style=\"padding-left:2em;\">arg as xs:string*,</div><div style=\"padding-left:2em;\">[node as node()]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns the sequence of element nodes that have an ID value matching the value of one or more of the IDREF values supplied in $arg. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:id\">Complete Information for fn:id</a></div></div>");
        fDocs.put("fn:idref", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:idref(</div><div style=\"padding-left:2em;\">arg as xs:string*,</div><div style=\"padding-left:2em;\">[node as node()]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\"> Returns the sequence of element or attribute nodes that have an IDREF value matching the value of one or more of the ID values supplied in $arg. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:idref\">Complete Information for fn:idref</a></div></div>");
        fDocs.put("fn:doc", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:doc(</div><div style=\"padding-left:2em;\">[uri as xs:string*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the document(s) stored in the database at the specified URI(s). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:doc\">Complete Information for fn:doc</a></div></div>");
        fDocs.put("fn:doc-available", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:doc-available(</div><div style=\"padding-left:2em;\">uri as xs:string?</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> <p xmlns=\"http://www.w3.org/1999/xhtml\">If fn:doc($uri) returns a document node, this function returns true. If $uri is not a valid xs:anyURI, an error is raised [err:FODC0005]. Otherwise, this function returns false. </p> <p xmlns=\"http://www.w3.org/1999/xhtml\">If this function returns true, then calling fn:doc($uri) within the same execution scope must return a document node. </p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:doc-available\">Complete Information for fn:doc-available</a></div></div>");
        fDocs.put("fn:collection", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">fn:collection(</div><div style=\"padding-left:2em;\">[uri as xs:string*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns all of the documents that belong to the specified collection(s). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:fn:collection\">Complete Information for fn:collection</a></div></div>");
        fDocs.put("xdmp:strftime", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:strftime(</div><div style=\"padding-left:2em;\">format as xs:string,</div><div style=\"padding-left:2em;\">value as xs:dateTime</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Formats a dateTime value using POSIX strftime. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:strftime\">Complete Information for xdmp:strftime</a></div></div>");
        fDocs.put("xdmp:exists", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:exists(</div><div style=\"padding-left:2em;\">expression as item()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns true if any fragment is selected by an expression, false if no fragments are selected. This can be used as a fast existence check. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:exists\">Complete Information for xdmp:exists</a></div></div>");
        fDocs.put("xdmp:estimate", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:estimate(</div><div style=\"padding-left:2em;\">expression as item()*,</div><div style=\"padding-left:2em;\">[maximum as xs:double?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the number of fragments selected by an expression. This can be used as a fast estimate of the number of items in a sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:estimate\">Complete Information for xdmp:estimate</a></div></div>");
        fDocs.put("xdmp:version", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:version(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the current MarkLogic Server version. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:version\">Complete Information for xdmp:version</a></div></div>");
        fDocs.put("xdmp:xquery-version", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:xquery-version(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the XQuery language version of the calling module. Currently supported XQuery versions are: <ul xmlns=\"http://www.w3.org/1999/xhtml\"> <li>\"0.9-ml\": The legacy Mark Logic XQuery version. This was the only XQuery version available on MarkLogic Server 3.2 and earlier. It is based on the May 2003 XQuery Draft Recommendation, with Mark Logic extensions </li> <li>\"1.0-ml\": XQuery version 1.0, with Mark Logic extensions. This is the preferred version of XQuery beginning with release 4.0. </li> <li>\"1.0\": Strict XQuery version 1.0. This XQuery version complies as closely as possible with the published XQuery 1.0 specification. </li> </ul> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:xquery-version\">Complete Information for xdmp:xquery-version</a></div></div>");
        fDocs.put("xdmp:platform", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:platform(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the operating-system platform upon which MarkLogic Server is running (\"solaris\", \"winnt\", or \"linux\"). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:platform\">Complete Information for xdmp:platform</a></div></div>");
        fDocs.put("xdmp:architecture", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:architecture(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the hardware architecture upon which MarkLogic Server is running. If <code xmlns=\"http://www.w3.org/1999/xhtml\">xdmp:platform()</code> returns \"linux\", it will return \"x86_64\" or \"i686. If <code xmlns=\"http://www.w3.org/1999/xhtml\">xdmp:platform()</code> returns \"solaris\", it will return \"amd64\" or \"sparcv9\". If <code xmlns=\"http://www.w3.org/1999/xhtml\">xdmp:platform()</code> returns \"winnt\", it will return \"amd64\" or \"i686\". </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:architecture\">Complete Information for xdmp:architecture</a></div></div>");
        fDocs.put("xdmp:path", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:path(</div><div style=\"padding-left:2em;\">node as node(),</div><div style=\"padding-left:2em;\">[include-document as xs:boolean?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a string whose value corresponds to the path of the node. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:path\">Complete Information for xdmp:path</a></div></div>");
        fDocs.put("xdmp:describe", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:describe(</div><div style=\"padding-left:2em;\">item as item()*,</div><div style=\"padding-left:2em;\">[maxSequenceLength as xs:unsignedInt?,]</div><div style=\"padding-left:2em;\">[maxItemLength as xs:unsignedInt*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a string representing the description of a given item sequence. If you take the output of the <code xmlns=\"http://www.w3.org/1999/xhtml\">xdmp:describe</code> function and evaluate it as an XQuery program, it returns the item(s) input to the function. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:describe\">Complete Information for xdmp:describe</a></div></div>");
        fDocs.put("xdmp:hash32", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:hash32(</div><div style=\"padding-left:2em;\">string as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the 32-bit hash of a string. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:hash32\">Complete Information for xdmp:hash32</a></div></div>");
        fDocs.put("xdmp:hash64", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:hash64(</div><div style=\"padding-left:2em;\">string as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the 64-bit hash of a string. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:hash64\">Complete Information for xdmp:hash64</a></div></div>");
        fDocs.put("xdmp:random", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:random(</div><div style=\"padding-left:2em;\">[max as xs:unsignedLong]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a random unsigned integer between 0 and a number up to 64 bits long. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:random\">Complete Information for xdmp:random</a></div></div>");
        fDocs.put("xdmp:hex-to-integer", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:hex-to-integer(</div><div style=\"padding-left:2em;\">hex as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Parses a hexadecimal string, returning an integer. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:hex-to-integer\">Complete Information for xdmp:hex-to-integer</a></div></div>");
        fDocs.put("xdmp:integer-to-hex", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:integer-to-hex(</div><div style=\"padding-left:2em;\">val as xs:integer</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a hexadecimal representation of an integer. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:integer-to-hex\">Complete Information for xdmp:integer-to-hex</a></div></div>");
        fDocs.put("xdmp:octal-to-integer", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:octal-to-integer(</div><div style=\"padding-left:2em;\">octal as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Parses an octal string, returning an integer. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:octal-to-integer\">Complete Information for xdmp:octal-to-integer</a></div></div>");
        fDocs.put("xdmp:integer-to-octal", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:integer-to-octal(</div><div style=\"padding-left:2em;\">val as xs:integer</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns an octal representation of an integer. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:integer-to-octal\">Complete Information for xdmp:integer-to-octal</a></div></div>");
        fDocs.put("xdmp:request-timestamp", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:request-timestamp(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the system timestamp for this request if the request is a query statement. Returns the empty sequence if the current request is an update statement. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:request-timestamp\">Complete Information for xdmp:request-timestamp</a></div></div>");
        fDocs.put("xdmp:eval", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:eval(</div><div style=\"padding-left:2em;\">xquery as xs:string,</div><div style=\"padding-left:2em;\">[vars as item()*,]</div><div style=\"padding-left:2em;\">[options as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the result of evaluating a string as an XQuery module. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:eval\">Complete Information for xdmp:eval</a></div></div>");
        fDocs.put("xdmp:eval-in", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:eval-in(</div><div style=\"padding-left:2em;\">xquery as xs:string,</div><div style=\"padding-left:2em;\">ID as xs:unsignedLong,</div><div style=\"padding-left:2em;\">[vars as item()*,]</div><div style=\"padding-left:2em;\">[modules as xs:unsignedLong?,]</div><div style=\"padding-left:2em;\">[root as xs:string?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> [DEPRECATED: use <a href=\"#xdmp:eval\" xmlns=\"http://www.w3.org/1999/xhtml\"><code>xdmp:eval</code></a> with the database option instead] Returns the result of evaluating a string as an XQuery module in a given database. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:eval-in\">Complete Information for xdmp:eval-in</a></div></div>");
        fDocs.put("xdmp:invoke", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:invoke(</div><div style=\"padding-left:2em;\">path as xs:string,</div><div style=\"padding-left:2em;\">[vars as item()*,]</div><div style=\"padding-left:2em;\">[options as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the result of evaluating a module at the given path. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:invoke\">Complete Information for xdmp:invoke</a></div></div>");
        fDocs.put("xdmp:invoke-in", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:invoke-in(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">ID as xs:unsignedLong,</div><div style=\"padding-left:2em;\">[vars as item()*,]</div><div style=\"padding-left:2em;\">[modules as xs:unsignedLong?,]</div><div style=\"padding-left:2em;\">[root as xs:string?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> [DEPRECATED: use <a href=\"#xdmp:invoke\" xmlns=\"http://www.w3.org/1999/xhtml\"><code>xdmp:invoke</code></a> with the database option instead] Returns the result of evaluating a module at the given path. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:invoke-in\">Complete Information for xdmp:invoke-in</a></div></div>");
        fDocs.put("xdmp:security-database", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:security-database(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the database ID of the security database associated with the current database. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:security-database\">Complete Information for xdmp:security-database</a></div></div>");
        fDocs.put("xdmp:schema-database", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:schema-database(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the database ID of the schema database associated with the current database. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:schema-database\">Complete Information for xdmp:schema-database</a></div></div>");
        fDocs.put("xdmp:modules-database", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:modules-database(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the database ID of the modules database. Returns 0 if the current App Server uses the file system for its modules. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:modules-database\">Complete Information for xdmp:modules-database</a></div></div>");
        fDocs.put("xdmp:triggers-database", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:triggers-database(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the database ID of the triggers database associated with the current database. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:triggers-database\">Complete Information for xdmp:triggers-database</a></div></div>");
        fDocs.put("xdmp:quote", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:quote(</div><div style=\"padding-left:2em;\">arg as item()*,</div><div style=\"padding-left:2em;\">[options as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the unevaluated serialized representation of the input parameter as a string. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:quote\">Complete Information for xdmp:quote</a></div></div>");
        fDocs.put("xdmp:unquote", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:unquote(</div><div style=\"padding-left:2em;\">arg as xs:string,</div><div style=\"padding-left:2em;\">[default-namespace as xs:string?,]</div><div style=\"padding-left:2em;\">[options as xs:string*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Parses a string as XML, returning one or more document nodes. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:unquote\">Complete Information for xdmp:unquote</a></div></div>");
        fDocs.put("xdmp:log", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:log(</div><div style=\"padding-left:2em;\">msg as item()*,</div><div style=\"padding-left:2em;\">[level as xs:string?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Logs a debug message to the log file <code xmlns=\"http://www.w3.org/1999/xhtml\">&lt;install_dir&gt;/Logs/ErrorLog.txt</code>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:log\">Complete Information for xdmp:log</a></div></div>");
        fDocs.put("xdmp:log-level", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:log-level(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Retrieves the current server log level. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:log-level\">Complete Information for xdmp:log-level</a></div></div>");
        fDocs.put("xdmp:query-meters", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:query-meters(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the current value of the resource meters for this query sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:query-meters\">Complete Information for xdmp:query-meters</a></div></div>");
        fDocs.put("xdmp:elapsed-time", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:elapsed-time(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the elapsed time since the start of processing of this query. Gives the same information as the <code xmlns=\"http://www.w3.org/1999/xhtml\">elapsed-time</code> element of the <code xmlns=\"http://www.w3.org/1999/xhtml\">xdmp:query-meters</code> output, but has less overhead than calling <code xmlns=\"http://www.w3.org/1999/xhtml\">xdmp:query-meters</code>. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:elapsed-time\">Complete Information for xdmp:elapsed-time</a></div></div>");
        fDocs.put("xdmp:query-trace", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:query-trace(</div><div style=\"padding-left:2em;\">enabled as xs:boolean</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Enables or disables tracing of this query. When query tracing is enabled, \"info\" level messages are logged detailing the search optimizations performed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:query-trace\">Complete Information for xdmp:query-trace</a></div></div>");
        fDocs.put("xdmp:node-uri", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:node-uri(</div><div style=\"padding-left:2em;\">node as node()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the document-uri property of the parameter or its ancestor. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:node-uri\">Complete Information for xdmp:node-uri</a></div></div>");
        fDocs.put("xdmp:node-database", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:node-database(</div><div style=\"padding-left:2em;\">node as node()</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the database id where the parameter is stored. If the specified node does not come from a document in a database, then <code xmlns=\"http://www.w3.org/1999/xhtml\">xdmp:node-database</code> returns an empty list. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:node-database\">Complete Information for xdmp:node-database</a></div></div>");
        fDocs.put("xdmp:product-edition", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:product-edition(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the current Mark Logic product edition. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:product-edition\">Complete Information for xdmp:product-edition</a></div></div>");
        fDocs.put("xdmp:document-locks", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:document-locks(</div><div style=\"padding-left:2em;\">[uri as xs:string*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the locks for one or more documents or directories. Returns the locks for all documents and directories in the database if no parameter is given. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:document-locks\">Complete Information for xdmp:document-locks</a></div></div>");
        fDocs.put("xdmp:document-properties", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:document-properties(</div><div style=\"padding-left:2em;\">[uri as xs:string*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of properties documents, one for each of the specified documents that has a corresponding properties document. If no documents are specified, returns a sequence of properties documents for all documents in the database that have a corresponding properties document. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:document-properties\">Complete Information for xdmp:document-properties</a></div></div>");
        fDocs.put("xdmp:document-get-quality", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:document-get-quality(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the quality of the specified document if the document exists. Otherwise, returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:document-get-quality\">Complete Information for xdmp:document-get-quality</a></div></div>");
        fDocs.put("xdmp:document-forest", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:document-forest(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">[forest-ids as xs:unsignedLong*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the forest ID of the forest in which a document (or a lock or a property) with the specified URI is stored. Otherwise, returns the empty sequence. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:document-forest\">Complete Information for xdmp:document-forest</a></div></div>");
        fDocs.put("xdmp:forest", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:forest(</div><div style=\"padding-left:2em;\">name as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the the ID of the forest specified as the parameter. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:forest\">Complete Information for xdmp:forest</a></div></div>");
        fDocs.put("xdmp:database", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:database(</div><div style=\"padding-left:2em;\">[name as xs:string]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the the ID of the database named in the the parameter. Returns the ID of the current database if no parameter is specified. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:database\">Complete Information for xdmp:database</a></div></div>");
        fDocs.put("xdmp:database-forests", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:database-forests(</div><div style=\"padding-left:2em;\">database as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of forest IDs in the specified database. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:database-forests\">Complete Information for xdmp:database-forests</a></div></div>");
        fDocs.put("xdmp:database-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:database-name(</div><div style=\"padding-left:2em;\">id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Return the name of the database with the given ID. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:database-name\">Complete Information for xdmp:database-name</a></div></div>");
        fDocs.put("xdmp:server-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:server-name(</div><div style=\"padding-left:2em;\">id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Return the name of the App Server with the given ID. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:server-name\">Complete Information for xdmp:server-name</a></div></div>");
        fDocs.put("xdmp:forest-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:forest-name(</div><div style=\"padding-left:2em;\">id as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Return the name of the forest with the given id. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:forest-name\">Complete Information for xdmp:forest-name</a></div></div>");
        fDocs.put("xdmp:databases", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:databases(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of the IDs of all the databases in the system. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:databases\">Complete Information for xdmp:databases</a></div></div>");
        fDocs.put("xdmp:forests", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:forests(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of the IDs of all the forests in the system. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:forests\">Complete Information for xdmp:forests</a></div></div>");
        fDocs.put("xdmp:forest-databases", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:forest-databases(</div><div style=\"padding-left:2em;\">forest as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the database ID corresponding to the database to which the specified forest belongs. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:forest-databases\">Complete Information for xdmp:forest-databases</a></div></div>");
        fDocs.put("xdmp:document-get", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:document-get(</div><div style=\"padding-left:2em;\">location as xs:string,</div><div style=\"padding-left:2em;\">[options as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the document in the file specified by $location. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:document-get\">Complete Information for xdmp:document-get</a></div></div>");
        fDocs.put("xdmp:get", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:get(</div><div style=\"padding-left:2em;\">path as xs:string,</div><div style=\"padding-left:2em;\">[default-namespace as xs:string?,]</div><div style=\"padding-left:2em;\">[options as xs:string*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> [DEPRECATED: use <a href=\"#xdmp:document-get\" xmlns=\"http://www.w3.org/1999/xhtml\"><code>xdmp:document-get</code></a> instead] Returns the document in the XML file specified by $path. <p xmlns=\"http://www.w3.org/1999/xhtml\">This function is deprecated and will be removed from a future release. Use <a href=\"#xdmp:document-get\"><code>xdmp:document-get</code></a> instead.</p> </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:get\">Complete Information for xdmp:get</a></div></div>");
        fDocs.put("xdmp:directory", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:directory(</div><div style=\"padding-left:2em;\">uri as xs:string*,</div><div style=\"padding-left:2em;\">[depth as xs:string?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the documents in a directory. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:directory\">Complete Information for xdmp:directory</a></div></div>");
        fDocs.put("xdmp:directory-properties", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:directory-properties(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">[depth as xs:string?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of properties documents, one for each document in the specified directory that has a corresponding properties document. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:directory-properties\">Complete Information for xdmp:directory-properties</a></div></div>");
        fDocs.put("xdmp:collection-properties", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:collection-properties(</div><div style=\"padding-left:2em;\">[uri as xs:string*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of properties documents, one for each document in the specified collection(s) that has a corresponding properties document. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:collection-properties\">Complete Information for xdmp:collection-properties</a></div></div>");
        fDocs.put("xdmp:directory-locks", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:directory-locks(</div><div style=\"padding-left:2em;\">uri as xs:string*,</div><div style=\"padding-left:2em;\">[depth as xs:string?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns locks of documents in a directory. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:directory-locks\">Complete Information for xdmp:directory-locks</a></div></div>");
        fDocs.put("xdmp:collection-locks", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:collection-locks(</div><div style=\"padding-left:2em;\">[uri as xs:string*]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns locks of documents in a collection. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:collection-locks\">Complete Information for xdmp:collection-locks</a></div></div>");
        fDocs.put("xdmp:uri-content-type", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:uri-content-type(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the content type of the given URI as matched in the mimetypes configuration. xdmp:content-type continues to work too. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:uri-content-type\">Complete Information for xdmp:uri-content-type</a></div></div>");
        fDocs.put("xdmp:uri-format", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:uri-format(</div><div style=\"padding-left:2em;\">uri as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the format of the given URI as matched in the mimetypes configuration. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:uri-format\">Complete Information for xdmp:uri-format</a></div></div>");
        fDocs.put("xdmp:document-get-properties", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:document-get-properties(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">property as xs:QName</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the property values for a document's property. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:document-get-properties\">Complete Information for xdmp:document-get-properties</a></div></div>");
        fDocs.put("xdmp:access", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:access(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">action as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns whether a given action on the specified document URI would succeed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:access\">Complete Information for xdmp:access</a></div></div>");
        fDocs.put("xdmp:http-get", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:http-get(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">[options as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Sends the http GET method to the specified URI. Returns the http response as well as whatever information is identified by the specified URI (for example, an html document). </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:http-get\">Complete Information for xdmp:http-get</a></div></div>");
        fDocs.put("xdmp:http-head", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:http-head(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">[options as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Sends the http HEAD method to the specified URI. Returns the http response header for the specified URI. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:http-head\">Complete Information for xdmp:http-head</a></div></div>");
        fDocs.put("xdmp:http-options", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:http-options(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">[options as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Sends the http OPTIONS method to the specified URI. Returns the http response for the specified URI. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:http-options\">Complete Information for xdmp:http-options</a></div></div>");
        fDocs.put("xdmp:http-delete", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:http-delete(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">[options as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Sends an http DELETE request to the http server specified in the URI to delete the specified resource. The server should respond if the request is to be completed, but a response is not guaranteed. Also, even if the server does respond, it does not guarantee that the request has been or will be completed. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:http-delete\">Complete Information for xdmp:http-delete</a></div></div>");
        fDocs.put("xdmp:http-post", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:http-post(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">[options as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Sends the http POST request to the server. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:http-post\">Complete Information for xdmp:http-post</a></div></div>");
        fDocs.put("xdmp:http-put", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:http-put(</div><div style=\"padding-left:2em;\">uri as xs:string,</div><div style=\"padding-left:2em;\">[options as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Sends an HTTP PUT request to an HTTP server. The HTTP server should return a response, which will differ depending on the action the HTTP server takes for the PUT. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:http-put\">Complete Information for xdmp:http-put</a></div></div>");
        fDocs.put("xdmp:rethrow", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:rethrow(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Rethrow the currently caught error. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:rethrow\">Complete Information for xdmp:rethrow</a></div></div>");
        fDocs.put("xdmp:base64-encode", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:base64-encode(</div><div style=\"padding-left:2em;\">plaintext as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Converts plaintext into base64-encoded string. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:base64-encode\">Complete Information for xdmp:base64-encode</a></div></div>");
        fDocs.put("xdmp:base64-decode", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:base64-decode(</div><div style=\"padding-left:2em;\">encoded as xs:string</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Converts base64-encoded string to plaintext. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:base64-decode\">Complete Information for xdmp:base64-decode</a></div></div>");
        fDocs.put("xdmp:subbinary", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:subbinary(</div><div style=\"padding-left:2em;\">source as binary(),</div><div style=\"padding-left:2em;\">starting-location as xs:double,</div><div style=\"padding-left:2em;\">[length as xs:double]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a binary node made up of a subset of the given binary node. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:subbinary\">Complete Information for xdmp:subbinary</a></div></div>");
        fDocs.put("xdmp:spawn", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:spawn(</div><div style=\"padding-left:2em;\">path as xs:string,</div><div style=\"padding-left:2em;\">[vars as item()*,]</div><div style=\"padding-left:2em;\">[options as node()?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Place the specified module on the task queue for evaluation. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:spawn\">Complete Information for xdmp:spawn</a></div></div>");
        fDocs.put("xdmp:spawn-in", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:spawn-in(</div><div style=\"padding-left:2em;\">path as xs:string,</div><div style=\"padding-left:2em;\">ID as xs:unsignedLong,</div><div style=\"padding-left:2em;\">[vars as item()*,]</div><div style=\"padding-left:2em;\">[modules as xs:unsignedLong?,]</div><div style=\"padding-left:2em;\">[root as xs:string?]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> [DEPRECATED: use <a href=\"#xdmp:spawn\" xmlns=\"http://www.w3.org/1999/xhtml\"><code>xdmp:spawn</code></a> with the database option instead] Place the specified module on the task queue for evaluation. It will be evaluated in the given database. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:spawn-in\">Complete Information for xdmp:spawn-in</a></div></div>");
        fDocs.put("xdmp:trace", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:trace(</div><div style=\"padding-left:2em;\">name as xs:string,</div><div style=\"padding-left:2em;\">value as item()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Signal a trace event. If trace events are activated and the event is enabled, the trace event is logged. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:trace\">Complete Information for xdmp:trace</a></div></div>");
        fDocs.put("xdmp:set", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:set(</div><div style=\"padding-left:2em;\">variable as item()*,</div><div style=\"padding-left:2em;\">expr as item()*</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Set the value of a variable to the specified expression. The <code xmlns=\"http://www.w3.org/1999/xhtml\">xdmp:set</code> command allows you to introduce changes to the state (side effects) of a query by changing the value of a variable to something other than what it is bound to. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:set\">Complete Information for xdmp:set</a></div></div>");
        fDocs.put("xdmp:host", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:host(</div><div style=\"padding-left:2em;\">[name as xs:string]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the the ID of the host named in the parameter. Returns the ID of the current host if no parameter is specified. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:host\">Complete Information for xdmp:host</a></div></div>");
        fDocs.put("xdmp:host-name", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:host-name(</div><div style=\"padding-left:2em;\">ID as xs:unsignedLong</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the the name of the host ID specified as the parameter. Returns the current host if no name is specified. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:host-name\">Complete Information for xdmp:host-name</a></div></div>");
        fDocs.put("xdmp:hosts", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:hosts(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns a sequence of the IDs of all the hosts in the system. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:hosts\">Complete Information for xdmp:hosts</a></div></div>");
        fDocs.put("xdmp:server", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:server(</div><div style=\"padding-left:2em;\">[name as xs:string]</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.com/xdmp/apidoc\"> Returns the the ID(s) of the App Server specified in the parameter. Returns the ID of the current App Server if no parameter is specified. </apidoc:summary></div><div style=\"margin-top:1em;\"><a style=\"font-size:.8em\" href=\"mlapidoc:xdmp:server\">Complete Information for xdmp:server</a></div></div>");
        fDocs.put("xdmp:servers", "<div><div style=\"font-family:Courier;\"><div style=\"color:#c00831;\">xdmp:servers(</div><div>)</div></div><div style=\"margin-top:1em;\"><apidoc:summary xmlns:apidoc=\"http://marklogic.c