/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.launching.marklogic;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;

public class MockStreamMonitor
implements IStreamMonitor {
    private ListenerList fListeners = new ListenerList();
    private StringBuffer fContents = new StringBuffer();

    public synchronized void addListener(IStreamListener listener) {
        this.fListeners.add((Object)listener);
    }

    private void fireStreamAppended(String text) {
        this.getNotifier().notifyAppend(text);
    }

    public synchronized String getContents() {
        return this.fContents.toString();
    }

    public synchronized void write(String text) {
        this.fContents.append(text);
        this.fireStreamAppended(text);
    }

    public synchronized void removeListener(IStreamListener listener) {
        this.fListeners.remove((Object)listener);
    }

    private ContentNotifier getNotifier() {
        return new ContentNotifier();
    }

    class ContentNotifier
    implements ISafeRunnable {
        private IStreamListener fListener;
        private String fText;

        ContentNotifier() {
        }

        public void handleException(Throwable exception) {
            DebugPlugin.log((Throwable)exception);
        }

        public void run() throws Exception {
            this.fListener.streamAppended(this.fText, (IStreamMonitor)MockStreamMonitor.this);
        }

        public void notifyAppend(String text) {
            if (text == null) {
                return;
            }
            this.fText = text;
            Object[] copiedListeners = MockStreamMonitor.this.fListeners.getListeners();
            int i = 0;
            while (i < copiedListeners.length) {
                this.fListener = (IStreamListener)copiedListeners[i];
                SafeRunner.run((ISafeRunnable)this);
                ++i;
            }
            this.fListener = null;
            this.fText = null;
        }
    }
}

