/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.launching.utils;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.wst.xquery.launching.IXQDTBuiltinDocProvider;
import org.eclipse.wst.xquery.launching.ModuleSearchPath;
import org.eclipse.wst.xquery.launching.XQDTInterpreterInstall;
import org.eclipse.wst.xquery.launching.XQDTInterpreterInstallType;
import org.eclipse.wst.xquery.launching.XQDTLaunchingPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltinModuleUtil {
    public static List<ModuleSearchPath> readBuiltinModuleSearchPaths(IInterpreterInstallType interpreterInstallType) {
        IConfigurationElement[] searchPaths;
        ArrayList<ModuleSearchPath> paths = new ArrayList<ModuleSearchPath>();
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.wst.xquery.launching", "builtinModules");
        IConfigurationElement[] iConfigurationElementArray = searchPaths = extPoint.getConfigurationElements();
        int n = searchPaths.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement searchPath = iConfigurationElementArray[n2];
            String installTypeId = searchPath.getAttribute("installType");
            if (installTypeId.equals(interpreterInstallType.getId())) {
                String path = searchPath.getAttribute("path");
                boolean relative = Boolean.parseBoolean(searchPath.getAttribute("relative"));
                paths.add(new ModuleSearchPath(path, relative));
            }
            ++n2;
        }
        return paths;
    }

    public static Map<String, String> readBuiltinDocs(IInterpreterInstallType interpreterInstallType) {
        IConfigurationElement[] searchPaths;
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.wst.xquery.launching", "builtinModules");
        IConfigurationElement[] iConfigurationElementArray = searchPaths = extPoint.getConfigurationElements();
        int n = searchPaths.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement searchPath = iConfigurationElementArray[n2];
            String installTypeId = searchPath.getAttribute("installType");
            if (installTypeId.equals(interpreterInstallType.getId())) {
                try {
                    IXQDTBuiltinDocProvider docProvider = (IXQDTBuiltinDocProvider)searchPath.createExecutableExtension("docProvider");
                    return docProvider.getDocs();
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        return new HashMap<String, String>();
    }

    public static Map<String, String> readBuiltinSources(XQDTInterpreterInstall install) {
        HashMap<String, String> sources = new HashMap<String, String>();
        Bundle bundle = FrameworkUtil.getBundle(install.getClass());
        XQDTInterpreterInstallType installType = (XQDTInterpreterInstallType)install.getInterpreterInstallType();
        ModuleSearchPath[] moduleSearchPathArray = installType.getBuiltinModuleSearchPaths();
        int n = moduleSearchPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleSearchPath searchPath = moduleSearchPathArray[n2];
            try {
                String strPath = searchPath.getPath();
                Path path = new Path(strPath);
                if (strPath.contains("${interpreterContainer}")) {
                    strPath = strPath.replace("${interpreterContainer}", install.getInstallLocation().getParent().toOSString());
                    path = new Path(strPath);
                    strPath = path.toPortableString();
                }
                if (searchPath.isRelative()) {
                    Enumeration urls = bundle.findEntries(path.toPortableString(), "*.xq*", true);
                    while (urls.hasMoreElements()) {
                        URL url = (URL)urls.nextElement();
                        String module = url.getPath().substring(url.getPath().indexOf(strPath) + strPath.length() + 1);
                        String displayName = install.getDisplayName(module);
                        String content = new String(Util.getInputStreamAsCharArray((InputStream)url.openStream(), (int)-1, (String)"UTF-8"));
                        sources.put(displayName, content);
                    }
                } else {
                    IFileSystem fs = EFS.getLocalFileSystem();
                    IFileStore st = fs.getStore((IPath)path);
                    List<IFileStore> foundStores = BuiltinModuleUtil.findModulesIn(st);
                    for (IFileStore store : foundStores) {
                        URL url = store.toURI().toURL();
                        String module = url.getPath().substring(url.getPath().indexOf(strPath) + strPath.length() + 1);
                        String displayName = install.getDisplayName(module);
                        String content = new String(Util.getInputStreamAsCharArray((InputStream)url.openStream(), (int)-1, (String)"UTF-8"));
                        sources.put(displayName, content);
                    }
                }
            }
            catch (Exception e) {
                XQDTLaunchingPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.xquery.launching", e.getMessage(), (Throwable)e));
            }
            ++n2;
        }
        return sources;
    }

    private static List<IFileStore> findModulesIn(IFileStore store) {
        ArrayList<IFileStore> results = new ArrayList<IFileStore>();
        IFileInfo info = store.fetchInfo();
        if (info.isDirectory()) {
            try {
                IFileStore[] childStores;
                IFileStore[] iFileStoreArray = childStores = store.childStores(0, null);
                int n = childStores.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileStore child = iFileStoreArray[n2];
                    results.addAll(BuiltinModuleUtil.findModulesIn(child));
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (info.exists() && info.getName().matches(".*\\.xq.{0,4}")) {
            results.add(store);
        }
        return results;
    }
}

