/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.debug.ui.launcher;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.debug.ui.launcher.AbstractScriptLaunchShortcut;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.xquery.set.core.SETProjectConfig;
import org.eclipse.wst.xquery.set.core.SETProjectConfigUtil;
import org.eclipse.wst.xquery.set.internal.ui.SETEditProjectConfigDialog;

public class SETLaunchShortcut
extends AbstractScriptLaunchShortcut {
    protected ILaunchConfigurationType getConfigurationType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.wst.xquery.set.launching.SETLaunchConfigurationType");
    }

    protected String getNatureId() {
        return "org.eclipse.wst.xquery.set.core.nature";
    }

    protected String getScriptSelectionTitle() {
        return "Select a handler function to launch";
    }

    protected String getSelectionEmptyMessage() {
        return "The project contains no handler modules";
    }

    protected IResource[] findScripts(Object[] elements, IRunnableContext context) throws InterruptedException, CoreException {
        IProject p;
        IFolder hd;
        IResource r = null;
        if (elements[0] instanceof IModelElement) {
            IModelElement me = (IModelElement)elements[0];
            r = me.getUnderlyingResource();
            if (r == null) {
                r = me.getScriptProject().getUnderlyingResource();
            }
        } else if (elements[0] instanceof IResource) {
            r = (IResource)elements[0];
        } else {
            return new IResource[0];
        }
        if (!(hd = (p = r.getProject()).getFolder("handlers")).exists()) {
            return new IResource[0];
        }
        IScriptProject sp = DLTKCore.create((IProject)p);
        return super.findScripts(new Object[]{sp.getProjectFragment((IResource)hd)}, context);
    }

    protected ILaunchConfiguration createConfiguration(IProject project, String startPage) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = this.getConfigurationType();
            String name = project.getName();
            wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(name));
            wc.setAttribute("nature", this.getNatureId());
            wc.setAttribute("project", project.getName());
            wc.setAttribute("mainScript", startPage);
            wc.setAttribute("xqdt_set_host", "127.0.0.1");
            wc.setAttribute("xqdt_set_port", 8080);
            wc.setAttribute("xqdt_set_indent", true);
            wc.setAttribute("xqdt_set_cear_collections", false);
            wc.setMappedResources(new IResource[]{project});
            config = wc.doSave();
        }
        catch (CoreException exception) {
            exception.printStackTrace();
        }
        return config;
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return;
        }
        IFile script = ((IFileEditorInput)editorInput).getFile();
        if (script != null) {
            this.launch((IResource)script, mode);
        }
    }

    protected void launch(IResource resource, String mode) {
        this.searchAndLaunch(new Object[]{resource}, mode, this.getScriptSelectionTitle(), this.getSelectionEmptyMessage());
    }

    public void searchAndLaunch(Object[] search, String mode, String selectMessage, String emptyMessage) {
        IProject project;
        block8: {
            if (search == null || search.length != 1) {
                return;
            }
            project = null;
            if (search[0] instanceof IModelElement) {
                IModelElement me = (IModelElement)search[0];
                project = me.getScriptProject().getProject();
            } else {
                if (search[0] instanceof IResource) {
                    IResource res = (IResource)search[0];
                    project = res.getProject();
                    try {
                        if (!project.hasNature("org.eclipse.wst.xquery.set.core.nature")) {
                            return;
                        }
                        break block8;
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        return;
                    }
                }
                return;
            }
        }
        SETProjectConfig config = SETProjectConfigUtil.readProjectConfig((IProject)project);
        String startPage = config.getStartPage();
        if (startPage == null) {
            startPage = SETEditProjectConfigDialog.getHandlerFunctionStartPage((IProject)project, (Shell)this.getShell());
        }
        this.launch(project, startPage, mode);
    }

    protected void launch(IProject project, String startPage, String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(project, startPage, this.getConfigurationType());
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(IProject project, String startPage, ILaunchConfigurationType configType) {
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute("mainScript", "").equals(startPage) && config.getAttribute("project", "").equals(project.getName())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            DLTKLaunchingPlugin.log((Throwable)e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(project, startPage);
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs);
        if (config != null) {
            return config;
        }
        return null;
    }
}

