/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelHelper;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.ui.wizards.buildpath.FolderSelectionDialog;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.xquery.core.model.ast.XQueryLibraryModule;
import org.eclipse.wst.xquery.internal.core.parser.XQDTSourceParser;
import org.eclipse.wst.xquery.set.core.SETProjectConfig;
import org.eclipse.wst.xquery.set.core.SETProjectConfigUtil;

public class SETImportModuleWizardPage
extends WizardPage
implements IDialogFieldListener {
    private static final String TEMP_DIR = ".config/temp/";
    protected StringButtonDialogField fModuleFileField;
    protected StringButtonDialogField fProjectField;
    protected StringDialogField fModuleNameField;
    protected ComboDialogField fModuleExtensionField;
    protected SelectionButtonDialogField fHandlerModuleSelectionField;
    protected SelectionButtonDialogField fLibraryModuleSelectionField;
    protected SelectionButtonDialogField fExternalModuleSelectionField;
    protected StringButtonDialogField fLibraryModulePathField;
    protected StringButtonDialogField fExternalModulePathField;
    protected Group fModuleTypeGroup;
    protected Composite fLibraryModuleComposite;
    protected Composite fExternalModuleComposite;
    private String[] fExtensions;
    private boolean fIsGroupEnabled;
    private IStructuredSelection fSelection;
    private IFile f;

    protected SETImportModuleWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription("Import a XQuery module from the local file system into a Sausalito project");
        this.fExtensions = ContentTypeManager.getInstance().getContentType("org.eclipse.wst.xquery.XQueryContentType").getFileSpecs(8);
        int i = 0;
        while (i < this.fExtensions.length) {
            this.fExtensions[i] = "." + this.fExtensions[i];
            ++i;
        }
        this.fSelection = selection;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        int numCols = 4;
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(numCols, false));
        this.fModuleFileField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                SETImportModuleWizardPage.this.handleModuleFileButtonSelected();
            }
        });
        this.fModuleFileField.setLabelText("Select module file:");
        this.fModuleFileField.setButtonLabel("Browse...");
        this.fModuleFileField.doFillIntoGrid(composite, numCols);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fModuleFileField.getTextControl(null).setLayoutData((Object)gd);
        this.fProjectField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                SETImportModuleWizardPage.this.handleProjectButtonSelected();
            }
        });
        this.fProjectField.setLabelText("Select project:");
        this.fProjectField.setButtonLabel("Select...");
        this.fProjectField.doFillIntoGrid(composite, numCols);
        Text text = this.fProjectField.getTextControl(null);
        gd = new GridData(776);
        gd.horizontalSpan = 2;
        text.setLayoutData((Object)gd);
        text.setEditable(false);
        this.fModuleNameField = new StringDialogField();
        this.fModuleNameField.setLabelText("Module name:");
        this.fModuleNameField.doFillIntoGrid(composite, 2);
        this.fModuleNameField.getTextControl(null).setLayoutData((Object)new GridData(768));
        this.fModuleExtensionField = new ComboDialogField(8);
        this.fModuleExtensionField.setLabelText("File extension:");
        this.fModuleExtensionField.doFillIntoGrid(composite, 2);
        this.fModuleExtensionField.setItems(this.fExtensions);
        this.fModuleExtensionField.getComboControl(null).select(0);
        this.createVerticalSpacer(composite, numCols);
        this.fModuleTypeGroup = new Group(composite, 0);
        this.fModuleTypeGroup.setLayout((Layout)new GridLayout(numCols, false));
        gd = new GridData(768);
        gd.horizontalSpan = numCols;
        this.fModuleTypeGroup.setLayoutData((Object)gd);
        this.fModuleTypeGroup.setText("Module type");
        this.createVerticalSpacer((Composite)this.fModuleTypeGroup, numCols);
        this.fHandlerModuleSelectionField = new SelectionButtonDialogField(16);
        this.fHandlerModuleSelectionField.setLabelText("&Handler module");
        this.fHandlerModuleSelectionField.doFillIntoGrid((Composite)this.fModuleTypeGroup, numCols);
        this.fHandlerModuleSelectionField.setSelection(true);
        GridLayout layout = new GridLayout(numCols, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        gd = new GridData(768);
        gd.horizontalSpan = numCols;
        gd.horizontalIndent = 15;
        this.createVerticalSpacer((Composite)this.fModuleTypeGroup, numCols);
        this.fLibraryModuleSelectionField = new SelectionButtonDialogField(16);
        this.fLibraryModuleSelectionField.setLabelText("&Library module");
        this.fLibraryModuleSelectionField.doFillIntoGrid((Composite)this.fModuleTypeGroup, numCols);
        this.fLibraryModuleComposite = new Composite((Composite)this.fModuleTypeGroup, 0);
        this.fLibraryModuleComposite.setLayout((Layout)layout);
        this.fLibraryModuleComposite.setLayoutData((Object)gd);
        this.fLibraryModuleComposite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SETImportModuleWizardPage.this.fModuleExtensionField.setEnabled(true);
                SETImportModuleWizardPage.this.fHandlerModuleSelectionField.setSelection(false);
                SETImportModuleWizardPage.this.fLibraryModuleSelectionField.setSelection(true);
                SETImportModuleWizardPage.this.fExternalModuleSelectionField.setSelection(false);
                SETImportModuleWizardPage.this.fLibraryModulePathField.getTextControl(null).setFocus();
            }
        });
        this.fLibraryModulePathField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                SETImportModuleWizardPage.this.handleLibraryModulePathButtonSelected();
            }
        });
        this.fLibraryModulePathField.setLabelText("Select module location:");
        this.fLibraryModulePathField.setButtonLabel("Select...");
        this.fLibraryModulePathField.doFillIntoGrid(this.fLibraryModuleComposite, numCols);
        this.fLibraryModulePathField.getTextControl(null).setLayoutData((Object)new GridData(768));
        this.fLibraryModulePathField.setEnabled(false);
        this.fLibraryModulePathField.setText("lib");
        this.createVerticalSpacer((Composite)this.fModuleTypeGroup, numCols);
        this.fExternalModuleSelectionField = new SelectionButtonDialogField(16);
        this.fExternalModuleSelectionField.setLabelText("&External module");
        this.fExternalModuleSelectionField.doFillIntoGrid((Composite)this.fModuleTypeGroup, numCols);
        this.fExternalModuleComposite = new Composite((Composite)this.fModuleTypeGroup, 0);
        this.fExternalModuleComposite.setLayout((Layout)layout);
        this.fExternalModuleComposite.setLayoutData((Object)gd);
        this.fExternalModuleComposite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SETImportModuleWizardPage.this.fModuleExtensionField.setEnabled(true);
                SETImportModuleWizardPage.this.fHandlerModuleSelectionField.setSelection(false);
                SETImportModuleWizardPage.this.fLibraryModuleSelectionField.setSelection(false);
                SETImportModuleWizardPage.this.fExternalModuleSelectionField.setSelection(true);
                SETImportModuleWizardPage.this.fExternalModulePathField.getTextControl(null).setFocus();
            }
        });
        this.fExternalModulePathField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                SETImportModuleWizardPage.this.handleExternalModulePathButtonSelected();
            }
        });
        this.fExternalModulePathField.setLabelText("Select module location:");
        this.fExternalModulePathField.setButtonLabel("Select...");
        this.fExternalModulePathField.doFillIntoGrid(this.fExternalModuleComposite, numCols);
        this.fExternalModulePathField.getTextControl(null).setLayoutData((Object)new GridData(768));
        this.fExternalModulePathField.setEnabled(false);
        this.fExternalModulePathField.setText("external");
        this.createVerticalSpacer((Composite)this.fModuleTypeGroup, numCols);
        this.processSelection();
        this.addFieldListeners();
        this.setPageComplete(this.isValid());
        this.setGroupEnabled(this.fIsGroupEnabled);
        this.setControl((Control)composite);
    }

    private void processSelection() {
        if (this.fSelection != null && !this.fSelection.isEmpty()) {
            Object[] elements;
            IProject project = null;
            IPath selectedPath = null;
            Object[] objectArray = elements = this.fSelection.toArray();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IResource) {
                    IResource resource = (IResource)element;
                    if (!(resource instanceof IContainer)) {
                        resource = resource.getParent();
                    }
                    project = resource.getProject();
                    selectedPath = resource.getFullPath();
                } else if (element instanceof IModelElement) {
                    IModelElement modelElem = (IModelElement)element;
                    IResource resource = modelElem.getResource();
                    if (!(resource instanceof IContainer)) {
                        resource = resource.getParent();
                    }
                    project = resource.getProject();
                    selectedPath = resource.getFullPath();
                }
                try {
                    if (project != null && project.isAccessible() && project.hasNature("org.eclipse.wst.xquery.set.core.nature")) {
                        break;
                    }
                }
                catch (CoreException coreException) {}
                project = null;
                selectedPath = null;
                ++n2;
            }
            if (project == null) {
                return;
            }
            this.fProjectField.setText(project.getName());
            IPath projectPath = project.getFullPath();
            this.fHandlerModuleSelectionField.setSelection(false);
            this.fLibraryModuleSelectionField.setSelection(false);
            this.fExternalModuleSelectionField.setSelection(false);
            if (projectPath.append("lib").isPrefixOf(selectedPath)) {
                this.fLibraryModuleSelectionField.setSelection(true);
                this.fLibraryModulePathField.setText(selectedPath.removeFirstSegments(1).toOSString());
            } else if (projectPath.append("external").isPrefixOf(selectedPath)) {
                this.fExternalModuleSelectionField.setSelection(true);
                this.fExternalModulePathField.setText(selectedPath.removeFirstSegments(1).toOSString());
            } else {
                this.fHandlerModuleSelectionField.setSelection(true);
                this.fModuleExtensionField.setEnabled(false);
            }
        }
    }

    protected void createVerticalSpacer(Composite parent, int numCols) {
        GridData gd = new GridData(0);
        gd.horizontalSpan = numCols;
        gd.heightHint = 0;
        Label l = new Label(parent, 16384);
        l.setLayoutData((Object)gd);
    }

    private void addFieldListeners() {
        this.fHandlerModuleSelectionField.setDialogFieldListener((IDialogFieldListener)this);
        this.fLibraryModuleSelectionField.setDialogFieldListener((IDialogFieldListener)this);
        this.fExternalModuleSelectionField.setDialogFieldListener((IDialogFieldListener)this);
        this.fModuleFileField.setDialogFieldListener((IDialogFieldListener)this);
        this.fProjectField.setDialogFieldListener((IDialogFieldListener)this);
        this.fModuleNameField.setDialogFieldListener((IDialogFieldListener)this);
        this.fModuleExtensionField.setDialogFieldListener((IDialogFieldListener)this);
        this.fLibraryModulePathField.setDialogFieldListener((IDialogFieldListener)this);
        this.fExternalModulePathField.setDialogFieldListener((IDialogFieldListener)this);
    }

    public void dialogFieldChanged(DialogField field) {
        if (field == this.fHandlerModuleSelectionField) {
            this.fModuleExtensionField.setEnabled(!this.fHandlerModuleSelectionField.isSelected());
        } else if (field == this.fLibraryModuleSelectionField) {
            boolean selection = this.fExternalModuleSelectionField.isSelected();
            this.fExternalModulePathField.setEnabled(selection);
            if (selection) {
                this.checkDirectory("external");
            }
        } else if (field == this.fExternalModuleSelectionField) {
            boolean selection = this.fExternalModuleSelectionField.isSelected();
            this.fExternalModulePathField.setEnabled(selection);
            if (selection) {
                this.checkDirectory("external");
            }
        }
        this.setPageComplete(this.isValid());
        this.setGroupEnabled(this.fIsGroupEnabled);
    }

    private void setGroupEnabled(boolean valid) {
        Control[] controlArray = this.fModuleTypeGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(valid);
            ++n2;
        }
        if (valid) {
            if (this.fLibraryModuleSelectionField.isSelected()) {
                this.fLibraryModulePathField.setEnabled(true);
            } else if (this.fExternalModuleSelectionField.isSelected()) {
                this.fExternalModulePathField.setEnabled(true);
            }
        }
    }

    private boolean isValid() {
        IPath path;
        String pathText;
        this.fIsGroupEnabled = false;
        String modulePath = this.fModuleFileField.getText().trim();
        if (modulePath.length() == 0) {
            this.setErrorMessage(null);
            return false;
        }
        File file = new File(modulePath);
        if (!file.exists() || !file.isFile()) {
            this.setErrorMessage("The provided module file is not accessible");
            return false;
        }
        IScriptProject project = this.getProject();
        if (project == null) {
            this.setErrorMessage("Select a target sausalito project");
            return false;
        }
        if (!project.getProject().isAccessible()) {
            this.setErrorMessage("The selected project is not accessible");
            return false;
        }
        String moduleName = this.fModuleNameField.getText().trim();
        if (moduleName.length() == 0) {
            this.setErrorMessage("Provide a name for the imported module");
            return false;
        }
        if (!moduleName.matches("(\\w|\\-)*")) {
            this.setErrorMessage("\"" + moduleName + "\" is not a valid module namea");
            return false;
        }
        this.fIsGroupEnabled = true;
        if (this.fLibraryModuleSelectionField.isSelected()) {
            pathText = this.fLibraryModulePathField.getText().trim();
            if (pathText.length() == 0) {
                this.setErrorMessage("Select a location for the imported library module");
                return false;
            }
            IPath path2 = this.getLibraryModulePath();
            if (path2 == null || path2.segmentCount() == 0) {
                this.setErrorMessage("Select an existing destination in the \"lib\" project directory");
                return false;
            }
            if (!path2.segment(0).equals("lib")) {
                this.setErrorMessage("Library modules must be located in the \"lib\" project directory");
                return false;
            }
        } else if (this.fExternalModuleSelectionField.isSelected()) {
            pathText = this.fExternalModulePathField.getText().trim();
            if (pathText.length() == 0) {
                this.setErrorMessage("Select a location for the imported external module");
                return false;
            }
            IPath path3 = this.getExternalModulePath();
            if (path3 == null || path3.segmentCount() == 0) {
                this.setErrorMessage("Select an existing destination in the \"external\" project directory");
                return false;
            }
            if (!path3.segment(0).equals("external")) {
                this.setErrorMessage("External modules must be located in the \"external\" project directory");
                return false;
            }
        }
        if ((path = this.getModuleDestinationFilePath()) != null && project.getProject().exists(path)) {
            this.setErrorMessage("A module already exists at location: " + path.toOSString());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private IPath getLibraryModulePath() {
        String pathText = this.fLibraryModulePathField.getText().trim();
        if (pathText.length() == 0) {
            return null;
        }
        IScriptProject project = this.getProject();
        if (project == null) {
            return null;
        }
        Path path = new Path(pathText);
        if (!project.getProject().exists((IPath)path)) {
            return null;
        }
        return path;
    }

    private IPath getExternalModulePath() {
        String pathText = this.fExternalModulePathField.getText().trim();
        if (pathText.length() == 0) {
            return null;
        }
        IScriptProject project = this.getProject();
        if (project == null) {
            return null;
        }
        Path path = new Path(pathText);
        if (!project.getProject().exists((IPath)path)) {
            return null;
        }
        return path;
    }

    private IPath getModuleDestinationFilePath() {
        Path path = null;
        if (this.fHandlerModuleSelectionField.isSelected()) {
            path = new Path("handlers");
        } else if (this.fLibraryModuleSelectionField.isSelected()) {
            path = this.getLibraryModulePath();
        } else if (this.fExternalModuleSelectionField.isSelected()) {
            path = this.getExternalModulePath();
        }
        if (path != null) {
            return path.append(String.valueOf(this.getModuleFileName()) + this.getModuleFileExtension());
        }
        return null;
    }

    private IPath getImportPath() {
        return new Path(this.fModuleFileField.getText().trim());
    }

    private String getModuleFileExtension() {
        return this.fModuleExtensionField.getText();
    }

    private String getModuleFileName() {
        return this.fModuleNameField.getText().trim();
    }

    public boolean finishPage() {
        final ImportModuleRecord moduleRecord = new ImportModuleRecord(this.getProject().getProject(), this.getImportPath(), this.getModuleDestinationFilePath());
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask("", 4000);
                        if (!SETImportModuleWizardPage.this.importModule(moduleRecord, monitor)) {
                            SETImportModuleWizardPage.this.rollbackImportModule(moduleRecord);
                        }
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        monitor.setTaskName("Canceling module import...");
                        SETImportModuleWizardPage.this.rollbackImportModule(moduleRecord);
                        monitor.done();
                    }
                    catch (CoreException ce) {
                        SETImportModuleWizardPage.this.rollbackImportModule(moduleRecord);
                        throw ce;
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            this.reportError(t);
            return false;
        }
        try {
            this.openEditor(this.f);
        }
        catch (CoreException e) {
            this.reportError(e);
        }
        return true;
    }

    private boolean importModule(ImportModuleRecord moduleRecord, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, CoreException {
        this.checkMonitor(monitor);
        this.addFolderToBuildpath(moduleRecord.destinationPath.segment(0), (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        IFile moduleFile = null;
        if (moduleRecord.type == 1 || moduleRecord.type == 2) {
            moduleFile = this.importHandlerOrLibraryModule(moduleRecord, monitor);
        } else if (moduleRecord.type == 3) {
            moduleFile = this.importExternalModule(moduleRecord, monitor);
        }
        if (moduleFile == null) {
            return false;
        }
        this.f = moduleFile;
        return true;
    }

    private IFile importHandlerOrLibraryModule(ImportModuleRecord moduleRecord, IProgressMonitor monitor) throws CoreException {
        monitor.setTaskName("Copying module...");
        IProject project = moduleRecord.project;
        IFile to = project.getFile(moduleRecord.destinationPath);
        File from = moduleRecord.importPath.toFile();
        IPath tempPath = new Path(TEMP_DIR).append(moduleRecord.destinationPath.lastSegment());
        this.createFoldersInPath(project, tempPath.removeLastSegments(1), (IProgressMonitor)new SubProgressMonitor(monitor, 500));
        this.copyFile(from, project.getFile(tempPath), (IProgressMonitor)new SubProgressMonitor(monitor, 500));
        this.checkMonitor(monitor);
        monitor.setTaskName("Parsing module...");
        XQueryLibraryModule libMod = this.parseModule(moduleRecord, tempPath, monitor);
        int off = libMod.getNamespaceUri().matchStart();
        int len = libMod.getNamespaceUri().matchLength();
        SETProjectConfig config = SETProjectConfigUtil.readProjectConfig((IProject)moduleRecord.project);
        if (config == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xquery.org.set.ui", "Could not read the project configuration file"));
        }
        URI projectUri = config.getLogicalUri();
        String toResolve = null;
        toResolve = moduleRecord.type == 1 ? moduleRecord.destinationPath.removeFirstSegments(1).removeFileExtension().toPortableString() : moduleRecord.destinationPath.removeFileExtension().toPortableString();
        URI resolvedUri = projectUri.resolve(toResolve);
        String ns = resolvedUri.toString();
        try {
            this.copyConfigureFile(project.getFile(tempPath), to, off, len, ns, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
        }
        catch (IOException ioe) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xquery.org.set.ui", ioe.getMessage()));
        }
        this.checkMonitor(monitor);
        this.deleteTempDir(project, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
        return to;
    }

    private void deleteTempDir(IProject project, IProgressMonitor monitor) throws CoreException {
        monitor = monitor == null ? new NullProgressMonitor() : monitor;
        IFolder folder = project.getFolder(TEMP_DIR);
        if (folder.exists()) {
            folder.delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
    }

    private void createFoldersInPath(IProject project, IPath path, IProgressMonitor monitor) throws CoreException {
        Path current = new Path("");
        String[] stringArray = path.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            IFolder folder = project.getFolder((IPath)(current = current.append(segment)));
            if (!folder.exists()) {
                folder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
            ++n2;
        }
    }

    private IFile importExternalModule(ImportModuleRecord moduleRecord, IProgressMonitor monitor) throws CoreException {
        monitor.setTaskName("Importing external module...");
        IProject project = moduleRecord.project;
        IFile to = project.getFile(moduleRecord.destinationPath);
        File from = moduleRecord.importPath.toFile();
        this.copyFile(from, to, (IProgressMonitor)new SubProgressMonitor(monitor, 3000));
        return to;
    }

    private void copyFile(File fromFile, IFile toFile, IProgressMonitor monitor) throws CoreException {
        try {
            FileInputStream fis = new FileInputStream(fromFile);
            toFile.create((InputStream)fis, true, monitor);
        }
        catch (FileNotFoundException fnfe) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xquery.org.set.ui", fnfe.getMessage()));
        }
    }

    private void copyConfigureFile(IFile fromFile, IFile toFile, int offset, int length, String namespace, IProgressMonitor monitor) throws CoreException, IOException {
        InputStreamReader sr = null;
        OutputStreamWriter sw = null;
        try {
            try {
                int c;
                sr = new InputStreamReader(fromFile.getContents());
                File out = toFile.getRawLocation().toFile();
                sw = new OutputStreamWriter(new FileOutputStream(out));
                char[] pre = new char[offset + 1];
                sr.read(pre);
                sw.write(pre);
                sr.skip(length - 1);
                sw.write(namespace);
                while ((c = sr.read()) != -1) {
                    sw.write(c);
                }
            }
            catch (Throwable throwable) {
                if (sr != null) {
                    sr.close();
                }
                if (sw != null) {
                    sw.close();
                }
            }
        }
        finally {
            if (sr != null) {
                sr.close();
            }
            if (sw != null) {
                sw.close();
            }
        }
    }

    private void rollbackImportModule(ImportModuleRecord moduleRecord) throws CoreException {
        IProject project = moduleRecord.project;
        IPath modulePath = moduleRecord.destinationPath;
        if (project.exists(modulePath)) {
            project.getFile(modulePath).delete(true, null);
        }
        this.deleteTempDir(project, null);
    }

    private void checkMonitor(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void reportError(Throwable t) {
        String message = "Import problems";
        Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "org.eclipse.wst.xquery.org.set.ui", 1, message, t);
        ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
    }

    protected void handleProjectButtonSelected() {
        IScriptProject project = this.chooseProject();
        if (project != null) {
            this.fProjectField.setText(project.getElementName());
        }
    }

    protected void handleModuleFileButtonSelected() {
        File file = this.browseForModuleFile();
        if (file != null) {
            this.fModuleFileField.setText(file.getPath());
            Path path = new Path(file.getPath());
            String moduleName = path.lastSegment();
            String ext = path.getFileExtension();
            if (ext != null && ext.length() > 0) {
                moduleName = moduleName.substring(0, moduleName.lastIndexOf(ext) - 1);
            }
            this.fModuleNameField.setText(moduleName);
        }
    }

    protected void handleLibraryModulePathButtonSelected() {
        if (!this.checkDirectory("lib")) {
            return;
        }
        IPath dir = this.chooseLibraryModulePath();
        if (dir != null) {
            this.fLibraryModulePathField.setText(dir.removeFirstSegments(1).toOSString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkDirectory(String name) {
        IScriptProject project = this.getProject();
        if (project == null) {
            this.setErrorMessage("Select a valid Sausalito project");
            return false;
        }
        IResource res = project.getProject().findMember(name);
        if (res == null) {
            boolean create = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Create directory", (String)("The \"" + name + "\" project directory is missing for the selected project.\nDo you want to create it now?"));
            if (!create) return false;
            IFolder folder = project.getProject().getFolder(name);
            try {
                folder.create(true, true, null);
            }
            catch (CoreException ce) {
                this.setErrorMessage("An error ocured while creating the \"" + name + "\" directory: " + ce.getMessage());
                return false;
            }
        } else if (!(res instanceof IFolder)) {
            this.setErrorMessage("The \"" + name + "\" directory cannot be created");
            return false;
        }
        this.isValid();
        return true;
    }

    protected void handleExternalModulePathButtonSelected() {
        if (!this.checkDirectory("external")) {
            return;
        }
        IPath dir = this.chooseExternalModulePath();
        if (dir != null) {
            this.fExternalModulePathField.setText(dir.removeFirstSegments(1).toOSString());
        }
    }

    private IScriptProject chooseProject() {
        ScriptUILabelProvider labelProvider = DLTKUILanguageManager.createLabelProvider((String)"org.eclipse.wst.xquery.set.core.nature");
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Project selection");
        dialog.setMessage("Select the import destination project");
        try {
            Object[] projects = ScriptModelHelper.getOpenedScriptProjects((IScriptModel)DLTKCore.create((IWorkspaceRoot)this.getWorkspaceRoot()), (String)"org.eclipse.wst.xquery.set.core.nature");
            dialog.setElements(projects);
        }
        catch (ModelException e) {
            DLTKLaunchingPlugin.log((Throwable)e);
        }
        IScriptProject project = this.getProject();
        if (project != null) {
            dialog.setInitialSelections(new Object[]{project});
        }
        if (dialog.open() == 0) {
            return (IScriptProject)dialog.getFirstResult();
        }
        return null;
    }

    private IPath chooseLibraryModulePath() {
        IFolder libDir;
        ScriptUILabelProvider labelProvider = DLTKUILanguageManager.createLabelProvider((String)"org.eclipse.wst.xquery.set.core.nature");
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)new WorkbenchContentProvider());
        IFolder container = libDir = this.getProject().getProject().getFolder("lib");
        IPath path = this.getLibraryModulePath();
        if (path != null) {
            container = this.getProject().getProject().getFolder(path);
        }
        dialog.addFilter(new ViewerFilter(){
            private IPath prefix;
            {
                this.prefix = SETImportModuleWizardPage.this.getProject().getPath().append("lib");
            }

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFolder) {
                    IFolder folder = (IFolder)element;
                    return this.prefix.isPrefixOf(folder.getFullPath());
                }
                return false;
            }
        });
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0) {
                    return new Status(4, "org.eclipse.wst.xquery.org.set.ui", "You must select one destination directory");
                }
                return new Status(0, "org.eclipse.wst.xquery.org.set.ui", "");
            }
        });
        dialog.setTitle("Library Module Directory");
        dialog.setMessage("Select the target directory for the library module:");
        dialog.setDoubleClickSelects(true);
        dialog.setInput((Object)this.getProject().getProject());
        if (container.exists()) {
            dialog.setInitialSelection((Object)container);
        } else {
            dialog.setInitialSelection((Object)libDir);
        }
        if (dialog.open() == 0) {
            return ((IFolder)dialog.getFirstResult()).getFullPath();
        }
        return null;
    }

    private IPath chooseExternalModulePath() {
        IFolder extDir;
        ScriptUILabelProvider labelProvider = DLTKUILanguageManager.createLabelProvider((String)"org.eclipse.wst.xquery.set.core.nature");
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)new WorkbenchContentProvider());
        IFolder container = extDir = this.getProject().getProject().getFolder("external");
        IPath path = this.getExternalModulePath();
        if (path != null) {
            container = this.getProject().getProject().getFolder(path);
        }
        dialog.addFilter(new ViewerFilter(){
            private IPath prefix;
            {
                this.prefix = SETImportModuleWizardPage.this.getProject().getPath().append("external");
            }

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFolder) {
                    IFolder folder = (IFolder)element;
                    return this.prefix.isPrefixOf(folder.getFullPath());
                }
                return false;
            }
        });
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0) {
                    return new Status(4, "org.eclipse.wst.xquery.org.set.ui", "You must select one destination directory");
                }
                return new Status(0, "org.eclipse.wst.xquery.org.set.ui", "");
            }
        });
        dialog.setTitle("External Module Directory");
        dialog.setMessage("Select the target directory for the external module:");
        dialog.setDoubleClickSelects(true);
        dialog.setInput((Object)this.getProject().getProject());
        if (container.exists()) {
            dialog.setInitialSelection((Object)container);
        } else {
            dialog.setInitialSelection((Object)extDir);
        }
        if (dialog.open() == 0) {
            return ((IFolder)dialog.getFirstResult()).getFullPath();
        }
        return null;
    }

    protected IScriptProject getProject() {
        String projectName = this.fProjectField.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getScriptModel().getScriptProject(projectName);
    }

    protected File browseForModuleFile() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        String filePath = fileDialog.open();
        if (filePath != null && (filePath = filePath.trim()).length() > 0) {
            return new File(filePath);
        }
        return null;
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected IScriptModel getScriptModel() {
        return DLTKCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    private void openEditor(final IFile toFile) throws CoreException {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows.length == 1) {
            toFile.refreshLocal(0, null);
            BasicNewResourceWizard.selectAndReveal((IResource)toFile, (IWorkbenchWindow)windows[0]);
            final IWorkbenchPage page = windows[0].getActivePage();
            windows[0].getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)toFile);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    /*
     * Exception decompiling
     */
    private void addFolderToBuildpath(String name, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private XQueryLibraryModule parseModule(ImportModuleRecord moduleRecord, IPath tempPath, IProgressMonitor monitor) throws CoreException {
        XQDTSourceParser parser = (XQDTSourceParser)DLTKLanguageManager.getSourceParser((String)"org.eclipse.wst.xquery.set.core.nature");
        char[] fileName = this.getProject().getPath().append(tempPath).toString().toCharArray();
        File module = moduleRecord.importPath.toFile();
        long length = module.length();
        if (length > Integer.MAX_VALUE) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xquery.org.set.ui", "Cannot import XQuery files larger than 2MB"));
        }
        char[] source = new char[(int)length];
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(new FileInputStream(module));
            reader.read(source);
            reader.close();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xquery.org.set.ui", e.getMessage()));
        }
        ModuleDeclaration modDecl = parser.parse(fileName, source, null);
        monitor.worked(1000);
        this.checkMonitor(monitor);
        monitor.setTaskName("Configuring module...");
        if (modDecl == null || !(modDecl instanceof XQueryLibraryModule)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xquery.org.set.ui", "The imported file does not contain a valid XQuery Module"));
        }
        return (XQueryLibraryModule)modDecl;
    }

    private static class ImportModuleRecord {
        private static final int TYPE_HANDLER = 1;
        private static final int TYPE_LIBRARY = 2;
        private static final int TYPE_EXTERNAL = 3;
        protected int type;
        protected IProject project;
        protected IPath importPath;
        protected IPath destinationPath;

        public ImportModuleRecord(IProject project, IPath source, IPath destination) {
            this.project = project;
            this.importPath = source;
            this.destinationPath = destination;
            String dir = destination.segment(0);
            if (dir.equals("handlers")) {
                this.type = 1;
            } else if (dir.equals("lib")) {
                this.type = 2;
            } else if (dir.equals("external")) {
                this.type = 3;
            }
        }
    }
}

