/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.ui.wizards;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.wizards.ProjectWizardFirstPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.xquery.set.internal.ui.wizards.CoreSDKTemplateUtility;

public class SETNewProjectWizardFirstPage
extends ProjectWizardFirstPage {
    protected SETCoreSDKGroup fCoreSDKGroup;
    protected SETProjectSettingsGroup fSausalitoGroup;
    private Validator fValidator;

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        composite.setLayoutData((Object)new GridData(256));
        this.fNameGroup = new ProjectWizardFirstPage.NameGroup((ProjectWizardFirstPage)this, composite, this.fInitialName);
        this.fLocationGroup = this.createLocationGroup();
        this.fLocationGroup.createControls(composite);
        this.fValidator = new Validator();
        this.createInterpreterGroup(composite);
        this.createCustomGroups(composite);
        this.fCoreSDKGroup.addObserver(this.fValidator);
        this.fCoreSDKGroup.addObserver(this.fSausalitoGroup);
        this.fDetectGroup = new ProjectWizardFirstPage.DetectGroup((ProjectWizardFirstPage)this, composite);
        this.fNameGroup.notifyObservers();
        this.fNameGroup.addObserver((Observer)this.fValidator);
        this.fLocationGroup.addObserver((Observer)this.fValidator);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    protected void createCustomGroups(Composite composite) {
        this.fSausalitoGroup = new SETProjectSettingsGroup(composite);
        this.fSausalitoGroup.addObserver(this.fValidator);
        this.fNameGroup.addObserver((Observer)this.fSausalitoGroup);
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public boolean isSrc() {
        return true;
    }

    public boolean isTemplate() {
        return this.fSausalitoGroup.isTemplateProject();
    }

    public String getProjectUriString() {
        return this.fSausalitoGroup.getProjectUriString();
    }

    public String getTemplateName() {
        return this.fSausalitoGroup.getTemplateName();
    }

    protected ProjectWizardFirstPage.IInterpreterGroup createInterpreterGroup(Composite parent) {
        if (this.fCoreSDKGroup == null) {
            this.fCoreSDKGroup = new SETCoreSDKGroup(parent);
        }
        return this.fCoreSDKGroup;
    }

    protected IInterpreterInstall getInterpreter() {
        return this.fCoreSDKGroup.getSelectedInterpreter();
    }

    protected boolean interpeterRequired() {
        return true;
    }

    public void dispose() {
        try {
            super.dispose();
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("This is an exception that is triggered in DLTK");
        }
    }

    private final class SETCoreSDKGroup
    extends ProjectWizardFirstPage.AbstractInterpreterGroup {
        public SETCoreSDKGroup(Composite composite) {
            super((ProjectWizardFirstPage)SETNewProjectWizardFirstPage.this, composite);
        }

        protected String getCurrentLanguageNature() {
            return "org.eclipse.wst.xquery.set.core.nature";
        }

        protected String getIntereprtersPreferencePageId() {
            return "org.eclipse.wst.xquery.set.preferences.interpreters";
        }

        public boolean hasWorkspaceCoreSDK() {
            IInterpreterInstallType[] types = ScriptRuntime.getInterpreterInstallTypes((String)this.getCurrentLanguageNature());
            IEnvironment environment = SETNewProjectWizardFirstPage.this.fLocationGroup.getEnvironment();
            int i = 0;
            while (i < types.length) {
                IInterpreterInstallType type = types[i];
                IInterpreterInstall[] installs = type.getInterpreterInstalls();
                int j = 0;
                while (j < installs.length) {
                    IInterpreterInstall install = installs[j];
                    String envId = install.getEnvironmentId();
                    if (envId != null && envId.equals(environment.getId())) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
            return false;
        }

        public void dialogFieldChanged(DialogField field) {
            super.dialogFieldChanged(field);
            if ((field != this.fInterpreterCombo || field.isEnabled()) && SETNewProjectWizardFirstPage.this.fSausalitoGroup != null) {
                SETNewProjectWizardFirstPage.this.fSausalitoGroup.initializeTemplates();
            }
        }
    }

    private final class SETProjectSettingsGroup
    extends Observable
    implements Observer,
    IDialogFieldListener {
        protected final SelectionButtonDialogField fNewRadioButton;
        protected final StringDialogField fProjectUriText;
        protected final SelectionButtonDialogField fTemplateRadioButton;
        protected final ComboDialogField fProjectTemplateCombo;
        private String[] templates;

        protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
            layout.horizontalSpacing = SETNewProjectWizardFirstPage.this.convertHorizontalDLUsToPixels(4);
            layout.verticalSpacing = SETNewProjectWizardFirstPage.this.convertVerticalDLUsToPixels(4);
            if (margins) {
                layout.marginWidth = SETNewProjectWizardFirstPage.this.convertHorizontalDLUsToPixels(7);
                layout.marginHeight = SETNewProjectWizardFirstPage.this.convertVerticalDLUsToPixels(7);
            } else {
                layout.marginWidth = 0;
                layout.marginHeight = 0;
            }
            return layout;
        }

        public SETProjectSettingsGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)this.initGridLayout(new GridLayout(3, false), true));
            group.setText("Sausalito settings");
            this.fNewRadioButton = new SelectionButtonDialogField(16);
            this.fNewRadioButton.setDialogFieldListener((IDialogFieldListener)this);
            this.fNewRadioButton.setLabelText("Create an empty project");
            this.fNewRadioButton.doFillIntoGrid((Composite)group, 3);
            this.fProjectUriText = new StringDialogField();
            this.fProjectUriText.setDialogFieldListener((IDialogFieldListener)this);
            this.fProjectUriText.setLabelText("Project logical URI:");
            this.fProjectUriText.doFillIntoGrid((Composite)group, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fProjectUriText.getTextControl(null));
            this.fNewRadioButton.attachDialogFields(new DialogField[]{this.fProjectUriText});
            this.fTemplateRadioButton = new SelectionButtonDialogField(16);
            this.fTemplateRadioButton.setDialogFieldListener((IDialogFieldListener)this);
            this.fTemplateRadioButton.setLabelText("Create project from a template");
            this.fTemplateRadioButton.doFillIntoGrid((Composite)group, 3);
            this.fProjectTemplateCombo = new ComboDialogField(12);
            this.fProjectTemplateCombo.setLabelText("Project template:");
            this.fProjectTemplateCombo.setDialogFieldListener((IDialogFieldListener)this);
            this.fProjectTemplateCombo.doFillIntoGrid((Composite)group, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fProjectTemplateCombo.getComboControl(null));
            this.fTemplateRadioButton.attachDialogFields(new DialogField[]{this.fProjectTemplateCombo});
            this.initializeControls();
        }

        private void initializeControls() {
            this.fNewRadioButton.setSelection(true);
            this.fTemplateRadioButton.setSelection(false);
            this.initializeTemplates();
        }

        private void initializeTemplates() {
            try {
                this.templates = SETNewProjectWizardFirstPage.this.fCoreSDKGroup.getSelectedInterpreter() == null ? CoreSDKTemplateUtility.getTemplateProjectNames() : CoreSDKTemplateUtility.getTemplateProjectNames(SETNewProjectWizardFirstPage.this.fCoreSDKGroup.getSelectedInterpreter());
                this.fProjectTemplateCombo.setItems(this.templates);
                if (this.templates.length > 0) {
                    this.fProjectTemplateCombo.setText(this.templates[0]);
                    this.fTemplateRadioButton.setEnabled(true);
                } else {
                    this.fTemplateRadioButton.setEnabled(false);
                }
            }
            catch (CoreException coreException) {}
        }

        protected void fireEvent(boolean hasChanged) {
            if (hasChanged) {
                this.setChanged();
            }
            this.notifyObservers();
        }

        public void update(Observable o, Object arg) {
            if (o == SETNewProjectWizardFirstPage.this.fCoreSDKGroup) {
                this.initializeTemplates();
            }
            if (this.isNewProject()) {
                this.fProjectUriText.setText(this.getSampleProjectUri());
            }
            this.fireEvent(true);
        }

        private String getSampleProjectUri() {
            if (this.fNewRadioButton.isSelected()) {
                String encodedName = "";
                try {
                    encodedName = URLEncoder.encode(SETNewProjectWizardFirstPage.this.fNameGroup.getName(), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                if (encodedName.length() > 0) {
                    return "http://www.example.com/" + encodedName + "/";
                }
            }
            return "";
        }

        public void dialogFieldChanged(DialogField field) {
            boolean hasChanged = false;
            if (field == this.fNewRadioButton) {
                this.fProjectUriText.setText(this.getSampleProjectUri());
                hasChanged = true;
            } else if (field == this.fProjectUriText) {
                hasChanged = true;
            }
            this.fireEvent(hasChanged);
        }

        public boolean isTemplateProject() {
            return this.fTemplateRadioButton.isSelected() && !this.fNewRadioButton.isSelected();
        }

        public boolean isNewProject() {
            return !this.fTemplateRadioButton.isSelected() && this.fNewRadioButton.isSelected();
        }

        public String getProjectUriString() {
            return this.fProjectUriText.getText().trim();
        }

        public String getTemplateName() {
            return this.fProjectTemplateCombo.getText();
        }
    }

    private final class Validator
    implements Observer {
        private Validator() {
        }

        public void update(Observable o, Object arg) {
            IStatus locationStatus;
            IEnvironment environment;
            if (SETNewProjectWizardFirstPage.this.supportInterpreter() && SETNewProjectWizardFirstPage.this.interpeterRequired() && SETNewProjectWizardFirstPage.this.getInterpreter() == null && !SETNewProjectWizardFirstPage.this.fCoreSDKGroup.hasWorkspaceCoreSDK()) {
                SETNewProjectWizardFirstPage.this.setErrorMessage("At least one Sausalito CoreSDK installation must be configured");
                SETNewProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IWorkspace workspace = DLTKUIPlugin.getWorkspace();
            String name = SETNewProjectWizardFirstPage.this.fNameGroup.getName();
            if (name.length() == 0) {
                SETNewProjectWizardFirstPage.this.setErrorMessage(null);
                SETNewProjectWizardFirstPage.this.setMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_enterProjectName);
                SETNewProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IStatus nameStatus = workspace.validateName(name, 4);
            if (!nameStatus.isOK()) {
                SETNewProjectWizardFirstPage.this.setErrorMessage(nameStatus.getMessage());
                SETNewProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IProject handle = SETNewProjectWizardFirstPage.this.getProjectHandle();
            if (handle.exists()) {
                SETNewProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_projectAlreadyExists);
                SETNewProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            String location = SETNewProjectWizardFirstPage.this.fLocationGroup.getLocation().toOSString();
            if (location.length() == 0) {
                SETNewProjectWizardFirstPage.this.setErrorMessage(null);
                SETNewProjectWizardFirstPage.this.setMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_enterLocation);
                SETNewProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!Path.EMPTY.isValidPath(location)) {
                SETNewProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_invalidDirectory);
                SETNewProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IPath projectPath = Path.fromOSString((String)location);
            if (!SETNewProjectWizardFirstPage.this.fLocationGroup.isInWorkspace() && Platform.getLocation().isPrefixOf(projectPath)) {
                SETNewProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_cannotCreateInWorkspace);
                SETNewProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!SETNewProjectWizardFirstPage.this.fLocationGroup.isInWorkspace() && EnvironmentManager.isLocal((IEnvironment)(environment = SETNewProjectWizardFirstPage.this.getEnvironment())) && !(locationStatus = workspace.validateProjectLocation(handle, projectPath)).isOK()) {
                SETNewProjectWizardFirstPage.this.setErrorMessage(locationStatus.getMessage());
                SETNewProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            boolean isNewPrj = SETNewProjectWizardFirstPage.this.fSausalitoGroup.isNewProject();
            if (isNewPrj) {
                String projectUriStr = SETNewProjectWizardFirstPage.this.fSausalitoGroup.getProjectUriString();
                if (projectUriStr.length() == 0) {
                    SETNewProjectWizardFirstPage.this.setErrorMessage("The project logical URI must be a syntactically correct absolute URI.");
                    SETNewProjectWizardFirstPage.this.setPageComplete(false);
                    return;
                }
                URI projectUri = null;
                try {
                    projectUri = new URI(SETNewProjectWizardFirstPage.this.fSausalitoGroup.getProjectUriString());
                }
                catch (URISyntaxException uRISyntaxException) {
                    SETNewProjectWizardFirstPage.this.setErrorMessage("The provided URI has an invalid syntax.");
                    SETNewProjectWizardFirstPage.this.setPageComplete(false);
                    return;
                }
                if (!projectUri.isAbsolute()) {
                    SETNewProjectWizardFirstPage.this.setErrorMessage("The project URI must be an absolute one.");
                    SETNewProjectWizardFirstPage.this.setPageComplete(false);
                    return;
                }
            }
            SETNewProjectWizardFirstPage.this.setPageComplete(true);
            SETNewProjectWizardFirstPage.this.setErrorMessage(null);
            SETNewProjectWizardFirstPage.this.setMessage(null);
        }
    }
}

