/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.ui.templates;

import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.ui.templates.ScriptTemplateAccess;
import org.eclipse.dltk.ui.templates.ScriptTemplateCompletionProcessor;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.wst.xquery.core.text.XQDTWordDetector;
import org.eclipse.wst.xquery.core.utils.LanguageUtil;
import org.eclipse.wst.xquery.internal.ui.templates.XQDTTemplateAccess;
import org.eclipse.wst.xquery.internal.ui.templates.XQueryTemplateContentType;

public class XQDTTemplateCompletionProcessor
extends ScriptTemplateCompletionProcessor {
    private boolean fIsNormalPrefixType;

    public XQDTTemplateCompletionProcessor(ScriptContentAssistInvocationContext context) {
        super(context);
    }

    protected String getContextTypeId() {
        IProject project = this.getContext().getProject().getProject();
        int mask = LanguageUtil.getLanguageLevel((IProject)project);
        if (LanguageUtil.isLanguage((int)mask, (int)3)) {
            return "org.eclipse.wst.xquery.ui.templates.XQueryScriptingTemplateContentType";
        }
        if (LanguageUtil.isLanguage((int)mask, (int)1)) {
            return "org.eclipse.wst.xquery.ui.templates.XQueryUpdateTemplateContentType";
        }
        return "org.eclipse.wst.xquery.ui.templates.XQueryTemplateContentType";
    }

    protected ScriptTemplateAccess getTemplateAccess() {
        return XQDTTemplateAccess.getInstance();
    }

    protected boolean isValidPrefix(String prefix) {
        return this.fIsNormalPrefixType;
    }

    protected boolean isMatchingTemplate(Template template, String prefix, TemplateContext context) {
        if (template.getName().equals("function")) {
            System.err.println("Move potential functions away from normal template processing: XQDTTemplateCompletionProcessor");
        }
        if (!template.getName().startsWith(prefix)) {
            return false;
        }
        if (template.matches(prefix, context.getContextType().getId())) {
            return true;
        }
        TemplateContextType contextType = context.getContextType();
        if (contextType instanceof XQueryTemplateContentType) {
            String[] alsoMatches;
            String[] stringArray = alsoMatches = ((XQueryTemplateContentType)contextType).getCompatibleContentTypes();
            int n = alsoMatches.length;
            int n2 = 0;
            while (n2 < n) {
                String contextTypeId = stringArray[n2];
                if (template.matches(prefix, contextTypeId)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected String extractPrefix(ITextViewer viewer, int offset) {
        int i = offset;
        IDocument document = viewer.getDocument();
        if (i > document.getLength()) {
            return "";
        }
        XQDTWordDetector wd = new XQDTWordDetector();
        try {
            char ch = '\u0000';
            while (i > 0) {
                ch = document.getChar(i - 1);
                if (!wd.isWordPart(ch)) break;
                --i;
            }
            this.fIsNormalPrefixType = ch != ':' && ch != '$';
            return document.get(i, offset - i);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    protected int getRelevance(Template template, String prefix) {
        if (template.getName().startsWith(prefix)) {
            return 1000000;
        }
        return 0;
    }
}

