/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.AbstractMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.AbstractReplyMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.ReplyMessage;

public abstract class AbstractCommandMessage
extends AbstractMessage {
    private static int idgen;
    private transient int commandSet;
    private transient int command;

    public AbstractCommandMessage(int commandSet, int command) {
        super(AbstractCommandMessage.nextId());
        this.commandSet = commandSet;
        this.command = command & 0xFF;
    }

    public byte[] toByteArray() {
        int size = 11;
        byte[] data = this.serializeData();
        if (data.length > 0) {
            size += data.length;
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outStream);
        try {
            dos.writeInt(size);
            dos.writeInt(this.getId());
            dos.writeByte(this.getFlags());
            dos.writeByte(this.commandSet);
            dos.writeByte(this.command);
            dos.write(data);
        }
        catch (IOException iOException) {}
        return outStream.toByteArray();
    }

    public boolean equals(AbstractMessage message) {
        if (message instanceof AbstractCommandMessage) {
            AbstractCommandMessage commandMessage = (AbstractCommandMessage)message;
            if (this.getId() == commandMessage.getId() && this.getFlags() == commandMessage.getFlags() && this.getCommandSet() == commandMessage.getCommandSet() && this.getCommand() == commandMessage.getCommand() && this.isDataEqual(message)) {
                return true;
            }
        }
        return false;
    }

    public int getCommand() {
        return this.command;
    }

    public void setCommand(int command) {
        this.command = command;
    }

    public int getCommandSet() {
        return this.commandSet;
    }

    public void setCommandSet(int commandSet) {
        this.commandSet = commandSet;
    }

    public AbstractReplyMessage buildReplyMessage(int errorCode) {
        return new ReplyMessage(this.getId(), errorCode);
    }

    public AbstractReplyMessage buildReplyMessage(int errorCode, Object data) {
        return new ReplyMessage(this.getId(), errorCode);
    }

    public byte[] serializeData() {
        return new byte[0];
    }

    public void deserializeData(byte[] data) {
    }

    protected static int nextId() {
        return ++idgen;
    }
}

