/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.AbstractCommandMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.MessageFormatException;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.ReplyMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.model.QueryLocation;

public class FramesMessage
extends AbstractCommandMessage {
    public FramesMessage() {
        super(244, 62473);
    }

    public ReplyMessage buildReplyMessage(int errorCode, Object data) {
        QueryLocation[] locations = (QueryLocation[])data;
        Gson g = new Gson();
        String json = g.toJson((Object)new LocationContainer(locations));
        return new ReplyMessage(this.getId(), 0, json.getBytes());
    }

    public QueryLocation[] readLocations(ReplyMessage reply) {
        byte[] data = reply.getData();
        if (data == null) {
            throw new MessageFormatException("Invalid data format. (null data in a reply message)");
        }
        LocationContainer container = (LocationContainer)new Gson().fromJson(new String(data), LocationContainer.class);
        return container.getLocations();
    }

    public static void main(String[] args) {
        FramesMessage fm = new FramesMessage();
        ReplyMessage rm = fm.buildReplyMessage(0, new QueryLocation[]{new QueryLocation("file", 1, 2, 3, 4), new QueryLocation("filefile", 11, 22, 33, 44)});
        String s = new String(rm.getData());
        System.out.println(s);
    }

    private class LocationContainer {
        @SerializedName(value="frames")
        private QueryLocation[] locations;

        public LocationContainer(QueryLocation[] locations) {
            this.locations = locations;
        }

        public QueryLocation[] getLocations() {
            return this.locations;
        }
    }
}

