/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.ui.zorba;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.debug.ui.interpreters.InterpretersUpdater;
import org.eclipse.dltk.internal.launching.LazyFileHandle;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.wst.xquery.debug.ui.zorba.ZorbaDebugUIPlugin;
import org.eclipse.wst.xquery.internal.launching.zorba.ZorbaInstallType;
import org.eclipse.wst.xquery.launching.XQDTLaunchingPlugin;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class ZorbaDebugUIUtils {
    public static void searchAndAddSausalitoZorba() {
        try {
            String os = Platform.getOS();
            String absoluteZorbaExec = null;
            if (os.equals("win32") || os.equals("macosx")) {
                URL zorbaURL;
                String fragment;
                Bundle[] bundles;
                String osPart = "." + os;
                String archPart = "";
                if (os.equals("macosx")) {
                    archPart = "." + Platform.getOSArch();
                }
                if ((bundles = Platform.getBundles((String)(fragment = "org.eclipse.wst.xquery.set.launching" + osPart + archPart), null)) == null || bundles.length == 0) {
                    if (XQDTLaunchingPlugin.DEBUG_AUTOMATIC_PROCESSOR_DETECTION) {
                        ZorbaDebugUIUtils.error(1, "Could not find plug-in fragment: " + fragment + ". No default Zorba XQuery processor will be configured.", null);
                    }
                    return;
                }
                if (XQDTLaunchingPlugin.DEBUG_AUTOMATIC_PROCESSOR_DETECTION) {
                    ZorbaDebugUIUtils.error(1, "Found plug-in fragment: " + fragment, null);
                }
                Bundle bundle = bundles[0];
                String relativeZorbaExec = "/coresdk/bin/zorba";
                if (os.equals("win32")) {
                    relativeZorbaExec = String.valueOf(relativeZorbaExec) + ".exe";
                }
                if ((zorbaURL = bundle.getEntry(relativeZorbaExec)) == null && XQDTLaunchingPlugin.DEBUG_AUTOMATIC_PROCESSOR_DETECTION) {
                    ZorbaDebugUIUtils.error(1, "Cound not find executable \"" + relativeZorbaExec + "\" in plug-in fragment: " + fragment, null);
                }
                absoluteZorbaExec = FileLocator.toFileURL((URL)zorbaURL).getFile();
            } else if (os.equals("linux")) {
                absoluteZorbaExec = "/opt/saualito/bin/zorba";
            } else {
                if (XQDTLaunchingPlugin.DEBUG_AUTOMATIC_PROCESSOR_DETECTION) {
                    ZorbaDebugUIUtils.error(1, "Automatic Zorba XQuery processor detection is not enabled on \"" + os + "\" pltforms.", null);
                }
                return;
            }
            if (XQDTLaunchingPlugin.DEBUG_AUTOMATIC_PROCESSOR_DETECTION) {
                ZorbaDebugUIUtils.error(1, "Confiuguring Zorba XQuery processor from: " + absoluteZorbaExec, null);
            }
            LazyFileHandle installLocation = new LazyFileHandle(EnvironmentManager.getLocalEnvironment().getId(), (IPath)new Path(absoluteZorbaExec));
            String id = String.valueOf(System.currentTimeMillis());
            InterpreterStandin zorbaInstall = new InterpreterStandin((IInterpreterInstallType)new ZorbaInstallType(), id);
            zorbaInstall.setInstallLocation((IFileHandle)installLocation);
            zorbaInstall.setName("Zorba 1.0.0");
            zorbaInstall.setInterpreterArgs(null);
            LibraryLocation moduleLoc = new LibraryLocation(installLocation.getFullPath().removeLastSegments(2).append("modules"));
            zorbaInstall.setLibraryLocations(new LibraryLocation[]{moduleLoc});
            if (os.equals("macosx") || os.equals("linux")) {
                String libraryPath = "LD_LIBRARY_PATH";
                if (os.equals("macosx")) {
                    libraryPath = "DY" + libraryPath;
                }
                String libDir = installLocation.getParent().getParent().getFullPath().append("lib").toOSString();
                EnvironmentVariable libPathVar = new EnvironmentVariable(libraryPath, libDir);
                if (XQDTLaunchingPlugin.DEBUG_AUTOMATIC_PROCESSOR_DETECTION) {
                    ZorbaDebugUIUtils.error(1, "Setting the " + libPathVar.getName() + " variable to: " + libPathVar.getValue(), null);
                }
                zorbaInstall.setEnvironmentVariables(new EnvironmentVariable[]{libPathVar});
            }
            boolean[] canceled = new boolean[1];
            InterpretersUpdater updater = new InterpretersUpdater();
            if (!updater.updateInterpreterSettings("org.eclipse.wst.xquery.core.nature", new IInterpreterInstall[]{zorbaInstall}, new IInterpreterInstall[]{zorbaInstall})) {
                canceled[0] = true;
            }
            if (canceled[0]) {
                ZorbaDebugUIUtils.error(4, "Automatic Zorba XQuery processor detection canceled", null);
            } else {
                IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.wst.xquery.debug.ui.zorba");
                node.putBoolean("defaultInterpreterFound", true);
                node.flush();
            }
        }
        catch (BackingStoreException backingStoreException) {
            ZorbaDebugUIUtils.error(4, "Could not enable the default Zorba XQuery interpreter", null);
        }
        catch (IOException iOException) {
            ZorbaDebugUIUtils.error(4, "Could not find the Zorba executable", null);
        }
    }

    public static void error(int severity, String message, Throwable t) {
        ZorbaDebugUIPlugin.log((IStatus)new Status(severity, "org.eclipse.wst.xquery.debug.ui.zorba", message, t));
    }
}

