/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.types.impl;

import java.math.BigDecimal;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.wst.xquery.marklogic.xcc.types.ItemType;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.AbstractStringItem;

public abstract class AbstractDateItem
extends AbstractStringItem {
    protected static final String GDAY_FMT_STRING = "---dd";
    protected static final String GMONTH_FMT_STRING = "--MM";
    protected static final String GMONTHDAY_FMT_STRING = "--MM-dd";
    protected static final String GYEAR_FMT_STRING = "yyyy";
    protected static final String GYEARMONTH_FMT_STRING = "yyyy-MM";
    protected static final String DATE_FMT_STRING = "yyyy-MM-dd";
    protected static final String DATETIME_FMT_STRING = "yyyy-MM-dd'T'HH:mm:ss";
    protected static final String TIME_FMT_STRING = "HH:mm:ss";
    private final TimeZone timezone;
    private final Locale locale;
    private static final BigDecimal oneThousand = new BigDecimal("1000");

    public AbstractDateItem(ItemType type, String value, TimeZone timezone, Locale locale) {
        super(type, value);
        this.timezone = timezone == null ? TimeZone.getDefault() : timezone;
        this.locale = locale == null ? Locale.getDefault() : locale;
    }

    protected Date dateFromDateString(String str) {
        return this.dateFromString(str, DATE_FMT_STRING, this.timezone, this.locale);
    }

    protected Date dateFromDateTimeString(String str) {
        return this.dateFromString(str, DATETIME_FMT_STRING, this.timezone, this.locale);
    }

    protected Date dateFromTimeString(String str) {
        return this.dateFromString(str, TIME_FMT_STRING, this.timezone, this.locale);
    }

    private Date dateFromString(String str, String fmt, TimeZone tz, Locale locale) {
        String val = str.trim();
        SimpleDateFormat sdf = new SimpleDateFormat(fmt, locale);
        sdf.setTimeZone(tz);
        ParsePosition pp = new ParsePosition(0);
        Date date = sdf.parse(val, pp);
        if (date == null) {
            throw new IllegalArgumentException("Not a valid date/time string: " + str + " (" + fmt + ")");
        }
        int millis = 0;
        if (pp.getIndex() < val.length() && val.charAt(pp.getIndex()) == '.') {
            pp.setIndex(pp.getIndex() + 1);
            int end = pp.getIndex();
            while (end < val.length() && val.charAt(end) >= '0' && val.charAt(end) <= '9') {
                ++end;
            }
            millis = AbstractDateItem.millisFromFractional(val.substring(pp.getIndex(), end));
            pp.setIndex(end);
        }
        if (pp.getIndex() < val.length()) {
            tz = val.charAt(pp.getIndex()) == 'Z' ? TimeZone.getTimeZone("UTC") : TimeZone.getTimeZone("GMT" + val.substring(pp.getIndex()));
        }
        GregorianCalendar cal = new GregorianCalendar(tz, locale);
        cal.setTime(date);
        cal.set(14, millis);
        date = cal.getTime();
        return date;
    }

    static int millisFromFractional(String fraction) {
        BigDecimal d = new BigDecimal("0." + fraction);
        d = d.setScale(3, 4);
        d = d.multiply(oneThousand);
        return d.intValue();
    }

    protected GregorianCalendar gCalFromGDayString(String str) {
        return this.gCalFromString(str, GDAY_FMT_STRING, this.timezone, this.locale);
    }

    protected GregorianCalendar gCalFromGMonthString(String str) {
        return this.gCalFromString(str, GMONTH_FMT_STRING, this.timezone, this.locale);
    }

    protected GregorianCalendar gCalFromGMonthDayString(String str) {
        return this.gCalFromString(str, GMONTHDAY_FMT_STRING, this.timezone, this.locale);
    }

    protected GregorianCalendar gCalFromGYearString(String str) {
        return this.gCalFromString(str, GYEAR_FMT_STRING, this.timezone, this.locale);
    }

    protected GregorianCalendar gCalFromGYearMonthString(String str) {
        return this.gCalFromString(str, GYEARMONTH_FMT_STRING, this.timezone, this.locale);
    }

    private GregorianCalendar gCalFromString(String str, String fmt, TimeZone tz, Locale locale) {
        String val = str.trim();
        SimpleDateFormat sdf = new SimpleDateFormat(fmt, locale);
        sdf.setTimeZone(tz);
        ParsePosition pp = new ParsePosition(0);
        Date d = sdf.parse(val, pp);
        if (d == null) {
            throw new IllegalArgumentException("Not a valid Gregorian string: " + str + " (" + fmt + ")");
        }
        if (pp.getIndex() < val.length()) {
            tz = TimeZone.getTimeZone("GMT" + val.substring(pp.getIndex()));
        }
        GregorianCalendar gcal = new GregorianCalendar(tz, locale);
        gcal.setTime(d);
        return gcal;
    }
}

