/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.types.impl;

import org.eclipse.wst.xquery.marklogic.xcc.types.ValueType;
import org.eclipse.wst.xquery.marklogic.xcc.types.XSHexBinary;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.AbstractStringItem;

public class XsHexBinaryImpl
extends AbstractStringItem
implements XSHexBinary {
    public XsHexBinaryImpl(String bodyString) {
        super(ValueType.XS_HEX_BINARY, bodyString);
        this.validateHex(bodyString);
    }

    public byte[] asBinaryData() {
        return this.convertHexToBinary(this.asString());
    }

    private void validateHex(String bodyString) {
        int len = bodyString.length();
        int i = 0;
        while (i < len) {
            char c = Character.toLowerCase(bodyString.charAt(i));
            if (!(Character.isDigit(c) || c >= 'a' && c <= 'f')) {
                throw new IllegalArgumentException("Illegal character in hex string: '" + c + "', index=" + i);
            }
            ++i;
        }
    }

    private byte[] convertHexToBinary(String hex) {
        int strLen = hex.length();
        byte[] binary = new byte[(strLen + 1) / 2];
        int binIdx = 0;
        int currIdx = 0;
        while (currIdx < strLen) {
            char hi = hex.charAt(currIdx);
            char lo = currIdx < strLen - 1 ? (char)hex.charAt(currIdx + 1) : (char)'0';
            int val = Character.digit(hi, 16) << 4 | Character.digit(lo, 16);
            binary[binIdx++] = (byte)(val & 0xFF);
            currIdx += 2;
        }
        return binary;
    }
}

