/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.launching;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemCollector;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.wst.xquery.core.semantic.ISemanticValidator;
import org.eclipse.wst.xquery.core.semantic.SemanticCheckError;
import org.eclipse.wst.xquery.launching.ISemanticValidatingInterpreterInstall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQDTSemanticBuilder
implements IBuildParticipant {
    public void build(IBuildContext context) throws CoreException {
        if (context.getBuildType() == 0) {
            List<SemanticCheckError> errors;
            ISourceModule source = context.getSourceModule();
            if (!this.isInBuildpath(source)) {
                return;
            }
            IProblemReporter reporter = context.getProblemReporter();
            if (reporter instanceof ProblemCollector) {
                ProblemCollector pc = (ProblemCollector)reporter;
                List problems = pc.getErrors();
                for (IProblem problem : problems) {
                    if (problem.getID() != 0x40000000) continue;
                    return;
                }
            }
            if ((errors = this.check(source)) != null) {
                for (SemanticCheckError error : errors) {
                    String fileName = error.getOriginatingFileName();
                    if (fileName.equals(source.getPath().toString())) {
                        context.getProblemReporter().reportProblem((IProblem)error);
                        continue;
                    }
                    IModelElement element = DLTKCore.create((IResource)ResourcesPlugin.getWorkspace().getRoot().findMember(fileName));
                    if (!(element instanceof ISourceModule)) continue;
                    ISourceModule module = (ISourceModule)element;
                    this.createMarker(module, error);
                }
            }
        }
    }

    private void createMarker(ISourceModule module, SemanticCheckError error) throws CoreException {
        IMarker marker = module.getResource().createMarker("org.eclipse.dltk.core.problem");
        marker.setAttribute("lineNumber", error.getSourceLineNumber() + 1);
        marker.setAttribute("message", (Object)error.getMessage());
        marker.setAttribute("severity", 2);
        marker.setAttribute("priority", 1);
        marker.setAttribute("charStart", error.getSourceStart());
        marker.setAttribute("charEnd", error.getSourceEnd());
        if (error.getID() != 0) {
            marker.setAttribute("id", error.getID());
        }
    }

    private boolean isInBuildpath(ISourceModule source) throws ModelException {
        IBuildpathEntry[] entries;
        IScriptProject project = source.getScriptProject();
        IBuildpathEntry[] iBuildpathEntryArray = entries = project.getRawBuildpath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry entry = iBuildpathEntryArray[n2];
            if (entry.getPath().isPrefixOf(source.getPath())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public List<SemanticCheckError> check(ISourceModule module) throws CoreException {
        IInterpreterInstall install = ScriptRuntime.getInterpreterInstall((IScriptProject)module.getScriptProject());
        if (install instanceof ISemanticValidatingInterpreterInstall) {
            ISemanticValidator validator = ((ISemanticValidatingInterpreterInstall)install).getSemanticValidator();
            return validator.check(module);
        }
        return null;
    }
}

