/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.launching.jobs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SETCoreSDKCommandJob
extends Job {
    protected IProject fProject;
    private IProgressMonitor fMonitor;
    private OutputStream fOutputStream;

    public SETCoreSDKCommandJob(String name, IProject project, OutputStream output) {
        super(name);
        this.setUser(true);
        this.fProject = project;
        this.fOutputStream = output;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.doActionsBeforeRun();
        this.fMonitor = monitor;
        int ticks = this.getJobTaskSize();
        if (ticks == 0) {
            monitor.done();
            return Status.OK_STATUS;
        }
        String name = this.getJobTaskName();
        monitor.beginTask(name, ticks);
        try {
            IScriptProject project = DLTKCore.create((IProject)this.fProject);
            IInterpreterInstall install = ScriptRuntime.getInterpreterInstall((IScriptProject)project);
            ArrayList<String> cmdLine = new ArrayList<String>();
            cmdLine.add(install.getInstallLocation().getPath().toOSString());
            cmdLine.addAll(this.getCommandParameters());
            IExecutionEnvironment exeEnv = install.getExecEnvironment();
            EnvironmentVariable[] environmentVariables = install.getEnvironmentVariables();
            String[] vars = null;
            if (environmentVariables != null) {
                vars = new String[environmentVariables.length];
                int j = 0;
                while (j < environmentVariables.length) {
                    vars[j] = environmentVariables[j].toString();
                    ++j;
                }
            }
            Process p = exeEnv.exec(cmdLine.toArray(new String[cmdLine.size()]), null, vars);
            InputStream input = p.getInputStream();
            this.readCommandOutput(input);
            int err = p.waitFor();
            if (err != 0) {
                BufferedReader r = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                StringBuffer sb = new StringBuffer();
                String line = null;
                while ((line = r.readLine()) != null) {
                    sb.append(line);
                }
                IStatus iStatus = this.reportError(sb.toString());
                return iStatus;
            }
        }
        catch (Exception ce) {
            IStatus iStatus = this.reportError(ce);
            return iStatus;
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    protected void doActionsBeforeRun() {
    }

    protected void readCommandOutput(InputStream inputStream) throws IOException {
        BufferedReader ir = new BufferedReader(new InputStreamReader(inputStream));
        while (ir.readLine() != null) {
        }
    }

    protected abstract boolean useConsole();

    protected abstract List<String> getCommandParameters();

    protected int getJobTaskSize() {
        return -1;
    }

    protected String getJobTaskName() {
        return "";
    }

    protected IStatus reportError(Throwable t) {
        return new Status(4, "org.eclipse.wst.xquery.set.core", t.getMessage(), t);
    }

    protected IStatus reportError(String message) {
        return new Status(4, "org.eclipse.wst.xquery.set.core", message);
    }

    protected IStatus reportWarning(String message) {
        return new Status(2, "org.eclipse.wst.xquery.set.core", message);
    }

    protected void updateMonitorTaskName(String taskName) {
        if (this.fMonitor != null) {
            this.fMonitor.setTaskName(taskName);
        }
    }

    protected void updateMonitorWork(int ammount) {
        if (this.fMonitor != null) {
            this.fMonitor.worked(ammount);
        }
    }

    protected OutputStream getOutputStream() {
        return this.fOutputStream;
    }
}

