/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.launching.jobs;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.xquery.set.internal.launching.jobs.SETCoreSDKCommandJob;
import org.eclipse.wst.xquery.set.launching.deploy.DeployInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SETCoreSDKDeployCommandJob
extends SETCoreSDKCommandJob {
    protected DeployInfo fInfo;

    public SETCoreSDKDeployCommandJob(String name, DeployInfo info, OutputStream output) {
        super(name, info.getProject().getProject(), output);
        this.fInfo = info;
    }

    @Override
    protected List<String> getCommandParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("deploy");
        params.add(this.getDeployType().toString());
        params.add("-d");
        params.add(this.fProject.getLocation().toOSString());
        params.add("-a");
        params.add(this.fInfo.getApplicationName());
        params.add("-us");
        params.add(this.fInfo.getUserName());
        params.add("-pw");
        params.add(this.fInfo.getPassword());
        String host = this.fInfo.getHost().trim();
        if (host != null && !host.equals("")) {
            params.add("-s");
            params.add(host);
        }
        return params;
    }

    protected abstract DeployType getDeployType();

    @Override
    protected boolean useConsole() {
        return false;
    }

    public void setDeployInfo(DeployInfo info) {
        this.fInfo = info;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DeployType {
        DEPLOY_PROJECT("project"),
        DEPLOY_DATA("data");

        private String fType;

        private DeployType(String type) {
            this.fType = type;
        }

        public String toString() {
            return this.fType;
        }
    }
}

