/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.launching.jobs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.xquery.set.internal.launching.jobs.SETCoreSDKCommandJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SETImportDataJob
extends SETCoreSDKCommandJob {
    private static final String BULKLOAD_PATH = "bulkload";

    public SETImportDataJob(IProject project, OutputStream output) {
        super("Importing project data", project, output);
    }

    @Override
    protected List<String> getCommandParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("import");
        params.add("data");
        params.add("-d");
        params.add(this.fProject.getLocation().toOSString());
        return params;
    }

    @Override
    protected int getJobTaskSize() {
        IFolder folder = this.fProject.getFolder(BULKLOAD_PATH);
        if (!folder.exists()) {
            return 0;
        }
        final HashSet names = new HashSet();
        try {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getType() == 1) {
                        IPath path = resource.getFullPath();
                        String ext = path.getFileExtension();
                        if (ext.equals("xq") || ext.equals("xml")) {
                            names.add(path.removeFileExtension().removeFirstSegments(4).toPortableString());
                        }
                        return false;
                    }
                    return true;
                }
            }, 2, 1);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return names.size();
    }

    @Override
    protected String getJobTaskName() {
        return "Importing data for project: " + this.fProject.getName();
    }

    @Override
    protected void readCommandOutput(InputStream inputStream) throws IOException {
        OutputStream output = this.getOutputStream();
        BufferedReader ir = new BufferedReader(new InputStreamReader(inputStream));
        String line = null;
        while ((line = ir.readLine()) != null) {
            if (line.startsWith("Importing file ")) {
                this.updateMonitorTaskName(line);
            } else if (line.startsWith("  done") || line.startsWith("  failed")) {
                this.updateMonitorWork(1);
            }
            if (output == null) continue;
            output.write((String.valueOf(line) + "\n").getBytes());
        }
    }

    @Override
    protected boolean useConsole() {
        return true;
    }
}

