/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.ui;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.xquery.set.core.SETProjectConfig;
import org.eclipse.wst.xquery.set.internal.ui.HandlerCollector;

public class SETEditProjectConfigDialog
extends TitleAreaDialog {
    private SETProjectConfig fConfig;
    private IProject fProject;
    private Text fUriText;
    private Text fVersionText;
    private Text fStartPageText;
    private Button fOKButton;
    private WidgetListener fListener = new WidgetListener();

    public SETEditProjectConfigDialog(Shell shell, IProject project, SETProjectConfig config) {
        super(shell);
        this.fConfig = config;
        this.fProject = project;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(3, false));
        this.setTitle("Project Configuration");
        this.setMessage("Edit the project configuration");
        Label label = new Label(composite, 0);
        label.setText("Logical URI:");
        this.fUriText = new Text(composite, 2052);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        this.fUriText.setLayoutData((Object)gd);
        this.fUriText.addModifyListener((ModifyListener)this.fListener);
        label = new Label(composite, 0);
        label.setText("Version:");
        this.fVersionText = new Text(composite, 2052);
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        this.fVersionText.setLayoutData((Object)gd);
        this.fVersionText.addModifyListener((ModifyListener)this.fListener);
        label = new Label(composite, 0);
        label.setText("Start Page:");
        this.fStartPageText = new Text(composite, 2052);
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        this.fStartPageText.setLayoutData((Object)gd);
        this.fStartPageText.addModifyListener((ModifyListener)this.fListener);
        Composite buttonComp = new Composite(composite, 0);
        gd = new GridData();
        gd.horizontalAlignment = 3;
        gd.horizontalSpan = 2;
        buttonComp.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComp.setLayout((Layout)layout);
        Button button = SWTFactory.createPushButton((Composite)buttonComp, (String)"Handler function...", null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String startPage = SETEditProjectConfigDialog.getHandlerFunctionStartPage(SETEditProjectConfigDialog.this.fProject, SETEditProjectConfigDialog.this.getShell());
                SETEditProjectConfigDialog.this.fStartPageText.setText(startPage);
            }
        });
        button = SWTFactory.createPushButton((Composite)buttonComp, (String)"Public resource...", null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String startPage = SETEditProjectConfigDialog.getPublicResourceStartPage(SETEditProjectConfigDialog.this.fProject, SETEditProjectConfigDialog.this.getShell());
                SETEditProjectConfigDialog.this.fStartPageText.setText(startPage);
            }
        });
        this.initializeData();
        return composite;
    }

    public static String getHandlerFunctionStartPage(IProject project, Shell shell) {
        HandlerCollector collector = new HandlerCollector();
        try {
            DLTKCore.create((IProject)project).accept((IModelElementVisitor)collector);
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider());
            dialog.setElements((Object[])collector.getHandlers());
            dialog.setTitle("Start Page");
            dialog.setMessage("Select the project start page handler");
            if (dialog.open() == 0) {
                IMethod handler = (IMethod)dialog.getFirstResult();
                String functionName = handler.getElementName();
                functionName = functionName.substring(functionName.indexOf(58) + 1);
                IResource resource = handler.getResource();
                String handlerModuleName = new Path(resource.getName()).removeFileExtension().toString();
                return "/" + handlerModuleName + "/" + functionName;
            }
        }
        catch (ModelException e1) {
            e1.printStackTrace();
        }
        return "";
    }

    public static String getPublicResourceStartPage(IProject project, Shell shell) {
        ScriptUILabelProvider labelProvider = DLTKUILanguageManager.createLabelProvider((String)"org.eclipse.wst.xquery.set.core.nature");
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)labelProvider, (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length != 1) {
                    return new Status(4, "org.eclipse.wst.xquery.org.set.ui", "You must select one file");
                }
                if (!(selection[0] instanceof IFile)) {
                    return new Status(4, "org.eclipse.wst.xquery.org.set.ui", "");
                }
                return new Status(0, "org.eclipse.wst.xquery.org.set.ui", "");
            }
        });
        dialog.setTitle("Select Resource");
        dialog.setMessage("Select the resource to be set as the start page:");
        dialog.setDoubleClickSelects(true);
        IFolder publicDir = project.getFolder("public");
        dialog.setInput((Object)publicDir);
        if (dialog.open() == 0) {
            IPath path = ((IFile)dialog.getFirstResult()).getFullPath().removeFirstSegments(2);
            return "/" + path.toPortableString();
        }
        return "";
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            this.fOKButton = super.createButton(parent, id, label, defaultButton);
        }
        return this.fOKButton;
    }

    private void initializeData() {
        if (this.fConfig != null) {
            this.fUriText.setText(this.fConfig.getLogicalUri().toString());
            this.fVersionText.setText(this.fConfig.getVersion());
            String startPage = this.fConfig.getStartPage();
            if (startPage != null) {
                this.fStartPageText.setText(this.fConfig.getStartPage());
            }
        }
    }

    protected void okPressed() {
        try {
            String startPage = this.fStartPageText.getText().trim();
            startPage = this.fStartPageText.getText().trim().length() == 0 ? null : startPage;
            String version = this.fVersionText.getText().trim();
            version = version.length() == 0 ? "1.0" : version;
            this.fConfig = new SETProjectConfig(new URI(this.fUriText.getText()), startPage, version);
        }
        catch (URISyntaxException uRISyntaxException) {}
        super.okPressed();
    }

    public SETProjectConfig getProjectConfig() {
        return this.fConfig;
    }

    class WidgetListener
    implements ModifyListener {
        WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            block5: {
                if (e.widget == SETEditProjectConfigDialog.this.fUriText) {
                    try {
                        new URI(SETEditProjectConfigDialog.this.fUriText.getText());
                        SETEditProjectConfigDialog.this.setErrorMessage(null);
                        if (SETEditProjectConfigDialog.this.fOKButton != null) {
                            SETEditProjectConfigDialog.this.fOKButton.setEnabled(true);
                        }
                        break block5;
                    }
                    catch (URISyntaxException use) {
                        SETEditProjectConfigDialog.this.setErrorMessage("Invalid URI. " + use.getMessage());
                        if (SETEditProjectConfigDialog.this.fOKButton != null) {
                            SETEditProjectConfigDialog.this.fOKButton.setEnabled(false);
                        }
                        break block5;
                    }
                }
                Widget cfr_ignored_0 = e.widget;
            }
        }
    }
}

