/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.xquery.set.core.SETProjectConfig;
import org.eclipse.wst.xquery.set.core.SETProjectConfigUtil;
import org.eclipse.wst.xquery.set.internal.ui.SETEditProjectConfigDialog;

public class SETSausalitoPropertyPage
extends PropertyPage {
    private IProject fProject;
    private SETProjectConfig fConfig;
    private Label fUriLabel;
    private Label fVersionLabel;
    private Link fStartPageLink;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        if (this.getElement() instanceof IProject) {
            this.fProject = (IProject)this.getElement();
            this.fConfig = SETProjectConfigUtil.readProjectConfig((IProject)this.fProject);
            composite.setLayout((Layout)new GridLayout(2, false));
            this.createProjectConfigControls(composite);
        } else if (this.getElement() instanceof IScriptProject) {
            this.fProject = ((IScriptProject)this.getElement()).getProject();
            this.fConfig = SETProjectConfigUtil.readProjectConfig((IProject)this.fProject);
            composite.setLayout((Layout)new GridLayout(2, false));
            this.createProjectConfigControls(composite);
        }
        return composite;
    }

    private void createProjectConfigControls(final Composite composite) {
        Composite configBlock = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        configBlock.setLayout((Layout)layout);
        configBlock.setLayoutData((Object)new GridData(768));
        Label label = new Label(configBlock, 0);
        label.setText("Project logical URI:");
        this.fUriLabel = new Label(configBlock, 0);
        this.fUriLabel.setLayoutData((Object)new GridData(256));
        label = new Label(configBlock, 0);
        label.setText("Version:");
        this.fVersionLabel = new Label(configBlock, 0);
        this.fVersionLabel.setLayoutData((Object)new GridData(256));
        label = new Label(configBlock, 0);
        label.setText("Start page:");
        this.fStartPageLink = new Link(configBlock, 0);
        this.fStartPageLink.setLayoutData((Object)new GridData(256));
        this.fStartPageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String startPage = SETEditProjectConfigDialog.getHandlerFunctionStartPage(SETSausalitoPropertyPage.this.fProject, SETSausalitoPropertyPage.this.getShell());
                SETSausalitoPropertyPage.this.fStartPageLink.setText(startPage);
                SETSausalitoPropertyPage.this.fConfig.setStartPage(startPage);
            }
        });
        this.updateConfigControls();
        this.createSeparator(configBlock);
        Composite buttonBar = new Composite(configBlock, 0);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonBar.setLayout((Layout)layout);
        GridData gd = new GridData(896);
        gd.horizontalSpan = 2;
        buttonBar.setLayoutData((Object)gd);
        Button changeButton = new Button(buttonBar, 8);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        gd = new GridData(256);
        Point minButtonSize = changeButton.computeSize(-1, -1, true);
        gd.widthHint = Math.max(widthHint, minButtonSize.x);
        changeButton.setLayoutData((Object)gd);
        changeButton.setText("&Change...");
        changeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = composite.getShell();
                SETEditProjectConfigDialog dialog = new SETEditProjectConfigDialog(shell, SETSausalitoPropertyPage.this.fProject, SETSausalitoPropertyPage.this.fConfig);
                if (dialog.open() == 0) {
                    SETSausalitoPropertyPage.this.fConfig = dialog.getProjectConfig();
                    SETSausalitoPropertyPage.this.updateConfigControls();
                }
            }
        });
    }

    private void updateConfigControls() {
        boolean linkVisible;
        this.fUriLabel.setText(this.fConfig.getLogicalUri().toString());
        this.fVersionLabel.setText(this.fConfig.getVersion());
        String startPage = this.fConfig.getStartPage();
        boolean bl = linkVisible = startPage == null;
        if (!linkVisible) {
            this.fStartPageLink.setText(startPage);
        } else {
            this.fStartPageLink.setText("<A HREF=\"\">not set</A>");
        }
    }

    private void createSeparator(Composite composite) {
        Label separator = new Label(composite, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    public boolean performOk() {
        SETProjectConfigUtil.writeProjectConfig((IProject)this.fProject, (SETProjectConfig)this.fConfig);
        return true;
    }
}

