/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.ui.wizards;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.wizards.BuildpathsBlock;
import org.eclipse.dltk.ui.wizards.CapabilityConfigurationPage;
import org.eclipse.dltk.ui.wizards.ProjectWizardFirstPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.xquery.set.internal.ui.preferences.SETBuildPathsBlock;
import org.eclipse.wst.xquery.set.internal.ui.wizards.CoreSDKTemplateUtility;
import org.eclipse.wst.xquery.set.internal.ui.wizards.SETNewProjectWizardFirstPage;
import org.eclipse.wst.xquery.set.ui.SETUIPlugin;

public class SETNewProjectWizardSecondPage
extends CapabilityConfigurationPage {
    private final SETNewProjectWizardFirstPage fFirstPage;
    private URI fCurrProjectLocation;
    private IProject fCurrProject;
    private Boolean fIsAutobuild;

    public SETNewProjectWizardSecondPage(SETNewProjectWizardFirstPage mainPage) {
        this.fFirstPage = mainPage;
        this.fCurrProjectLocation = null;
        this.fCurrProject = null;
        this.fIsAutobuild = null;
    }

    public ProjectWizardFirstPage getFirstPage() {
        return this.fFirstPage;
    }

    protected boolean useNewSourcePage() {
        return true;
    }

    protected String getScriptNature() {
        return "org.eclipse.wst.xquery.set.core.nature";
    }

    protected BuildpathsBlock createBuildpathBlock(IStatusChangeListener listener) {
        return new SETBuildPathsBlock((IRunnableContext)new BusyIndicatorRunnableContext(), listener, 0, this.useNewSourcePage(), null);
    }

    final void updateProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.fCurrProject = this.fFirstPage.getProjectHandle();
        this.fCurrProjectLocation = this.getProjectLocationURI();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ScriptProjectWizardSecondPage_operation_initialize, 50);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            SETNewProjectWizardSecondPage.createProject((IProject)this.fCurrProject, (URI)this.fCurrProjectLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
            IBuildpathEntry[] entries = null;
            IPreferenceStore store = this.getPreferenceStore();
            Path handlerSrcPath = new Path(store.getString("org.eclipse.wst.xquery.set.preferences.buildpath.handler"));
            Path libSrcPath = new Path(store.getString("org.eclipse.wst.xquery.set.preferences.buildpath.library"));
            IPath projectPath = this.fCurrProject.getFullPath();
            ArrayList<IBuildpathEntry> cpEntries = new ArrayList<IBuildpathEntry>();
            cpEntries.add(DLTKCore.newSourceEntry((IPath)projectPath.append((IPath)handlerSrcPath)));
            cpEntries.add(DLTKCore.newSourceEntry((IPath)projectPath.append((IPath)libSrcPath)));
            IBuildpathEntry[] entrys = this.getDefaultBuildpathEntry();
            if (entrys != null) {
                cpEntries.addAll(Arrays.asList(entrys));
            }
            entries = cpEntries.toArray(new IBuildpathEntry[cpEntries.size()]);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.init(DLTKCore.create((IProject)this.fCurrProject), entries, false);
            this.configureScriptProject((IProgressMonitor)new SubProgressMonitor(monitor, 25));
        }
        finally {
            monitor.done();
        }
    }

    protected IPreferenceStore getPreferenceStore() {
        return SETUIPlugin.getDefault().getPreferenceStore();
    }

    private URI getProjectLocationURI() throws CoreException {
        if (this.fFirstPage.isInWorkspace()) {
            return null;
        }
        return this.fFirstPage.getLocationURI();
    }

    private IBuildpathEntry[] getDefaultBuildpathEntry() {
        IBuildpathEntry defaultPath = ScriptRuntime.getDefaultInterpreterContainerEntry();
        Path InterpreterEnvironmentContainerPath = new Path(ScriptRuntime.INTERPRETER_CONTAINER);
        IInterpreterInstall inst = this.fFirstPage.getInterpreter();
        if (inst != null) {
            IPath newPath = InterpreterEnvironmentContainerPath.append(inst.getInterpreterInstallType().getId()).append(inst.getName());
            return new IBuildpathEntry[]{DLTKCore.newContainerEntry((IPath)newPath)};
        }
        if (defaultPath != null) {
            return new IBuildpathEntry[]{defaultPath};
        }
        return null;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            monitor.beginTask(NewWizardMessages.ScriptProjectWizardSecondPage_operation_create, 100);
            this.updateProject((IProgressMonitor)new SubProgressMonitor(monitor, 50));
            this.createProjectFromTemplate(new SubProgressMonitor(monitor, 50));
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
            if (this.fIsAutobuild != null) {
                CoreUtility.enableAutoBuild((boolean)this.fIsAutobuild);
                this.fIsAutobuild = null;
            }
        }
    }

    private void createProjectFromTemplate(SubProgressMonitor monitor) throws CoreException {
        try {
            IPreferenceStore store = this.getPreferenceStore();
            String templateName = null;
            templateName = this.fFirstPage.isTemplate() ? this.fFirstPage.getTemplateName() : store.getString("org.eclipse.wst.xquery.set.preferences.templates.projects.default");
            monitor.beginTask("Creating project directory structure", 50);
            CoreSDKTemplateUtility.createProjectContent(this.fCurrProject, templateName, this.fFirstPage.getProjectUriString());
        }
        finally {
            monitor.done();
        }
    }
}

