/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.ui.wizards;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.ui.wizards.Messages;
import org.eclipse.dltk.ui.wizards.NewSourceModulePage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class XQDTNewModuleWizardPage
extends NewSourceModulePage {
    private static final String FILE = "NewSourceModulePage.file";
    private SelectionButtonDialogField fMainModuleField;
    private SelectionButtonDialogField fLibraryModuleField;
    private StringDialogField fPrefixField;
    private StringDialogField fNamespaceField;
    private IDialogFieldListener fListener = new XQueryModuleFieldModule();
    private boolean fHasError = false;
    private boolean fUserChanged = false;
    private static final String NAMESPACE_PREFIX = "http://www.example.com/";
    private static final int PREFIX_LENGTH = 4;

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        if (this.isCurrentPage()) {
            this.getContainer().updateMessage();
        }
    }

    protected String getPageDescription() {
        return "Create a new XQuery module";
    }

    protected String getPageTitle() {
        return "XQuery Module";
    }

    protected String getRequiredNature() {
        return "org.eclipse.wst.xquery.core.nature";
    }

    private XQDTNewModuleWizardPage enableLibraryModule() {
        this.fPrefixField.setEnabled(true);
        this.fNamespaceField.setEnabled(true);
        return this;
    }

    private XQDTNewModuleWizardPage disableLibraryModule() {
        this.fPrefixField.setEnabled(false);
        this.fNamespaceField.setEnabled(false);
        this.fUserChanged = false;
        return this;
    }

    protected void createContentControls(Composite composite, int nColumns) {
        composite = new Composite(composite, 8);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        Composite subComposite = new Composite(composite, 8);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        subComposite.setLayout((Layout)layout);
        subComposite.setLayoutData((Object)new GridData(768));
        super.createContentControls(subComposite, nColumns);
        Group group = new Group(composite, 8);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)this.initGridLayout(new GridLayout(3, false), true));
        group.setText("Module settings");
        this.fMainModuleField = new SelectionButtonDialogField(16);
        this.fMainModuleField.setLabelText("Main module");
        this.fMainModuleField.setSelection(true);
        this.fMainModuleField.setDialogFieldListener(this.fListener);
        this.fMainModuleField.doFillIntoGrid((Composite)group, 3);
        this.fLibraryModuleField = new SelectionButtonDialogField(16);
        this.fLibraryModuleField.setLabelText("Library module");
        this.fLibraryModuleField.setDialogFieldListener(this.fListener);
        this.fLibraryModuleField.doFillIntoGrid((Composite)group, 3);
        this.fPrefixField = new StringDialogField();
        this.fPrefixField.setLabelText("Prefix:");
        this.fPrefixField.setDialogFieldListener(this.fListener);
        this.fPrefixField.doFillIntoGrid((Composite)group, 3);
        LayoutUtil.setHorizontalGrabbing((Control)this.fPrefixField.getTextControl(null));
        this.fPrefixField.setEnabled(false);
        this.fNamespaceField = new StringDialogField();
        this.fNamespaceField.setDialogFieldListener(this.fListener);
        this.fNamespaceField.setLabelText("Namespace:");
        this.fNamespaceField.doFillIntoGrid((Composite)group, 3);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNamespaceField.getTextControl(null));
        this.fNamespaceField.setEnabled(false);
        FocusAdapter fa = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                XQDTNewModuleWizardPage.this.fUserChanged = true;
            }
        };
        this.fPrefixField.getTextControl(null).addFocusListener((FocusListener)fa);
        this.fNamespaceField.getTextControl(null).addFocusListener((FocusListener)fa);
    }

    protected String getFileContent() {
        String content = "";
        if (this.fMainModuleField.isSelected()) {
            content = "(: XQuery main module :)\n\n.";
        } else {
            String prefix = this.fPrefixField.getText();
            String namespace = this.fNamespaceField.getText();
            content = "module namespace " + prefix + " = '" + namespace + "';\n\n";
        }
        return content;
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName.equals(FILE)) {
            String fileName = this.getFileText().trim();
            if (!this.fUserChanged) {
                this.fPrefixField.setText(this.generatePrefix(fileName));
                this.fNamespaceField.setText(this.generateNamespace(fileName));
            }
        }
    }

    private String generatePrefix(String fileName) {
        if (fileName == null || fileName.equals("")) {
            return "";
        }
        String prefix = "";
        prefix = !Character.isJavaIdentifierStart(fileName.charAt(0)) ? "_" + fileName.substring(0, Math.min(fileName.length(), 3)) : fileName.substring(0, Math.min(fileName.length(), 4));
        prefix = prefix.trim().toLowerCase();
        return this.validatePrefix(prefix) ? prefix : "";
    }

    private String generateNamespace(String fileName) {
        if (fileName == null || fileName.equals("")) {
            return NAMESPACE_PREFIX;
        }
        String encodedName = "";
        try {
            encodedName = URLEncoder.encode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return NAMESPACE_PREFIX + encodedName;
    }

    private boolean validatePrefix(String prefix) {
        return prefix.matches("[a-zA-Z_][0-9a-zA-Z_\\.\\-]*");
    }

    private class XQueryModuleFieldModule
    implements IDialogFieldListener {
        private XQueryModuleFieldModule() {
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == XQDTNewModuleWizardPage.this.fMainModuleField) {
                return;
            }
            if (field == XQDTNewModuleWizardPage.this.fLibraryModuleField) {
                if (XQDTNewModuleWizardPage.this.fLibraryModuleField.isSelected()) {
                    XQDTNewModuleWizardPage.this.enableLibraryModule();
                } else {
                    XQDTNewModuleWizardPage.this.disableLibraryModule();
                }
            }
            if (XQDTNewModuleWizardPage.this.getErrorMessage() != null && !XQDTNewModuleWizardPage.this.fHasError) {
                return;
            }
            String fileName = XQDTNewModuleWizardPage.this.getFileText().trim();
            if (fileName.equals("")) {
                this.reportError(Messages.NewSourceModulePage_InvalidFileName);
                return;
            }
            String aPrefix = XQDTNewModuleWizardPage.this.fPrefixField.getText().trim();
            if (XQDTNewModuleWizardPage.this.fPrefixField.isEnabled()) {
                if (aPrefix.length() == 0) {
                    this.reportError("A prefix must be set.");
                    return;
                }
                if (!XQDTNewModuleWizardPage.this.validatePrefix(aPrefix)) {
                    this.reportError("Invalid prefix.");
                    return;
                }
            }
            String uriStr = XQDTNewModuleWizardPage.this.fNamespaceField.getText().trim();
            if (XQDTNewModuleWizardPage.this.fNamespaceField.isEnabled()) {
                try {
                    new URI(uriStr);
                }
                catch (URISyntaxException e) {
                    this.reportError("Invalid URI: " + e.getMessage());
                    return;
                }
            }
            XQDTNewModuleWizardPage.this.setPageComplete(true);
            XQDTNewModuleWizardPage.this.handleFieldChanged(XQDTNewModuleWizardPage.this.getFileName());
            XQDTNewModuleWizardPage.this.fHasError = false;
        }

        private void reportError(String message) {
            XQDTNewModuleWizardPage.this.fHasError = true;
            XQDTNewModuleWizardPage.this.setErrorMessage(message);
            XQDTNewModuleWizardPage.this.setPageComplete(false);
        }
    }
}

