/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.ui.templates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IPreferencesLookupDelegate;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ui.templates.IScriptTemplateIndenter;
import org.eclipse.dltk.ui.templates.ScriptTemplateContext;
import org.eclipse.dltk.ui.templates.TabExpandScriptTemplateIndenter;
import org.eclipse.dltk.ui.text.util.TabStyle;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.wst.xquery.core.XQDTCorePlugin;
import org.eclipse.wst.xquery.core.model.ast.XQueryLibraryModule;
import org.eclipse.wst.xquery.core.model.ast.XQueryModule;
import org.eclipse.wst.xquery.core.utils.PathUtil;

public class XQDTTemplateContext
extends ScriptTemplateContext {
    private static final String DEFAULT_URI_AND_HINT_VARIABLE_VALUE = "\"URI\" at \"location hint\"";

    public XQDTTemplateContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ISourceModule sourceModule) {
        super(type, document, completionOffset, completionLength, sourceModule);
    }

    protected IScriptTemplateIndenter getIndenter() {
        IPreferencesLookupDelegate prefs = this.getPreferences();
        if (TabStyle.SPACES == TabStyle.forName((String)prefs.getString("org.eclipse.wst.xquery.ui", "formatter.tabulation.char"))) {
            return new TabExpandScriptTemplateIndenter(prefs.getInt("org.eclipse.wst.xquery.ui", "formatter.tabulation.size"));
        }
        return super.getIndenter();
    }

    public String[] getBoundarySpaceTypes() {
        return new String[]{"preserve", "strip"};
    }

    public String[] getDefaultNamespaceTypes() {
        return new String[]{"element", "function"};
    }

    public String[] getOrderingModes() {
        return new String[]{"ordered", "unordered"};
    }

    public String[] getEmptyOrderModes() {
        return new String[]{"greatest", "least"};
    }

    public String[] getPreserveModes() {
        return new String[]{"preserve", "no-preserve"};
    }

    public String[] getInheritModes() {
        return new String[]{"inherit", "no-inherit"};
    }

    public String[] getConstructionModes() {
        return new String[]{"strip", "preserve"};
    }

    public String[] getStrictOrder() {
        return new String[]{"order by", "stable order by"};
    }

    public String[] getOrderModifiers() {
        return new String[]{"ascending", "descending"};
    }

    public String[] getIterationVariables() {
        return new String[]{"e"};
    }

    public String[] getPositionalVariables() {
        return new String[]{"i"};
    }

    public String[] getVariables() {
        return new String[]{"x"};
    }

    public String[] getFunctionName() {
        return new String[]{"name"};
    }

    public String[] getFunctionNamespace() {
        XQueryModule xqModule = (XQueryModule)SourceParserUtil.getModuleDeclaration((ISourceModule)this.getSourceModule());
        String namespacePrefix = xqModule.getNamespacePrefix();
        if (namespacePrefix != null) {
            return new String[]{namespacePrefix};
        }
        return new String[]{""};
    }

    public String[] getFunctionParams() {
        return new String[]{"(: $param as type, ... :)"};
    }

    public String[] getQuantifiers() {
        String key = this.getKey();
        if (key != null && "every".startsWith(key)) {
            return new String[]{"every", "some"};
        }
        return new String[]{"some", "every"};
    }

    public String[] getSequenceTypes() {
        return new String[]{"item()", "node()", "text()", "empty-sequence()", "document-node( ... )", "element( ... )", "schema-element( ... )", "attribute( ... )", "schema-attribute( ... )", "processing-instruction( ... )", "comment()"};
    }

    public String[] getValidationModes() {
        return new String[]{"lax", "strict"};
    }

    public String[] getXQueryVersion() {
        return new String[]{"1.0"};
    }

    public String[] getXQueryEncoding() {
        return new String[]{"utf-8"};
    }

    public String[] getTargetChoices() {
        return new String[]{"after", "before", "into", "as first into", "as last into"};
    }

    public String[] getNodeNodes() {
        return new String[]{"node", "nodes"};
    }

    public String[] getValueOf() {
        return new String[]{"", "value of "};
    }

    public String[] getSimpleFtOption() {
        return new String[]{"case insensitive", "case sensitive", "lowercase", "uppercase", "diacritics insensitive", "diacritics sensitive", "with stemming", "without stemming", "with thesaurus default", "with thesaurus at \"URI_literal\"", "without thesaurus", "with stop words (\"list_of_words\")", "without stop words", "with default stop words", "language \"string_literal\"", "with wildcards", "without wildcards", "without content expression"};
    }

    public String[] getBuiltingLibraryModuleURIs() {
        ISourceModule sourceModule = this.getSourceModule();
        IScriptProject project = sourceModule.getScriptProject();
        LibraryModuleCollector collector = new LibraryModuleCollector(true);
        ArrayList<String> namespaces = new ArrayList<String>();
        try {
            project.accept((IModelElementVisitor)collector);
            for (ISourceModule module : collector.modules) {
                XQueryLibraryModule library = (XQueryLibraryModule)SourceParserUtil.getModuleDeclaration((ISourceModule)module);
                if (library == null) continue;
                namespaces.add(library.getNamespaceUri().getValue());
            }
        }
        catch (ModelException e) {
            if (XQDTCorePlugin.DEBUG) {
                e.printStackTrace();
            }
            return new String[0];
        }
        Object[] results = namespaces.toArray(new String[namespaces.size()]);
        Arrays.sort(results);
        return results;
    }

    public String[] getLibraryModuleURIsAndHints() {
        ArrayList<String> namespacesPlusHints;
        block4: {
            ISourceModule sourceModule = this.getSourceModule();
            IScriptProject project = sourceModule.getScriptProject();
            LibraryModuleCollector collector = new LibraryModuleCollector(false);
            namespacesPlusHints = new ArrayList<String>();
            IPath parentPath = sourceModule.getParent().getPath();
            try {
                project.accept((IModelElementVisitor)collector);
                for (ISourceModule module : collector.modules) {
                    XQueryLibraryModule library = (XQueryLibraryModule)SourceParserUtil.getModuleDeclaration((ISourceModule)module);
                    String uri = library.getNamespaceUri().getValue();
                    String hint = PathUtil.makePathRelativeTo((IPath)module.getPath(), (IPath)parentPath).toPortableString();
                    namespacesPlusHints.add("\"" + uri + "\" at \"" + hint + "\"");
                }
            }
            catch (ModelException e) {
                if (!XQDTCorePlugin.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        if (namespacesPlusHints.size() == 0) {
            return new String[]{DEFAULT_URI_AND_HINT_VARIABLE_VALUE};
        }
        Object[] results = namespacesPlusHints.toArray(new String[namespacesPlusHints.size()]);
        Arrays.sort(results);
        return results;
    }

    public String[] getSchemaImportPrefix() {
        return new String[]{"namespace ns =", "default element namespace"};
    }

    public String[] getSchemaUriAndHints() {
        return new String[]{"\"\" at \"\""};
    }

    static class LibraryModuleCollector
    implements IModelElementVisitor {
        final Set<ISourceModule> modules = new HashSet<ISourceModule>();
        private boolean fBuiltins = false;

        public LibraryModuleCollector(boolean builtins) {
            this.fBuiltins = builtins;
        }

        public boolean visit(IModelElement element) {
            if (element.getElementType() == 5) {
                ModuleDeclaration module;
                if (this.fBuiltins && element instanceof IExternalSourceModule) {
                    this.modules.add((ISourceModule)element);
                } else if (!this.fBuiltins && !(element instanceof IExternalSourceModule) && (module = SourceParserUtil.getModuleDeclaration((ISourceModule)((ISourceModule)element))) instanceof XQueryLibraryModule) {
                    this.modules.add((ISourceModule)element);
                }
                return false;
            }
            return true;
        }
    }
}

