/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.ObjectNavigator;
import com.google.gson.ObjectNavigatorFactory;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.google.gson.Preconditions;
import com.google.gson.TypeInfoArray;
import com.google.gson.TypeInfoFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JsonSerializationVisitor
implements ObjectNavigator.Visitor {
    private final ObjectNavigatorFactory factory;
    private final ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers;
    private final boolean serializeNulls;
    private final JsonSerializationContext context;
    private JsonElement root;

    JsonSerializationVisitor(ObjectNavigatorFactory factory, boolean serializeNulls, ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers, JsonSerializationContext context) {
        this.factory = factory;
        this.serializeNulls = serializeNulls;
        this.serializers = serializers;
        this.context = context;
    }

    @Override
    public Object getTarget() {
        return null;
    }

    @Override
    public void startVisitingObject(Object node) {
        this.assignToRoot(new JsonObject());
    }

    @Override
    public void visitArray(Object array, Type arrayType) {
        this.assignToRoot(new JsonArray());
        int length = Array.getLength(array);
        TypeInfoArray fieldTypeInfo = TypeInfoFactory.getTypeInfoForArray(arrayType);
        Type componentType = fieldTypeInfo.getSecondLevelType();
        int i = 0;
        while (i < length) {
            Object child = Array.get(array, i);
            this.addAsArrayElement(componentType, child);
            ++i;
        }
    }

    @Override
    public void visitArrayField(Field f, Type typeOfF, Object obj) {
        if (this.isFieldNull(f, obj)) {
            if (this.serializeNulls) {
                this.addChildAsElement(f, JsonNull.createJsonNull());
            }
        } else {
            Object array = this.getFieldValue(f, obj);
            this.addAsChildOfObject(f, typeOfF, array);
        }
    }

    @Override
    public void visitObjectField(Field f, Type typeOfF, Object obj) {
        if (this.isFieldNull(f, obj)) {
            if (this.serializeNulls) {
                this.addChildAsElement(f, JsonNull.createJsonNull());
            }
        } else {
            Object fieldValue = this.getFieldValue(f, obj);
            if (fieldValue != null && typeOfF == Object.class) {
                typeOfF = fieldValue.getClass();
            }
            this.addAsChildOfObject(f, typeOfF, fieldValue);
        }
    }

    private void addAsChildOfObject(Field f, Type fieldType, Object fieldValue) {
        JsonElement childElement = this.getJsonElementForChild(fieldType, fieldValue);
        this.addChildAsElement(f, childElement);
    }

    private void addChildAsElement(Field f, JsonElement childElement) {
        FieldNamingStrategy namingPolicy = this.factory.getFieldNamingPolicy();
        this.root.getAsJsonObject().add(namingPolicy.translateName(f), childElement);
    }

    private void addAsArrayElement(Type elementType, Object elementValue) {
        if (elementValue == null) {
            this.root.getAsJsonArray().add(JsonNull.createJsonNull());
        } else {
            JsonElement childElement = this.getJsonElementForChild(elementType, elementValue);
            this.root.getAsJsonArray().add(childElement);
        }
    }

    private JsonElement getJsonElementForChild(Type fieldType, Object fieldValue) {
        ObjectNavigator on = this.factory.create(fieldValue, fieldType);
        JsonSerializationVisitor childVisitor = new JsonSerializationVisitor(this.factory, this.serializeNulls, this.serializers, this.context);
        on.accept(childVisitor);
        return childVisitor.getJsonElement();
    }

    @Override
    public boolean visitUsingCustomHandler(Object obj, Type objType) {
        JsonSerializer<?> serializer = this.serializers.getHandlerFor(objType);
        if (serializer != null) {
            if (obj == null) {
                this.assignToRoot(JsonNull.createJsonNull());
            } else {
                this.assignToRoot(serializer.serialize(obj, objType, this.context));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean visitFieldUsingCustomHandler(Field f, Type actualTypeOfField, Object parent) {
        Object obj;
        block5: {
            try {
                Preconditions.checkState(this.root.isJsonObject());
                obj = f.get(parent);
                if (obj != null) break block5;
                if (this.serializeNulls) {
                    this.addChildAsElement(f, JsonNull.createJsonNull());
                }
                return true;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException();
            }
        }
        JsonSerializer<?> serializer = this.serializers.getHandlerFor(actualTypeOfField);
        if (serializer != null) {
            JsonElement child = serializer.serialize(obj, actualTypeOfField, this.context);
            this.addChildAsElement(f, child);
            return true;
        }
        return false;
    }

    private void assignToRoot(JsonElement newRoot) {
        Preconditions.checkNotNull(newRoot);
        this.root = newRoot;
    }

    private boolean isFieldNull(Field f, Object obj) {
        return this.getFieldValue(f, obj) == null;
    }

    private Object getFieldValue(Field f, Object obj) {
        try {
            return f.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonElement getJsonElement() {
        return this.root;
    }
}

