/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.MemoryRefStack;
import com.google.gson.Preconditions;
import com.google.gson.TypeInfo;
import com.google.gson.TypeInfoFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectNavigator {
    private final ExclusionStrategy exclusionStrategy;
    private final MemoryRefStack<Object> ancestors;
    private final Object obj;
    private final Type objType;

    ObjectNavigator(Object obj, Type objType, ExclusionStrategy exclusionStrategy, MemoryRefStack<Object> ancestors) {
        Preconditions.checkNotNull(exclusionStrategy);
        Preconditions.checkNotNull(ancestors);
        this.obj = obj;
        this.objType = objType;
        this.exclusionStrategy = exclusionStrategy;
        this.ancestors = ancestors;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void accept(Visitor visitor) {
        Object objectToVisit;
        boolean visitedWithCustomHandler = visitor.visitUsingCustomHandler(this.obj, this.objType);
        if (visitedWithCustomHandler) return;
        Object object = objectToVisit = this.obj == null ? visitor.getTarget() : this.obj;
        if (objectToVisit == null) {
            return;
        }
        TypeInfo objTypeInfo = new TypeInfo(this.objType);
        if (this.exclusionStrategy.shouldSkipClass(objTypeInfo.getRawClass())) {
            return;
        }
        if (this.ancestors.contains(objectToVisit)) {
            throw new IllegalStateException("Circular reference found: " + objectToVisit);
        }
        this.ancestors.push(objectToVisit);
        try {
            block11: {
                Class<?> curr;
                block10: {
                    if (objTypeInfo.isArray()) {
                        visitor.visitArray(objectToVisit, this.objType);
                        return;
                    }
                    visitor.startVisitingObject(objectToVisit);
                    curr = objTypeInfo.getRawClass();
                    if (!true) break block10;
                    if (curr == null) return;
                    if (curr.equals(Object.class)) break block11;
                }
                do {
                    if (!curr.isSynthetic()) {
                        this.navigateClassFields(objectToVisit, curr, visitor);
                    }
                    curr = curr.getSuperclass();
                    if (curr == null) return;
                } while (!curr.equals(Object.class));
            }
            return;
        }
        finally {
            this.ancestors.pop();
        }
    }

    private void navigateClassFields(Object obj, Class<?> clazz, Visitor visitor) {
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        AccessibleObject[] accessibleObjectArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            boolean visitedWithCustomHandler;
            AccessibleObject f = accessibleObjectArray[n2];
            TypeInfo fieldTypeInfo = TypeInfoFactory.getTypeInfoForField((Field)f, this.objType);
            Type actualTypeOfField = fieldTypeInfo.getActualType();
            if (!this.exclusionStrategy.shouldSkipField((Field)f) && !(visitedWithCustomHandler = visitor.visitFieldUsingCustomHandler((Field)f, actualTypeOfField, obj))) {
                if (fieldTypeInfo.isArray()) {
                    visitor.visitArrayField((Field)f, actualTypeOfField, obj);
                } else {
                    visitor.visitObjectField((Field)f, actualTypeOfField, obj);
                }
            }
            ++n2;
        }
    }

    public static interface Visitor {
        public void startVisitingObject(Object var1);

        public void visitArray(Object var1, Type var2);

        public void visitObjectField(Field var1, Type var2, Object var3);

        public void visitArrayField(Field var1, Type var2, Object var3);

        public boolean visitUsingCustomHandler(Object var1, Type var2);

        public boolean visitFieldUsingCustomHandler(Field var1, Type var2, Object var3);

        public Object getTarget();
    }
}

