/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.debug.ui.marklogic.interpreters;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.xquery.debug.ui.interpreters.AbstractAddInterpreterDialogBlock;

public class MarkLogicAddInterpreterDialogBlock
extends AbstractAddInterpreterDialogBlock {
    protected StringDialogField fInterpreterNameField;
    protected StringDialogField fInterpreterLocationField;
    protected StringDialogField fInterpreterUserField;
    protected StringDialogField fInterpreterPasswordField;
    private IStatus[] fStati = new IStatus[5];
    private static final char PASS_CHAR = '\u25cf';
    private static final String SEPARATOR = "|";

    public MarkLogicAddInterpreterDialogBlock() {
        int i = 0;
        while (i < this.fStati.length) {
            this.fStati[i] = new StatusInfo();
            ++i;
        }
    }

    protected void addControlsTo(Composite comp) {
        int numColumns = 3;
        this.fInterpreterNameField = new StringDialogField();
        this.fInterpreterNameField.setLabelText(InterpretersMessages.addInterpreterDialog_InterpreterEnvironmentName);
        this.fInterpreterNameField.doFillIntoGrid(comp, numColumns);
        this.fInterpreterLocationField = new StringDialogField();
        this.fInterpreterLocationField.setLabelText("XCC UR&L:");
        this.fInterpreterLocationField.doFillIntoGrid(comp, numColumns);
        ((GridData)this.fInterpreterLocationField.getTextControl(null).getLayoutData()).widthHint = this.convertWidthInCharsToPixels(70);
        this.fInterpreterUserField = new StringDialogField();
        this.fInterpreterUserField.setLabelText("MarkLogic &User:");
        this.fInterpreterUserField.doFillIntoGrid(comp, numColumns);
        this.fInterpreterPasswordField = new StringDialogField();
        this.fInterpreterPasswordField.setLabelText("Password:");
        this.fInterpreterPasswordField.doFillIntoGrid(comp, numColumns);
        this.fInterpreterPasswordField.getTextControl(null).setEchoChar('\u25cf');
    }

    public String getInterpreterLocation() {
        return this.fInterpreterLocationField.getText();
    }

    public String getInterpreterName() {
        return this.fInterpreterNameField.getText();
    }

    public void initializeFields(IInterpreterInstall install) {
        if (install == null) {
            this.fInterpreterNameField.setText("");
            this.fInterpreterLocationField.setText("");
        } else {
            String[] parts = install.getInterpreterArgs().trim().split("\\|");
            this.fInterpreterNameField.setText(install.getName());
            this.fInterpreterLocationField.setText(parts[0]);
            this.fInterpreterUserField.setText(parts[1]);
            this.fInterpreterPasswordField.setText(parts[2]);
        }
        this.setInterpreterNameStatus(this.validateInterpreterName());
        this.setInterpreterLocationStatus(this.validateInterpreterLocation());
        this.updateStatus();
    }

    public void setFieldValuesToInterpreter(IInterpreterInstall install) {
        install.setName(this.getInterpreterName());
        IEnvironment selectedEnv = this.fAddInterpreterDialog.getEnvironment();
        install.setInstallLocation(selectedEnv.getFile((IPath)new Path(System.getProperty("java.io.tmpdir"))));
        install.setInterpreterArgs(String.valueOf(this.fInterpreterLocationField.getText()) + SEPARATOR + this.fInterpreterUserField.getText() + SEPARATOR + this.fInterpreterPasswordField.getText());
    }

    protected IStatus validateInterpreterLocation() {
        String locationName = this.getInterpreterLocation();
        Object s = null;
        if (locationName.length() == 0) {
            s = new StatusInfo(1, InterpretersMessages.addInterpreterDialog_enterLocation);
        } else {
            try {
                URI uri = new URI(locationName);
                s = uri.getHost() == null || uri.getHost().length() == 0 ? new StatusInfo(4, "The XCC URL host cannot be empty.") : Status.OK_STATUS;
            }
            catch (URISyntaxException use) {
                s = new StatusInfo(4, "Invalid XCC URL (" + use.getMessage() + ")");
            }
        }
        return s;
    }

    public String generateInterpreterName(String location) {
        return null;
    }

    public void createFieldListeners() {
        this.fInterpreterNameField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                MarkLogicAddInterpreterDialogBlock.this.setInterpreterNameStatus(MarkLogicAddInterpreterDialogBlock.this.validateInterpreterName());
                MarkLogicAddInterpreterDialogBlock.this.updateStatus();
            }
        });
        this.fInterpreterLocationField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                MarkLogicAddInterpreterDialogBlock.this.setInterpreterLocationStatus(MarkLogicAddInterpreterDialogBlock.this.validateInterpreterLocation());
                MarkLogicAddInterpreterDialogBlock.this.updateStatus();
            }
        });
    }

    protected IStatus validateInterpreterName() {
        StatusInfo status = new StatusInfo();
        String name = this.fInterpreterNameField.getText();
        if (name == null || name.trim().length() == 0) {
            status.setInfo(InterpretersMessages.addInterpreterDialog_enterName);
        } else if (this.fRequestor.isDuplicateName(name) && (this.fEditedInterpreter == null || !name.equals(this.fEditedInterpreter.getName()))) {
            status.setError(InterpretersMessages.addInterpreterDialog_duplicateName);
        }
        return status;
    }

    private void setInterpreterNameStatus(IStatus status) {
        this.fStati[0] = status;
    }

    private void setInterpreterLocationStatus(IStatus status) {
        this.fStati[1] = status;
    }

    public void updateStatus() {
        IStatus max = null;
        int i = 0;
        while (i < this.fStati.length) {
            IStatus curr = this.fStati[i];
            if (curr.matches(4)) {
                this.getStatusListener().statusChanged(curr);
                return;
            }
            if (max == null || curr.getSeverity() > max.getSeverity()) {
                max = curr;
            }
            ++i;
        }
        this.getStatusListener().statusChanged(max);
    }
}

