/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.http;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.wst.xquery.marklogic.http.HttpHeaders;
import org.eclipse.wst.xquery.marklogic.http.MultipartSplitter;
import org.eclipse.wst.xquery.marklogic.http.PartInputStream;
import org.eclipse.wst.xquery.marklogic.io.IOHelper;

public class MultipartBuffer {
    private InputStream partInputStream;
    private MultipartSplitter splitter;
    private HttpHeaders headers = new HttpHeaders();

    public MultipartBuffer(MultipartSplitter splitter) {
        this.splitter = splitter;
    }

    public String getHeader(String name) {
        return this.headers.getHeaderNormalized(name);
    }

    public void close() throws IOException {
        if (this.partInputStream != null) {
            this.partInputStream.close();
            this.partInputStream = null;
        }
        if (this.splitter != null) {
            this.splitter.close();
            this.splitter = null;
        }
    }

    public boolean isClosed() {
        return this.splitter == null;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.partInputStream == null) {
            throw new IllegalStateException("No active part stream");
        }
        return this.partInputStream.read(buf, off, len);
    }

    public String getBodyAsString() throws IOException {
        if (this.partInputStream == null) {
            throw new IllegalStateException("No active part stream");
        }
        return IOHelper.literalStringFromStream(this.partInputStream);
    }

    public InputStream nextStream() throws IOException {
        if (!this.next()) {
            return null;
        }
        return this.partInputStream;
    }

    public boolean next() throws IOException {
        if (!this.splitter.hasNext()) {
            this.partInputStream = null;
            return false;
        }
        this.splitter.next();
        this.partInputStream = new PartInputStream(this.splitter);
        this.headers.clear();
        this.headers.parsePlainHeaders(this.partInputStream);
        return true;
    }

    public boolean hasNext() throws IOException {
        return this.splitter.hasNext();
    }

    public InputStream getBodyStream() {
        if (this.partInputStream == null) {
            throw new IllegalStateException("No active part stream");
        }
        return this.partInputStream;
    }
}

