/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.io;

import java.io.IOException;
import java.io.InputStream;

public class LengthLimitedInputStream
extends InputStream {
    private InputStream stream;
    private boolean limitReached = false;
    private long limit;
    private long readCount = 0L;

    public LengthLimitedInputStream(InputStream stream, long limit) {
        this.stream = stream;
        this.limit = limit < 0L ? Long.MAX_VALUE : limit;
    }

    public int read() throws IOException {
        if (this.checkLimit()) {
            return -1;
        }
        int rc = this.stream.read();
        if (rc != -1) {
            this.advanceReadCount(1L);
        }
        return rc;
    }

    public int read(byte[] buffer, int off, int len) throws IOException {
        if (this.checkLimit()) {
            return -1;
        }
        int toRead = (int)this.maxReadable(len);
        int rc = this.stream.read(buffer, off, toRead);
        if (rc <= 0) {
            return rc;
        }
        this.advanceReadCount(rc);
        return rc;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public void close() throws IOException {
        this.limitReached = true;
        this.stream.close();
    }

    public long skip(long n) throws IOException {
        long toSkip = this.maxReadable(n);
        long skipped = super.skip(toSkip);
        this.advanceReadCount(skipped);
        return skipped;
    }

    private void advanceReadCount(long n) {
        this.readCount += n;
        this.checkLimit();
    }

    private long maxReadable(long n) {
        return Math.min(n, this.limit - this.readCount);
    }

    private boolean checkLimit() {
        if (this.limitReached) {
            return true;
        }
        if (this.readCount == this.limit) {
            this.limitReached = true;
        }
        return this.limitReached;
    }
}

