/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.impl;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.xquery.marklogic.io.IOHelper;
import org.eclipse.wst.xquery.marklogic.xcc.Request;
import org.eclipse.wst.xquery.marklogic.xcc.RequestOptions;
import org.eclipse.wst.xquery.marklogic.xcc.Session;
import org.eclipse.wst.xquery.marklogic.xcc.ValueFactory;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.UnimplementedFeatureException;
import org.eclipse.wst.xquery.marklogic.xcc.types.ValueType;
import org.eclipse.wst.xquery.marklogic.xcc.types.XName;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmNode;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmSequence;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmValue;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmVariable;

public abstract class RequestImpl
implements Request {
    private final Session session;
    private RequestOptions options;
    private Set<XdmVariable> variables = Collections.synchronizedSet(new LinkedHashSet());

    public RequestImpl(Session session, RequestOptions options) {
        this.session = session;
        this.setOptions(options);
    }

    abstract void urlEncodeXQueryString(StringBuffer var1, Logger var2);

    abstract String serverPath();

    abstract String requestVar();

    public Session getSession() {
        return this.session;
    }

    public void setOptions(RequestOptions options) {
        this.options = options == null ? new RequestOptions() : options;
    }

    public RequestOptions getOptions() {
        return this.options;
    }

    public RequestOptions getEffectiveOptions() {
        RequestOptions eff = new RequestOptions();
        RequestOptions req = this.getOptions();
        RequestOptions ses = this.getSession().getDefaultRequestOptions();
        eff.applyEffectiveValues(new RequestOptions[]{ses, req});
        return eff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVariable(XdmVariable variable) {
        XdmValue value = variable.getValue();
        if (value instanceof XdmNode) {
            throw new UnimplementedFeatureException("Setting variables of type XdmNode is not supported");
        }
        if (value instanceof XdmSequence) {
            throw new UnimplementedFeatureException("Setting variables that are sequences is not supported");
        }
        Set<XdmVariable> set = this.variables;
        synchronized (set) {
            this.clearVariable(variable);
            this.variables.add(variable);
        }
    }

    public XdmVariable setNewVariable(XName xname, XdmValue value) {
        XdmVariable variable = ValueFactory.newVariable(xname, value);
        this.setVariable(variable);
        return variable;
    }

    public XdmVariable setNewVariable(String namespace, String localname, ValueType type, Object value) {
        return this.setNewVariable(new XName(namespace, localname), ValueFactory.newValue(type, value));
    }

    public XdmVariable setNewVariable(String localname, ValueType type, Object value) {
        return this.setNewVariable(null, localname, type, value);
    }

    public XdmVariable setNewStringVariable(String namespace, String localname, String value) {
        return this.setNewVariable(namespace, localname, ValueType.XS_STRING, value);
    }

    public XdmVariable setNewStringVariable(String localname, String value) {
        return this.setNewStringVariable(null, localname, value);
    }

    public XdmVariable setNewIntegerVariable(String namespace, String localname, long value) {
        return this.setNewVariable(namespace, localname, ValueType.XS_INTEGER, new Long(value));
    }

    public XdmVariable setNewIntegerVariable(String localname, long value) {
        return this.setNewIntegerVariable(null, localname, value);
    }

    public void clearVariable(XdmVariable variable) {
        this.variables.remove(variable);
    }

    public void clearVariables() {
        this.variables.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XdmVariable[] getVariables() {
        Set<XdmVariable> set = this.variables;
        synchronized (set) {
            XdmVariable[] vars = new XdmVariable[this.variables.size()];
            this.variables.toArray(vars);
            return vars;
        }
    }

    String encodedQueryString(Logger logger) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.requestVar()).append("=");
        this.urlEncodeXQueryString(sb, logger);
        this.encodeQueryOptions(sb, null);
        this.encodeQueryVariables(sb, logger);
        String payload = sb.toString();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Eval request POST payload: '" + payload + "'");
        }
        return payload;
    }

    public void encodeQueryOptions(StringBuffer sb, RequestOptions requestOptions) {
        RequestOptions options = requestOptions == null ? this.getEffectiveOptions() : requestOptions;
        sb.append("&locale=").append(options.getLocale().toString());
        sb.append("&tzoffset=").append(options.getTimeZone().getOffset(System.currentTimeMillis()) / 1000);
        if (this.session.getContentBaseName() != null) {
            String dbname = this.session.getContentBaseName();
            if (this.isName(dbname)) {
                sb.append("&dbname=");
                IOHelper.urlEncodeToStringBuffer(sb, this.session.getContentBaseName());
            } else {
                sb.append("&dbid=").append(dbname.substring(1));
            }
        }
        if (options.getEffectivePointInTime() != null) {
            sb.append("&timestamp=").append(options.getEffectivePointInTime().toString());
        }
        if (options.getRequestName() != null) {
            sb.append("&requestname=");
            IOHelper.urlEncodeToStringBuffer(sb, options.getRequestName());
        }
        if (options.getDefaultXQueryVersion() != null) {
            sb.append("&defaultxquery=");
            IOHelper.urlEncodeToStringBuffer(sb, options.getDefaultXQueryVersion());
        }
        if (options.getRequestTimeLimit() != -1) {
            sb.append("&timelimit=").append(options.getRequestTimeLimit());
        }
    }

    private void encodeQueryVariables(StringBuffer sb, Logger logger) {
        XdmVariable[] vars = this.getVariables();
        int i = 0;
        while (i < vars.length) {
            XdmVariable var = vars[i];
            XName xname = var.getName();
            XdmValue value = var.getValue();
            sb.append("&evn").append(i).append("=");
            if (xname.getNamespace() != null) {
                sb.append(xname.getNamespace());
            }
            sb.append("&evl").append(i).append("=").append(xname.getLocalname());
            sb.append("&evt").append(i).append("=");
            IOHelper.urlEncodeToStringBuffer(sb, value.getValueType().toString());
            sb.append("&evv").append(i).append("=");
            IOHelper.urlEncodeToStringBuffer(sb, value.toString());
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(" ev" + i + ": " + xname.toString() + "(" + value.getValueType() + ") " + value.toString());
            }
            ++i;
        }
    }

    protected boolean isName(String name) {
        if (name.length() == 0) {
            return true;
        }
        return name.charAt(0) != '#';
    }
}

