/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.xquery.marklogic.io.GenericResourcePool;
import org.eclipse.wst.xquery.marklogic.io.SslByteChannel;
import org.eclipse.wst.xquery.marklogic.xcc.Request;
import org.eclipse.wst.xquery.marklogic.xcc.SecurityOptions;
import org.eclipse.wst.xquery.marklogic.xcc.Session;
import org.eclipse.wst.xquery.marklogic.xcc.impl.SSLConnection;
import org.eclipse.wst.xquery.marklogic.xcc.impl.SocketPoolProvider;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ConnectionErrorAction;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ConnectionProvider;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ServerConnection;
import org.eclipse.wst.xquery.marklogic.xcc.spi.SingleHostAddress;

public class SSLSocketPoolProvider
implements ConnectionProvider,
SingleHostAddress {
    private final SocketAddress address;
    private final SecurityOptions securityOptions;
    private final SocketPoolProvider socketProvider;
    private final SSLConnectionResourcePool sslPool;
    private final Logger logger = Logger.getLogger(ConnectionProvider.class.getName());

    public SSLSocketPoolProvider(SocketAddress address, SecurityOptions options) throws NoSuchAlgorithmException, KeyManagementException {
        this.logger.fine("constructing new SSLSocketPoolProvider");
        this.address = address;
        this.socketProvider = new SocketPoolProvider(address);
        this.securityOptions = options;
        this.sslPool = new SSLConnectionResourcePool(this.socketProvider.getPoolSize());
    }

    public InetSocketAddress getAddress() {
        return (InetSocketAddress)(this.address instanceof InetSocketAddress ? this.address : null);
    }

    public ServerConnection obtainConnection(Session session, Request request, Logger logger) throws IOException {
        ServerConnection conn = (ServerConnection)this.sslPool.get(this.address);
        if (conn != null) {
            return conn;
        }
        conn = this.socketProvider.obtainConnection(session, request, logger);
        return new SSLConnection(conn, this.securityOptions, this, logger);
    }

    public void returnConnection(ServerConnection connection, Logger logger) {
        ByteChannel channel;
        if (this.getLogger(logger).isLoggable(Level.FINE)) {
            this.getLogger(logger).fine("returnConnection for " + this.address + ", expire=" + connection.getTimeoutMillis());
        }
        if ((channel = connection.channel()) == null || !(channel instanceof SslByteChannel)) {
            this.getLogger(logger).fine("channel is not eligible for pooling, dropping");
            try {
                channel.close();
            }
            catch (IOException iOException) {
                this.getLogger(logger).fine("unable to close channel");
            }
            return;
        }
        SslByteChannel socketChannel = (SslByteChannel)channel;
        if (!socketChannel.isOpen()) {
            this.getLogger(logger).fine("channel has been closed, dropping");
            return;
        }
        long timeoutMillis = connection.getTimeoutMillis();
        if (timeoutMillis <= 0L) {
            this.getLogger(logger).fine("channel has already expired, closing");
            connection.close();
            return;
        }
        long timeoutTime = connection.getTimeoutTime();
        if (this.getLogger(logger).isLoggable(Level.FINE)) {
            this.getLogger(logger).fine("returning socket to pool (" + this.address + "), timeout time=" + timeoutTime);
        }
        this.sslPool.put(this.address, connection, timeoutTime);
    }

    public ConnectionErrorAction returnErrorConnection(ServerConnection connection, Throwable exception, Logger logger) {
        this.getLogger(logger).fine("error return: " + exception);
        ByteChannel channel = connection.channel();
        if (channel != null) {
            if (channel.isOpen()) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {}
            } else {
                this.getLogger(logger).warning("returned error connection is closed, retrying");
                return ConnectionErrorAction.RETRY;
            }
        }
        this.getLogger(logger).fine("returning FAIL action");
        return ConnectionErrorAction.FAIL;
    }

    public void shutdown(Logger logger) {
        ServerConnection conn;
        this.getLogger(logger).fine("shutting down socket pool provider");
        while ((conn = (ServerConnection)this.sslPool.get(this.address)) != null) {
            SocketChannel channel = (SocketChannel)conn.channel();
            try {
                channel.close();
            }
            catch (IOException iOException) {}
        }
        this.socketProvider.shutdown(logger);
    }

    public String toString() {
        return "SSLconn address=" + this.address.toString() + ", pool=" + this.sslPool.size(this.address) + "/" + this.socketProvider.getPoolSize();
    }

    private Logger getLogger(Logger clientLogger) {
        return clientLogger == null ? this.logger : clientLogger;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SSLConnectionResourcePool
    extends GenericResourcePool<SocketAddress, ServerConnection> {
        SSLConnectionResourcePool(int limit) {
            super(limit);
        }

        @Override
        protected void itemExpired(GenericResourcePool.PoolItem item) {
            ServerConnection conn = (ServerConnection)item.getValue();
            conn.close();
        }
    }
}

