/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.types.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.wst.xquery.marklogic.xcc.types.ItemType;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.AbstractItem;

abstract class AbstractStringItem
extends AbstractItem {
    private final String value;

    protected AbstractStringItem(ItemType type, String value) {
        super(type);
        this.value = value;
    }

    public boolean isCached() {
        return true;
    }

    public String asString() {
        return this.value;
    }

    public Reader asReader() {
        return new StringReader(this.value);
    }

    public InputStream asInputStream() {
        try {
            return new ByteArrayInputStream(this.value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new ByteArrayInputStream(this.value.getBytes());
        }
    }

    protected String scrubbedFloatValue(String rawValue) {
        if (rawValue.equalsIgnoreCase("-INF")) {
            return "-Infinity";
        }
        if (rawValue.equalsIgnoreCase("+INF")) {
            return "+Infinity";
        }
        if (rawValue.equalsIgnoreCase("INF")) {
            return "Infinity";
        }
        return rawValue;
    }

    public String toString() {
        return this.asString();
    }
}

