xquery version "1.0-ml";

(: Copyright (c) 2002-2009 Mark Logic Corporation. All rights reserved.
 : 
 :  This program and the accompanying materials are made available
 :  under the terms of the Eclipse Public License v1.0 which
 :  accompanies this distribution, and is available at
 :  http://www.eclipse.org/legal/epl-v10.html
 : 
 :  Contributors:
 :      Mark Logic, Inc.
 :)

module namespace admin="http://marklogic.com/xdmp/admin";

declare function admin:appserver-add-namespace($config as element(configuration), $appserver-id as xs:unsignedLong, $namespaces as element(gr:namespace)*) as element(configuration) external;
declare function admin:appserver-add-request-blackout($config as element(configuration), $appserver-id as xs:unsignedLong, $request-blackouts as element(gr:request-blackout)*) as element(configuration) external;
declare function admin:appserver-add-schema($config as element(configuration), $appserver-id as xs:unsignedLong, $schemas as element(gr:schema)*) as element(configuration) external;
declare function admin:appserver-copy($config as element(configuration), $appserver-id as xs:unsignedLong, $target-group-id as xs:unsignedLong?, $appserver-name as xs:string, $port as xs:unsignedLong) as element(configuration) external;
declare function admin:appserver-delete($config as element(configuration), $appserver-ids as xs:unsignedLong*) as element(configuration) external;
declare function admin:appserver-delete-namespace($config as element(configuration), $appserver-id as xs:unsignedLong, $namespaces as element(gr:namespace)*) as element(configuration) external;
declare function admin:appserver-delete-request-blackout($config as element(configuration), $appserver-id as xs:unsignedLong, $blackouts as element(gr:request-blackout)*) as element(configuration) external;
declare function admin:appserver-delete-schema($config as element(configuration), $appserver-id as xs:unsignedLong, $schemas as element(gr:schema)*) as element(configuration) external;
declare function admin:appserver-get-address($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:string external;
declare function admin:appserver-get-authentication($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:string external;
declare function admin:appserver-get-backlog($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:appserver-get-collation($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:string external;
declare function admin:appserver-get-compute-content-length($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:boolean external;
declare function admin:appserver-get-concurrent-request-limit($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:appserver-get-database($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedLong external;
declare function admin:appserver-get-debug-allow($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:boolean external;
declare function admin:appserver-get-default-time-limit($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:appserver-get-default-user($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedLong external;
declare function admin:appserver-get-default-xquery-version($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:string external;
declare function admin:appserver-get-display-last-login($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:boolean external;
declare function admin:appserver-get-enabled($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:boolean external;
declare function admin:appserver-get-error-handler($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:string external;
declare function admin:appserver-get-group-id($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedLong external;
declare function admin:appserver-get-host-ids($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedLong* external;
declare function admin:appserver-get-id($config as element(configuration), $group-ids as xs:unsignedLong*, $appserver-name as xs:string) as xs:unsignedLong* external;
declare function admin:appserver-get-keep-alive-timeout($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:appserver-get-last-login($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedLong external;
declare function admin:appserver-get-log-errors($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:boolean external;
declare function admin:appserver-get-max-time-limit($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:appserver-get-modules-database($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedLong external;
declare function admin:appserver-get-name($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:string external;
declare function admin:appserver-get-namespaces($config as element(configuration), $appserver-id as xs:unsignedLong) as element(gr:namespace)* external;
declare function admin:appserver-get-output-encoding($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:string external;
declare function admin:appserver-get-output-sgml-character-entities($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:string external;
declare function admin:appserver-get-port($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:appserver-get-pre-commit-trigger-depth($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:appserver-get-pre-commit-trigger-limit($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:appserver-get-privilege($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedLong external;
declare function admin:appserver-get-profile-allow($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:boolean external;
declare function admin:appserver-get-request-blackouts($config as element(configuration), $appserver-id as xs:unsignedLong) as element(gr:request-blackout)* external;
declare function admin:appserver-get-request-timeout($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:appserver-get-root($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:string external;
declare function admin:appserver-get-schemas($config as element(configuration), $appserver-id as xs:unsignedLong) as element(gr:schema)* external;
declare function admin:appserver-get-session-timeout($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:appserver-get-ssl-allow-sslv3($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:boolean external;
declare function admin:appserver-get-ssl-allow-tls($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:boolean external;
declare function admin:appserver-get-ssl-certificate-template($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedLong external;
declare function admin:appserver-get-ssl-ciphers($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:string external;
declare function admin:appserver-get-ssl-client-certificate-authorities($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedLong* external;
declare function admin:appserver-get-ssl-hostname($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:string? external;
declare function admin:appserver-get-static-expires($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:appserver-get-threads($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:appserver-get-type($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:string external;
declare function admin:appserver-get-url-rewriter($config as element(configuration), $appserver-id as xs:unsignedLong) as xs:string external;
declare function admin:appserver-one-time-request-blackout($users as xs:unsignedLong*, $roles as xs:unsignedLong*, $start as xs:dateTime, $end as xs:dateTime?, $duration as xs:duration?) as element(gr:request-blackout) external;
declare function admin:appserver-recurring-request-blackout($users as xs:unsignedLong*, $roles as xs:unsignedLong*, $days as xs:string*, $start-time as xs:time?, $end-time as xs:time?, $duration as xs:duration?) as element(gr:request-blackout) external;
declare function admin:appserver-set-address($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:appserver-set-authentication($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:appserver-set-backlog($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:appserver-set-collation($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:appserver-set-compute-content-length($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:appserver-set-concurrent-request-limit($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:appserver-set-database($config as element(configuration), $appserver-id as xs:unsignedLong, $database-id as xs:unsignedLong) as element(configuration) external;
declare function admin:appserver-set-debug-allow($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:appserver-set-default-time-limit($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:appserver-set-default-user($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:unsignedLong) as element(configuration) external;
declare function admin:appserver-set-default-xquery-version($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:appserver-set-display-last-login($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:appserver-set-enabled($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:appserver-set-error-handler($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:appserver-set-keep-alive-timeout($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:appserver-set-last-login($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:unsignedLong?) as element(configuration) external;
declare function admin:appserver-set-log-errors($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:appserver-set-max-time-limit($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:appserver-set-modules-database($config as element(configuration), $appserver-id as xs:unsignedLong, $database-id as item()) as element(configuration) external;
declare function admin:appserver-set-name($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:appserver-set-output-encoding($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:appserver-set-output-sgml-character-entities($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:appserver-set-port($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:appserver-set-pre-commit-trigger-depth($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:appserver-set-pre-commit-trigger-limit($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:appserver-set-privilege($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:unsignedLong) as element(configuration) external;
declare function admin:appserver-set-profile-allow($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:appserver-set-request-timeout($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:appserver-set-root($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:appserver-set-session-timeout($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:appserver-set-ssl-allow-sslv3($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:appserver-set-ssl-allow-tls($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:appserver-set-ssl-certificate-template($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:unsignedLong) as element(configuration) external;
declare function admin:appserver-set-ssl-ciphers($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:appserver-set-ssl-client-certificate-authorities($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:unsignedLong*) as element(configuration) external;
declare function admin:appserver-set-ssl-hostname($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:appserver-set-static-expires($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:appserver-set-threads($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:appserver-set-url-rewriter($config as element(configuration), $appserver-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:database-add-backup($config as element(configuration), $database-id as xs:unsignedLong, $backups as element(db:database-backup)*) as element(configuration) external;
declare function admin:database-add-element-attribute-word-lexicon($config as element(configuration), $database-id as xs:unsignedLong, $element-attribute-word-lexicons as element(db:element-attribute-word-lexicon)*) as element(configuration) external;
declare function admin:database-add-element-word-lexicon($config as element(configuration), $database-id as xs:unsignedLong, $element-word-lexicons as element(db:element-word-lexicon)*) as element(configuration) external;
declare function admin:database-add-element-word-query-through($config as element(configuration), $database-id as xs:unsignedLong, $element-word-query-throughs as element(db:element-word-query-through)*) as element(configuration) external;
declare function admin:database-add-field($config as element(configuration), $database-id as xs:unsignedLong, $fields as element(db:field)*) as element(configuration) external;
declare function admin:database-add-field-excluded-element($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $excluded-elements as element(db:excluded-element)*) as element(configuration) external;
declare function admin:database-add-field-included-element($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $included-elements as element(db:included-element)*) as element(configuration) external;
declare function admin:database-add-field-word-lexicon($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $word-lexicons as element(db:word-lexicon)*) as element(configuration) external;
declare function admin:database-add-fragment-parent($config as element(configuration), $database-id as xs:unsignedLong, $fragment-parents as element(db:fragment-parent)*) as element(configuration) external;
declare function admin:database-add-fragment-root($config as element(configuration), $database-id as xs:unsignedLong, $fragment-roots as element(db:fragment-root)*) as element(configuration) external;
declare function admin:database-add-geospatial-element-attribute-pair-index($config as element(configuration), $database-id as xs:unsignedLong, $geospatial-element-attribute-pair-indexes as element(db:geospatial-element-attribute-pair-index)*) as element(configuration) external;
declare function admin:database-add-geospatial-element-child-index($config as element(configuration), $database-id as xs:unsignedLong, $geospatial-element-child-indexes as element(db:geospatial-element-child-index)*) as element(configuration) external;
declare function admin:database-add-geospatial-element-index($config as element(configuration), $database-id as xs:unsignedLong, $geospatial-element-indexes as element(db:geospatial-element-index)*) as element(configuration) external;
declare function admin:database-add-geospatial-element-pair-index($config as element(configuration), $database-id as xs:unsignedLong, $geospatial-element-pair-indexes as element(db:geospatial-element-pair-index)*) as element(configuration) external;
declare function admin:database-add-merge-blackout($config as element(configuration), $database-id as xs:unsignedLong, $merge-blackouts as element(db:merge-blackout)*) as element(configuration) external;
declare function admin:database-add-phrase-around($config as element(configuration), $database-id as xs:unsignedLong, $phrase-arounds as element(db:phrase-around)*) as element(configuration) external;
declare function admin:database-add-phrase-through($config as element(configuration), $database-id as xs:unsignedLong, $phrase-throughs as element(db:phrase-through)*) as element(configuration) external;
declare function admin:database-add-range-element-attribute-index($config as element(configuration), $database-id as xs:unsignedLong, $attribute-indexes as element(db:range-element-attribute-index)*) as element(configuration) external;
declare function admin:database-add-range-element-index($config as element(configuration), $database-id as xs:unsignedLong, $range-indexes as element(db:range-element-index)*) as element(configuration) external;
declare function admin:database-add-word-lexicon($config as element(configuration), $database-id as xs:unsignedLong, $word-lexicons as element(db:word-lexicon)*) as element(configuration) external;
declare function admin:database-add-word-query-excluded-element($config as element(configuration), $database-id as xs:unsignedLong, $excluded-elements as element(db:excluded-element)*) as element(configuration) external;
declare function admin:database-add-word-query-included-element($config as element(configuration), $database-id as xs:unsignedLong, $included-elements as element(db:included-element)*) as element(configuration) external;
declare function admin:database-attach-forest($config as element(configuration), $database-id as xs:unsignedLong, $forest-id as xs:unsignedLong) as element(configuration) external;
declare function admin:database-copy($config as element(configuration), $database-id as xs:unsignedLong, $database-name as xs:string) as element(configuration) external;
declare function admin:database-create($config as element(configuration), $database-name as xs:string, $security-db as xs:unsignedLong, $schema-db as xs:unsignedLong) as element(configuration) external;
declare function admin:database-daily-backup($backup-dir as xs:string, $backup-period as xs:positiveInteger, $start-time as xs:time, $max-backups as xs:unsignedLong, $backup-security-db as xs:boolean, $backup-schemas-db as xs:boolean, $backup-triggers-db as xs:boolean) as element(db:database-backup) external;
declare function admin:database-delete($config as element(configuration), $database-ids as xs:unsignedLong*) as element(configuration) external;
declare function admin:database-delete-backup($config as element(configuration), $database-id as xs:unsignedLong, $backups as element(db:database-backup)*) as element(configuration) external;
declare function admin:database-delete-element-attribute-word-lexicon($config as element(configuration), $database-id as xs:unsignedLong, $lexicons as element(db:element-attribute-word-lexicon)*) as element(configuration) external;
declare function admin:database-delete-element-word-lexicon($config as element(configuration), $database-id as xs:unsignedLong, $element-word-lexicons as element(db:element-word-lexicon)*) as element(configuration) external;
declare function admin:database-delete-element-word-query-through($config as element(configuration), $database-id as xs:unsignedLong, $throughs as element(db:element-word-query-through)*) as element(configuration) external;
declare function admin:database-delete-field($config as element(configuration), $database-id as xs:unsignedLong, $field-names as xs:string*) as element(configuration) external;
declare function admin:database-delete-field-excluded-element($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $excluded-elements as element(db:excluded-element)*) as element(configuration) external;
declare function admin:database-delete-field-included-element($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $included-elements as element(db:included-element)*) as element(configuration) external;
declare function admin:database-delete-field-word-lexicon($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $word-lexicons as element(db:word-lexicon)*) as element(configuration) external;
declare function admin:database-delete-fragment-parent($config as element(configuration), $database-id as xs:unsignedLong, $fragment-parents as element(db:fragment-parent)*) as element(configuration) external;
declare function admin:database-delete-fragment-root($config as element(configuration), $database-id as xs:unsignedLong, $fragment-roots as element(db:fragment-root)*) as element(configuration) external;
declare function admin:database-delete-geospatial-element-attribute-pair-index($config as element(configuration), $database-id as xs:unsignedLong, $indexes as element(db:geospatial-element-attribute-pair-index)*) as element(configuration) external;
declare function admin:database-delete-geospatial-element-child-index($config as element(configuration), $database-id as xs:unsignedLong, $geospatial-element-child-indexes as element(db:geospatial-element-child-index)*) as element(configuration) external;
declare function admin:database-delete-geospatial-element-index($config as element(configuration), $database-id as xs:unsignedLong, $geospatial-element-indexes as element(db:geospatial-element-index)*) as element(configuration) external;
declare function admin:database-delete-geospatial-element-pair-index($config as element(configuration), $database-id as xs:unsignedLong, $geospatial-element-pair-indexes as element(db:geospatial-element-pair-index)*) as element(configuration) external;
declare function admin:database-delete-merge-blackout($config as element(configuration), $database-id as xs:unsignedLong, $blackouts as element(db:merge-blackout)*) as element(configuration) external;
declare function admin:database-delete-phrase-around($config as element(configuration), $database-id as xs:unsignedLong, $phrase-arounds as element(db:phrase-around)*) as element(configuration) external;
declare function admin:database-delete-phrase-through($config as element(configuration), $database-id as xs:unsignedLong, $phrase-throughs as element(db:phrase-through)*) as element(configuration) external;
declare function admin:database-delete-range-element-attribute-index($config as element(configuration), $database-id as xs:unsignedLong, $attribute-indexes as element(db:range-element-attribute-index)*) as element(configuration) external;
declare function admin:database-delete-range-element-index($config as element(configuration), $database-id as xs:unsignedLong, $range-indexes as element(db:range-element-index)*) as element(configuration) external;
declare function admin:database-delete-word-lexicon($config as element(configuration), $database-id as xs:unsignedLong, $word-lexicons as element(db:word-lexicon)*) as element(configuration) external;
declare function admin:database-delete-word-query-excluded-element($config as element(configuration), $database-id as xs:unsignedLong, $excluded-elements as element(db:excluded-element)*) as element(configuration) external;
declare function admin:database-delete-word-query-included-element($config as element(configuration), $database-id as xs:unsignedLong, $included-elements as element(db:included-element)*) as element(configuration) external;
declare function admin:database-detach-forest($config as element(configuration), $database-id as xs:unsignedLong, $forest-id as xs:unsignedLong) as element(configuration) external;
declare function admin:database-element-attribute-word-lexicon($parent-namespace as xs:string, $parent-localname as xs:string, $namespace as xs:string, $localname as xs:string, $collation as xs:string) as element(db:element-attribute-word-lexicon) external;
declare function admin:database-element-word-lexicon($namespace as xs:string, $localname as xs:string, $collation as xs:string) as element(db:element-word-lexicon) external;
declare function admin:database-element-word-query-through($namespace as xs:string, $localname as xs:string) as element(db:element-word-query-through) external;
declare function admin:database-excluded-element($namespace as xs:string, $localname as xs:string) as element(db:excluded-element) external;
declare function admin:database-field($field-name as xs:string, $include-root as xs:boolean) as element(db:field) external;
declare function admin:database-fragment-parent($namespace as xs:string, $localname as xs:string) as element(db:fragment-parent) external;
declare function admin:database-fragment-root($namespace as xs:string, $localname as xs:string) as element(db:fragment-root) external;
declare function admin:database-geospatial-element-attribute-pair-index($parent-namespace as xs:string, $parent-localname as xs:string, $latitude-namespace as xs:string, $latitude-localname as xs:string, $longitude-namespace as xs:string, $longitude-localname as xs:string, $coordinate-system as xs:string, $range-value-positions as xs:boolean) as element(db:geospatial-element-attribute-pair-index) external;
declare function admin:database-geospatial-element-child-index($parent-namespace as xs:string, $parent-localname as xs:string, $namespace as xs:string, $localname as xs:string, $coordinate-system as xs:string, $range-value-positions as xs:boolean) as element(db:geospatial-element-child-index) external;
declare function admin:database-geospatial-element-index($namespace as xs:string, $localname as xs:string, $coordinate-system as xs:string, $range-value-positions as xs:boolean) as element(db:geospatial-element-index) external;
declare function admin:database-geospatial-element-pair-index($parent-namespace as xs:string, $parent-localname as xs:string, $latitude-namespace as xs:string, $latitude-localname as xs:string, $longitude-namespace as xs:string, $longitude-localname as xs:string, $coordinate-system as xs:string, $range-value-positions as xs:boolean) as element(db:geospatial-element-pair-index) external;
declare function admin:database-get-attached-forests($config as element(configuration), $database-id as xs:unsignedLong) as xs:unsignedLong* external;
declare function admin:database-get-attribute-value-positions($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-backups($config as element(configuration), $database-id as xs:unsignedLong) as element(db:database-backup)* external;
declare function admin:database-get-collection-lexicon($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-directory-creation($config as element(configuration), $database-id as xs:unsignedLong) as xs:string external;
declare function admin:database-get-element-attribute-word-lexicons($config as element(configuration), $database-id as xs:unsignedLong) as element(db:element-attribute-word-lexicon)* external;
declare function admin:database-get-element-value-positions($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-element-word-lexicons($config as element(configuration), $database-id as xs:unsignedLong) as element(db:element-word-lexicon)* external;
declare function admin:database-get-element-word-positions($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-element-word-query-throughs($config as element(configuration), $database-id as xs:unsignedLong) as element(db:element-word-query-through)* external;
declare function admin:database-get-enabled($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-expunge-locks($config as element(configuration), $database-id as xs:unsignedLong) as xs:string external;
declare function admin:database-get-fast-case-sensitive-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-fast-diacritic-sensitive-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-fast-element-character-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-fast-element-phrase-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-fast-element-trailing-wildcard-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-fast-element-word-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-fast-phrase-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-fast-reverse-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-field($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string) as element(db:field) external;
declare function admin:database-get-field-excluded-elements($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string) as element(db:excluded-element)* external;
declare function admin:database-get-field-fast-case-sensitive-searches($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string) as xs:boolean? external;
declare function admin:database-get-field-fast-diacritic-sensitive-searches($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string) as xs:boolean? external;
declare function admin:database-get-field-fast-phrase-searches($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string) as xs:boolean? external;
declare function admin:database-get-field-include-document-root($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string) as xs:boolean external;
declare function admin:database-get-field-included-elements($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string) as element(db:included-element)* external;
declare function admin:database-get-field-one-character-searches($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string) as xs:boolean? external;
declare function admin:database-get-field-stemmed-searches($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string) as xs:string? external;
declare function admin:database-get-field-three-character-searches($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string) as xs:boolean? external;
declare function admin:database-get-field-three-character-word-positions($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string) as xs:boolean? external;
declare function admin:database-get-field-trailing-wildcard-searches($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string) as xs:boolean? external;
declare function admin:database-get-field-trailing-wildcard-word-positions($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string) as xs:boolean? external;
declare function admin:database-get-field-two-character-searches($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string) as xs:boolean? external;
declare function admin:database-get-field-word-lexicons($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string) as element(db:word-lexicon)* external;
declare function admin:database-get-field-word-searches($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string) as xs:boolean? external;
declare function admin:database-get-fields($config as element(configuration), $database-id as xs:unsignedLong) as element(db:field)* external;
declare function admin:database-get-format-compatibility($config as element(configuration), $database-id as xs:unsignedLong) as xs:string external;
declare function admin:database-get-fragment-parents($config as element(configuration), $database-id as xs:unsignedLong) as element(db:fragment-parent)* external;
declare function admin:database-get-fragment-roots($config as element(configuration), $database-id as xs:unsignedLong) as element(db:fragment-root)* external;
declare function admin:database-get-geospatial-element-attribute-pair-indexes($config as element(configuration), $database-id as xs:unsignedLong) as element(db:geospatial-element-attribute-pair-index)* external;
declare function admin:database-get-geospatial-element-child-indexes($config as element(configuration), $database-id as xs:unsignedLong) as element(db:geospatial-element-child-index)* external;
declare function admin:database-get-geospatial-element-indexes($config as element(configuration), $database-id as xs:unsignedLong) as element(db:geospatial-element-index)* external;
declare function admin:database-get-geospatial-element-pair-indexes($config as element(configuration), $database-id as xs:unsignedLong) as element(db:geospatial-element-pair-index)* external;
declare function admin:database-get-id($config as element(configuration), $database-name as xs:string) as xs:unsignedLong external;
declare function admin:database-get-in-memory-limit($config as element(configuration), $database-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:database-get-in-memory-list-size($config as element(configuration), $database-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:database-get-in-memory-range-index-size($config as element(configuration), $database-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:database-get-in-memory-reverse-index-size($config as element(configuration), $database-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:database-get-in-memory-tree-size($config as element(configuration), $database-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:database-get-index-detection($config as element(configuration), $database-id as xs:unsignedLong) as xs:string external;
declare function admin:database-get-inherit-collections($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-inherit-permissions($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-inherit-quality($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-journal-size($config as element(configuration), $database-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:database-get-language($config as element(configuration), $database-id as xs:unsignedLong) as xs:string external;
declare function admin:database-get-maintain-directory-last-modified($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-maintain-last-modified($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-merge-blackouts($config as element(configuration), $database-id as xs:unsignedLong) as element(db:merge-blackout)* external;
declare function admin:database-get-merge-enable($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-merge-max-size($config as element(configuration), $database-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:database-get-merge-min-ratio($config as element(configuration), $database-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:database-get-merge-min-size($config as element(configuration), $database-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:database-get-merge-timestamp($config as element(configuration), $database-id as xs:unsignedLong) as xs:unsignedLong external;
declare function admin:database-get-name($config as element(configuration), $database-id as xs:unsignedLong) as xs:string external;
declare function admin:database-get-one-character-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-phrase-arounds($config as element(configuration), $database-id as xs:unsignedLong) as element(db:phrase-around)* external;
declare function admin:database-get-phrase-throughs($config as element(configuration), $database-id as xs:unsignedLong) as element(db:phrase-through)* external;
declare function admin:database-get-positions-list-max-size($config as element(configuration), $database-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:database-get-preallocate-journals($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-preload-mapped-data($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-range-element-attribute-indexes($config as element(configuration), $database-id as xs:unsignedLong) as element(db:range-element-attribute-index)* external;
declare function admin:database-get-range-element-indexes($config as element(configuration), $database-id as xs:unsignedLong) as element(db:range-element-index)* external;
declare function admin:database-get-reindexer-enable($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-reindexer-throttle($config as element(configuration), $database-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:database-get-reindexer-timestamp($config as element(configuration), $database-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:database-get-schema-database($config as element(configuration), $database-id as xs:unsignedLong) as xs:unsignedLong external;
declare function admin:database-get-security-database($config as element(configuration), $database-id as xs:unsignedLong) as xs:unsignedLong external;
declare function admin:database-get-stemmed-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:string external;
declare function admin:database-get-tf-normalization($config as element(configuration), $database-id as xs:unsignedLong) as xs:string external;
declare function admin:database-get-three-character-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-three-character-word-positions($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-trailing-wildcard-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-trailing-wildcard-word-positions($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-triggers-database($config as element(configuration), $database-id as xs:unsignedLong) as xs:unsignedLong external;
declare function admin:database-get-two-character-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-uri-lexicon($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-word-lexicons($config as element(configuration), $database-id as xs:unsignedLong) as element(db:word-lexicon)* external;
declare function admin:database-get-word-positions($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-word-query-excluded-elements($config as element(configuration), $database-id as xs:unsignedLong) as element(db:excluded-element)* external;
declare function admin:database-get-word-query-fast-case-sensitive-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean? external;
declare function admin:database-get-word-query-fast-diacritic-sensitive-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean? external;
declare function admin:database-get-word-query-fast-phrase-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean? external;
declare function admin:database-get-word-query-include-document-root($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-get-word-query-included-elements($config as element(configuration), $database-id as xs:unsignedLong) as element(db:included-element)* external;
declare function admin:database-get-word-query-one-character-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean? external;
declare function admin:database-get-word-query-stemmed-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:string? external;
declare function admin:database-get-word-query-three-character-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean? external;
declare function admin:database-get-word-query-three-character-word-positions($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean? external;
declare function admin:database-get-word-query-trailing-wildcard-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean? external;
declare function admin:database-get-word-query-trailing-wildcard-word-positions($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean? external;
declare function admin:database-get-word-query-two-character-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean? external;
declare function admin:database-get-word-query-word-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean? external;
declare function admin:database-get-word-searches($config as element(configuration), $database-id as xs:unsignedLong) as xs:boolean external;
declare function admin:database-hourly-backup($backup-dir as xs:string, $backup-period as xs:positiveInteger, $start-minute as xs:nonNegativeInteger, $max-backups as xs:unsignedLong, $backup-security-db as xs:boolean, $backup-schemas-db as xs:boolean, $backup-triggers-db as xs:boolean) as element(db:database-backup) external;
declare function admin:database-included-element($namespace as xs:string, $localname as xs:string, $weight as xs:double, $attribute-namespace as xs:string, $attribute-localname as xs:string, $attribute-value as xs:string) as element(db:included-element) external;
declare function admin:database-minutely-backup($backup-dir as xs:string, $backup-period as xs:positiveInteger, $max-backups as xs:unsignedLong, $backup-security-db as xs:boolean, $backup-schemas-db as xs:boolean, $backup-triggers-db as xs:boolean) as element(db:database-backup) external;
declare function admin:database-monthly-backup($backup-dir as xs:string, $backup-period as xs:positiveInteger, $backup-month-day as xs:unsignedLong, $start-time as xs:time, $max-backups as xs:unsignedLong, $backup-security-db as xs:boolean, $backup-schemas-db as xs:boolean, $backup-triggers-db as xs:boolean) as element(db:database-backup) external;
declare function admin:database-one-time-backup($backup-dir as xs:string, $start as xs:dateTime, $max-backups as xs:unsignedLong, $backup-security-db as xs:boolean, $backup-schemas-db as xs:boolean, $backup-triggers-db as xs:boolean) as element(db:database-backup) external;
declare function admin:database-one-time-merge-blackout($limit as xs:unsignedInt, $start as xs:dateTime, $end as xs:dateTime?, $duration as xs:duration?) as element(db:merge-blackout) external;
declare function admin:database-phrase-around($namespace as xs:string, $localname as xs:string) as element(db:phrase-around) external;
declare function admin:database-phrase-through($namespace as xs:string, $localname as xs:string) as element(db:phrase-through) external;
declare function admin:database-range-element-attribute-index($scalar-type as xs:string, $parent-namespace as xs:string, $parent-localname as xs:string, $namespace as xs:string, $localname as xs:string, $collation as xs:string, $range-value-positions as xs:boolean) as element(db:range-element-attribute-index) external;
declare function admin:database-range-element-index($scalar-type as xs:string, $namespace as xs:string, $localname as xs:string, $collation as xs:string, $range-value-positions as xs:boolean) as element(db:range-element-index) external;
declare function admin:database-recurring-merge-blackout($limit as xs:unsignedInt, $days as xs:string+, $start-time as xs:time?, $end-time as xs:time?, $duration as xs:duration?) as element(db:merge-blackout) external;
declare function admin:database-set-attribute-value-positions($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-collection-lexicon($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-directory-creation($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:database-set-element-value-positions($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-element-word-positions($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-enabled($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-expunge-locks($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:database-set-fast-case-sensitive-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-fast-diacritic-sensitive-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-fast-element-character-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-fast-element-phrase-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-fast-element-trailing-wildcard-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-fast-element-word-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-fast-phrase-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-fast-reverse-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-field-fast-case-sensitive-searches($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-field-fast-diacritic-sensitive-searches($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-field-fast-phrase-searches($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-field-include-document-root($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-field-name($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $value as xs:string) as element(configuration) external;
declare function admin:database-set-field-one-character-searches($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-field-stemmed-searches($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $value as xs:string?) as element(configuration) external;
declare function admin:database-set-field-three-character-searches($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-field-three-character-word-positions($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-field-trailing-wildcard-searches($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-field-trailing-wildcard-word-positions($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-field-two-character-searches($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-field-word-searches($config as element(configuration), $database-id as xs:unsignedLong, $field-name as xs:string, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-format-compatibility($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:database-set-in-memory-limit($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:database-set-in-memory-list-size($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:database-set-in-memory-range-index-size($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:database-set-in-memory-reverse-index-size($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:database-set-in-memory-tree-size($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:database-set-index-detection($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:database-set-inherit-collections($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-inherit-permissions($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-inherit-quality($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-journal-size($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:database-set-language($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:database-set-maintain-directory-last-modified($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-maintain-last-modified($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-merge-enable($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-merge-max-size($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:database-set-merge-min-ratio($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:database-set-merge-min-size($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:database-set-merge-timestamp($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:unsignedLong) as element(configuration) external;
declare function admin:database-set-name($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:database-set-one-character-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-positions-list-max-size($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:database-set-preallocate-journals($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-preload-mapped-data($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-reindexer-enable($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-reindexer-throttle($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:database-set-reindexer-timestamp($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:database-set-schema-database($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:unsignedLong) as element(configuration) external;
declare function admin:database-set-security-database($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:unsignedLong) as element(configuration) external;
declare function admin:database-set-stemmed-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:database-set-tf-normalization($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:database-set-three-character-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-three-character-word-positions($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-trailing-wildcard-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-trailing-wildcard-word-positions($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-triggers-database($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:unsignedLong) as element(configuration) external;
declare function admin:database-set-two-character-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-uri-lexicon($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-word-positions($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-word-query-fast-case-sensitive-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-word-query-fast-diacritic-sensitive-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-word-query-fast-phrase-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-word-query-include-document-root($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-set-word-query-one-character-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-word-query-stemmed-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:string?) as element(configuration) external;
declare function admin:database-set-word-query-three-character-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-word-query-three-character-word-positions($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-word-query-trailing-wildcard-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-word-query-trailing-wildcard-word-positions($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-word-query-two-character-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-word-query-word-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean?) as element(configuration) external;
declare function admin:database-set-word-searches($config as element(configuration), $database-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:database-weekly-backup($backup-dir as xs:string, $backup-period as xs:positiveInteger, $days as xs:string+, $start-time as xs:time, $max-backups as xs:unsignedLong, $backup-security-db as xs:boolean, $backup-schemas-db as xs:boolean, $backup-triggers-db as xs:boolean) as element(db:database-backup) external;
declare function admin:database-word-lexicon($collation as xs:string) as element(db:word-lexicon) external;
declare function admin:forest-add-backup($config as element(configuration), $forest-id as xs:unsignedLong, $backups as element(as:forest-backup)*) as element(configuration) external;
declare function admin:forest-add-failover-host($config as element(configuration), $forest-id as xs:unsignedLong, $hosts as xs:unsignedLong*) as element(configuration) external;
declare function admin:forest-copy($config as element(configuration), $forest-id as xs:unsignedLong, $forest-name as xs:string, $data-directory as xs:string?) as element(configuration) external;
declare function admin:forest-create($config as element(configuration), $forest-name as xs:string, $host-id as xs:unsignedLong, $data-directory as xs:string?) as element(configuration) external;
declare function admin:forest-daily-backup($backup-dir as xs:string, $backup-period as xs:positiveInteger, $start-time as xs:time) as element(as:forest-backup) external;
declare function admin:forest-delete($config as element(configuration), $forest-ids as xs:unsignedLong*, $delete-data as xs:boolean) as element(configuration) external;
declare function admin:forest-delete-backup($config as element(configuration), $forest-id as xs:unsignedLong, $backups as element(as:forest-backup)*) as element(configuration) external;
declare function admin:forest-delete-failover-host($config as element(configuration), $forest-id as xs:unsignedLong, $hosts as xs:unsignedLong*) as element(configuration) external;
declare function admin:forest-get-backups($config as element(configuration), $forest-id as xs:unsignedLong) as element(as:forest-backup)* external;
declare function admin:forest-get-data-directory($config as element(configuration), $forest-id as xs:unsignedLong) as xs:string external;
declare function admin:forest-get-enabled($config as element(configuration), $forest-id as xs:unsignedLong) as xs:boolean external;
declare function admin:forest-get-failover-enable($config as element(configuration), $forest-id as xs:unsignedLong) as xs:boolean external;
declare function admin:forest-get-failover-hosts($config as element(configuration), $forest-id as xs:unsignedLong) as xs:unsignedLong* external;
declare function admin:forest-get-host($config as element(configuration), $forest-id as xs:unsignedLong) as xs:unsignedLong external;
declare function admin:forest-get-id($config as element(configuration), $forest-name as xs:string) as xs:unsignedLong external;
declare function admin:forest-get-name($config as element(configuration), $forest-id as xs:unsignedLong) as xs:string external;
declare function admin:forest-get-updates-allowed($config as element(configuration), $forest-id as xs:unsignedLong) as xs:string external;
declare function admin:forest-hourly-backup($backup-dir as xs:string, $backup-period as xs:positiveInteger, $start-minute as xs:nonNegativeInteger) as element(as:forest-backup) external;
declare function admin:forest-minutely-backup($backup-dir as xs:string, $backup-period as xs:positiveInteger) as element(as:forest-backup) external;
declare function admin:forest-monthly-backup($backup-dir as xs:string, $backup-period as xs:positiveInteger, $backup-month-day as xs:unsignedInt, $start-time as xs:time) as element(as:forest-backup) external;
declare function admin:forest-one-time-backup($backup-dir as xs:string, $start as xs:dateTime) as element(as:forest-backup) external;
declare function admin:forest-set-enabled($config as element(configuration), $forest-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:forest-set-failover-enable($config as element(configuration), $forest-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:forest-set-host($config as element(configuration), $forest-id as xs:unsignedLong, $value as xs:unsignedLong) as element(configuration) external;
declare function admin:forest-set-updates-allowed($config as element(configuration), $forest-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:forest-weekly-backup($backup-dir as xs:string, $backup-period as xs:positiveInteger, $days as xs:string+, $start-time as xs:time) as element(as:forest-backup) external;
declare function admin:get-appserver-ids($config as element(configuration)) as xs:unsignedLong* external;
declare function admin:get-configuration() as element(configuration) external;
declare function admin:get-database-ids($config as element(configuration)) as xs:unsignedLong* external;
declare function admin:get-forest-ids($config as element(configuration)) as xs:unsignedLong* external;
declare function admin:get-group-ids($config as element(configuration)) as xs:unsignedLong* external;
declare function admin:get-host-ids($config as element(configuration)) as xs:unsignedLong* external;
declare function admin:group-add-namespace($config as element(configuration), $group-id as xs:unsignedLong, $namespaces as element(gr:namespace)*) as element(configuration) external;
declare function admin:group-add-scheduled-task($config as element(configuration), $group-id as xs:unsignedLong, $scheduled-tasks as element(gr:scheduled-task)*) as element(configuration) external;
declare function admin:group-add-schema($config as element(configuration), $group-id as xs:unsignedLong, $schemas as element(gr:schema)*) as element(configuration) external;
declare function admin:group-add-trace-event($config as element(configuration), $group-id as xs:unsignedLong, $events as element(gr:event)*) as element(configuration) external;
declare function admin:group-copy($config as element(configuration), $group-id as xs:unsignedLong, $group-name as xs:string) as element(configuration) external;
declare function admin:group-create($config as element(configuration), $group-name as xs:string) as element(configuration) external;
declare function admin:group-daily-scheduled-task($task-path as xs:string, $task-root as xs:string, $task-period as xs:positiveInteger, $task-start-time as xs:time, $task-database as xs:unsignedLong, $task-modules as xs:unsignedLong, $task-user as xs:unsignedLong, $task-host as xs:unsignedLong?) as element(gr:scheduled-task) external;
declare function admin:group-delete($config as element(configuration), $group-ids as xs:unsignedLong*) as element(configuration) external;
declare function admin:group-delete-namespace($config as element(configuration), $group-id as xs:unsignedLong, $namespaces as element(gr:namespace)*) as element(configuration) external;
declare function admin:group-delete-scheduled-task($config as element(configuration), $group-id as xs:unsignedLong, $scheduled-tasks as element(gr:scheduled-task)*) as element(configuration) external;
declare function admin:group-delete-schema($config as element(configuration), $group-id as xs:unsignedLong, $schemas as element(gr:schema)*) as element(configuration) external;
declare function admin:group-delete-trace-event($config as element(configuration), $group-id as xs:unsignedLong, $events as element(gr:event)*) as element(configuration) external;
declare function admin:group-disable-audit-event-type($config as element(configuration), $group-id as xs:unsignedLong, $event-type as xs:string*) as element(configuration) external;
declare function admin:group-enable-audit-event-type($config as element(configuration), $group-id as xs:unsignedLong, $event-type as xs:string*) as element(configuration) external;
declare function admin:group-get-appserver-ids($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedLong* external;
declare function admin:group-get-audit-enabled($config as element(configuration), $group-id as xs:unsignedLong) as xs:boolean external;
declare function admin:group-get-audit-event-type-enabled($config as element(configuration), $group-id as xs:unsignedLong, $event-type as xs:string) as xs:boolean external;
declare function admin:group-get-audit-excluded-roles($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedLong* external;
declare function admin:group-get-audit-excluded-uris($config as element(configuration), $group-id as xs:unsignedLong) as xs:string* external;
declare function admin:group-get-audit-excluded-users($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedLong* external;
declare function admin:group-get-audit-included-roles($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedLong* external;
declare function admin:group-get-audit-included-uris($config as element(configuration), $group-id as xs:unsignedLong) as xs:string* external;
declare function admin:group-get-audit-included-users($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedLong* external;
declare function admin:group-get-audit-outcome-restriction($config as element(configuration), $group-id as xs:unsignedLong) as xs:string external;
declare function admin:group-get-compressed-tree-cache-partitions($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:group-get-compressed-tree-cache-size($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:group-get-compressed-tree-read-size($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:group-get-expanded-tree-cache-partitions($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:group-get-expanded-tree-cache-size($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:group-get-failover-enable($config as element(configuration), $group-id as xs:unsignedLong) as xs:boolean external;
declare function admin:group-get-file-log-level($config as element(configuration), $group-id as xs:unsignedLong) as xs:string external;
declare function admin:group-get-host-ids($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedLong* external;
declare function admin:group-get-host-initial-timeout($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:group-get-host-timeout($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:group-get-http-timeout($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:group-get-http-user-agent($config as element(configuration), $group-id as xs:unsignedLong) as xs:string external;
declare function admin:group-get-httpserver-ids($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedLong* external;
declare function admin:group-get-id($config as element(configuration), $group-name as xs:string) as xs:unsignedLong external;
declare function admin:group-get-keep-audit-files($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:group-get-keep-log-files($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:group-get-list-cache-partitions($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:group-get-list-cache-size($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:group-get-name($config as element(configuration), $group-id as xs:unsignedLong) as xs:string external;
declare function admin:group-get-namespaces($config as element(configuration), $group-id as xs:unsignedLong) as element(gr:namespace)* external;
declare function admin:group-get-retry-timeout($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:group-get-rotate-audit-files($config as element(configuration), $group-id as xs:unsignedLong) as xs:string external;
declare function admin:group-get-rotate-log-files($config as element(configuration), $group-id as xs:unsignedLong) as xs:string external;
declare function admin:group-get-scheduled-tasks($config as element(configuration), $group-id as xs:unsignedLong) as element(gr:scheduled-task)* external;
declare function admin:group-get-schemas($config as element(configuration), $group-id as xs:unsignedLong) as element(gr:schema)* external;
declare function admin:group-get-smtp-relay($config as element(configuration), $group-id as xs:unsignedLong) as xs:string external;
declare function admin:group-get-smtp-timeout($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:group-get-system-log-level($config as element(configuration), $group-id as xs:unsignedLong) as xs:string external;
declare function admin:group-get-taskserver-id($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedLong* external;
declare function admin:group-get-trace-events($config as element(configuration), $group-id as xs:unsignedLong) as element(gr:event)* external;
declare function admin:group-get-trace-events-activated($config as element(configuration), $group-id as xs:unsignedLong) as xs:boolean external;
declare function admin:group-get-webdavserver-ids($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedLong* external;
declare function admin:group-get-xdbcserver-ids($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedLong* external;
declare function admin:group-get-xdqp-ssl-allow-sslv3($config as element(configuration), $group-id as xs:unsignedLong) as xs:boolean external;
declare function admin:group-get-xdqp-ssl-allow-tls($config as element(configuration), $group-id as xs:unsignedLong) as xs:boolean external;
declare function admin:group-get-xdqp-ssl-ciphers($config as element(configuration), $group-id as xs:unsignedLong) as xs:string external;
declare function admin:group-get-xdqp-ssl-enabled($config as element(configuration), $group-id as xs:unsignedLong) as xs:boolean external;
declare function admin:group-get-xdqp-timeout($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:group-hourly-scheduled-task($task-path as xs:string, $task-root as xs:string, $task-period as xs:positiveInteger, $task-minute as xs:nonNegativeInteger, $task-database as xs:unsignedLong, $task-modules as xs:unsignedLong, $task-user as xs:unsignedLong, $task-host as xs:unsignedLong?) as element(gr:scheduled-task) external;
declare function admin:group-minutely-scheduled-task($task-path as xs:string, $task-root as xs:string, $task-period as xs:positiveInteger, $task-database as xs:unsignedLong, $task-modules as xs:unsignedLong, $task-user as xs:unsignedLong, $task-host as xs:unsignedLong?) as element(gr:scheduled-task) external;
declare function admin:group-monthly-scheduled-task($task-path as xs:string, $task-root as xs:string, $task-period as xs:positiveInteger, $task-month-day as xs:unsignedLong, $task-start-time as xs:time, $task-database as xs:unsignedLong, $task-modules as xs:unsignedLong, $task-user as xs:unsignedLong, $task-host as xs:unsignedLong?) as element(gr:scheduled-task) external;
declare function admin:group-namespace($prefix as xs:string, $namespace-uri as xs:string) as element(gr:namespace) external;
declare function admin:group-one-time-scheduled-task($task-path as xs:string, $task-root as xs:string, $task-start as xs:dateTime, $task-database as xs:unsignedLong, $task-modules as xs:unsignedLong, $task-user as xs:unsignedLong, $task-host as xs:unsignedLong?) as element(gr:scheduled-task) external;
declare function admin:group-schema($namespace-uri as xs:string, $schema-location as xs:string) as element(gr:schema) external;
declare function admin:group-set-audit-enabled($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:group-set-audit-outcome-restriction($config as element(configuration), $group-id as xs:unsignedLong, $outcome as xs:string*) as element(configuration) external;
declare function admin:group-set-audit-role-restriction($config as element(configuration), $group-id as xs:unsignedLong, $restriction-type as xs:string, $roles as xs:string*) as element(configuration) external;
declare function admin:group-set-audit-uri-restriction($config as element(configuration), $group-id as xs:unsignedLong, $restriction-type as xs:string, $uris as xs:string*) as element(configuration) external;
declare function admin:group-set-audit-user-restriction($config as element(configuration), $group-id as xs:unsignedLong, $restriction-type as xs:string, $users as xs:string*) as element(configuration) external;
declare function admin:group-set-compressed-tree-cache-partitions($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:group-set-compressed-tree-cache-size($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:group-set-compressed-tree-read-size($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:group-set-expanded-tree-cache-partitions($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:group-set-expanded-tree-cache-size($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:group-set-failover-enable($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:group-set-file-log-level($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:group-set-host-initial-timeout($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:group-set-host-timeout($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:group-set-http-timeout($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:group-set-http-user-agent($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:group-set-keep-audit-files($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:group-set-keep-log-files($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:group-set-list-cache-partitions($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:group-set-list-cache-size($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:group-set-name($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:group-set-retry-timeout($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:group-set-rotate-audit-files($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:group-set-rotate-log-files($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:group-set-smtp-relay($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:group-set-smtp-timeout($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:group-set-system-log-level($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:group-set-trace-events-activated($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:group-set-xdqp-ssl-allow-sslv3($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:group-set-xdqp-ssl-allow-tls($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:group-set-xdqp-ssl-ciphers($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:group-set-xdqp-ssl-enabled($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:group-set-xdqp-timeout($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:group-trace-event($event-id as xs:string) as element(gr:event) external;
declare function admin:group-weekly-scheduled-task($task-path as xs:string, $task-root as xs:string, $task-period as xs:positiveInteger, $task-days as xs:string+, $task-start-time as xs:time, $task-database as xs:unsignedLong, $task-modules as xs:unsignedLong, $task-user as xs:unsignedLong, $task-host as xs:unsignedLong?) as element(gr:scheduled-task) external;
declare function admin:host-get-group($config as element(configuration), $host-id as xs:unsignedLong) as xs:unsignedLong external;
declare function admin:host-get-id($config as element(configuration), $host-name as xs:string) as xs:unsignedLong external;
declare function admin:host-get-name($config as element(configuration), $host-id as xs:unsignedLong) as xs:string external;
declare function admin:host-get-port($config as element(configuration), $host-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:host-set-group($config as element(configuration), $host-id as xs:unsignedLong, $group-id as xs:unsignedLong) as element(configuration) external;
declare function admin:host-set-name($config as element(configuration), $host-id as xs:unsignedLong, $value as xs:string) as element(configuration) external;
declare function admin:host-set-port($config as element(configuration), $host-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:http-server-create($config as element(configuration), $group-id as xs:unsignedLong, $appserver-name as xs:string, $root as xs:string, $port as xs:unsignedLong, $modules-id as item(), $database-id as xs:unsignedLong) as element(configuration) external;
declare function admin:mimetype($name as xs:string, $extensions as xs:string, $format as xs:string) as element(mt:mimetype) external;
declare function admin:mimetypes-add($config as element(configuration), $mimetypes as element(mt:mimetype)*) as element(configuration) external;
declare function admin:mimetypes-delete($config as element(configuration), $mimetypes as element(mt:mimetype)*) as element(configuration) external;
declare function admin:mimetypes-get($config as element(configuration)) as element(mt:mimetype)* external;
declare function admin:restart-hosts($hosts as xs:unsignedLong*) as empty-sequence() external;
declare function admin:save-configuration($config as element(configuration)) as empty-sequence() external;
declare function admin:save-configuration-without-restart($config as element(configuration)) as xs:unsignedLong* external;
declare function admin:taskserver-get-debug-allow($config as element(configuration), $group-id as xs:unsignedLong) as xs:boolean external;
declare function admin:taskserver-get-debug-threads($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:taskserver-get-default-time-limit($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:taskserver-get-log-errors($config as element(configuration), $group-id as xs:unsignedLong) as xs:boolean external;
declare function admin:taskserver-get-max-time-limit($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:taskserver-get-name($config as element(configuration), $group-id as xs:unsignedLong) as xs:string external;
declare function admin:taskserver-get-post-commit-trigger-depth($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:taskserver-get-pre-commit-trigger-depth($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:taskserver-get-pre-commit-trigger-limit($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:taskserver-get-profile-allow($config as element(configuration), $group-id as xs:unsignedLong) as xs:boolean external;
declare function admin:taskserver-get-queue-size($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:taskserver-get-threads($config as element(configuration), $group-id as xs:unsignedLong) as xs:unsignedInt external;
declare function admin:taskserver-set-debug-allow($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:taskserver-set-debug-threads($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:taskserver-set-default-time-limit($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:taskserver-set-log-errors($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:taskserver-set-max-time-limit($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:taskserver-set-post-commit-trigger-depth($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:taskserver-set-pre-commit-trigger-depth($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:taskserver-set-pre-commit-trigger-limit($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:taskserver-set-profile-allow($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:boolean) as element(configuration) external;
declare function admin:taskserver-set-queue-size($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:taskserver-set-threads($config as element(configuration), $group-id as xs:unsignedLong, $value as xs:unsignedInt) as element(configuration) external;
declare function admin:webdav-server-create($config as element(configuration), $group-id as xs:unsignedLong, $appserver-name as xs:string, $root as xs:string, $port as xs:unsignedLong, $database-id as xs:unsignedLong) as element(configuration) external;
declare function admin:xdbc-server-create($config as element(configuration), $group-id as xs:unsignedLong, $appserver-name as xs:string, $root as xs:string, $port as xs:unsignedLong, $modules-id as item(), $database-id as xs:unsignedLong) as element(configuration) external;
