/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.launching;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xquery.launching.XQDTInterpreterInstallType;
import org.eclipse.wst.xquery.set.internal.launching.CoreSDKInstall;
import org.eclipse.wst.xquery.set.internal.launching.jobs.SETInstallValidator;

public class CoreSDKInstallType
extends XQDTInterpreterInstallType {
    private static final String INSTALL_TYPE_NAME = "Sausalito CoreSDK";
    private static final String INSTALL_TYPE_ID = "org.eclipse.wst.xquery.set.launching.CoreSDKInstallType";

    protected IInterpreterInstall doCreateInterpreterInstall(String id) {
        return new CoreSDKInstall((IInterpreterInstallType)this, id);
    }

    public String getId() {
        return INSTALL_TYPE_ID;
    }

    public String getName() {
        return INSTALL_TYPE_NAME;
    }

    public String getNatureId() {
        return "org.eclipse.wst.xquery.set.core.nature";
    }

    protected String getPluginId() {
        return "org.eclipse.wst.xquery.set.launching";
    }

    protected String[] getPossibleInterpreterNames() {
        return new String[]{"sausalito"};
    }

    public synchronized LibraryLocation[] getDefaultLibraryLocations(IFileHandle installLocation, EnvironmentVariable[] variables, IProgressMonitor monitor) {
        IPath sausalitoRoot = new Path(installLocation.getParent().getParent().getCanonicalPath()).append("modules");
        LibraryLocation loc = new LibraryLocation(EnvironmentPathUtils.getFullPath((IEnvironment)this.getEnvironment(), (IPath)sausalitoRoot));
        return new LibraryLocation[]{loc};
    }

    public IStatus validatePossiblyName(IFileHandle installLocation) {
        IStatus status = super.validatePossiblyName(installLocation);
        if (!status.isOK()) {
            return status;
        }
        if (Platform.getOS().equals("win32")) {
            status = this.validateInstall(installLocation);
        }
        return status;
    }

    private IStatus validateInstall(IFileHandle installLocation) {
        boolean done = false;
        IStatus status = null;
        while (!done) {
            SETInstallValidator validator = new SETInstallValidator(installLocation.getPath());
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            try {
                InstallMSVCRPDialog installDialog;
                dialog.run(true, true, (IRunnableWithProgress)validator);
                status = validator.getResult();
                if (status.isOK() || (installDialog = new InstallMSVCRPDialog(Display.getCurrent().getActiveShell())).open() != 0) break;
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
                return new Status(4, "org.eclipse.wst.xquery.set.launching", "ite");
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                return new Status(4, "org.eclipse.wst.xquery.set.launching", "ie");
            }
        }
        return status;
    }

    private class InstallMSVCRPDialog
    extends TitleAreaDialog {
        public InstallMSVCRPDialog(Shell parentShell) {
            super(parentShell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite control = (Composite)super.createDialogArea(parent);
            this.setTitle("Sausalito CoreSDK Configuration");
            this.setMessage("Install required system libraries");
            this.createText(control);
            return control;
        }

        private void createText(Composite parent) {
            Composite panel = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            panel.setLayout((Layout)layout);
            panel.setLayoutData((Object)new GridData(768));
            panel.setFont(parent.getFont());
            Link link = new Link(panel, 0);
            link.setText("The Microsoft Visual C++ 2008 Redistributable Package (x86) must be installed in order to run\nSausalito Applications.\n\n<a>Click on this link</a> to install the the Microsoft Visual C++ 2008 Redistributable Package (x86).\nAfter the installation press \"Try again\".\n\nBy pressing \"Ignore\" no Sausalito CoreSDK will be configured.\n");
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        ProcessBuilder pb = new ProcessBuilder("explorer.exe", "C:\\Users\\Gabriel\\Eclipse Workspace WTP\\org.eclipse.wst.xquery.set.launching.win32\\vcredist");
                        pb.start();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            });
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, "Try again", true);
            this.createButton(parent, 1, "Ignore", false);
        }
    }
}

