/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.ui.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.wst.xquery.set.core.SETProjectConfig;
import org.eclipse.wst.xquery.set.core.SETProjectConfigUtil;
import org.eclipse.wst.xquery.set.launching.deploy.DeployInfo;
import org.eclipse.wst.xquery.set.launching.deploy.DeployManager;

public class SETDeployProjectFirstWizardPage
extends WizardPage {
    private static final String DESCRIPTION = "Deploy the project in the Sausalito Cloud Infrastructure";
    private Link fPortalLink;
    private Text fApplicationNameText;
    private Text fVersionText;
    private Text fUsernameText;
    private Text fPasswordText;
    private Button fRememberCheckButton;
    private Button fShowCharsCheckButton;
    private WidgetListener fListener = new WidgetListener();
    private IScriptProject fProject;
    private SETProjectConfig fConfig;
    private static final String PORTAL_URL = "http://portal.28msec.com/";

    private void isValid() {
        String appName = this.fApplicationNameText.getText();
        if (appName.equals("")) {
            this.setErrorMessage("Provide an application name");
            this.setPageComplete(false);
            return;
        }
        if (!appName.matches("[\\p{Lower}\\p{Digit}\\-]+")) {
            this.setErrorMessage("Application name can only contain lower case letters, numbers, or hyphen (-)");
            this.setPageComplete(false);
            return;
        }
        if (appName.startsWith("-") || appName.endsWith("-") || appName.contains("--")) {
            this.setErrorMessage("The hyphen can not be used as first or last character, or more than once in a row");
            this.setPageComplete(false);
            return;
        }
        if (this.fUsernameText.getText().trim().equals("") || this.fPasswordText.getText().trim().equals("")) {
            this.setErrorMessage("The user name and the password cannot be empty");
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    protected SETDeployProjectFirstWizardPage(IScriptProject project) {
        super("Deploy Sausalito Project");
        this.fProject = project;
        this.fConfig = SETProjectConfigUtil.readProjectConfig((IProject)this.fProject.getProject());
        this.setTitle("Deploy Sausalito Project");
        this.setDescription(DESCRIPTION);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        this.createDescriptionLabels(composite);
        this.createAppNameText(composite);
        SWTFactory.createVerticalSpacer((Composite)composite, (int)5);
        this.createCredentialsGroup(composite);
        this.initializePageFields();
        this.fApplicationNameText.setFocus();
        this.fApplicationNameText.setSelection(0, this.fApplicationNameText.getText().length());
    }

    private void initializePageFields() {
        DeployInfo info = DeployManager.getInstance().getCachedDeployInfo(this.fProject);
        if (info != null) {
            this.fRememberCheckButton.setSelection(true);
            this.fApplicationNameText.setText(info.getApplicationName());
            this.fVersionText.setText(info.getProjectConfig().getVersion());
            this.fUsernameText.setText(info.getUserName());
            this.fPasswordText.setText(info.getPassword());
        }
    }

    private void createDescriptionLabels(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.fPortalLink = new Link(composite, 0);
        this.fPortalLink.setText("Pressing finish will deploy the selected project in the Sausalito cloud infrastructure.\nMake sure you already have an application created for this deployment in your\n<A HREF=\"http://portal.28msec.com/\">28msec Portal</A> account. The name of the application must be provided in the field below.");
        this.fPortalLink.addSelectionListener((SelectionListener)this.fListener);
        SWTFactory.createVerticalSpacer((Composite)composite, (int)5);
    }

    private void createAppNameText(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        SWTFactory.createLabel((Composite)composite, (String)"Project name:", (int)1);
        SWTFactory.createLabel((Composite)composite, (String)this.fProject.getElementName(), (int)1);
        SWTFactory.createLabel((Composite)composite, (String)"Application name:", (int)1);
        this.fApplicationNameText = SWTFactory.createText((Composite)composite, (int)2048, (int)1, (String)"");
        this.fApplicationNameText.addModifyListener((ModifyListener)this.fListener);
        SWTFactory.createLabel((Composite)composite, (String)"Version:", (int)1);
        this.fVersionText = SWTFactory.createText((Composite)composite, (int)2048, (int)1, (String)this.fConfig.getVersion());
        this.fVersionText.addModifyListener((ModifyListener)this.fListener);
    }

    private void createCredentialsGroup(Composite composite) {
        Group group = SWTFactory.createGroup((Composite)composite, (String)"Credentials", (int)2, (int)1, (int)768);
        this.createUsernameText((Composite)group);
        this.createPasswortText((Composite)group);
        this.createShowCharsCheckButton((Composite)group);
        this.createRememberCheckButton((Composite)group);
    }

    void createUsernameText(Composite parent) {
        SWTFactory.createLabel((Composite)parent, (String)"Username:", (int)1);
        this.fUsernameText = SWTFactory.createText((Composite)parent, (int)2048, (int)1, (String)"");
        this.fUsernameText.addModifyListener((ModifyListener)this.fListener);
    }

    void createPasswortText(Composite parent) {
        SWTFactory.createLabel((Composite)parent, (String)"Password:", (int)1);
        this.fPasswordText = SWTFactory.createText((Composite)parent, (int)0x400800, (int)1, (String)"");
        this.fPasswordText.addModifyListener((ModifyListener)this.fListener);
    }

    void createShowCharsCheckButton(Composite parent) {
        SWTFactory.createLabel((Composite)parent, (String)"", (int)1);
        this.fShowCharsCheckButton = SWTFactory.createCheckButton((Composite)parent, (String)"Show password", null, (boolean)false, (int)1);
        this.fShowCharsCheckButton.addSelectionListener((SelectionListener)this.fListener);
    }

    void createRememberCheckButton(Composite parent) {
        SWTFactory.createLabel((Composite)parent, (String)"", (int)1);
        this.fRememberCheckButton = SWTFactory.createCheckButton((Composite)parent, (String)"Remember deployment data for this project", null, (boolean)false, (int)1);
        this.fRememberCheckButton.addSelectionListener((SelectionListener)this.fListener);
    }

    public DeployInfo getDeployInfo() {
        this.fConfig.setVersion(this.fVersionText.getText());
        return new DeployInfo(this.fProject, this.fConfig, this.fApplicationNameText.getText(), this.fUsernameText.getText(), this.fPasswordText.getText(), DeployInfo.DeployType.PROJECT, null);
    }

    public boolean cacheCredentials() {
        return this.fRememberCheckButton.getSelection();
    }

    private void openBrowser() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    String urlStr = SETDeployProjectFirstWizardPage.PORTAL_URL;
                    URL url = new URL(urlStr);
                    IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                    browser.openURL(url);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        private WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == SETDeployProjectFirstWizardPage.this.fApplicationNameText) {
                SETDeployProjectFirstWizardPage.this.isValid();
            } else if (e.widget == SETDeployProjectFirstWizardPage.this.fUsernameText) {
                SETDeployProjectFirstWizardPage.this.isValid();
            } else if (e.widget == SETDeployProjectFirstWizardPage.this.fPasswordText) {
                SETDeployProjectFirstWizardPage.this.isValid();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == SETDeployProjectFirstWizardPage.this.fShowCharsCheckButton) {
                if (SETDeployProjectFirstWizardPage.this.fShowCharsCheckButton.getSelection()) {
                    SETDeployProjectFirstWizardPage.this.fPasswordText.setEchoChar('\u0000');
                } else {
                    SETDeployProjectFirstWizardPage.this.fPasswordText.setEchoChar('\u25cf');
                }
            } else if (e.widget == SETDeployProjectFirstWizardPage.this.fPortalLink) {
                SETDeployProjectFirstWizardPage.this.openBrowser();
            }
            SETDeployProjectFirstWizardPage.this.isValid();
        }
    }
}

