/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IEJBModule;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.generic.core.internal.CorePlugin;
import org.eclipse.jst.server.generic.core.internal.GenericServerCoreMessages;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.jst.server.generic.core.internal.Trace;
import org.eclipse.jst.server.generic.servertype.definition.Module;
import org.eclipse.jst.server.generic.servertype.definition.Port;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ServerMonitorManager;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.ServerDelegate;

public class GenericServer
extends ServerDelegate
implements IURLProvider {
    private static final String ATTR_GENERIC_SERVER_MODULES = "Generic_Server_Modules_List";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public IStatus publishStart(IProgressMonitor monitor) {
        if (this.getModules().length < 1) {
            return new Status(8, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.cancelNoPublish, null);
        }
        return new Status(0, "org.eclipse.jst.server.generic.core", 0, "PublishingStarted", null);
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        Iterator iterator = this.getServerDefinition().getModule().iterator();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            int i = 0;
            while (i < add.length) {
                if (add[i].getModuleType().getId().equals(module.getType())) {
                    return new Status(0, "org.eclipse.jst.server.generic.core", 0, "CanModifyModules", null);
                }
                ++i;
            }
        }
        return new Status(4, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.moduleNotCompatible, null);
    }

    private String createModuleId(IModule module) {
        return String.valueOf(module.getProject().getName()) + ":" + module.getId();
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
        int i;
        ArrayList<String> modules = this.getAttribute(ATTR_GENERIC_SERVER_MODULES, null);
        if (add != null && add.length > 0) {
            if (modules == null) {
                modules = new ArrayList<String>(add.length);
            }
            i = 0;
            while (i < add.length) {
                String modlId = this.createModuleId(add[i]);
                if (!modules.contains(modlId)) {
                    modules.add(modlId);
                }
                ++i;
            }
        }
        if (remove != null && remove.length > 0 && modules != null) {
            i = 0;
            while (i < remove.length) {
                modules.remove(this.createModuleId(remove[i]));
                ++i;
            }
        }
        if (modules != null) {
            this.setAttribute(ATTR_GENERIC_SERVER_MODULES, modules);
        }
    }

    public IModule[] getModules() {
        List modules = this.getAttribute(ATTR_GENERIC_SERVER_MODULES, null);
        ArrayList<IModule> imodules = new ArrayList<IModule>();
        Iterator iterator = modules.iterator();
        while (iterator.hasNext()) {
            String moduleId = (String)iterator.next();
            int sep = moduleId.indexOf(":");
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(moduleId.substring(0, sep));
            IModule[] ms = ServerUtil.getModules((IProject)project);
            int i = 0;
            while (i < ms.length) {
                if (ms[i].getId().equals(moduleId.substring(sep + 1))) {
                    imodules.add(ms[i]);
                }
                ++i;
            }
        }
        if (modules != null) {
            return imodules.toArray(new IModule[imodules.size()]);
        }
        return new IModule[0];
    }

    public IModule[] getChildModules(IModule[] module) {
        String type = module[0].getModuleType().getId();
        if (module.length == 1 && "j2ee.ear".equals(type)) {
            IEnterpriseApplication enterpriseApplication;
            IModule iModule = module[0];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.server.core.IEnterpriseApplication");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((enterpriseApplication = (IEnterpriseApplication)iModule.loadAdapter((Class)clazz, null)).getModules() != null) {
                return enterpriseApplication.getModules();
            }
        }
        return new IModule[0];
    }

    private Map getServerInstanceProperties() {
        Map runtimeProperties = this.getRuntimeDelegate().getServerInstanceProperties();
        Map serverProperties = this.getServerInstancePropertiesImpl();
        HashMap instanceProperties = new HashMap(runtimeProperties.size() + serverProperties.size());
        instanceProperties.putAll(runtimeProperties);
        instanceProperties.putAll(serverProperties);
        return instanceProperties;
    }

    public ServerPort[] getServerPorts() {
        ArrayList<ServerPort> ports = new ArrayList<ServerPort>();
        Iterator pIter = this.getServerDefinition().getPort().iterator();
        while (pIter.hasNext()) {
            Port element = (Port)pIter.next();
            int port = Integer.parseInt(this.getServerDefinition().getResolver().resolveProperties(element.getNo()));
            ports.add(new ServerPort("server", element.getName(), port, element.getProtocol()));
        }
        return ports.toArray(new ServerPort[ports.size()]);
    }

    public URL getModuleRootURL(IModule module) {
        try {
            block12: {
                block11: {
                    if (module == null) break block11;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.jst.server.core.IWebModule");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (module.loadAdapter((Class)clazz, null) != null) break block12;
                }
                return null;
            }
            String url = "http://localhost";
            int port = 0;
            port = this.getHttpPort();
            port = ServerMonitorManager.getInstance().getMonitoredPort(this.getServer(), port, "web");
            if (port != 80) {
                url = String.valueOf(url) + ":" + port;
            }
            if (!(url = String.valueOf(url) + "/" + module.getName()).endsWith("/")) {
                url = String.valueOf(url) + "/";
            }
            return new URL(url);
        }
        catch (Exception e) {
            Trace.trace("Could not get root URL", e);
            return null;
        }
    }

    protected int getHttpPort() {
        int port = -1;
        Iterator pIter = this.getServerDefinition().getPort().iterator();
        while (pIter.hasNext()) {
            Port aPort = (Port)pIter.next();
            if (port == -1) {
                port = Integer.parseInt(this.getServerDefinition().getResolver().resolveProperties(aPort.getNo()));
                continue;
            }
            if (!"http".equals(aPort.getProtocol())) continue;
            port = Integer.parseInt(aPort.getNo());
        }
        if (port == -1) {
            port = 8080;
        }
        return port;
    }

    public ServerRuntime getServerDefinition() {
        GenericServerRuntime rt = this.getRuntimeDelegate();
        if (rt == null) {
            return null;
        }
        String defId = rt.getServerDefinitionId();
        return CorePlugin.getDefault().getServerTypeDefinitionManager().getServerRuntimeDefinition(defId, this.getServerInstanceProperties());
    }

    private GenericServerRuntime getRuntimeDelegate() {
        IRuntime iRuntime = this.getServer().getRuntime();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jst.server.generic.core.internal.GenericServerRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (GenericServerRuntime)((Object)iRuntime.loadAdapter((Class)clazz, null));
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        String type = module.getModuleType().getId();
        if (type.equals("j2ee.ejb")) {
            IEJBModule ejbModule;
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.jst.server.core.IEJBModule");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((ejbModule = (IEJBModule)module.loadAdapter((Class)clazz, null)) != null) {
                IStatus status = this.canModifyModules(new IModule[]{module}, null);
                if (status == null || !status.isOK()) {
                    throw new CoreException(status);
                }
                IModule[] childs = this.doGetChildModules(module);
                if (childs.length > 0) {
                    return childs;
                }
                return new IModule[]{module};
            }
        }
        if (type.equals("j2ee.ear")) {
            IEnterpriseApplication enterpriseApplication;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.server.core.IEnterpriseApplication");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((enterpriseApplication = (IEnterpriseApplication)module.loadAdapter((Class)clazz, null)).getModules() != null) {
                IStatus status = this.canModifyModules(new IModule[]{module}, null);
                if (status == null || !status.isOK()) {
                    throw new CoreException(status);
                }
                return new IModule[]{module};
            }
        }
        if (type.equals("j2ee.web")) {
            IWebModule webModule;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jst.server.core.IWebModule");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((webModule = (IWebModule)module.loadAdapter((Class)clazz, null)) != null) {
                IStatus status = this.canModifyModules(new IModule[]{module}, null);
                if (status == null || !status.isOK()) {
                    throw new CoreException(status);
                }
                IModule[] childs = this.doGetChildModules(module);
                if (childs.length > 0) {
                    return childs;
                }
                return new IModule[]{module};
            }
        }
        return null;
    }

    private IModule[] doGetChildModules(IModule module) {
        IModule[] ears = ServerUtil.getModules((String)"j2ee.ear");
        ArrayList<IModule> list = new ArrayList<IModule>();
        int i = 0;
        while (i < ears.length) {
            IModule iModule = ears[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.jst.server.core.IEnterpriseApplication");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IEnterpriseApplication ear = (IEnterpriseApplication)iModule.loadAdapter((Class)clazz, null);
            IModule[] childs = ear.getModules();
            int j = 0;
            while (j < childs.length) {
                if (childs[j].equals(module)) {
                    list.add(ears[i]);
                }
                ++j;
            }
            ++i;
        }
        return list.toArray(new IModule[list.size()]);
    }

    public Map getServerInstancePropertiesImpl() {
        return this.getAttribute("generic_server_instance_properties", new HashMap());
    }

    public void setServerInstanceProperties(Map map) {
        this.setAttribute("generic_server_instance_properties", map);
    }
}

