/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.jst.server.core.EJBBean;
import org.eclipse.jst.server.core.JndiLaunchable;
import org.eclipse.jst.server.core.JndiObject;
import org.eclipse.jst.server.core.Servlet;
import org.eclipse.jst.server.generic.core.internal.GenericServer;
import org.eclipse.jst.server.generic.core.internal.Trace;
import org.eclipse.jst.server.generic.servertype.definition.JndiProperty;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.LaunchableAdapterDelegate;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.eclipse.wst.server.core.util.HttpLaunchable;
import org.eclipse.wst.server.core.util.WebResource;

public class GenericServerLaunchableAdapterDelegate
extends LaunchableAdapterDelegate {
    static /* synthetic */ Class class$0;

    public Object getLaunchable(IServer server, IModuleArtifact moduleObject) {
        ServerDelegate delegate;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ServerDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!((delegate = (ServerDelegate)server.loadAdapter((Class)clazz, null)) instanceof GenericServer)) {
            return null;
        }
        if (moduleObject instanceof Servlet || moduleObject instanceof WebResource) {
            return this.prepareHttpLaunchable(moduleObject, delegate);
        }
        if (moduleObject instanceof EJBBean || moduleObject instanceof JndiObject) {
            return this.prepareJndiLaunchable(moduleObject, delegate);
        }
        return null;
    }

    private Object prepareJndiLaunchable(IModuleArtifact moduleObject, ServerDelegate delegate) {
        JndiLaunchable launchable = null;
        GenericServer genericServer = (GenericServer)delegate;
        ServerRuntime definition = genericServer.getServerDefinition();
        Properties props = new Properties();
        props.put("java.naming.factory.initial", definition.getJndiConnection().getInitialContextFactory());
        props.put("java.naming.provider.url", definition.getJndiConnection().getProviderUrl());
        List jps = definition.getJndiConnection().getJndiProperty();
        Iterator propsIt = jps.iterator();
        while (propsIt.hasNext()) {
            JndiProperty prop = (JndiProperty)propsIt.next();
            props.put(prop.getName(), prop.getValue());
        }
        if (moduleObject instanceof EJBBean) {
            EJBBean bean = (EJBBean)moduleObject;
            launchable = new JndiLaunchable(props, bean.getJndiName());
        }
        if (moduleObject instanceof JndiObject) {
            JndiObject jndi = (JndiObject)moduleObject;
            launchable = new JndiLaunchable(props, jndi.getJndiName());
        }
        return launchable;
    }

    private Object prepareHttpLaunchable(IModuleArtifact moduleObject, ServerDelegate delegate) {
        try {
            URL url = ((IURLProvider)delegate).getModuleRootURL(moduleObject.getModule());
            Trace.trace("root: " + url);
            if (moduleObject instanceof Servlet) {
                Servlet servlet = (Servlet)moduleObject;
                if (servlet.getAlias() != null) {
                    String path = servlet.getAlias();
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    url = new URL(url, path);
                } else {
                    url = new URL(url, "servlet/" + servlet.getServletClassName());
                }
            } else if (moduleObject instanceof WebResource) {
                WebResource resource = (WebResource)moduleObject;
                String path = resource.getPath().toString();
                Trace.trace("path: " + path);
                if (path != null && path.startsWith("/") && path.length() > 0) {
                    path = path.substring(1);
                }
                if (path != null && path.length() > 0) {
                    url = new URL(url, path);
                }
            }
            return new HttpLaunchable(url);
        }
        catch (Exception e) {
            Trace.trace("Error getting URL for " + moduleObject, e);
            return null;
        }
    }
}

