/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.contentproperties.ui;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.html.ui.internal.Logger;
import org.eclipse.wst.html.ui.internal.contentproperties.ui.ContentSettingsRegistry;
import org.eclipse.wst.sse.ui.internal.contentproperties.ui.ComboList;
import org.eclipse.wst.sse.ui.internal.contentproperties.ui.ComboListOnPropertyPage;
import org.eclipse.wst.sse.ui.internal.contentproperties.ui.ContentSettingsPropertyPage;

public final class HTMLContentSettingsPropertyPage
extends ContentSettingsPropertyPage
implements SelectionListener {
    private final int N_DOCUMENT_TYPE = 0;
    private final int N_CSS_PROFILE = 1;
    private final int N_TARGET_DEVICE = 2;
    private Text publicIdText;
    private Text systemIdText;

    public HTMLContentSettingsPropertyPage() {
        this.numberOfCombo = 3;
        this.numCols = 2;
        this.numRows = 8;
        this.combo = new ComboListOnPropertyPage[this.numberOfCombo];
    }

    protected void createDocumentTypeComboBox() {
        Label label = new Label(this.propertyPage, 16384);
        label.setText(HTMLUIMessages.UI_Description_of_role_of_following_DOCTYPE);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = this.numCols;
        label.setLayoutData((Object)data);
        this.combo[0] = super.createComboBoxOf(this.DOCUMENT_LABEL);
        this.combo[this.N_DOCUMENT_TYPE].addSelectionListener((SelectionListener)this);
        ContentSettingsRegistry.setHTMLDocumentTypeRegistryInto((ComboList)this.combo[0]);
        this.createIDTextField();
        if (this.combo[0].getItemCount() <= 0) {
            return;
        }
        String initValue = this.contentSettings.getProperty((IResource)super.getElement(), "html-document-type");
        if (initValue == null) {
            initValue = "";
        }
        super.setSelectionItem(this.combo[0], initValue);
        this.publicIdText.setText(initValue);
        if (!initValue.equals("")) {
            if (ContentSettingsRegistry.getSystemIdFrom(initValue) != null) {
                this.systemIdText.setText(ContentSettingsRegistry.getSystemIdFrom(initValue));
            } else {
                this.systemIdText.setText("");
            }
        } else {
            this.systemIdText.setText("");
        }
        label = new Label(this.propertyPage, 258);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = this.numCols;
        data.verticalSpan = 8;
        label.setLayoutData((Object)data);
    }

    protected void createCSSComboBox() {
        this.combo[1] = super.createComboBoxOf(this.CSS_LABEL);
        ContentSettingsRegistry.setCSSMetaModelRegistryInto((ComboList)this.combo[1]);
        if (this.combo[1].getItemCount() <= 0) {
            return;
        }
        String initValue = this.contentSettings.getProperty((IResource)super.getElement(), "css-profile");
        if (initValue == null) {
            initValue = "";
        }
        super.setSelectionItem(this.combo[1], initValue);
    }

    protected void createDeviceComboBox() {
        this.combo[2] = super.createComboBoxOf(this.DEVICE_LABEL);
        ContentSettingsRegistry.setDeviceProfileRegistryInto((ComboList)this.combo[2]);
        if (this.combo[2].getItemCount() <= 0) {
            return;
        }
        String initValue = this.contentSettings.getProperty((IResource)super.getElement(), "target-device");
        if (initValue == null) {
            initValue = "";
        }
        super.setSelectionItem(this.combo[2], initValue);
    }

    protected void createSettingsPageGUI() {
        int type = ((IResource)this.getElement()).getType();
        switch (type) {
            case 1: {
                this.createDocumentTypeComboBox();
                this.createCSSComboBox();
                this.createDeviceComboBox();
                this.computeMaxWidthHint();
                WorkbenchHelp.setHelp((Control)this.propertyPage, (String)"org.eclipse.wst.html.ui.misc0170");
                break;
            }
            default: {
                Logger.log(2, "HTMLContentSettingsPropertyPage is instantiated by resource except FILE");
            }
        }
    }

    protected void putSelectedPropertyInto(Map properties, String valueInCombo, int index) {
        switch (index) {
            case 0: {
                properties.put("html-document-type", valueInCombo);
                break;
            }
            case 1: {
                properties.put("css-profile", valueInCombo);
                break;
            }
            case 2: {
                properties.put("target-device", valueInCombo);
                break;
            }
            default: {
                Logger.log(4, "Index is out of range in putSelectedPropertyInto() in class HTMLContentSettingsPropertyPage");
            }
        }
    }

    protected void deleteNoneProperty(int index) {
        switch (index) {
            case 0: {
                this.contentSettings.deleteProperty((IResource)super.getElement(), "html-document-type");
                break;
            }
            case 1: {
                this.contentSettings.deleteProperty((IResource)super.getElement(), "css-profile");
                break;
            }
            case 2: {
                this.contentSettings.deleteProperty((IResource)super.getElement(), "target-device");
                break;
            }
            default: {
                Logger.log(4, "Index is out of range in deleteNoneProperty() in class HTMLContentSettingsPropertyPage");
            }
        }
    }

    private void createIDTextField() {
        Label publicLabel = new Label(this.propertyPage, 0);
        GridData data = new GridData(768);
        data.horizontalIndent = 10;
        publicLabel.setLayoutData((Object)data);
        publicLabel.setText(HTMLUIMessages.UI_Public_ID);
        this.publicIdText = new Text(this.propertyPage, 2056);
        data = new GridData();
        this.publicIdText.setLayoutData((Object)data);
        Label systemLabel = new Label(this.propertyPage, 0);
        data = new GridData(768);
        data.horizontalIndent = 10;
        systemLabel.setLayoutData((Object)data);
        systemLabel.setText(HTMLUIMessages.UI_System_ID);
        this.systemIdText = new Text(this.propertyPage, 2056);
        data = new GridData();
        this.systemIdText.setLayoutData((Object)data);
    }

    private void computeMaxWidthHint() {
        String maxLengthString = ContentSettingsRegistry.maxLengthStringInHTMLDocumentTypeRegistry;
        String backup = this.systemIdText.getText();
        this.systemIdText.setText(maxLengthString);
        int maxWidthHint = this.systemIdText.computeSize((int)-1, (int)-1).x;
        this.systemIdText.setText(backup);
        if (this.combo[this.N_DOCUMENT_TYPE].getLayoutData() != null) {
            ((GridData)this.combo[this.N_DOCUMENT_TYPE].getLayoutData()).widthHint = maxWidthHint;
        }
        if (this.publicIdText.getLayoutData() != null) {
            ((GridData)this.publicIdText.getLayoutData()).widthHint = maxWidthHint;
        }
        if (this.systemIdText.getLayoutData() != null) {
            ((GridData)this.systemIdText.getLayoutData()).widthHint = maxWidthHint;
        }
        if (this.combo[this.N_CSS_PROFILE].getLayoutData() != null) {
            ((GridData)this.combo[this.N_CSS_PROFILE].getLayoutData()).widthHint = maxWidthHint;
        }
        if (this.combo[this.N_TARGET_DEVICE].getLayoutData() != null) {
            ((GridData)this.combo[this.N_TARGET_DEVICE].getLayoutData()).widthHint = maxWidthHint;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent event) {
        Widget source = event.widget;
        if (this.combo[this.N_DOCUMENT_TYPE].equals((Object)source)) {
            ComboListOnPropertyPage combo = this.combo[this.N_DOCUMENT_TYPE];
            if (combo.getSelectionIndex() < 0) {
                return;
            }
            if (!combo.getSelectedValue().equals("")) {
                this.publicIdText.setText(combo.getSelectedValue());
                if (ContentSettingsRegistry.getSystemIdFrom(combo.getSelectedValue()) != null) {
                    this.systemIdText.setText(ContentSettingsRegistry.getSystemIdFrom(combo.getSelectedValue()));
                } else {
                    this.systemIdText.setText("");
                }
            } else {
                this.publicIdText.setText("");
                this.systemIdText.setText("");
            }
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.publicIdText.setText("");
        this.systemIdText.setText("");
    }
}

