/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoRequestor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class AddImportsOperation
implements IWorkspaceRunnable {
    private ICompilationUnit fCompilationUnit;
    private final IDocument fDocument;
    private final int fSelectionOffset;
    private final int fSelectionLength;
    private final IChooseImportQuery fQuery;
    private IStatus fStatus;

    public AddImportsOperation(ICompilationUnit cu, IDocument document, int selectionOffset, int selectionLength, IChooseImportQuery query) {
        Assert.isNotNull((Object)cu);
        Assert.isNotNull((Object)document);
        this.fCompilationUnit = cu;
        this.fDocument = document;
        this.fSelectionOffset = selectionOffset;
        this.fSelectionLength = selectionLength;
        this.fQuery = query;
        this.fStatus = Status.OK_STATUS;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                monitor.beginTask(CodeGenerationMessages.AddImportsOperation_description, 15);
                ImportRewrite importRewrite = new ImportRewrite(this.fCompilationUnit);
                importRewrite.setFindAmbiguosImports(true);
                CompilationUnit astRoot = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)this.fCompilationUnit, ASTProvider.WAIT_YES, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                TextEdit edit = this.evaluateEdits(astRoot, importRewrite, this.fSelectionOffset, this.fSelectionLength, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                if (edit != null) {
                    edit.apply(this.fDocument, 0);
                    TextEdit importsEdit = importRewrite.createEdit(this.fDocument, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                    importsEdit.apply(this.fDocument, 0);
                }
            }
            catch (BadLocationException e) {
                throw new CoreException(JavaUIStatus.createError(4, e));
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        monitor.done();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TextEdit evaluateEdits(CompilationUnit root, ImportRewrite importRewrite, int offset, int length, IProgressMonitor monitor) throws BadLocationException, JavaModelException {
        TypeInfo chosen;
        IJavaSearchScope searchScope;
        TypeInfo[] types;
        int qualifierStart;
        String name;
        String containerName;
        int simpleNameStart;
        String simpleName;
        SimpleName nameNode = null;
        if (root != null) {
            ASTNode node = NodeFinder.perform((ASTNode)root, offset, length);
            if (node instanceof MarkerAnnotation) {
                node = ((Annotation)node).getTypeName();
            }
            if (node instanceof QualifiedName) {
                nameNode = ((QualifiedName)node).getName();
            } else if (node instanceof SimpleName) {
                nameNode = (SimpleName)node;
            }
        }
        if (nameNode != null) {
            Name qualifier;
            simpleName = nameNode.getIdentifier();
            simpleNameStart = nameNode.getStartPosition();
            if (nameNode.getLocationInParent() == QualifiedName.NAME_PROPERTY) {
                qualifier = ((QualifiedName)nameNode.getParent()).getQualifier();
                containerName = qualifier.getFullyQualifiedName();
                name = JavaModelUtil.concatenateName(containerName, simpleName);
                qualifierStart = qualifier.getStartPosition();
            } else if (nameNode.getParent().getLocationInParent() == QualifiedType.NAME_PROPERTY) {
                qualifier = ((QualifiedType)nameNode.getParent().getParent()).getQualifier();
                containerName = ASTNodes.asString((ASTNode)qualifier);
                name = JavaModelUtil.concatenateName(containerName, simpleName);
                qualifierStart = qualifier.getStartPosition();
            } else if (nameNode.getLocationInParent() == MethodInvocation.NAME_PROPERTY) {
                qualifier = ((MethodInvocation)nameNode.getParent()).getExpression();
                if (!(qualifier instanceof Name)) return null;
                containerName = ASTNodes.asString((ASTNode)qualifier);
                name = JavaModelUtil.concatenateName(containerName, simpleName);
                qualifierStart = qualifier.getStartPosition();
            } else {
                containerName = "";
                name = simpleName;
                qualifierStart = simpleNameStart;
            }
            IBinding binding = nameNode.resolveBinding();
            if (binding != null) {
                ITypeBinding declaringClass;
                if (binding instanceof ITypeBinding) {
                    ITypeBinding typeBinding = (ITypeBinding)binding;
                    String qualifiedBindingName = typeBinding.getQualifiedName();
                    if (containerName.length() > 0 && !qualifiedBindingName.equals(name)) {
                        return null;
                    }
                    String res = importRewrite.addImport(typeBinding);
                    if (containerName.length() <= 0 || res.equals(simpleName)) return new ReplaceEdit(qualifierStart, simpleNameStart - qualifierStart, "");
                    return null;
                }
                if (!(binding instanceof IVariableBinding) && !(binding instanceof IMethodBinding)) return null;
                boolean isField = binding instanceof IVariableBinding;
                ITypeBinding iTypeBinding = declaringClass = isField ? ((IVariableBinding)binding).getDeclaringClass() : ((IMethodBinding)binding).getDeclaringClass();
                if (!Modifier.isStatic((int)binding.getModifiers()) || containerName.length() <= 0 || !containerName.equals(declaringClass.getName()) && !containerName.equals(declaringClass.getQualifiedName())) return null;
                String res = importRewrite.addStaticImport(declaringClass.getQualifiedName(), binding.getName(), isField);
                if (res.equals(simpleName)) return new ReplaceEdit(qualifierStart, simpleNameStart - qualifierStart, "");
                return null;
            }
        } else {
            qualifierStart = this.getNameStart(this.fDocument, offset);
            int nameEnd = this.getNameEnd(this.fDocument, offset + length);
            int len = nameEnd - qualifierStart;
            name = this.fDocument.get(qualifierStart, len).trim();
            simpleName = Signature.getSimpleName((String)name);
            containerName = Signature.getQualifier((String)name);
            simpleNameStart = this.getSimpleNameStart(this.fDocument, qualifierStart, containerName);
            String existingImport = importRewrite.findImport(simpleName);
            if (existingImport != null) {
                if (containerName.length() == 0) {
                    return null;
                }
                if (existingImport.equals(name)) return new ReplaceEdit(qualifierStart, simpleNameStart - qualifierStart, "");
                this.fStatus = JavaUIStatus.createError(4, Messages.format(CodeGenerationMessages.AddImportsOperation_error_importclash, existingImport), null);
                return null;
            }
        }
        if ((types = this.findAllTypes(simpleName, searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.fCompilationUnit.getJavaProject()}), nameNode, (IProgressMonitor)new SubProgressMonitor(monitor, 1))).length == 0) {
            this.fStatus = JavaUIStatus.createError(4, Messages.format(CodeGenerationMessages.AddImportsOperation_error_notresolved_message, simpleName), null);
            return null;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (types.length > 1 && this.fQuery != null) {
            chosen = this.fQuery.chooseImport(types, containerName);
            if (chosen == null) {
                throw new OperationCanceledException();
            }
        } else {
            chosen = types[0];
        }
        importRewrite.addImport(chosen.getFullyQualifiedName());
        return new ReplaceEdit(qualifierStart, simpleNameStart - qualifierStart, "");
    }

    private int getNameStart(IDocument doc, int pos) throws BadLocationException {
        while (pos > 0) {
            char ch = doc.getChar(pos - 1);
            if (!Character.isJavaIdentifierPart(ch) && ch != '.') {
                return pos;
            }
            --pos;
        }
        return pos;
    }

    private int getNameEnd(IDocument doc, int pos) throws BadLocationException {
        if (pos > 0 && Character.isWhitespace(doc.getChar(pos - 1))) {
            return pos;
        }
        int len = doc.getLength();
        while (pos < len) {
            char ch = doc.getChar(pos);
            if (!Character.isJavaIdentifierPart(ch)) {
                return pos;
            }
            ++pos;
        }
        return pos;
    }

    private int getSimpleNameStart(IDocument doc, int nameStart, String containerName) throws BadLocationException {
        int containerLen = containerName.length();
        int docLen = doc.getLength();
        if (containerLen > 0 && nameStart + containerLen + 1 < docLen) {
            int k = 0;
            while (k < containerLen) {
                if (doc.getChar(nameStart + k) != containerName.charAt(k)) {
                    return nameStart;
                }
                ++k;
            }
            if (doc.getChar(nameStart + containerLen) == '.') {
                return nameStart + containerLen;
            }
        }
        return nameStart;
    }

    private int getSearchForConstant(int typeKinds) {
        switch (typeKinds & 0x1E) {
            case 2: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 16: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 6: {
                return 10;
            }
            case 18: {
                return 9;
            }
        }
        return 0;
    }

    private TypeInfo[] findAllTypes(String simpleTypeName, IJavaSearchScope searchScope, SimpleName nameNode, IProgressMonitor monitor) throws JavaModelException {
        boolean is50OrHigher = JavaModelUtil.is50OrHigher(this.fCompilationUnit.getJavaProject());
        int typeKinds = 126;
        if (nameNode != null) {
            typeKinds = ASTResolving.getPossibleTypeKinds((ASTNode)nameNode, is50OrHigher);
        }
        ArrayList typeInfos = new ArrayList();
        TypeInfoRequestor requestor = new TypeInfoRequestor(typeInfos);
        new SearchEngine().searchAllTypeNames(null, simpleTypeName.toCharArray(), 0, this.getSearchForConstant(typeKinds), searchScope, (TypeNameRequestor)requestor, 3, monitor);
        ArrayList<TypeInfo> typeRefsFound = new ArrayList<TypeInfo>(typeInfos.size());
        int i = 0;
        int len = typeInfos.size();
        while (i < len) {
            TypeInfo curr = (TypeInfo)typeInfos.get(i);
            if (curr.getPackageName().length() > 0 && this.isOfKind(curr, typeKinds, is50OrHigher) && this.isVisible(curr)) {
                typeRefsFound.add(curr);
            }
            ++i;
        }
        return typeRefsFound.toArray(new TypeInfo[typeRefsFound.size()]);
    }

    private boolean isOfKind(TypeInfo curr, int typeKinds, boolean is50OrHigher) {
        int flags = curr.getModifiers();
        if (Flags.isAnnotation((int)flags)) {
            return is50OrHigher && (typeKinds & 8) != 0;
        }
        if (Flags.isEnum((int)flags)) {
            return is50OrHigher && (typeKinds & 0x10) != 0;
        }
        if (Flags.isInterface((int)flags)) {
            return (typeKinds & 4) != 0;
        }
        return (typeKinds & 2) != 0;
    }

    private boolean isVisible(TypeInfo curr) {
        int flags = curr.getModifiers();
        if (Flags.isPrivate((int)flags)) {
            return false;
        }
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags)) {
            return true;
        }
        return curr.getPackageName().equals(this.fCompilationUnit.getParent().getElementName());
    }

    public ISchedulingRule getScheduleRule() {
        return this.fCompilationUnit.getJavaProject().getResource();
    }

    public static interface IChooseImportQuery {
        public TypeInfo chooseImport(TypeInfo[] var1, String var2);
    }
}

