/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.corext.ValidateEditException;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.IImportsStructure;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public final class ImportsStructure
implements IImportsStructure {
    private ICompilationUnit fCompilationUnit;
    private ArrayList fPackageEntries;
    private int fImportOnDemandThreshold;
    private boolean fFilterImplicitImports;
    private boolean fFindAmbiguousImports;
    private List fImportsCreated;
    private List fStaticImportsCreated;
    private boolean fHasChanges;
    private IRegion fReplaceRange;
    private static final String JAVA_LANG = "java.lang";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImportsStructure(ICompilationUnit cu, String[] preferenceOrder, int importThreshold, boolean restoreExistingImports) throws CoreException {
        block11: {
            this.fHasChanges = false;
            this.fCompilationUnit = cu;
            JavaModelUtil.reconcile(cu);
            IImportContainer container = cu.getImportContainer();
            this.fImportOnDemandThreshold = importThreshold;
            this.fFilterImplicitImports = true;
            this.fFindAmbiguousImports = true;
            this.fPackageEntries = new ArrayList(20);
            this.fImportsCreated = null;
            this.fStaticImportsCreated = null;
            NullProgressMonitor monitor = new NullProgressMonitor();
            IDocument document = null;
            try {
                try {
                    document = this.aquireDocument((IProgressMonitor)monitor);
                    this.fReplaceRange = this.evaluateReplaceRange(document);
                    if (restoreExistingImports && container.exists()) {
                        this.addExistingImports(document, cu.getImports(), this.fReplaceRange);
                    }
                }
                catch (BadLocationException e) {
                    throw new CoreException(JavaUIStatus.createError(4, e));
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (document != null) {
                    this.releaseDocument(document, (IProgressMonitor)monitor);
                }
                throw throwable;
            }
            {
                Object var9_13 = null;
                if (document == null) break block11;
            }
            this.releaseDocument(document, (IProgressMonitor)monitor);
        }
        PackageEntry[] order = new PackageEntry[preferenceOrder.length];
        int i = 0;
        while (true) {
            if (i >= order.length) {
                this.addPreferenceOrderHolders(order);
                this.fHasChanges = false;
                return;
            }
            String curr = preferenceOrder[i];
            if (curr.length() > 0 && curr.charAt(0) == '#') {
                curr = curr.substring(1);
                order[i] = new PackageEntry(curr, curr, true);
            } else {
                order[i] = new PackageEntry(curr, curr, false);
            }
            ++i;
        }
    }

    private void addPreferenceOrderHolders(PackageEntry[] preferenceOrder) {
        if (this.fPackageEntries.isEmpty()) {
            int i = 0;
            while (i < preferenceOrder.length) {
                this.fPackageEntries.add(preferenceOrder[i]);
                ++i;
            }
        } else {
            PackageEntry[] lastAssigned = new PackageEntry[preferenceOrder.length];
            int k = 0;
            while (k < this.fPackageEntries.size()) {
                PackageEntry entry = (PackageEntry)this.fPackageEntries.get(k);
                if (!entry.isComment()) {
                    String currName = entry.getName();
                    int currNameLen = currName.length();
                    int bestGroupIndex = -1;
                    int bestGroupLen = -1;
                    int i = 0;
                    while (i < preferenceOrder.length) {
                        boolean currPrevStatic = preferenceOrder[i].isStatic();
                        if (currPrevStatic == entry.isStatic()) {
                            String currPrefEntry = preferenceOrder[i].getName();
                            int currPrefLen = currPrefEntry.length();
                            if (!(!currName.startsWith(currPrefEntry) || currPrefLen < bestGroupLen || currPrefLen != currNameLen && currName.charAt(currPrefLen) != '.' || bestGroupIndex != -1 && currPrefLen <= bestGroupLen)) {
                                bestGroupLen = currPrefLen;
                                bestGroupIndex = i;
                            }
                        }
                        ++i;
                    }
                    if (bestGroupIndex != -1) {
                        entry.setGroupID(preferenceOrder[bestGroupIndex].getName());
                        lastAssigned[bestGroupIndex] = entry;
                    }
                }
                ++k;
            }
            int currAppendIndex = 0;
            int i = 0;
            while (i < lastAssigned.length) {
                PackageEntry entry = lastAssigned[i];
                if (entry == null) {
                    PackageEntry newEntry = preferenceOrder[i];
                    if (currAppendIndex == 0 && !newEntry.isStatic()) {
                        currAppendIndex = this.getIndexAfterStatics();
                    }
                    this.fPackageEntries.add(currAppendIndex, newEntry);
                    ++currAppendIndex;
                } else {
                    currAppendIndex = this.fPackageEntries.indexOf(entry) + 1;
                }
                ++i;
            }
        }
    }

    private void addExistingImports(IDocument document, IImportDeclaration[] decls, IRegion replaceRange) throws JavaModelException, BadLocationException {
        if (decls.length == 0) {
            return;
        }
        PackageEntry currPackage = null;
        IImportDeclaration curr = decls[0];
        ISourceRange sourceRange = curr.getSourceRange();
        int currOffset = sourceRange.getOffset();
        int currLength = sourceRange.getLength();
        int currEndLine = document.getLineOfOffset(currOffset + currLength);
        int i = 1;
        while (i < decls.length) {
            String name = curr.getElementName();
            boolean isStatic = Flags.isStatic((int)curr.getFlags());
            String packName = Signature.getQualifier((String)name);
            if (currPackage == null || currPackage.compareTo(packName, isStatic) != 0) {
                currPackage = new PackageEntry(packName, null, isStatic);
                this.fPackageEntries.add(currPackage);
            }
            IImportDeclaration next = decls[i];
            sourceRange = next.getSourceRange();
            int nextOffset = sourceRange.getOffset();
            int nextLength = sourceRange.getLength();
            int nextOffsetLine = document.getLineOfOffset(nextOffset);
            if (currEndLine < nextOffsetLine) {
                nextOffset = document.getLineInformation(++currEndLine).getOffset();
            }
            currPackage.add(new ImportDeclEntry(name, isStatic, (IRegion)new Region(currOffset, nextOffset - currOffset)));
            currOffset = nextOffset;
            curr = next;
            if (currEndLine < nextOffsetLine) {
                nextOffset = document.getLineInformation(nextOffsetLine).getOffset();
                currPackage = new PackageEntry();
                this.fPackageEntries.add(currPackage);
                currPackage.add(new ImportDeclEntry(null, false, (IRegion)new Region(currOffset, nextOffset - currOffset)));
                currOffset = nextOffset;
            }
            currEndLine = document.getLineOfOffset(nextOffset + nextLength);
            ++i;
        }
        String name = curr.getElementName();
        boolean isStatic = Flags.isStatic((int)curr.getFlags());
        String packName = Signature.getQualifier((String)name);
        if (currPackage == null || currPackage.compareTo(packName, isStatic) != 0) {
            currPackage = new PackageEntry(packName, null, isStatic);
            this.fPackageEntries.add(currPackage);
        }
        ISourceRange range = curr.getSourceRange();
        int length = replaceRange.getOffset() + replaceRange.getLength() - range.getOffset();
        currPackage.add(new ImportDeclEntry(name, isStatic, (IRegion)new Region(range.getOffset(), length)));
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public void setFilterImplicitImports(boolean filterImplicitImports) {
        this.fFilterImplicitImports = filterImplicitImports;
    }

    public void setFindAmbiguousImports(boolean findAmbiguousImports) {
        this.fFindAmbiguousImports = findAmbiguousImports;
    }

    private static int getCommonPrefixLength(String s, String t) {
        int len = Math.min(s.length(), t.length());
        int i = 0;
        while (i < len) {
            if (s.charAt(i) != t.charAt(i)) {
                return i;
            }
            ++i;
        }
        return len;
    }

    private static char getCharAt(String str, int index) {
        if (str.length() > index) {
            return str.charAt(index);
        }
        return '\u0000';
    }

    private PackageEntry findBestMatch(String newName, boolean isStatic) {
        if (this.fPackageEntries.isEmpty()) {
            return null;
        }
        String groupId = null;
        int longestPrefix = -1;
        int i = 0;
        while (i < this.fPackageEntries.size()) {
            String currGroup;
            PackageEntry curr = (PackageEntry)this.fPackageEntries.get(i);
            if (isStatic == curr.isStatic() && (currGroup = curr.getGroupID()) != null && newName.startsWith(currGroup)) {
                int prefixLen = currGroup.length();
                if (prefixLen == newName.length()) {
                    return curr;
                }
                if (newName.charAt(prefixLen) == '.' && prefixLen > longestPrefix) {
                    longestPrefix = prefixLen;
                    groupId = currGroup;
                }
            }
            ++i;
        }
        PackageEntry bestMatch = null;
        PackageMatcher matcher = new PackageMatcher();
        matcher.initialize(newName, "");
        int i2 = 0;
        while (i2 < this.fPackageEntries.size()) {
            PackageEntry curr = (PackageEntry)this.fPackageEntries.get(i2);
            if (!curr.isComment() && curr.isStatic() == isStatic && (groupId == null || groupId.equals(curr.getGroupID()))) {
                boolean preferrCurr;
                boolean bl = preferrCurr = bestMatch == null || curr.getNumberOfImports() > bestMatch.getNumberOfImports();
                if (matcher.isBetterMatch(curr.getName(), preferrCurr)) {
                    bestMatch = curr;
                }
            }
            ++i2;
        }
        return bestMatch;
    }

    public static boolean isImplicitImport(String qualifier, ICompilationUnit cu) {
        if (JAVA_LANG.equals(qualifier)) {
            return true;
        }
        String packageName = cu.getParent().getElementName();
        if (qualifier.equals(packageName)) {
            return true;
        }
        String mainTypeName = JavaModelUtil.concatenateName(packageName, Signature.getQualifier((String)cu.getElementName()));
        return qualifier.equals(mainTypeName);
    }

    public Type addImport(ITypeBinding binding, AST ast) {
        if (binding.isPrimitive()) {
            return ast.newPrimitiveType(PrimitiveType.toCode((String)binding.getName()));
        }
        ITypeBinding normalizedBinding = Bindings.normalizeTypeBinding(binding);
        if (normalizedBinding == null) {
            return ast.newSimpleType((Name)ast.newSimpleName("invalid"));
        }
        if (normalizedBinding.isTypeVariable()) {
            return ast.newSimpleType((Name)ast.newSimpleName(binding.getName()));
        }
        if (normalizedBinding.isWildcardType()) {
            WildcardType wcType = ast.newWildcardType();
            ITypeBinding bound = normalizedBinding.getBound();
            if (bound != null && !bound.isWildcardType() && !bound.isCapture()) {
                Type boundType = this.addImport(bound, ast);
                wcType.setBound(boundType, normalizedBinding.isUpperbound());
            }
            return wcType;
        }
        if (normalizedBinding.isArray()) {
            Type elementType = this.addImport(normalizedBinding.getElementType(), ast);
            return ast.newArrayType(elementType, normalizedBinding.getDimensions());
        }
        String qualifiedName = Bindings.getRawQualifiedName(normalizedBinding);
        if (qualifiedName.length() > 0) {
            String res = this.internalAddImport(qualifiedName);
            ITypeBinding[] typeArguments = normalizedBinding.getTypeArguments();
            if (typeArguments.length > 0) {
                SimpleType erasureType = ast.newSimpleType(ASTNodeFactory.newName(ast, res));
                ParameterizedType paramType = ast.newParameterizedType((Type)erasureType);
                List arguments = paramType.typeArguments();
                int i = 0;
                while (i < typeArguments.length) {
                    arguments.add(this.addImport(typeArguments[i], ast));
                    ++i;
                }
                return paramType;
            }
            return ast.newSimpleType(ASTNodeFactory.newName(ast, res));
        }
        return ast.newSimpleType(ASTNodeFactory.newName(ast, Bindings.getRawName(normalizedBinding)));
    }

    public Type addImportFromSignature(String typeSig, AST ast) {
        if (typeSig == null || typeSig.length() == 0) {
            throw new IllegalArgumentException("Invalid type signature: empty or null");
        }
        int sigKind = Signature.getTypeSignatureKind((String)typeSig);
        switch (sigKind) {
            case 2: {
                return ast.newPrimitiveType(PrimitiveType.toCode((String)Signature.toString((String)typeSig)));
            }
            case 4: {
                Type elementType = this.addImportFromSignature(Signature.getElementType((String)typeSig), ast);
                return ast.newArrayType(elementType, Signature.getArrayCount((String)typeSig));
            }
            case 1: {
                String erasureSig = Signature.getTypeErasure((String)typeSig);
                String erasureName = Signature.toString((String)erasureSig);
                if (erasureSig.charAt(0) == 'L') {
                    erasureName = this.internalAddImport(erasureName);
                }
                SimpleType baseType = ast.newSimpleType(ASTNodeFactory.newName(ast, erasureName));
                String[] typeArguments = Signature.getTypeArguments((String)typeSig);
                if (typeArguments.length > 0) {
                    ParameterizedType type = ast.newParameterizedType((Type)baseType);
                    List argNodes = type.typeArguments();
                    int i = 0;
                    while (i < typeArguments.length) {
                        argNodes.add(this.addImportFromSignature(typeArguments[i], ast));
                        ++i;
                    }
                    return type;
                }
                return baseType;
            }
            case 3: {
                return ast.newSimpleType((Name)ast.newSimpleName(Signature.toString((String)typeSig)));
            }
            case 5: {
                WildcardType wildcardType = ast.newWildcardType();
                char ch = typeSig.charAt(0);
                if (ch != '*') {
                    Type bound = this.addImportFromSignature(typeSig.substring(1), ast);
                    wildcardType.setBound(bound, ch == '+');
                }
                return wildcardType;
            }
            case 6: {
                return this.addImportFromSignature(typeSig.substring(1), ast);
            }
        }
        JavaPlugin.logErrorMessage("Unknown type signature kind: " + typeSig);
        return ast.newSimpleType((Name)ast.newSimpleName("invalid"));
    }

    public String addImport(ITypeBinding binding) {
        if (binding.isPrimitive() || binding.isTypeVariable()) {
            return binding.getName();
        }
        ITypeBinding normalizedBinding = Bindings.normalizeTypeBinding(binding);
        if (normalizedBinding == null) {
            return "invalid";
        }
        if (normalizedBinding.isWildcardType()) {
            StringBuffer res = new StringBuffer("?");
            ITypeBinding bound = normalizedBinding.getBound();
            if (bound != null && !bound.isWildcardType() && !bound.isCapture()) {
                if (normalizedBinding.isUpperbound()) {
                    res.append(" extends ");
                } else {
                    res.append(" super ");
                }
                res.append(this.addImport(bound));
            }
            return res.toString();
        }
        if (normalizedBinding.isArray()) {
            StringBuffer res = new StringBuffer(this.addImport(normalizedBinding.getElementType()));
            int i = normalizedBinding.getDimensions();
            while (i > 0) {
                res.append("[]");
                --i;
            }
            return res.toString();
        }
        String qualifiedName = Bindings.getRawQualifiedName(normalizedBinding);
        if (qualifiedName.length() > 0) {
            String str = this.internalAddImport(qualifiedName);
            ITypeBinding[] typeArguments = normalizedBinding.getTypeArguments();
            if (typeArguments.length > 0) {
                StringBuffer res = new StringBuffer(str);
                res.append('<');
                int i = 0;
                while (i < typeArguments.length) {
                    if (i > 0) {
                        res.append(',');
                    }
                    res.append(this.addImport(typeArguments[i]));
                    ++i;
                }
                res.append('>');
                return res.toString();
            }
            return str;
        }
        return Bindings.getRawName(normalizedBinding);
    }

    public String addImport(String qualifiedTypeName) {
        int angleBracketOffset = qualifiedTypeName.indexOf(60);
        if (angleBracketOffset != -1) {
            return String.valueOf(this.internalAddImport(qualifiedTypeName.substring(0, angleBracketOffset))) + qualifiedTypeName.substring(angleBracketOffset);
        }
        int bracketOffset = qualifiedTypeName.indexOf(91);
        if (bracketOffset != -1) {
            return String.valueOf(this.internalAddImport(qualifiedTypeName.substring(0, bracketOffset))) + qualifiedTypeName.substring(bracketOffset);
        }
        return this.internalAddImport(qualifiedTypeName);
    }

    public String addStaticImport(IBinding binding) {
        if (binding instanceof IVariableBinding) {
            ITypeBinding declaringType = ((IVariableBinding)binding).getDeclaringClass();
            return this.addStaticImport(Bindings.getRawQualifiedName(declaringType), binding.getName(), true);
        }
        if (binding instanceof IMethodBinding) {
            ITypeBinding declaringType = ((IMethodBinding)binding).getDeclaringClass();
            return this.addStaticImport(Bindings.getRawQualifiedName(declaringType), binding.getName(), false);
        }
        return binding.getName();
    }

    public String addStaticImport(String declaringTypeName, String simpleName, boolean isField) {
        String containerName = Signature.getQualifier((String)declaringTypeName);
        String fullName = String.valueOf(declaringTypeName) + '.' + simpleName;
        if (containerName.length() == 0) {
            return String.valueOf(declaringTypeName) + '.' + simpleName;
        }
        if (!"*".equals(simpleName)) {
            String existing;
            if (isField) {
                existing = this.findStaticImport(null, simpleName);
                if (existing != null) {
                    if (existing.equals(fullName)) {
                        return simpleName;
                    }
                    return fullName;
                }
            } else {
                existing = this.findStaticImport(declaringTypeName, simpleName);
                if (existing != null) {
                    return simpleName;
                }
            }
        }
        ImportDeclEntry decl = new ImportDeclEntry(fullName, true, null);
        this.sortIn(declaringTypeName, decl, true);
        return simpleName;
    }

    private String internalAddImport(String fullTypeName) {
        String typeName;
        String typeContainerName;
        int idx = fullTypeName.lastIndexOf(46);
        if (idx != -1) {
            typeContainerName = fullTypeName.substring(0, idx);
            typeName = fullTypeName.substring(idx + 1);
        } else {
            typeContainerName = "";
            typeName = fullTypeName;
        }
        if (typeContainerName.length() == 0 && PrimitiveType.toCode((String)typeName) != null) {
            return fullTypeName;
        }
        if (!"*".equals(typeName)) {
            String topLevelTypeName = Signature.getQualifier((String)this.fCompilationUnit.getElementName());
            if (typeName.equals(topLevelTypeName)) {
                if (!typeContainerName.equals(this.fCompilationUnit.getParent().getElementName())) {
                    return fullTypeName;
                }
                return typeName;
            }
            String existing = this.findImport(typeName);
            if (existing != null) {
                if (fullTypeName.equals(existing)) {
                    return typeName;
                }
                return fullTypeName;
            }
        }
        ImportDeclEntry decl = new ImportDeclEntry(fullTypeName, false, null);
        this.sortIn(typeContainerName, decl, false);
        return typeName;
    }

    private int getIndexAfterStatics() {
        int i = 0;
        while (i < this.fPackageEntries.size()) {
            if (!((PackageEntry)this.fPackageEntries.get(i)).isStatic()) {
                return i;
            }
            ++i;
        }
        return this.fPackageEntries.size();
    }

    private void sortIn(String typeContainerName, ImportDeclEntry decl, boolean isStatic) {
        PackageEntry bestMatch = this.findBestMatch(typeContainerName, isStatic);
        if (bestMatch == null) {
            PackageEntry packEntry = new PackageEntry(typeContainerName, null, isStatic);
            packEntry.add(decl);
            int insertPos = packEntry.isStatic() ? 0 : this.getIndexAfterStatics();
            this.fPackageEntries.add(insertPos, packEntry);
        } else {
            int cmp = typeContainerName.compareTo(bestMatch.getName());
            if (cmp == 0) {
                bestMatch.sortIn(decl);
            } else {
                String group = bestMatch.getGroupID();
                if (group != null && !typeContainerName.startsWith(group)) {
                    group = null;
                }
                PackageEntry packEntry = new PackageEntry(typeContainerName, group, isStatic);
                packEntry.add(decl);
                int index = this.fPackageEntries.indexOf(bestMatch);
                if (cmp < 0) {
                    this.fPackageEntries.add(index, packEntry);
                } else {
                    this.fPackageEntries.add(index + 1, packEntry);
                }
            }
        }
        this.fHasChanges = true;
    }

    public boolean removeImport(String qualifiedName) {
        String typeContainerName = Signature.getQualifier((String)qualifiedName);
        int bracketOffset = qualifiedName.indexOf(91);
        if (bracketOffset != -1) {
            qualifiedName = qualifiedName.substring(0, bracketOffset);
        }
        int nPackages = this.fPackageEntries.size();
        int i = 0;
        while (i < nPackages) {
            PackageEntry entry = (PackageEntry)this.fPackageEntries.get(i);
            if (entry.compareTo(typeContainerName, false) == 0 && entry.remove(qualifiedName, false)) {
                this.fHasChanges = true;
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeStaticImport(String qualifiedName) {
        String containerName = Signature.getQualifier((String)qualifiedName);
        int nPackages = this.fPackageEntries.size();
        int i = 0;
        while (i < nPackages) {
            PackageEntry entry = (PackageEntry)this.fPackageEntries.get(i);
            if (entry.compareTo(containerName, true) == 0 && entry.remove(qualifiedName, true)) {
                this.fHasChanges = true;
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeImport(ITypeBinding binding) {
        if ((binding = Bindings.normalizeTypeBinding(binding)) == null) {
            return false;
        }
        String qualifiedName = Bindings.getRawQualifiedName(binding);
        if (qualifiedName.length() > 0) {
            return this.removeImport(qualifiedName);
        }
        return false;
    }

    public String findImport(String simpleName) {
        int nPackages = this.fPackageEntries.size();
        int i = 0;
        while (i < nPackages) {
            ImportDeclEntry found;
            PackageEntry entry = (PackageEntry)this.fPackageEntries.get(i);
            if (!entry.isStatic() && (found = entry.find(simpleName)) != null) {
                return found.getElementName();
            }
            ++i;
        }
        return null;
    }

    public String findStaticImport(String typeContainerName, String typeSimpleName) {
        int nPackages = this.fPackageEntries.size();
        int i = 0;
        while (i < nPackages) {
            ImportDeclEntry found;
            PackageEntry entry = (PackageEntry)this.fPackageEntries.get(i);
            if (entry.isStatic() && (typeContainerName == null || entry.getName().equals(typeContainerName)) && (found = entry.find(typeSimpleName)) != null) {
                return found.getElementName();
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void create(boolean save, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(CodeGenerationMessages.ImportsStructure_operation_description, 4);
        document = null;
        session = null;
        try {
            block15: {
                try {
                    document = this.aquireDocument((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (document instanceof IDocumentExtension4) {
                        session = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
                    }
                    if (!(edit = this.getResultingEdits(document, (IProgressMonitor)new SubProgressMonitor(monitor, 1))).hasChildren()) break block15;
                    if (save) {
                        this.commitDocument(document, edit, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        edit.apply(document);
                    }
                }
                catch (BadLocationException e) {
                    throw new CoreException(JavaUIStatus.createError(4, e));
                }
            }
            var6_9 = null;
        }
        catch (Throwable var7_7) {
            var6_8 = null;
            try {
                if (session != null) {
                    ((IDocumentExtension4)document).stopRewriteSession(session);
                }
                v0 = null;
            }
            catch (Throwable var9_10) {
                v0 = null;
            }
            var8_12 = v0;
            this.releaseDocument(document, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            throw var7_7;
        }
        try {}
        catch (Throwable var9_11) {
            v1 = null;
lbl40:
            // 2 sources

            var8_13 = v1;
            this.releaseDocument(document, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            return;
        }
        if (session != null) {
            ((IDocumentExtension4)document).stopRewriteSession(session);
        }
        v1 = null;
        ** GOTO lbl40
    }

    private IDocument aquireDocument(IProgressMonitor monitor) throws CoreException {
        IFile file;
        if (JavaModelUtil.isPrimary(this.fCompilationUnit) && (file = (IFile)this.fCompilationUnit.getResource()).exists()) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            IPath path = this.fCompilationUnit.getPath();
            bufferManager.connect(path, monitor);
            return bufferManager.getTextFileBuffer(path).getDocument();
        }
        monitor.done();
        return new Document(this.fCompilationUnit.getSource());
    }

    private void releaseDocument(IDocument document, IProgressMonitor monitor) throws CoreException {
        IFile file;
        if (JavaModelUtil.isPrimary(this.fCompilationUnit) && (file = (IFile)this.fCompilationUnit.getResource()).exists()) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            bufferManager.disconnect(file.getFullPath(), monitor);
            return;
        }
        this.fCompilationUnit.getBuffer().setContents(document.get());
        monitor.done();
    }

    private void commitDocument(IDocument document, MultiTextEdit edit, IProgressMonitor monitor) throws CoreException, MalformedTreeException, BadLocationException {
        IFile file;
        if (JavaModelUtil.isPrimary(this.fCompilationUnit) && (file = (IFile)this.fCompilationUnit.getResource()).exists()) {
            IStatus status = Resources.makeCommittable((IResource)file, null);
            if (!status.isOK()) {
                throw new ValidateEditException(status);
            }
            edit.apply(document);
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            bufferManager.getTextFileBuffer(file.getFullPath()).commit(monitor, true);
            return;
        }
        edit.apply(document);
    }

    private IRegion evaluateReplaceRange(IDocument document) throws JavaModelException, BadLocationException {
        JavaModelUtil.reconcile(this.fCompilationUnit);
        IImportContainer container = this.fCompilationUnit.getImportContainer();
        if (container.exists()) {
            int nextLine;
            ISourceRange importSourceRange = container.getSourceRange();
            int startPos = importSourceRange.getOffset();
            int endPos = startPos + importSourceRange.getLength();
            if (!Strings.isLineDelimiterChar(document.getChar(endPos - 1)) && (nextLine = document.getLineOfOffset(endPos) + 1) < document.getNumberOfLines()) {
                int stopPos = document.getLineInformation(nextLine).getOffset();
                while (endPos < stopPos && Character.isWhitespace(document.getChar(endPos))) {
                    ++endPos;
                }
            }
            return new Region(startPos, endPos - startPos);
        }
        int start = this.getPackageStatementEndPos(document);
        return new Region(start, 0);
    }

    public MultiTextEdit getResultingEdits(IDocument document, IProgressMonitor monitor) throws JavaModelException, BadLocationException {
        MultiTextEdit resEdit;
        block20: {
            MultiTextEdit multiTextEdit;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                this.fImportsCreated = new ArrayList();
                this.fStaticImportsCreated = new ArrayList();
                int importsStart = this.fReplaceRange.getOffset();
                int importsLen = this.fReplaceRange.getLength();
                String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                boolean useSpaceBetween = this.useSpaceBetweenGroups();
                int currPos = importsStart;
                resEdit = new MultiTextEdit();
                if (importsLen == 0) {
                    resEdit.addChild((TextEdit)new InsertEdit(currPos, lineDelim));
                }
                PackageEntry lastPackage = null;
                Set onDemandConflicts = null;
                if (this.fFindAmbiguousImports) {
                    onDemandConflicts = this.evaluateStarImportConflicts(monitor);
                }
                ArrayList<String> stringsToInsert = new ArrayList<String>();
                int nPackageEntries = this.fPackageEntries.size();
                int i = 0;
                while (i < nPackageEntries) {
                    PackageEntry pack = (PackageEntry)this.fPackageEntries.get(i);
                    int nImports = pack.getNumberOfImports();
                    if (this.fFilterImplicitImports && !pack.isStatic() && ImportsStructure.isImplicitImport(pack.getName(), this.fCompilationUnit)) {
                        pack.removeAllNew(onDemandConflicts);
                        nImports = pack.getNumberOfImports();
                    }
                    if (nImports != 0) {
                        if (useSpaceBetween && lastPackage != null && !pack.isComment() && !pack.isSameGroup(lastPackage)) {
                            ImportDeclEntry last = lastPackage.getImportAt(lastPackage.getNumberOfImports() - 1);
                            ImportDeclEntry first = pack.getImportAt(0);
                            if (!lastPackage.isComment() && (last.isNew() || first.isNew())) {
                                stringsToInsert.add(lineDelim);
                            }
                        }
                        lastPackage = pack;
                        boolean isStatic = pack.isStatic();
                        boolean doStarImport = pack.hasStarImport(this.fImportOnDemandThreshold, onDemandConflicts);
                        if (doStarImport && pack.find("*") == null) {
                            String starImportString = String.valueOf(pack.getName()) + ".*";
                            String str = this.getNewImportString(starImportString, isStatic, lineDelim);
                            stringsToInsert.add(str);
                        }
                        int k = 0;
                        while (k < nImports) {
                            ImportDeclEntry currDecl = pack.getImportAt(k);
                            IRegion region = currDecl.getSourceRange();
                            if (region == null) {
                                if (!doStarImport || currDecl.isOnDemand() || onDemandConflicts != null && onDemandConflicts.contains(currDecl.getSimpleName())) {
                                    String str = this.getNewImportString(currDecl.getElementName(), isStatic, lineDelim);
                                    stringsToInsert.add(str);
                                }
                            } else if (!doStarImport || currDecl.isOnDemand() || onDemandConflicts == null || onDemandConflicts.contains(currDecl.getSimpleName())) {
                                int offset = region.getOffset();
                                this.removeAndInsertNew(document, currPos, offset, stringsToInsert, resEdit);
                                stringsToInsert.clear();
                                currPos = offset + region.getLength();
                            }
                            ++k;
                        }
                    }
                    ++i;
                }
                int end = importsStart + importsLen;
                this.removeAndInsertNew(document, currPos, end, stringsToInsert, resEdit);
                if (importsLen != 0) break block20;
                if (!this.fImportsCreated.isEmpty() || !this.fStaticImportsCreated.isEmpty()) {
                    IType[] types;
                    if (this.fCompilationUnit.getPackageDeclarations().length == 0) {
                        resEdit.removeChild(0);
                    }
                    if ((types = this.fCompilationUnit.getTypes()).length > 0 && types[0].getSourceRange().getOffset() == importsStart) {
                        resEdit.addChild((TextEdit)new InsertEdit(currPos, lineDelim));
                    }
                    break block20;
                }
                multiTextEdit = new MultiTextEdit();
                Object var22_28 = null;
            }
            catch (Throwable throwable) {
                Object var22_30 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return multiTextEdit;
        }
        MultiTextEdit multiTextEdit = resEdit;
        Object var22_29 = null;
        monitor.done();
        return multiTextEdit;
    }

    private void removeAndInsertNew(IDocument doc, int contentOffset, int contentEnd, ArrayList stringsToInsert, MultiTextEdit resEdit) throws BadLocationException {
        int pos = contentOffset;
        int i = 0;
        while (i < stringsToInsert.size()) {
            String curr = (String)stringsToInsert.get(i);
            int idx = this.findInDocument(doc, curr, pos, contentEnd);
            if (idx != -1) {
                if (idx != pos) {
                    resEdit.addChild((TextEdit)new DeleteEdit(pos, idx - pos));
                }
                pos = idx + curr.length();
            } else {
                resEdit.addChild((TextEdit)new InsertEdit(pos, curr));
            }
            ++i;
        }
        if (pos < contentEnd) {
            resEdit.addChild((TextEdit)new DeleteEdit(pos, contentEnd - pos));
        }
    }

    private int findInDocument(IDocument doc, String str, int start, int end) throws BadLocationException {
        int pos = start;
        int len = str.length();
        if (pos + len > end || str.length() == 0) {
            return -1;
        }
        char first = str.charAt(0);
        int step = str.indexOf(first, 1);
        if (step == -1) {
            step = len;
        }
        while (pos + len <= end) {
            if (doc.getChar(pos) == first) {
                int k = 1;
                while (k < len && doc.getChar(pos + k) == str.charAt(k)) {
                    ++k;
                }
                if (k == len) {
                    return pos;
                }
                if (k < step) {
                    pos += k;
                    continue;
                }
                pos += step;
                continue;
            }
            ++pos;
        }
        return -1;
    }

    private boolean useSpaceBetweenGroups() {
        try {
            String sample = "import a.A;\n\n import b.B;\nclass C {}";
            TextEdit res = ToolFactory.createCodeFormatter((Map)this.fCompilationUnit.getJavaProject().getOptions(true)).format(8, sample, 0, sample.length(), 0, String.valueOf('\n'));
            Document doc = new Document(sample);
            res.apply((IDocument)doc);
            int idx1 = doc.search(0, "import", true, true, false);
            int line1 = doc.getLineOfOffset(idx1);
            int idx2 = doc.search(idx1 + 1, "import", true, true, false);
            int line2 = doc.getLineOfOffset(idx2);
            return line2 - line1 > 1;
        }
        catch (BadLocationException badLocationException) {
            return true;
        }
    }

    private Set evaluateStarImportConflicts(IProgressMonitor monitor) throws JavaModelException {
        final HashSet onDemandConflicts = new HashSet();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.fCompilationUnit.getJavaProject()});
        ArrayList<char[]> starImportPackages = new ArrayList<char[]>();
        ArrayList<char[]> simpleTypeNames = new ArrayList<char[]>();
        int nPackageEntries = this.fPackageEntries.size();
        int i = 0;
        while (i < nPackageEntries) {
            PackageEntry pack = (PackageEntry)this.fPackageEntries.get(i);
            if (!pack.isStatic() && pack.hasStarImport(this.fImportOnDemandThreshold, null)) {
                starImportPackages.add(pack.getName().toCharArray());
                int k = 0;
                while (k < pack.getNumberOfImports()) {
                    ImportDeclEntry curr = pack.getImportAt(k);
                    if (!curr.isOnDemand() && !curr.isComment()) {
                        simpleTypeNames.add(curr.getSimpleName().toCharArray());
                    }
                    ++k;
                }
            }
            ++i;
        }
        if (starImportPackages.isEmpty()) {
            return null;
        }
        starImportPackages.add(this.fCompilationUnit.getParent().getElementName().toCharArray());
        starImportPackages.add(JAVA_LANG.toCharArray());
        char[][] allPackages = (char[][])starImportPackages.toArray((T[])new char[starImportPackages.size()][]);
        char[][] allTypes = (char[][])simpleTypeNames.toArray((T[])new char[simpleTypeNames.size()][]);
        TypeNameRequestor requestor = new TypeNameRequestor(){
            HashMap foundTypes = new HashMap();

            private String getTypeContainerName(char[] packageName, char[][] enclosingTypeNames) {
                StringBuffer buf = new StringBuffer();
                buf.append(packageName);
                int i = 0;
                while (i < enclosingTypeNames.length) {
                    if (buf.length() > 0) {
                        buf.append('.');
                    }
                    buf.append(enclosingTypeNames[i]);
                    ++i;
                }
                return buf.toString();
            }

            public void acceptType(int flags, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                String name = new String(simpleTypeName);
                String containerName = this.getTypeContainerName(packageName, enclosingTypeNames);
                String oldContainer = this.foundTypes.put(name, containerName);
                if (oldContainer != null && !oldContainer.equals(containerName)) {
                    onDemandConflicts.add(name);
                }
            }
        };
        new SearchEngine().searchAllTypeNames(allPackages, allTypes, scope, requestor, 3, monitor);
        return onDemandConflicts;
    }

    private String getNewImportString(String importName, boolean isStatic, String lineDelim) {
        StringBuffer buf = new StringBuffer();
        buf.append("import ");
        if (isStatic) {
            buf.append("static ");
        }
        buf.append(importName);
        buf.append(';');
        buf.append(lineDelim);
        if (isStatic) {
            this.fStaticImportsCreated.add(importName);
        } else {
            this.fImportsCreated.add(importName);
        }
        return buf.toString();
    }

    private int getPackageStatementEndPos(IDocument document) throws JavaModelException, BadLocationException {
        ISourceRange range;
        int line;
        IRegion region;
        IPackageDeclaration[] packDecls = this.fCompilationUnit.getPackageDeclarations();
        if (packDecls != null && packDecls.length > 0 && (region = document.getLineInformation((line = document.getLineOfOffset((range = packDecls[0].getSourceRange()).getOffset() + range.getLength())) + 1)) != null) {
            IType[] types = this.fCompilationUnit.getTypes();
            if (types.length > 0) {
                return Math.min(types[0].getSourceRange().getOffset(), region.getOffset());
            }
            return region.getOffset();
        }
        return 0;
    }

    public String toString() {
        int nPackages = this.fPackageEntries.size();
        StringBuffer buf = new StringBuffer("\n-----------------------\n");
        int i = 0;
        while (i < nPackages) {
            PackageEntry entry = (PackageEntry)this.fPackageEntries.get(i);
            if (entry.isStatic()) {
                buf.append("static ");
            }
            buf.append(entry.toString());
            ++i;
        }
        return buf.toString();
    }

    public String[] getCreatedImports() {
        if (this.fImportsCreated == null) {
            return new String[0];
        }
        return this.fImportsCreated.toArray(new String[this.fImportsCreated.size()]);
    }

    public String[] getCreatedStaticImports() {
        if (this.fStaticImportsCreated == null) {
            return new String[0];
        }
        return this.fStaticImportsCreated.toArray(new String[this.fStaticImportsCreated.size()]);
    }

    public boolean hasChanges() {
        return this.fHasChanges;
    }

    private static class PackageMatcher {
        private String fNewName;
        private String fBestName;
        private int fBestMatchLen;

        public void initialize(String newName, String bestName) {
            this.fNewName = newName;
            this.fBestName = bestName;
            this.fBestMatchLen = ImportsStructure.getCommonPrefixLength(bestName, this.fNewName);
        }

        public boolean isBetterMatch(String currName, boolean preferCurr) {
            boolean isBetter;
            int currMatchLen = ImportsStructure.getCommonPrefixLength(currName, this.fNewName);
            int matchDiff = currMatchLen - this.fBestMatchLen;
            if (matchDiff == 0) {
                isBetter = currMatchLen == this.fNewName.length() && currMatchLen == currName.length() && currMatchLen == this.fBestName.length() ? preferCurr : this.sameMatchLenTest(currName);
            } else {
                boolean bl = isBetter = matchDiff > 0;
            }
            if (isBetter) {
                this.fBestName = currName;
                this.fBestMatchLen = currMatchLen;
            }
            return isBetter;
        }

        private boolean sameMatchLenTest(String currName) {
            int matchLen = this.fBestMatchLen;
            char newChar = ImportsStructure.getCharAt(this.fNewName, matchLen);
            char currChar = ImportsStructure.getCharAt(currName, matchLen);
            char bestChar = ImportsStructure.getCharAt(this.fBestName, matchLen);
            if (newChar < currChar) {
                if (bestChar < newChar) {
                    return currChar - newChar < newChar - bestChar;
                }
                if (currChar == bestChar) {
                    return false;
                }
                return currChar < bestChar;
            }
            if (bestChar > newChar) {
                return newChar - currChar < bestChar - newChar;
            }
            if (currChar == bestChar) {
                return true;
            }
            return currChar > bestChar;
        }
    }

    private static final class ImportDeclEntry {
        private String fElementName;
        private IRegion fSourceRange;
        private final boolean fIsStatic;

        public ImportDeclEntry(String elementName, boolean isStatic, IRegion sourceRange) {
            this.fElementName = elementName;
            this.fSourceRange = sourceRange;
            this.fIsStatic = isStatic;
        }

        public String getElementName() {
            return this.fElementName;
        }

        public int compareTo(String fullName, boolean isStatic) {
            int cmp = this.fElementName.compareTo(fullName);
            if (cmp == 0) {
                if (this.fIsStatic == isStatic) {
                    return 0;
                }
                return this.fIsStatic ? -1 : 1;
            }
            return cmp;
        }

        public String getSimpleName() {
            return Signature.getSimpleName((String)this.fElementName);
        }

        public boolean isOnDemand() {
            return this.fElementName != null && this.fElementName.endsWith(".*");
        }

        public boolean isStatic() {
            return this.fIsStatic;
        }

        public boolean isNew() {
            return this.fSourceRange == null;
        }

        public boolean isComment() {
            return this.fElementName == null;
        }

        public IRegion getSourceRange() {
            return this.fSourceRange;
        }
    }

    private static final class PackageEntry {
        private String fName;
        private ArrayList fImportEntries;
        private String fGroup;
        private boolean fIsStatic;

        public static PackageEntry createOnPlaceholderEntry(String preferenceOrder) {
            if (preferenceOrder.length() > 0 && preferenceOrder.charAt(0) == '#') {
                String curr = preferenceOrder.substring(1);
                return new PackageEntry(curr, curr, true);
            }
            return new PackageEntry(preferenceOrder, preferenceOrder, false);
        }

        public PackageEntry() {
            this("!", null, false);
        }

        public PackageEntry(String name, String group, boolean isStatic) {
            this.fName = name;
            this.fImportEntries = new ArrayList(5);
            this.fGroup = group;
            this.fIsStatic = isStatic;
        }

        public boolean isStatic() {
            return this.fIsStatic;
        }

        public int compareTo(String name, boolean isStatic) {
            int cmp = this.fName.compareTo(name);
            if (cmp == 0) {
                if (this.fIsStatic == isStatic) {
                    return 0;
                }
                return this.fIsStatic ? -1 : 1;
            }
            return cmp;
        }

        public void sortIn(ImportDeclEntry imp) {
            String fullImportName = imp.getElementName();
            int insertPosition = -1;
            int nInports = this.fImportEntries.size();
            int i = 0;
            while (i < nInports) {
                ImportDeclEntry curr = this.getImportAt(i);
                if (!curr.isComment()) {
                    int cmp = curr.compareTo(fullImportName, imp.isStatic());
                    if (cmp == 0) {
                        return;
                    }
                    if (cmp > 0 && insertPosition == -1) {
                        insertPosition = i;
                    }
                }
                ++i;
            }
            if (insertPosition == -1) {
                this.fImportEntries.add(imp);
            } else {
                this.fImportEntries.add(insertPosition, imp);
            }
        }

        public void add(ImportDeclEntry imp) {
            this.fImportEntries.add(imp);
        }

        public ImportDeclEntry find(String simpleName) {
            int nInports = this.fImportEntries.size();
            int i = 0;
            while (i < nInports) {
                int dotPos;
                String name;
                ImportDeclEntry curr = this.getImportAt(i);
                if (!curr.isComment() && (name = curr.getElementName()).endsWith(simpleName) && ((dotPos = name.length() - simpleName.length() - 1) == -1 || dotPos > 0 && name.charAt(dotPos) == '.')) {
                    return curr;
                }
                ++i;
            }
            return null;
        }

        public boolean remove(String fullName, boolean isStaticImport) {
            int nInports = this.fImportEntries.size();
            int i = 0;
            while (i < nInports) {
                ImportDeclEntry curr = this.getImportAt(i);
                if (!curr.isComment() && curr.compareTo(fullName, isStaticImport) == 0) {
                    this.fImportEntries.remove(i);
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void removeAllNew(Set onDemandConflicts) {
            int nInports = this.fImportEntries.size();
            int i = nInports - 1;
            while (i >= 0) {
                ImportDeclEntry curr = this.getImportAt(i);
                if (curr.isNew()) {
                    this.fImportEntries.remove(i);
                }
                --i;
            }
        }

        public ImportDeclEntry getImportAt(int index) {
            return (ImportDeclEntry)this.fImportEntries.get(index);
        }

        public boolean hasStarImport(int threshold, Set explicitImports) {
            if (this.isComment() || this.isDefaultPackage()) {
                return false;
            }
            int nImports = this.getNumberOfImports();
            int count = 0;
            boolean containsNew = false;
            int i = 0;
            while (i < nImports) {
                ImportDeclEntry curr = this.getImportAt(i);
                if (curr.isOnDemand()) {
                    return true;
                }
                if (!curr.isComment()) {
                    ++count;
                    boolean isExplicit = !curr.isStatic() && explicitImports != null && explicitImports.contains(curr.getSimpleName());
                    containsNew |= curr.isNew() && !isExplicit;
                }
                ++i;
            }
            return count >= threshold && containsNew;
        }

        public int getNumberOfImports() {
            return this.fImportEntries.size();
        }

        public String getName() {
            return this.fName;
        }

        public String getGroupID() {
            return this.fGroup;
        }

        public void setGroupID(String groupID) {
            this.fGroup = groupID;
        }

        public boolean isSameGroup(PackageEntry other) {
            if (this.fGroup == null) {
                return other.getGroupID() == null;
            }
            return this.fGroup.equals(other.getGroupID()) && this.fIsStatic == other.isStatic();
        }

        public ImportDeclEntry getLast() {
            int nImports = this.getNumberOfImports();
            if (nImports > 0) {
                return this.getImportAt(nImports - 1);
            }
            return null;
        }

        public boolean isComment() {
            return "!".equals(this.fName);
        }

        public boolean isDefaultPackage() {
            return this.fName.length() == 0;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this.isComment()) {
                buf.append("comment\n");
            } else {
                buf.append(this.fName);
                buf.append(", groupId: ");
                buf.append(this.fGroup);
                buf.append("\n");
                int nImports = this.getNumberOfImports();
                int i = 0;
                while (i < nImports) {
                    ImportDeclEntry curr = this.getImportAt(i);
                    buf.append("  ");
                    if (curr.isStatic()) {
                        buf.append("static ");
                    }
                    buf.append(curr.getSimpleName());
                    if (curr.isNew()) {
                        buf.append(" (new)");
                    }
                    buf.append("\n");
                    ++i;
                }
            }
            return buf.toString();
        }
    }
}

