/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;

public final class JavaModelUtil {
    private static boolean PRIMARY_ONLY = false;

    public static IType findType(IJavaProject jproject, String fullyQualifiedName) throws JavaModelException {
        IType type = jproject.findType(fullyQualifiedName);
        if (type != null) {
            return type;
        }
        IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            type = JavaModelUtil.findType(root, fullyQualifiedName);
            if (type != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public static IType findType(IJavaProject jproject, String fullyQualifiedName, WorkingCopyOwner owner) throws JavaModelException {
        IType type = jproject.findType(fullyQualifiedName, owner);
        if (type != null) {
            return type;
        }
        IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            type = JavaModelUtil.findType(root, fullyQualifiedName);
            if (type != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public static boolean isReferenced(IPackageFragmentRoot root) {
        IResource resource = root.getResource();
        if (resource != null) {
            IProject jarProject = resource.getProject();
            IProject container = root.getJavaProject().getProject();
            return !container.equals((Object)jarProject);
        }
        return false;
    }

    private static IType findType(IPackageFragmentRoot root, String fullyQualifiedName) throws JavaModelException {
        IJavaElement[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            IType type;
            IPackageFragment pack;
            IJavaElement element = children[i];
            if (element.getElementType() == 4 && fullyQualifiedName.startsWith((pack = (IPackageFragment)element).getElementName()) && (type = JavaModelUtil.findType(pack, fullyQualifiedName)) != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private static IType findType(IPackageFragment pack, String fullyQualifiedName) throws JavaModelException {
        ICompilationUnit[] cus = pack.getCompilationUnits();
        int i = 0;
        while (i < cus.length) {
            ICompilationUnit unit = cus[i];
            IType type = JavaModelUtil.findType(unit, fullyQualifiedName);
            if (type != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private static IType findType(ICompilationUnit cu, String fullyQualifiedName) throws JavaModelException {
        IType[] types = cu.getAllTypes();
        int i = 0;
        while (i < types.length) {
            IType type = types[i];
            if (JavaModelUtil.getFullyQualifiedName(type).equals(fullyQualifiedName)) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public static IType findType(IJavaProject jproject, String pack, String typeQualifiedName) throws JavaModelException {
        return jproject.findType(pack, typeQualifiedName);
    }

    public static IJavaElement findTypeContainer(IJavaProject jproject, String typeContainerName) throws JavaModelException {
        Path path;
        IType result = jproject.findType(typeContainerName);
        if (result == null && !((result = jproject.findElement((IPath)(path = new Path(typeContainerName.replace('.', '/'))))) instanceof IPackageFragment)) {
            result = null;
        }
        return result;
    }

    public static IType findTypeInCompilationUnit(ICompilationUnit cu, String typeQualifiedName) throws JavaModelException {
        IType[] types = cu.getAllTypes();
        int i = 0;
        while (i < types.length) {
            String currName = JavaModelUtil.getTypeQualifiedName(types[i]);
            if (typeQualifiedName.equals(currName)) {
                return types[i];
            }
            ++i;
        }
        return null;
    }

    public static IMember findMemberInCompilationUnit(ICompilationUnit cu, IMember member) {
        IJavaElement[] elements = cu.findElements((IJavaElement)member);
        if (elements != null && elements.length > 0) {
            return (IMember)elements[0];
        }
        return null;
    }

    public static IJavaElement findInCompilationUnit(ICompilationUnit cu, IJavaElement element) {
        IJavaElement[] elements = cu.findElements(element);
        if (elements != null && elements.length > 0) {
            return elements[0];
        }
        return null;
    }

    public static String getTypeQualifiedName(IType type) {
        return type.getTypeQualifiedName('.');
    }

    public static String getFullyQualifiedName(IType type) {
        return type.getFullyQualifiedName('.');
    }

    public static String getTypeContainerName(IType type) {
        IType outerType = type.getDeclaringType();
        if (outerType != null) {
            return outerType.getFullyQualifiedName('.');
        }
        return type.getPackageFragment().getElementName();
    }

    public static String concatenateName(String name1, String name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length() > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static String concatenateName(char[] name1, char[] name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static boolean isVisible(IMember member, IPackageFragment pack) throws JavaModelException {
        int type = member.getElementType();
        if (type == 10 || type == 9 && member.getElementName().startsWith("<")) {
            return false;
        }
        int otherflags = member.getFlags();
        IType declaringType = member.getDeclaringType();
        if (Flags.isPublic((int)otherflags) || declaringType != null && JavaModelUtil.isInterfaceOrAnnotation(declaringType)) {
            return true;
        }
        if (Flags.isPrivate((int)otherflags)) {
            return false;
        }
        IPackageFragment otherpack = (IPackageFragment)JavaModelUtil.findParentOfKind((IJavaElement)member, 4);
        return pack != null && otherpack != null && JavaModelUtil.isSamePackage(pack, otherpack);
    }

    public static boolean isVisibleInHierarchy(IMember member, IPackageFragment pack) throws JavaModelException {
        int type = member.getElementType();
        if (type == 10 || type == 9 && member.getElementName().startsWith("<")) {
            return false;
        }
        int otherflags = member.getFlags();
        IType declaringType = member.getDeclaringType();
        if (Flags.isPublic((int)otherflags) || Flags.isProtected((int)otherflags) || declaringType != null && JavaModelUtil.isInterfaceOrAnnotation(declaringType)) {
            return true;
        }
        if (Flags.isPrivate((int)otherflags)) {
            return false;
        }
        IPackageFragment otherpack = (IPackageFragment)JavaModelUtil.findParentOfKind((IJavaElement)member, 4);
        return pack != null && pack.equals(otherpack);
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        return (IPackageFragmentRoot)element.getAncestor(3);
    }

    public static IJavaElement findParentOfKind(IJavaElement element, int kind) {
        if (element != null && element.getParent() != null) {
            return element.getParent().getAncestor(kind);
        }
        return null;
    }

    public static IMethod findMethod(String name, String[] paramTypes, boolean isConstructor, IType type) throws JavaModelException {
        return JavaModelUtil.findMethod(name, paramTypes, isConstructor, type.getMethods());
    }

    public static IMethod findMethod(String name, String[] paramTypes, boolean isConstructor, IMethod[] methods) throws JavaModelException {
        int i = methods.length - 1;
        while (i >= 0) {
            if (JavaModelUtil.isSameMethodSignature(name, paramTypes, isConstructor, methods[i])) {
                return methods[i];
            }
            --i;
        }
        return null;
    }

    public static IMethod findMethod2(IMethod curr, IMethod[] methods) throws JavaModelException {
        int i = methods.length - 1;
        while (i >= 0) {
            if (JavaModelUtil.isSameMethodSignature2(curr, methods[i])) {
                return methods[i];
            }
            --i;
        }
        return null;
    }

    public static IMethod findMethodDeclarationInHierarchy(ITypeHierarchy hierarchy, IType type, String name, String[] paramTypes, boolean isConstructor) throws JavaModelException {
        IType[] superTypes = hierarchy.getAllSupertypes(type);
        int i = superTypes.length - 1;
        while (i >= 0) {
            IMethod first = JavaModelUtil.findMethod(name, paramTypes, isConstructor, superTypes[i]);
            if (first != null && !Flags.isPrivate((int)first.getFlags())) {
                IMethod res = JavaModelUtil.findMethodDeclarationInHierarchy(hierarchy, first.getDeclaringType(), name, paramTypes, isConstructor);
                if (res != null) {
                    return res;
                }
                return first;
            }
            --i;
        }
        return null;
    }

    public static IMethod findMethodDeclarationInHierarchy2(ITypeHierarchy hierarchy, IType type, IMethod method) throws JavaModelException {
        IType[] superTypes = hierarchy.getAllSupertypes(type);
        int i = superTypes.length - 1;
        while (i >= 0) {
            IMethod first = JavaModelUtil.findMethod2(method, superTypes[i].getMethods());
            if (first != null && !Flags.isPrivate((int)first.getFlags())) {
                IMethod res = JavaModelUtil.findMethodDeclarationInHierarchy2(hierarchy, first.getDeclaringType(), method);
                if (res != null) {
                    return res;
                }
                return first;
            }
            --i;
        }
        return null;
    }

    public static IMethod findMethodImplementationInHierarchy(ITypeHierarchy hierarchy, IType type, String name, String[] paramTypes, boolean isConstructor) throws JavaModelException {
        IType[] superTypes = hierarchy.getAllSuperclasses(type);
        int i = 0;
        while (i < superTypes.length) {
            IMethod found = JavaModelUtil.findMethod(name, paramTypes, isConstructor, superTypes[i]);
            if (found != null) {
                if (Flags.isAbstract((int)found.getFlags())) {
                    return null;
                }
                return found;
            }
            ++i;
        }
        return null;
    }

    public static IMethod findMethodImplementationInHierarchy2(ITypeHierarchy hierarchy, IType type, IMethod method) throws JavaModelException {
        IType[] superTypes = hierarchy.getAllSuperclasses(type);
        int i = 0;
        while (i < superTypes.length) {
            IMethod found = JavaModelUtil.findMethod2(method, superTypes[i].getMethods());
            if (found != null) {
                if (Flags.isAbstract((int)found.getFlags())) {
                    return null;
                }
                return found;
            }
            ++i;
        }
        return null;
    }

    private static IMethod findMethodInHierarchy(ITypeHierarchy hierarchy, IType type, String name, String[] paramTypes, boolean isConstructor) throws JavaModelException {
        IMethod res;
        IMethod method = JavaModelUtil.findMethod(name, paramTypes, isConstructor, type);
        if (method != null) {
            return method;
        }
        IType superClass = hierarchy.getSuperclass(type);
        if (superClass != null && (res = JavaModelUtil.findMethodInHierarchy(hierarchy, superClass, name, paramTypes, isConstructor)) != null) {
            return res;
        }
        if (!isConstructor) {
            IType[] superInterfaces = hierarchy.getSuperInterfaces(type);
            int i = 0;
            while (i < superInterfaces.length) {
                IMethod res2 = JavaModelUtil.findMethodInHierarchy(hierarchy, superInterfaces[i], name, paramTypes, false);
                if (res2 != null) {
                    return res2;
                }
                ++i;
            }
        }
        return method;
    }

    private static IMethod findMethodInHierarchy2(ITypeHierarchy hierarchy, IType type, IMethod curr) throws JavaModelException {
        IMethod res;
        IMethod method = JavaModelUtil.findMethod2(curr, type.getMethods());
        if (method != null) {
            return method;
        }
        IType superClass = hierarchy.getSuperclass(type);
        if (superClass != null && (res = JavaModelUtil.findMethodInHierarchy2(hierarchy, superClass, curr)) != null) {
            return res;
        }
        if (!curr.isConstructor()) {
            IType[] superInterfaces = hierarchy.getSuperInterfaces(type);
            int i = 0;
            while (i < superInterfaces.length) {
                IMethod res2 = JavaModelUtil.findMethodInHierarchy2(hierarchy, superInterfaces[i], curr);
                if (res2 != null) {
                    return res2;
                }
                ++i;
            }
        }
        return method;
    }

    public static IMethod findMethodDefininition(ITypeHierarchy typeHierarchy, IType type, String methodName, String[] paramTypes, boolean isConstructor, boolean testVisibility) throws JavaModelException {
        IMethod res;
        IType superClass = typeHierarchy.getSuperclass(type);
        if (!(superClass == null || (res = JavaModelUtil.findMethodInHierarchy(typeHierarchy, superClass, methodName, paramTypes, isConstructor)) == null || Flags.isPrivate((int)res.getFlags()) || testVisibility && !JavaModelUtil.isVisibleInHierarchy((IMember)res, type.getPackageFragment()))) {
            return res;
        }
        if (!isConstructor) {
            IType[] interfaces = typeHierarchy.getSuperInterfaces(type);
            int i = 0;
            while (i < interfaces.length) {
                IMethod res2 = JavaModelUtil.findMethodInHierarchy(typeHierarchy, interfaces[i], methodName, paramTypes, false);
                if (res2 != null) {
                    return res2;
                }
                ++i;
            }
        }
        return null;
    }

    public static IMethod findMethodDefininition2(ITypeHierarchy typeHierarchy, IType type, IMethod method, boolean testVisibility) throws JavaModelException {
        IMethod res;
        IType superClass = typeHierarchy.getSuperclass(type);
        if (!(superClass == null || (res = JavaModelUtil.findMethodInHierarchy2(typeHierarchy, superClass, method)) == null || Flags.isPrivate((int)res.getFlags()) || testVisibility && !JavaModelUtil.isVisibleInHierarchy((IMember)res, type.getPackageFragment()))) {
            return res;
        }
        if (!method.isConstructor()) {
            IType[] interfaces = typeHierarchy.getSuperInterfaces(type);
            int i = 0;
            while (i < interfaces.length) {
                IMethod res2 = JavaModelUtil.findMethodInHierarchy2(typeHierarchy, interfaces[i], method);
                if (res2 != null) {
                    return res2;
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean isSameMethodSignature(String name, String[] paramTypes, boolean isConstructor, IMethod curr) throws JavaModelException {
        String[] currParamTypes;
        if ((isConstructor || name.equals(curr.getElementName())) && isConstructor == curr.isConstructor() && paramTypes.length == (currParamTypes = curr.getParameterTypes()).length) {
            int i = 0;
            while (i < paramTypes.length) {
                String t2;
                String t1 = Signature.getSimpleName((String)Signature.toString((String)paramTypes[i]));
                if (!t1.equals(t2 = Signature.getSimpleName((String)Signature.toString((String)currParamTypes[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean isSameMethodSignature2(IMethod method, IMethod other) throws JavaModelException {
        boolean isConstructor = method.isConstructor();
        if (isConstructor != other.isConstructor()) {
            return false;
        }
        if (!isConstructor && !method.getElementName().equals(other.getElementName())) {
            return false;
        }
        int nParameters = method.getNumberOfParameters();
        if (nParameters != other.getNumberOfParameters()) {
            return false;
        }
        if (nParameters > 0) {
            String[] currParamTypes = JavaModelUtil.getParameterTypes(method);
            String[] otherParamTypes = JavaModelUtil.getParameterTypes(other);
            int i = 0;
            if (i < currParamTypes.length) {
                String p1 = currParamTypes[i];
                String p2 = otherParamTypes[i];
                if (p1 == null) {
                    return p2 == null || PrimitiveType.toCode((String)p2) == null;
                }
                if (p2 == null) {
                    return p1 == null || PrimitiveType.toCode((String)p1) == null;
                }
                return p1.equals(p2);
            }
        }
        return true;
    }

    private static String[] getParameterTypes(IMethod curr) throws JavaModelException {
        String[] paramTypeSigs = curr.getParameterTypes();
        String[] paramTypes = new String[paramTypeSigs.length];
        if (JavaModelUtil.is50OrHigher(curr.getJavaProject())) {
            Set variables = JavaModelUtil.getVariables(curr);
            int i = 0;
            while (i < paramTypeSigs.length) {
                paramTypes[i] = JavaModelUtil.getErasure(paramTypeSigs[i], variables);
                ++i;
            }
        } else {
            int i = 0;
            while (i < paramTypeSigs.length) {
                paramTypes[i] = Signature.getSimpleName((String)Signature.toString((String)paramTypeSigs[i]));
                ++i;
            }
        }
        return paramTypes;
    }

    private static Set getVariables(IMethod curr) throws JavaModelException {
        HashSet<String> res = new HashSet<String>();
        ITypeParameter[] typeParameters = curr.getTypeParameters();
        int i = 0;
        while (i < typeParameters.length) {
            res.add(typeParameters[i].getElementName());
            ++i;
        }
        typeParameters = curr.getDeclaringType().getTypeParameters();
        i = 0;
        while (i < typeParameters.length) {
            res.add(typeParameters[i].getElementName());
            ++i;
        }
        return res;
    }

    private static String getErasure(String str, Set variables) {
        switch (Signature.getTypeSignatureKind((String)str)) {
            case 3: {
                return null;
            }
            case 1: {
                String s = Signature.toString((String)str);
                if (variables.contains(s)) {
                    return null;
                }
                return Signature.getSimpleName((String)Signature.getTypeErasure((String)s));
            }
            case 4: {
                int dim = Signature.getArrayCount((String)str);
                String erasure = JavaModelUtil.getErasure(Signature.getElementType((String)str), variables);
                if (erasure == null) {
                    return null;
                }
                StringBuffer buf = new StringBuffer(erasure);
                int i = 0;
                while (i < dim) {
                    buf.append('[').append(']');
                    ++i;
                }
                return buf.toString();
            }
        }
        return Signature.toString((String)str);
    }

    public static boolean isSamePackage(IPackageFragment pack1, IPackageFragment pack2) {
        return pack1.getElementName().equals(pack2.getElementName());
    }

    public static boolean hasMainMethod(IType type) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].isMainMethod()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isBoolean(IField field) throws JavaModelException {
        return field.getTypeSignature().equals("Z");
    }

    public static boolean isInterfaceOrAnnotation(IType type) throws JavaModelException {
        return type.isInterface();
    }

    public static boolean isOnBuildPath(IJavaProject jproject, IJavaElement element) {
        return jproject.isOnClasspath(element);
    }

    public static boolean isOnClasspath(IJavaElement element) {
        IJavaProject project = element.getJavaProject();
        if (!project.exists()) {
            return false;
        }
        return project.isOnClasspath(element);
    }

    public static String getResolvedTypeName(String refTypeSig, IType declaringType) throws JavaModelException {
        int arrayCount = Signature.getArrayCount((String)refTypeSig);
        char type = refTypeSig.charAt(arrayCount);
        if (type == 'Q') {
            String name = "";
            int bracket = refTypeSig.indexOf(60, arrayCount + 1);
            if (bracket > 0) {
                name = refTypeSig.substring(arrayCount + 1, bracket);
            } else {
                int semi = refTypeSig.indexOf(59, arrayCount + 1);
                if (semi == -1) {
                    throw new IllegalArgumentException();
                }
                name = refTypeSig.substring(arrayCount + 1, semi);
            }
            String[][] resolvedNames = declaringType.resolveType(name);
            if (resolvedNames != null && resolvedNames.length > 0) {
                return JavaModelUtil.concatenateName(resolvedNames[0][0], resolvedNames[0][1]);
            }
            return null;
        }
        return Signature.toString((String)refTypeSig.substring(arrayCount));
    }

    public static boolean isEditable(ICompilationUnit cu) {
        IResource resource = JavaModelUtil.toOriginal(cu).getResource();
        return resource.exists() && !resource.getResourceAttributes().isReadOnly();
    }

    public static IMember toOriginal(IMember member) {
        if (PRIMARY_ONLY) {
            JavaModelUtil.testCompilationUnitOwner("toOriginal", member.getCompilationUnit());
        }
        if (member instanceof IMethod) {
            return JavaModelUtil.toOriginalMethod((IMethod)member);
        }
        return (IMember)member.getPrimaryElement();
    }

    private static IMethod toOriginalMethod(IMethod method) {
        ICompilationUnit cu = method.getCompilationUnit();
        if (cu == null || JavaModelUtil.isPrimary(cu)) {
            return method;
        }
        try {
            if (!method.getElementName().equals(method.getDeclaringType().getElementName())) {
                return (IMethod)method.getPrimaryElement();
            }
            IType originalType = (IType)JavaModelUtil.toOriginal((IMember)method.getDeclaringType());
            IMethod[] methods = originalType.findMethods(method);
            boolean isConstructor = method.isConstructor();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].isConstructor() == isConstructor) {
                    return methods[i];
                }
                ++i;
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static ICompilationUnit toOriginal(ICompilationUnit cu) {
        if (PRIMARY_ONLY) {
            JavaModelUtil.testCompilationUnitOwner("toOriginal", cu);
        }
        if (cu == null) {
            return cu;
        }
        return cu.getPrimary();
    }

    public static IJavaElement toOriginal(IJavaElement element) {
        return element.getPrimaryElement();
    }

    private static void testCompilationUnitOwner(String methodName, ICompilationUnit cu) {
        if (cu == null) {
            return;
        }
        if (!JavaModelUtil.isPrimary(cu)) {
            JavaPlugin.logErrorMessage(String.valueOf(methodName) + ": operating with non-primary cu");
        }
    }

    public static IMember toWorkingCopy(IMember member) {
        return member;
    }

    public static IPackageDeclaration toWorkingCopy(IPackageDeclaration declaration) {
        return declaration;
    }

    public static IJavaElement toWorkingCopy(IJavaElement elem) {
        return elem;
    }

    public static IImportContainer toWorkingCopy(IImportContainer container) {
        return container;
    }

    public static IImportDeclaration toWorkingCopy(IImportDeclaration importDeclaration) {
        return importDeclaration;
    }

    public static ICompilationUnit toWorkingCopy(ICompilationUnit cu) {
        return cu;
    }

    public static boolean isPrimary(ICompilationUnit cu) {
        return cu.getOwner() == null;
    }

    public static boolean isExceptionToBeLogged(CoreException exception) {
        if (!(exception instanceof JavaModelException)) {
            return true;
        }
        JavaModelException je = (JavaModelException)((Object)exception);
        if (!je.isDoesNotExist()) {
            return true;
        }
        IJavaElement[] elements = je.getJavaModelStatus().getElements();
        int i = 0;
        while (i < elements.length) {
            IJavaElement element = elements[i];
            if (element.getElementType() != 5) {
                ICompilationUnit unit = (ICompilationUnit)element.getAncestor(5);
                if (unit == null) {
                    return true;
                }
                if (!unit.isWorkingCopy()) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static IType[] getAllSuperTypes(IType type, IProgressMonitor pm) throws JavaModelException {
        HashSet<IType> types = new HashSet<IType>(Arrays.asList(type.newSupertypeHierarchy(pm).getAllSupertypes(type)));
        IType objekt = type.getJavaProject().findType("java.lang.Object");
        if (objekt != null) {
            types.add(objekt);
        }
        return types.toArray(new IType[types.size()]);
    }

    public static boolean isExcludedPath(IPath resourcePath, IPath[] exclusionPatterns) {
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            char[] pattern = exclusionPatterns[i].toString().toCharArray();
            if (CharOperation.pathMatch((char[])pattern, (char[])path, (boolean)true, (char)'/')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isExcluded(IPath resourcePath, char[][] exclusionPatterns) {
        if (exclusionPatterns == null) {
            return false;
        }
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            if (CharOperation.pathMatch((char[])exclusionPatterns[i], (char[])path, (boolean)true, (char)'/')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reconcile(ICompilationUnit unit) throws JavaModelException {
        ICompilationUnit iCompilationUnit = unit;
        synchronized (iCompilationUnit) {
            unit.reconcile(0, false, null, null);
        }
    }

    public static IClasspathEntry getClasspathEntryToEdit(IJavaProject jproject, IPath containerPath, IPath libPath) throws JavaModelException {
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)jproject);
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0));
        if (container != null && initializer != null && initializer.canUpdateClasspathContainer(containerPath, jproject)) {
            IClasspathEntry[] entries = container.getClasspathEntries();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry curr = entries[i];
                IClasspathEntry resolved = JavaCore.getResolvedClasspathEntry((IClasspathEntry)curr);
                if (resolved != null && libPath.equals((Object)resolved.getPath())) {
                    return curr;
                }
                ++i;
            }
        }
        return null;
    }

    public static ICompilationUnit[] getAllCompilationUnits(IJavaElement[] javaElements) throws JavaModelException {
        HashSet result = new HashSet();
        int i = 0;
        while (i < javaElements.length) {
            JavaModelUtil.addAllCus(result, javaElements[i]);
            ++i;
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private static void addAllCus(HashSet collector, IJavaElement javaElement) throws JavaModelException {
        switch (javaElement.getElementType()) {
            case 2: {
                IJavaProject javaProject = (IJavaProject)javaElement;
                IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < packageFragmentRoots.length) {
                    JavaModelUtil.addAllCus(collector, (IJavaElement)packageFragmentRoots[i]);
                    ++i;
                }
                return;
            }
            case 3: {
                IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)javaElement;
                if (packageFragmentRoot.getKind() != 1) {
                    return;
                }
                IJavaElement[] packageFragments = packageFragmentRoot.getChildren();
                int j = 0;
                while (j < packageFragments.length) {
                    JavaModelUtil.addAllCus(collector, packageFragments[j]);
                    ++j;
                }
                return;
            }
            case 4: {
                IPackageFragment packageFragment = (IPackageFragment)javaElement;
                collector.addAll(Arrays.asList(packageFragment.getCompilationUnits()));
                return;
            }
            case 5: {
                collector.add(javaElement);
                return;
            }
        }
        IJavaElement cu = javaElement.getAncestor(5);
        if (cu != null) {
            collector.add(cu);
        }
    }

    public static void set50CompilanceOptions(Map map) {
        JavaModelUtil.setCompilanceOptions(map, "1.5");
    }

    public static void setCompilanceOptions(Map map, String compliance) {
        if ("1.5".equals(compliance)) {
            map.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
            map.put("org.eclipse.jdt.core.compiler.source", "1.5");
            map.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
            map.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "error");
            map.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "error");
        } else if ("1.4".equals(compliance)) {
            map.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
            map.put("org.eclipse.jdt.core.compiler.source", "1.3");
            map.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
            map.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "warning");
            map.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "warning");
        } else if ("1.3".equals(compliance)) {
            map.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
            map.put("org.eclipse.jdt.core.compiler.source", "1.3");
            map.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
            map.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "ignore");
            map.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "ignore");
        } else {
            throw new IllegalArgumentException("Unsupported compliance: " + compliance);
        }
    }

    public static boolean is50OrHigher(IJavaProject project) {
        return "1.5".equals(project.getOption("org.eclipse.jdt.core.compiler.compliance", true));
    }

    public static boolean is50OrHigherJRE(IJavaProject project) throws CoreException {
        IVMInstall vmInstall = JavaRuntime.getVMInstall((IJavaProject)project);
        if (!(vmInstall instanceof IVMInstall2)) {
            return true;
        }
        String javaVersion = ((IVMInstall2)vmInstall).getJavaVersion();
        if (javaVersion == null) {
            return true;
        }
        return javaVersion.startsWith("1.5");
    }
}

