/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.propertiesfileeditor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertyKeyHyperlink;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class PropertyKeyHyperlinkDetector
implements IHyperlinkDetector {
    private ITextEditor fTextEditor;

    public PropertyKeyHyperlinkDetector(ITextEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fTextEditor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || this.fTextEditor == null || canShowMultipleHyperlinks) {
            return null;
        }
        IEditorSite site = this.fTextEditor.getEditorSite();
        if (site == null) {
            return null;
        }
        if (!this.checkEnabled(region)) {
            return null;
        }
        int offset = region.getOffset();
        ITypedRegion partition = null;
        try {
            IStorageEditorInput storageEditorInput = (IStorageEditorInput)this.fTextEditor.getEditorInput();
            IDocument document = this.fTextEditor.getDocumentProvider().getDocument((Object)storageEditorInput);
            if (document instanceof IDocumentExtension3) {
                partition = ((IDocumentExtension3)document).getPartition("___pf_partitioning", offset, false);
            }
            if (partition == null || !"__dftl_partition_content_type".equals(partition.getType())) {
                return null;
            }
            if (offset + region.getLength() > partition.getOffset() + partition.getLength()) {
                return null;
            }
            String key = document.get(partition.getOffset(), partition.getLength());
            String realKey = key.trim();
            int delta = key.indexOf(realKey);
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(document.get().getBytes()));
            if (properties.getProperty(realKey) == null) {
                return null;
            }
            return new PropertyKeyHyperlink[]{new PropertyKeyHyperlink((IRegion)new Region(partition.getOffset() + delta, realKey.length()), realKey, this.fTextEditor)};
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        catch (BadPartitioningException badPartitioningException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private boolean checkEnabled(IRegion region) {
        if (region == null || region.getOffset() < 0) {
            return false;
        }
        return this.fTextEditor.getEditorInput() instanceof IFileEditorInput;
    }
}

