/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.swt.graphics.Image;

public final class ConvertIterableLoopProposal
extends LinkedCorrectionProposal {
    private static final String GROUP_ELEMENT = "element";
    private boolean fAssigned = false;
    private final AST fAst;
    private IBinding fElement = null;
    private Expression fExpression = null;
    private IBinding fIterable = null;
    private IVariableBinding fIterator = null;
    private List fOccurrences = new ArrayList(2);
    private final ForStatement fStatement;
    static /* synthetic */ Class class$0;

    private static ITypeBinding getSuperType(ITypeBinding binding, String name) {
        ITypeBinding result;
        if (binding.isArray() || binding.isPrimitive()) {
            return null;
        }
        if (binding.getQualifiedName().startsWith(name)) {
            return binding;
        }
        ITypeBinding type = binding.getSuperclass();
        if (type != null && (result = ConvertIterableLoopProposal.getSuperType(type, name)) != null) {
            return result;
        }
        ITypeBinding[] types = binding.getInterfaces();
        int index = 0;
        while (index < types.length) {
            ITypeBinding result2 = ConvertIterableLoopProposal.getSuperType(types[index], name);
            if (result2 != null) {
                return result2;
            }
            ++index;
        }
        return null;
    }

    public ConvertIterableLoopProposal(String name, ICompilationUnit unit, ForStatement statement, int relevance, Image image) {
        super(name, unit, (ASTRewrite)null, relevance, image);
        this.fStatement = statement;
        this.fAst = statement.getAST();
    }

    private List computeElementNames() {
        ArrayList<String> names = new ArrayList<String>();
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        String name = GROUP_ELEMENT;
        ITypeBinding binding = this.fIterator.getType();
        if (binding != null && binding.isParameterizedType()) {
            name = binding.getTypeArguments()[0].getName();
        }
        List excluded = this.getExcludedNames();
        String[] suggestions = StubUtility.getLocalNameSuggestions(project, name, 0, excluded.toArray(new String[excluded.size()]));
        int index = 0;
        while (index < suggestions.length) {
            names.add(suggestions[index]);
            ++index;
        }
        return names;
    }

    private List getExcludedNames() {
        CompilationUnit unit = (CompilationUnit)this.fStatement.getRoot();
        IBinding[] before = new ScopeAnalyzer(unit).getDeclarationsInScope(this.fStatement.getStartPosition(), 2);
        IBinding[] after = new ScopeAnalyzer(unit).getDeclarationsAfter(this.fStatement.getStartPosition() + this.fStatement.getLength(), 2);
        ArrayList<String> names = new ArrayList<String>();
        int index = 0;
        while (index < before.length) {
            names.add(before[index].getName());
            ++index;
        }
        index = 0;
        while (index < after.length) {
            names.add(after[index].getName());
            ++index;
        }
        return names;
    }

    private Expression getExpression(ASTRewrite rewrite) {
        if (this.fExpression instanceof MethodInvocation) {
            return (MethodInvocation)rewrite.createMoveTarget((ASTNode)this.fExpression);
        }
        return (Expression)ASTNode.copySubtree((AST)rewrite.getAST(), (ASTNode)this.fExpression);
    }

    private ITypeBinding getIterableType(ITypeBinding iterator) {
        ITypeBinding[] bindings;
        if (iterator != null && (bindings = iterator.getTypeArguments()).length > 0) {
            return bindings[0];
        }
        return this.fAst.resolveWellKnownType("java.lang.Object");
    }

    protected final ASTRewrite getRewrite() throws CoreException {
        final ASTRewrite rewrite = ASTRewrite.create((AST)this.fAst);
        EnhancedForStatement statement = this.fAst.newEnhancedForStatement();
        List names = this.computeElementNames();
        String name = GROUP_ELEMENT;
        if (this.fElement != null) {
            name = this.fElement.getName();
            if (!names.contains(name)) {
                names.add(0, name);
            }
        } else if (!names.isEmpty()) {
            name = (String)names.get(0);
        }
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            this.addLinkedPositionProposal(GROUP_ELEMENT, (String)iterator.next(), null);
        }
        Statement body = this.fStatement.getBody();
        if (body != null) {
            if (body instanceof Block) {
                final ListRewrite list = rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY);
                Iterator iterator2 = this.fOccurrences.iterator();
                while (iterator2.hasNext()) {
                    Statement parent;
                    ASTNode aSTNode = (ASTNode)iterator2.next();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.jdt.core.dom.Statement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((parent = (Statement)ASTNodes.getParent(aSTNode, clazz)) == null || !list.getRewrittenList().contains(parent)) continue;
                    list.remove((ASTNode)parent, null);
                }
                final String text = name;
                body.accept(new ASTVisitor(){

                    private boolean replace(Expression expression) {
                        SimpleName node = ConvertIterableLoopProposal.this.fAst.newSimpleName(text);
                        rewrite.replace((ASTNode)expression, (ASTNode)node, null);
                        ConvertIterableLoopProposal.this.addLinkedPosition(rewrite.track((ASTNode)node), false, ConvertIterableLoopProposal.GROUP_ELEMENT);
                        return false;
                    }

                    public final boolean visit(MethodInvocation node) {
                        IBinding result;
                        Expression expression;
                        IMethodBinding binding = node.resolveMethodBinding();
                        if (binding != null && binding.getName().equals("next") && ((expression = node.getExpression()) instanceof Name ? (result = ((Name)expression).resolveBinding()) != null && result.equals((Object)ConvertIterableLoopProposal.this.fIterator) : (expression instanceof MethodInvocation ? (result = ((MethodInvocation)expression).resolveMethodBinding()) != null && result.equals((Object)ConvertIterableLoopProposal.this.fIterator) : expression instanceof FieldAccess && (result = ((FieldAccess)expression).resolveFieldBinding()) != null && result.equals((Object)ConvertIterableLoopProposal.this.fIterator)))) {
                            return this.replace((Expression)node);
                        }
                        return super.visit(node);
                    }

                    public final boolean visit(SimpleName node) {
                        IBinding binding;
                        if (ConvertIterableLoopProposal.this.fElement != null && (binding = node.resolveBinding()) != null && binding.equals((Object)ConvertIterableLoopProposal.this.fElement)) {
                            Statement parent;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.Statement");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((parent = (Statement)ASTNodes.getParent((ASTNode)node, clazz)) != null && list.getRewrittenList().contains(parent)) {
                                ConvertIterableLoopProposal.this.addLinkedPosition(rewrite.track((ASTNode)node), false, ConvertIterableLoopProposal.GROUP_ELEMENT);
                            }
                        }
                        return false;
                    }
                });
            }
            statement.setBody((Statement)rewrite.createMoveTarget((ASTNode)body));
        }
        SingleVariableDeclaration declaration = this.fAst.newSingleVariableDeclaration();
        SimpleName simple = this.fAst.newSimpleName(name);
        this.addLinkedPosition(rewrite.track((ASTNode)simple), true, GROUP_ELEMENT);
        declaration.setName(simple);
        declaration.setType(this.getImportRewrite().addImport(this.getIterableType(this.fIterator.getType()), this.fAst));
        statement.setParameter(declaration);
        statement.setExpression(this.getExpression(rewrite));
        rewrite.replace((ASTNode)this.fStatement, (ASTNode)statement, null);
        return rewrite;
    }

    public final boolean isApplicable() {
        if (JavaModelUtil.is50OrHigher(this.getCompilationUnit().getJavaProject())) {
            ASTNode root;
            Iterator outer = this.fStatement.initializers().iterator();
            while (outer.hasNext()) {
                Expression initializer = (Expression)outer.next();
                if (!(initializer instanceof VariableDeclarationExpression)) continue;
                VariableDeclarationExpression declaration = (VariableDeclarationExpression)initializer;
                Iterator inner = declaration.fragments().iterator();
                while (inner.hasNext()) {
                    VariableDeclarationFragment fragment = (VariableDeclarationFragment)inner.next();
                    fragment.accept(new ASTVisitor(){

                        public final boolean visit(MethodInvocation node) {
                            ITypeBinding iterable;
                            ITypeBinding type;
                            Expression qualifier;
                            IMethodBinding binding = node.resolveMethodBinding();
                            if (binding != null && binding.getName().equals("iterator") && (qualifier = node.getExpression()) != null && (type = qualifier.resolveTypeBinding()) != null && (iterable = ConvertIterableLoopProposal.getSuperType(type, "java.lang.Iterable")) != null) {
                                ConvertIterableLoopProposal.this.fExpression = qualifier;
                                if (qualifier instanceof Name) {
                                    Name name = (Name)qualifier;
                                    ConvertIterableLoopProposal.this.fIterable = name.resolveBinding();
                                } else if (qualifier instanceof MethodInvocation) {
                                    MethodInvocation invocation = (MethodInvocation)qualifier;
                                    ConvertIterableLoopProposal.this.fIterable = (IBinding)invocation.resolveMethodBinding();
                                } else if (qualifier instanceof FieldAccess) {
                                    FieldAccess access = (FieldAccess)qualifier;
                                    ConvertIterableLoopProposal.this.fIterable = (IBinding)access.resolveFieldBinding();
                                }
                            }
                            return true;
                        }

                        public final boolean visit(VariableDeclarationFragment node) {
                            ITypeBinding iterator;
                            ITypeBinding type;
                            IVariableBinding binding = node.resolveBinding();
                            if (binding != null && (type = binding.getType()) != null && (iterator = ConvertIterableLoopProposal.getSuperType(type, "java.util.Iterator")) != null) {
                                ConvertIterableLoopProposal.this.fIterator = binding;
                            }
                            return true;
                        }
                    });
                }
            }
            Statement statement = this.fStatement.getBody();
            if (statement != null && this.fIterator != null) {
                final ITypeBinding iterable = this.getIterableType(this.fIterator.getType());
                statement.accept(new ASTVisitor(){

                    public final boolean visit(Assignment node) {
                        return this.visit(node.getLeftHandSide(), node.getRightHandSide());
                    }

                    private boolean visit(Expression node) {
                        ITypeBinding binding;
                        if (node != null && (binding = node.resolveTypeBinding()) != null && iterable.equals((Object)binding)) {
                            FieldAccess access;
                            IVariableBinding result;
                            if (node instanceof Name) {
                                Name name = (Name)node;
                                IBinding result2 = name.resolveBinding();
                                if (result2 != null) {
                                    ConvertIterableLoopProposal.this.fOccurrences.add(node);
                                    ConvertIterableLoopProposal.this.fElement = result2;
                                    return false;
                                }
                            } else if (node instanceof FieldAccess && (result = (access = (FieldAccess)node).resolveFieldBinding()) != null) {
                                ConvertIterableLoopProposal.this.fOccurrences.add(node);
                                ConvertIterableLoopProposal.this.fElement = (IBinding)result;
                                return false;
                            }
                        }
                        return true;
                    }

                    private boolean visit(Expression left, Expression right) {
                        Name qualifier;
                        IBinding result;
                        Expression expression;
                        MethodInvocation invocation;
                        IMethodBinding binding;
                        if (right instanceof MethodInvocation ? (binding = (invocation = (MethodInvocation)right).resolveMethodBinding()) != null && binding.getName().equals("next") && ((expression = invocation.getExpression()) instanceof Name ? (result = (qualifier = (Name)expression).resolveBinding()) != null && result.equals((Object)ConvertIterableLoopProposal.this.fIterator) : (expression instanceof MethodInvocation ? (result = (qualifier = (MethodInvocation)expression).resolveMethodBinding()) != null && result.equals((Object)ConvertIterableLoopProposal.this.fIterator) : expression instanceof FieldAccess && (result = (qualifier = (FieldAccess)expression).resolveFieldBinding()) != null && result.equals((Object)ConvertIterableLoopProposal.this.fIterator))) : right instanceof NullLiteral) {
                            return this.visit(left);
                        }
                        return true;
                    }

                    public final boolean visit(VariableDeclarationFragment node) {
                        return this.visit((Expression)node.getName(), node.getInitializer());
                    }
                });
            }
            if ((root = this.fStatement.getRoot()) != null) {
                root.accept(new ASTVisitor(){

                    public final boolean visit(ForStatement node) {
                        return false;
                    }

                    public final boolean visit(SimpleName node) {
                        IBinding binding = node.resolveBinding();
                        if (binding != null && binding.equals((Object)ConvertIterableLoopProposal.this.fElement)) {
                            ConvertIterableLoopProposal.this.fAssigned = true;
                        }
                        return false;
                    }
                });
            }
        }
        return this.fExpression != null && this.fIterable != null && this.fIterator != null && !this.fAssigned;
    }
}

