/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.AbstractVMRunner;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.util.Assert;

public final class SerialVersionLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public static final String ERROR_POSTFIX = "__SerialVersionComputationErrorPostfix__";
    public static final String ERROR_PREFIX = "__SerialVersionComputationErrorPrefix__";
    private static final String[] fgExecutableLocations = new String[]{"bin" + File.separatorChar + "javaw", "bin" + File.separatorChar + "javaw.exe", "jre" + File.separatorChar + "bin" + File.separatorChar + "javaw", "jre" + File.separatorChar + "bin" + File.separatorChar + "javaw.exe", "bin" + File.separatorChar + "java", "bin" + File.separatorChar + "java.exe", "jre" + File.separatorChar + "bin" + File.separatorChar + "java", "jre" + File.separatorChar + "bin" + File.separatorChar + "java.exe"};
    public static final String RESULT_POSTFIX = "__SerialVersionComputationResultPostfix__";
    public static final String RESULT_PREFIX = "__SerialVersionComputationResultPrefix__";
    protected String fErrorMessage = null;
    protected long fSerialVersionID = 1L;

    public static File findJavaExecutable(File location) {
        Assert.isNotNull((Object)location);
        File file = null;
        int index = 0;
        while (index < fgExecutableLocations.length) {
            file = new File(location, fgExecutableLocations[index]);
            if (file.isFile()) {
                return file;
            }
            ++index;
        }
        return null;
    }

    public final String getErrorMessage() {
        return this.fErrorMessage;
    }

    public final long getSerialVersionID() {
        return this.fSerialVersionID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block7: {
            block8: {
                block6: {
                    block5: {
                        Assert.isNotNull((Object)configuration);
                        Assert.isNotNull((Object)monitor);
                        try {
                            monitor.beginTask(MessageFormat.format("{0}...", configuration.getName()), 4);
                            if (monitor.isCanceled()) {
                                Object var15_5 = null;
                                break block5;
                            }
                            monitor.subTask(CorrectionMessages.SerialVersionLaunchConfigurationDelegate_verifying_launch_attributes);
                            String type = this.verifyMainTypeName(configuration);
                            IVMInstall install = this.verifyVMInstall(configuration);
                            SerialVersionRunner runner = new SerialVersionRunner(install);
                            monitor.worked(1);
                            monitor.subTask(CorrectionMessages.SerialVersionLaunchConfigurationDelegate_setting_up);
                            String[] environment = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
                            String programArguments = this.getProgramArguments(configuration);
                            String vmArguments = this.getVMArguments(configuration);
                            ExecutionArguments execArguments = new ExecutionArguments(vmArguments, programArguments);
                            Map attributes = this.getVMSpecificAttributesMap(configuration);
                            String[] classpath = this.getClasspath(configuration);
                            monitor.worked(1);
                            VMRunnerConfiguration vmConfiguration = new VMRunnerConfiguration(type, classpath);
                            vmConfiguration.setProgramArguments(execArguments.getProgramArgumentsArray());
                            vmConfiguration.setEnvironment(environment);
                            vmConfiguration.setVMArguments(execArguments.getVMArgumentsArray());
                            vmConfiguration.setVMSpecificAttributesMap(attributes);
                            vmConfiguration.setBootClassPath(this.getBootpath(configuration));
                            if (monitor.isCanceled()) {
                                break block6;
                            }
                            monitor.subTask(CorrectionMessages.SerialVersionLaunchConfigurationDelegate_launching_computation);
                            monitor.worked(1);
                            runner.run(vmConfiguration, launch, monitor);
                            if (!monitor.isCanceled()) break block7;
                            break block8;
                        }
                        catch (Throwable throwable) {
                            Object var15_8 = null;
                            monitor.done();
                            throw throwable;
                        }
                    }
                    monitor.done();
                    return;
                }
                Object var15_6 = null;
                monitor.done();
                return;
            }
            Object var15_7 = null;
            monitor.done();
            return;
        }
        Object var15_9 = null;
        monitor.done();
    }

    public final class SerialVersionRunner
    extends AbstractVMRunner {
        private final IVMInstall fInstall;

        public SerialVersionRunner(IVMInstall install) {
            Assert.isNotNull((Object)install);
            this.fInstall = install;
        }

        private String flattenClassPath(String[] path) {
            Assert.isNotNull((Object)path);
            int count = 0;
            if (path.length == 0) {
                return "";
            }
            StringBuffer buffer = new StringBuffer();
            int index = 0;
            while (index < path.length) {
                if (count > 0) {
                    buffer.append(File.pathSeparator);
                }
                buffer.append(path[index]);
                ++count;
                ++index;
            }
            return buffer.toString();
        }

        private String getJavaExecutable(VMRunnerConfiguration configuration) throws CoreException {
            Assert.isNotNull((Object)configuration);
            String command = null;
            Map map = configuration.getVMSpecificAttributesMap();
            if (map != null) {
                command = (String)map.get(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND);
            }
            if (command == null) {
                File executable = SerialVersionLaunchConfigurationDelegate.findJavaExecutable(this.fInstall.getInstallLocation());
                if (executable == null) {
                    this.abort(Messages.format(CorrectionMessages.SerialVersionHashProposal_unable_locate_executable, new String[]{this.fInstall.getName()}), null, 150);
                }
                return executable.getAbsolutePath();
            }
            String location = String.valueOf(this.fInstall.getInstallLocation().getAbsolutePath()) + File.separatorChar;
            File executable = new File(String.valueOf(location) + "bin" + File.separatorChar + command);
            if (executable.exists() && executable.isFile()) {
                return executable.getAbsolutePath();
            }
            if ((executable = new File(String.valueOf(executable.getAbsolutePath()) + ".exe")).exists() && executable.isFile()) {
                return executable.getAbsolutePath();
            }
            executable = new File(String.valueOf(location) + "jre" + File.separatorChar + "bin" + File.separatorChar + command);
            if (executable.exists() && executable.isFile()) {
                return executable.getAbsolutePath();
            }
            if ((executable = new File(String.valueOf(executable.getAbsolutePath()) + ".exe")).exists() && executable.isFile()) {
                return executable.getAbsolutePath();
            }
            this.abort(Messages.format(CorrectionMessages.SerialVersionHashProposal_wrong_executable, new String[]{command, this.fInstall.getName()}), null, 150);
            return null;
        }

        protected final String getPluginIdentifier() {
            return JavaPlugin.getPluginId();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void run(VMRunnerConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
            SubProgressMonitor subMonitor;
            block28: {
                block27: {
                    Assert.isNotNull((Object)configuration);
                    Assert.isNotNull((Object)launch);
                    Assert.isNotNull((Object)monitor);
                    subMonitor = new SubProgressMonitor(monitor, 1);
                    subMonitor.beginTask(CorrectionMessages.SerialVersionLaunchConfigurationDelegate_launching_vm, 2);
                    try {
                        int end;
                        int start;
                        String string;
                        String[] commandLine;
                        String[] combinedClassPath;
                        String[] classPath;
                        String[] bootClassPath;
                        ArrayList<String> arguments;
                        block26: {
                            int index;
                            LibraryLocation[] locations;
                            subMonitor.subTask(CorrectionMessages.SerialVersionLaunchConfigurationDelegate_constructing_command_line);
                            arguments = new ArrayList<String>();
                            arguments.add(this.getJavaExecutable(configuration));
                            String[] vmArguments = this.combineVmArgs(configuration, this.fInstall);
                            int index2 = 0;
                            while (true) {
                                if (index2 >= vmArguments.length) {
                                    bootClassPath = configuration.getBootClassPath();
                                    classPath = configuration.getClassPath();
                                    combinedClassPath = null;
                                    locations = null;
                                    if (bootClassPath == null) {
                                        locations = JavaRuntime.getLibraryLocations((IVMInstall)this.fInstall);
                                        bootClassPath = new String[locations.length];
                                        index = 0;
                                        break;
                                    }
                                    break block26;
                                }
                                arguments.add(vmArguments[index2]);
                                ++index2;
                            }
                            while (index < locations.length) {
                                bootClassPath[index] = locations[index].getSystemLibraryPath().toOSString();
                                ++index;
                            }
                        }
                        combinedClassPath = new String[bootClassPath.length + classPath.length];
                        int offset = 0;
                        int index = 0;
                        while (true) {
                            if (index >= bootClassPath.length) break;
                            combinedClassPath[offset] = bootClassPath[index];
                            ++offset;
                            ++index;
                        }
                        index = 0;
                        while (true) {
                            if (index >= classPath.length) {
                                if (combinedClassPath.length > 0) {
                                    arguments.add("-classpath");
                                    arguments.add(this.flattenClassPath(combinedClassPath));
                                }
                                break;
                            }
                            combinedClassPath[offset] = classPath[index];
                            ++offset;
                            ++index;
                        }
                        arguments.add(configuration.getClassToLaunch());
                        String[] programArguments = configuration.getProgramArguments();
                        int index3 = 0;
                        while (true) {
                            if (index3 >= programArguments.length) {
                                commandLine = new String[arguments.size()];
                                arguments.toArray(commandLine);
                                if (!monitor.isCanceled()) break;
                                Object var21_17 = null;
                                break block27;
                            }
                            arguments.add(programArguments[index3]);
                            ++index3;
                        }
                        subMonitor.worked(1);
                        subMonitor.subTask(CorrectionMessages.SerialVersionLaunchConfigurationDelegate_starting_vm);
                        Process process = this.exec(commandLine, null);
                        if (process == null) break block28;
                        try {
                            process.waitFor();
                        }
                        catch (InterruptedException interruptedException) {}
                        StringBuffer buffer = new StringBuffer();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        try {
                            int result = 0;
                            while (true) {
                                if (!reader.ready()) {
                                    string = buffer.toString();
                                    start = string.indexOf(SerialVersionLaunchConfigurationDelegate.RESULT_PREFIX);
                                    if (start >= 0 && (end = string.indexOf(SerialVersionLaunchConfigurationDelegate.RESULT_POSTFIX, start)) >= 0) {
                                        SerialVersionLaunchConfigurationDelegate.this.fSerialVersionID = Long.valueOf(string.substring(start + SerialVersionLaunchConfigurationDelegate.RESULT_PREFIX.length(), end));
                                    }
                                    break;
                                }
                                result = reader.read();
                                if (result < 0) continue;
                                buffer.append((char)result);
                            }
                        }
                        catch (IOException exception) {
                            JavaPlugin.log(exception);
                            SerialVersionLaunchConfigurationDelegate.this.fErrorMessage = exception.getLocalizedMessage();
                        }
                        buffer = new StringBuffer();
                        reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        try {
                            int result = 0;
                            while (true) {
                                if (!reader.ready()) {
                                    string = buffer.toString();
                                    start = string.indexOf(SerialVersionLaunchConfigurationDelegate.ERROR_PREFIX);
                                    if (start >= 0 && (end = string.indexOf(SerialVersionLaunchConfigurationDelegate.ERROR_POSTFIX, start)) >= 0) {
                                        SerialVersionLaunchConfigurationDelegate.this.fErrorMessage = string.substring(start + SerialVersionLaunchConfigurationDelegate.ERROR_PREFIX.length(), end);
                                    }
                                    break;
                                }
                                result = reader.read();
                                if (result < 0) continue;
                                buffer.append((char)result);
                            }
                        }
                        catch (IOException exception) {
                            JavaPlugin.log(exception);
                            SerialVersionLaunchConfigurationDelegate.this.fErrorMessage = exception.getLocalizedMessage();
                        }
                        if (monitor.isCanceled()) {
                            process.destroy();
                        }
                        break block28;
                    }
                    catch (Throwable throwable) {
                        Object var21_18 = null;
                        subMonitor.done();
                        throw throwable;
                    }
                }
                subMonitor.done();
                return;
            }
            Object var21_19 = null;
            subMonitor.done();
        }
    }
}

