/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.ui.preferences;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.ws.internal.ui.plugin.WebServiceUIPlugin;
import org.eclipse.jst.ws.internal.ui.preferences.ActionDialogPreferenceType;
import org.eclipse.jst.ws.internal.ui.preferences.PersistentActionDialogsContext;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class ActionDialogsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private String INFOPOP_PPAD_PAGE = "org.eclipse.jst.ws.ui.PPAD0001";
    private Button showAll;
    private String INFOPOP_PPAD_BUTTON_SHOW_ALL = "org.eclipse.jst.ws.ui.PPAD0002";
    private Button hideAll;
    private String INFOPOP_PPAD_BUTTON_HIDE_ALL = "org.eclipse.jst.ws.ui.PPAD0003";
    private Hashtable checkBoxes_;

    protected Control createContents(Composite superparent) {
        this.checkBoxes_ = new Hashtable();
        this.addOptionalDialogsCheckBoxes(superparent);
        new Label(superparent, 256);
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        Composite parent = new Composite(superparent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        parent.setToolTipText(this.getMessage("%TOOLTIP_PPAD_PAGE"));
        helpSystem.setHelp((Control)parent, this.INFOPOP_PPAD_PAGE);
        this.showAll = new Button(parent, 0);
        this.showAll.setText(this.getMessage("%BUTTON_SHOW_ALL_DIALOGS"));
        this.showAll.addListener(13, (Listener)this);
        this.showAll.setToolTipText(this.getMessage("%TOOLTIP_PPAD_BUTTON_SHOW_ALL"));
        helpSystem.setHelp((Control)this.showAll, this.INFOPOP_PPAD_BUTTON_SHOW_ALL);
        this.hideAll = new Button(parent, 0);
        this.hideAll.setText(this.getMessage("%BUTTON_HIDE_ALL_DIALOGS"));
        this.hideAll.addListener(13, (Listener)this);
        this.hideAll.setToolTipText(this.getMessage("%TOOLTIP_PPAD_BUTTON_HIDE_ALL"));
        helpSystem.setHelp((Control)this.hideAll, this.INFOPOP_PPAD_BUTTON_HIDE_ALL);
        this.initializeValues();
        Dialog.applyDialogFont((Control)superparent);
        return parent;
    }

    private String getMessage(String key) {
        return WebServiceUIPlugin.getMessage(key);
    }

    public void handleEvent(Event event) {
        if (this.showAll == event.widget) {
            this.handleShowAllEvent();
        } else if (this.hideAll == event.widget) {
            this.handleHideAllEvent();
        }
    }

    private void handleShowAllEvent() {
        Enumeration e = this.checkBoxes_.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            Button dialog = (Button)e.nextElement();
            dialog.setSelection(true);
            ++i;
        }
    }

    private void handleHideAllEvent() {
        Enumeration e = this.checkBoxes_.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            Button dialog = (Button)e.nextElement();
            dialog.setSelection(false);
            ++i;
        }
    }

    private void addOptionalDialogsCheckBoxes(Composite parent) {
        PersistentActionDialogsContext context = WebServiceUIPlugin.getInstance().getActionDialogsContext();
        ActionDialogPreferenceType[] dialogs = context.getDialogs();
        int i = 0;
        while (i < dialogs.length) {
            Button checkBox = this.createCheckBox(parent, dialogs[i].getName());
            checkBox.setToolTipText(this.getMessage(dialogs[i].getTooltip()));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)checkBox, dialogs[i].getInfopop());
            this.checkBoxes_.put(dialogs[i].getId(), checkBox);
            ++i;
        }
    }

    private Button createCheckBox(Composite parent, String text) {
        Button button = new Button(parent, 32);
        button.setText(text);
        return button;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    public IPreferenceStore getPreferenceStore() {
        return WebServiceUIPlugin.getInstance().getPreferenceStore();
    }

    private void initializeDefaults() {
        Enumeration e = this.checkBoxes_.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            Button dialog = (Button)e.nextElement();
            dialog.setSelection(true);
            ++i;
        }
    }

    private void initializeValues() {
        PersistentActionDialogsContext context = WebServiceUIPlugin.getInstance().getActionDialogsContext();
        Enumeration e = this.checkBoxes_.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String id = (String)e.nextElement();
            Button button = (Button)this.checkBoxes_.get(id);
            button.setSelection(context.isActionDialogEnabled(id));
            ++i;
        }
    }

    private void storeValues() {
        PersistentActionDialogsContext context = WebServiceUIPlugin.getInstance().getActionDialogsContext();
        Enumeration e = this.checkBoxes_.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String id = (String)e.nextElement();
            context.setActionDialogEnabled(id, ((Button)this.checkBoxes_.get(id)).getSelection());
            ++i;
        }
    }
}

