/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ServerPreferences;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.ServerUIPreferences;
import org.eclipse.wst.server.ui.internal.Trace;

public class ServerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected Button publishBeforeStart;
    protected Button autoRestart;
    protected Button promptIrreversible;
    protected Button showOnActivity;
    protected byte saveEditors;
    protected Button saveNever;
    protected Button savePrompt;
    protected Button saveAuto;
    protected ServerPreferences preferences = ServerPreferences.getInstance();
    protected ServerUIPreferences uiPreferences = ServerUIPlugin.getPreferences();
    protected Button autoPublishOnAction;
    protected Button autoPublishLocal;
    protected Spinner autoPublishLocalTime;
    protected Button autoPublishRemote;
    protected Spinner autoPublishRemoteTime;
    protected Combo machineSpeedCombo;

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)parent, "org.eclipse.wst.server.ui.spge0000");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 4;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(784);
        composite.setLayoutData((Object)data);
        this.publishBeforeStart = new Button(composite, 32);
        this.publishBeforeStart.setText(Messages.prefAutoPublish);
        data = new GridData(256);
        data.horizontalSpan = 4;
        this.publishBeforeStart.setLayoutData((Object)data);
        this.publishBeforeStart.setSelection(this.preferences.isAutoPublishing());
        whs.setHelp((Control)this.publishBeforeStart, "org.eclipse.wst.server.ui.spge0012");
        this.autoPublishLocal = new Button(composite, 32);
        this.autoPublishLocal.setText(Messages.prefAutoPublishLocal);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.autoPublishLocal.setLayoutData((Object)data);
        this.autoPublishLocal.setSelection(this.preferences.getAutoPublishLocal());
        this.autoPublishLocalTime = new Spinner(composite, 2048);
        this.autoPublishLocalTime.setMinimum(0);
        this.autoPublishLocalTime.setMaximum(120);
        this.autoPublishLocalTime.setSelection(this.preferences.getAutoPublishLocalTime());
        this.autoPublishLocalTime.setEnabled(this.autoPublishLocal.getSelection());
        data = new GridData(128);
        data.widthHint = 60;
        this.autoPublishLocalTime.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        label.setText(Messages.prefAutoPublishSeconds);
        data = new GridData(128);
        label.setLayoutData((Object)data);
        this.autoPublishLocal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerPreferencePage.this.autoPublishLocalTime.setEnabled(ServerPreferencePage.this.autoPublishLocal.getSelection());
            }
        });
        this.autoPublishRemote = new Button(composite, 32);
        this.autoPublishRemote.setText(Messages.prefAutoPublishRemote);
        data = new GridData(256);
        data.horizontalSpan = 2;
        this.autoPublishRemote.setLayoutData((Object)data);
        this.autoPublishRemote.setSelection(this.preferences.getAutoPublishRemote());
        this.autoPublishRemoteTime = new Spinner(composite, 2048);
        this.autoPublishLocalTime.setMinimum(0);
        this.autoPublishLocalTime.setMaximum(120);
        this.autoPublishRemoteTime.setSelection(this.preferences.getAutoPublishRemoteTime());
        this.autoPublishRemoteTime.setEnabled(this.autoPublishRemote.getSelection());
        data = new GridData(256);
        data.widthHint = 60;
        this.autoPublishRemoteTime.setLayoutData((Object)data);
        this.autoPublishRemote.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerPreferencePage.this.autoPublishRemoteTime.setEnabled(ServerPreferencePage.this.autoPublishRemote.getSelection());
            }
        });
        label = new Label(composite, 0);
        label.setText(Messages.prefAutoPublishSeconds);
        data = new GridData(128);
        label.setLayoutData((Object)data);
        this.autoRestart = new Button(composite, 32);
        this.autoRestart.setText(Messages.prefAutoRestart);
        data = new GridData(256);
        data.horizontalSpan = 4;
        this.autoRestart.setLayoutData((Object)data);
        this.autoRestart.setSelection(this.preferences.isAutoRestarting());
        whs.setHelp((Control)this.autoRestart, "org.eclipse.wst.server.ui.spge0014");
        this.promptIrreversible = new Button(composite, 32);
        this.promptIrreversible.setText(Messages.prefPromptIrreversible);
        data = new GridData(256);
        data.horizontalSpan = 4;
        this.promptIrreversible.setLayoutData((Object)data);
        this.promptIrreversible.setSelection(this.uiPreferences.getPromptBeforeIrreversibleChange());
        whs.setHelp((Control)this.promptIrreversible, "org.eclipse.wst.server.ui.spge0020");
        this.showOnActivity = new Button(composite, 32);
        this.showOnActivity.setText(Messages.prefShowOnActivity);
        data = new GridData(256);
        data.horizontalSpan = 4;
        this.showOnActivity.setLayoutData((Object)data);
        this.showOnActivity.setSelection(this.uiPreferences.getShowOnActivity());
        whs.setHelp((Control)this.showOnActivity, "org.eclipse.wst.server.ui.spge0016");
        Group saveEditorGroup = new Group(composite, 0);
        saveEditorGroup.setText(Messages.prefSaveEditorsGroup);
        layout = new GridLayout();
        layout.numColumns = 3;
        saveEditorGroup.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 4;
        saveEditorGroup.setLayoutData((Object)data);
        this.saveNever = new Button((Composite)saveEditorGroup, 16);
        this.saveNever.setText(Messages.prefSaveEditorsNever);
        this.saveNever.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ServerPreferencePage.this.saveEditors = 0;
            }
        });
        whs.setHelp((Control)this.saveNever, "org.eclipse.wst.server.ui.spge0024");
        this.savePrompt = new Button((Composite)saveEditorGroup, 16);
        this.savePrompt.setText(Messages.prefSaveEditorsPrompt);
        this.savePrompt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ServerPreferencePage.this.saveEditors = 1;
            }
        });
        whs.setHelp((Control)this.savePrompt, "org.eclipse.wst.server.ui.spge0024");
        this.saveAuto = new Button((Composite)saveEditorGroup, 16);
        this.saveAuto.setText(Messages.prefSaveEditorsAutosave);
        this.saveAuto.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ServerPreferencePage.this.saveEditors = (byte)2;
            }
        });
        whs.setHelp((Control)this.saveAuto, "org.eclipse.wst.server.ui.spge0024");
        label = new Label(composite, 0);
        label.setText(Messages.prefMachineSpeed);
        this.machineSpeedCombo = new Combo(composite, 8);
        String[] items = new String[]{Messages.prefMachineSpeedVerySlow, Messages.prefMachineSpeedSlow, Messages.prefMachineSpeedAverage, Messages.prefMachineSpeedFast, Messages.prefMachineSpeedVeryFast};
        this.machineSpeedCombo.setItems(items);
        this.machineSpeedCombo.select(this.preferences.getMachineSpeed() / 2);
        data = new GridData(256);
        data.horizontalSpan = 3;
        this.machineSpeedCombo.setLayoutData((Object)data);
        this.setSaveEditorStatus(this.uiPreferences.getSaveEditors());
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void setSaveEditorStatus(byte status) {
        this.saveEditors = status;
        this.saveNever.setSelection(this.saveEditors == 0);
        this.savePrompt.setSelection(this.saveEditors == 1);
        this.saveAuto.setSelection(this.saveEditors == 2);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.autoRestart.setSelection(this.preferences.isDefaultAutoRestarting());
        this.publishBeforeStart.setSelection(this.preferences.isDefaultAutoPublishing());
        this.promptIrreversible.setSelection(this.uiPreferences.getDefaultPromptBeforeIrreversibleChange());
        this.showOnActivity.setSelection(this.uiPreferences.getDefaultShowOnActivity());
        this.autoPublishLocal.setSelection(this.preferences.getDefaultAutoPublishLocal());
        this.autoPublishLocalTime.setSelection(this.preferences.getDefaultAutoPublishLocalTime());
        this.autoPublishRemote.setSelection(this.preferences.getDefaultAutoPublishRemote());
        this.autoPublishRemoteTime.setSelection(this.preferences.getDefaultAutoPublishRemoteTime());
        this.machineSpeedCombo.select(this.preferences.getDefaultMachineSpeed() / 2);
        this.setSaveEditorStatus(this.uiPreferences.getDefaultSaveEditors());
        super.performDefaults();
    }

    public boolean performOk() {
        this.preferences.setAutoPublishing(this.publishBeforeStart.getSelection());
        this.preferences.setAutoRestarting(this.autoRestart.getSelection());
        this.uiPreferences.setSaveEditors(this.saveEditors);
        this.uiPreferences.setPromptBeforeIrreversibleChange(this.promptIrreversible.getSelection());
        this.uiPreferences.setShowOnActivity(this.showOnActivity.getSelection());
        this.preferences.setAutoPublishLocal(this.autoPublishLocal.getSelection());
        this.preferences.setAutoPublishLocalTime(this.autoPublishLocalTime.getSelection());
        this.preferences.setAutoPublishRemote(this.autoPublishRemote.getSelection());
        this.preferences.setAutoPublishRemoteTime(this.autoPublishRemoteTime.getSelection());
        this.preferences.setMachineSpeed(this.machineSpeedCombo.getSelectionIndex() * 2);
        if (this.autoRestart.getSelection()) {
            ServerPreferencePage.autoRestartAll();
        }
        return true;
    }

    protected static void autoRestartAll() {
        Trace.trace(Trace.FINEST, "Auto restarting all dirty servers");
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                String mode;
                IServer server = servers[i];
                if (server.getServerRestartState() && server.canRestart(mode = server.getMode()).isOK()) {
                    try {
                        Trace.trace(Trace.FINEST, "Attempting to auto restart " + server.getName());
                        server.restart(mode, null);
                    }
                    catch (Exception e) {
                        Trace.trace(Trace.SEVERE, "Error restarting: " + server, e);
                    }
                }
                ++i;
            }
        }
    }
}

