/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractTreeContentProvider
implements ITreeContentProvider {
    public static final byte STYLE_FLAT = 0;
    public static final String ROOT = "root";
    protected byte style;
    protected Object initialSelection;
    protected int initialSelectionOrder;
    protected Object[] elements;
    protected Map elementToParentMap = new HashMap(2);
    protected Map textMap = new HashMap(2);

    public AbstractTreeContentProvider(byte style) {
        this.style = style;
        this.fillTree();
    }

    public AbstractTreeContentProvider(byte style, boolean init) {
        this.style = style;
    }

    protected abstract void fillTree();

    protected void clean() {
        this.elements = null;
        this.elementToParentMap = new HashMap(2);
        this.textMap = new HashMap(2);
        this.initialSelection = null;
        this.initialSelectionOrder = -1000;
    }

    protected TreeElement getOrCreate(List list, String text) {
        try {
            Object obj = this.textMap.get(text);
            if (obj != null) {
                return (TreeElement)obj;
            }
        }
        catch (Exception exception) {
            return null;
        }
        TreeElement element = new TreeElement();
        element.text = text;
        element.contents = new ArrayList();
        this.textMap.put(text, element);
        list.add(element);
        return element;
    }

    protected TreeElement getOrCreate(List list, String id, String text) {
        try {
            Object obj = this.textMap.get(id);
            if (obj != null) {
                return (TreeElement)obj;
            }
        }
        catch (Exception exception) {
            return null;
        }
        TreeElement element = new TreeElement();
        element.text = text;
        element.contents = new ArrayList();
        this.textMap.put(id, element);
        list.add(element);
        return element;
    }

    protected TreeElement getByText(String text) {
        try {
            return (TreeElement)this.textMap.get(text);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected TreeElement getParentImpl(Object obj) {
        try {
            return (TreeElement)this.elementToParentMap.get(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void dispose() {
    }

    public Object[] getElements(Object element) {
        return this.elements;
    }

    public Object[] getChildren(Object element) {
        if (this.style == 0) {
            return null;
        }
        if (!(element instanceof TreeElement)) {
            return null;
        }
        TreeElement rte = (TreeElement)element;
        return rte.contents.toArray();
    }

    public Object getParent(Object element) {
        if (this.style == 0) {
            return null;
        }
        return this.getParentImpl(element);
    }

    public boolean hasChildren(Object element) {
        if (this.style == 0) {
            return false;
        }
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object getInitialSelection() {
        return this.initialSelection;
    }

    public class TreeElement {
        String text;
        List contents;
    }
}

