/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeComposite;
import org.eclipse.wst.server.ui.internal.viewers.ServerTypeTreeContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.ServerTypeTreeLabelProvider;

public class ServerTypeComposite
extends AbstractTreeComposite {
    protected IServerType selection;
    protected ServerTypeSelectionListener listener;
    protected ServerTypeTreeContentProvider contentProvider;
    protected boolean initialSelection = true;
    protected IModuleType moduleType;
    protected boolean isLocalhost;
    protected boolean includeIncompatibleVersions;

    public ServerTypeComposite(Composite parent, int style, IModuleType moduleType, ServerTypeSelectionListener listener2) {
        super(parent, style);
        this.listener = listener2;
        this.moduleType = moduleType;
        this.contentProvider = new ServerTypeTreeContentProvider(1, moduleType);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ServerTypeTreeLabelProvider());
        this.treeViewer.setInput((Object)"root");
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = ServerTypeComposite.this.getSelection(event.getSelection());
                if (obj instanceof IServerType) {
                    ServerTypeComposite.this.selection = (IServerType)obj;
                    ServerTypeComposite.this.setDescription(ServerTypeComposite.this.selection.getDescription());
                } else {
                    ServerTypeComposite.this.selection = null;
                    ServerTypeComposite.this.setDescription("");
                }
                ServerTypeComposite.this.listener.serverTypeSelected(ServerTypeComposite.this.selection);
            }
        });
        this.treeViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IServerType && !(e2 instanceof IServerType)) {
                    return 1;
                }
                if (!(e1 instanceof IServerType) && e2 instanceof IServerType) {
                    return -1;
                }
                if (!(e1 instanceof IServerType) || !(e2 instanceof IServerType)) {
                    return super.compare(viewer, e1, e2);
                }
                IServerType r1 = (IServerType)e1;
                IServerType r2 = (IServerType)e2;
                return r1.getName().compareTo(r2.getName());
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.initialSelection) {
            this.initialSelection = false;
            if (this.contentProvider.getInitialSelection() != null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection(this.contentProvider.getInitialSelection()), true);
            }
        }
    }

    public void setHost(boolean newHost) {
        if (this.isLocalhost == newHost) {
            return;
        }
        this.isLocalhost = newHost;
        ISelection sel = this.treeViewer.getSelection();
        this.contentProvider.setLocalhost(this.isLocalhost);
        this.treeViewer.refresh();
        this.treeViewer.setSelection(sel, true);
    }

    public void setIncludeIncompatibleVersions(boolean b) {
        this.includeIncompatibleVersions = b;
        ISelection sel = this.treeViewer.getSelection();
        this.contentProvider.setIncludeIncompatibleVersions(b);
        this.treeViewer.refresh();
        this.treeViewer.setSelection(sel, true);
    }

    protected String getDescriptionLabel() {
        return null;
    }

    protected String getTitleLabel() {
        return Messages.serverTypeCompDescription;
    }

    protected String[] getComboOptions() {
        return new String[]{Messages.name, Messages.vendor, Messages.version, Messages.moduleSupport};
    }

    protected void viewOptionSelected(byte option) {
        ISelection sel = this.treeViewer.getSelection();
        this.contentProvider = new ServerTypeTreeContentProvider(option, this.moduleType);
        this.contentProvider.setLocalhost(this.isLocalhost);
        this.contentProvider.setIncludeIncompatibleVersions(this.includeIncompatibleVersions);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setSelection(sel);
    }

    public IServerType getSelectedServerType() {
        return this.selection;
    }

    public static interface ServerTypeSelectionListener {
        public void serverTypeSelected(IServerType var1);
    }
}

